/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.preference.PreferenceManager;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FixedFragmentStatePagerAdapter;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBarActivity;
import android.text.Html;
import android.text.SpannableString;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.InstalledApkEvent;
import cm.aptoide.ptdev.LoginActivity;
import cm.aptoide.ptdev.MyAppsAddStoreInterface;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.Start;
import cm.aptoide.ptdev.UnInstalledApkEvent;
import cm.aptoide.ptdev.UninstallRetainFragment;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.dialogs.AptoideDialog;
import cm.aptoide.ptdev.downloadmanager.Utils;
import cm.aptoide.ptdev.downloadmanager.event.DownloadEvent;
import cm.aptoide.ptdev.events.AppViewRefresh;
import cm.aptoide.ptdev.events.BusProvider;
import cm.aptoide.ptdev.fragments.FragmentAppView;
import cm.aptoide.ptdev.model.Comment;
import cm.aptoide.ptdev.model.Download;
import cm.aptoide.ptdev.model.Error;
import cm.aptoide.ptdev.model.MediaObject;
import cm.aptoide.ptdev.model.Screenshot;
import cm.aptoide.ptdev.model.Video;
import cm.aptoide.ptdev.services.DownloadService;
import cm.aptoide.ptdev.services.HttpClientSpiceService;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.utils.Filters;
import cm.aptoide.ptdev.utils.IconSizes;
import cm.aptoide.ptdev.utils.SimpleCursorLoader;
import cm.aptoide.ptdev.webservices.GetApkInfoRequest;
import cm.aptoide.ptdev.webservices.GetApkInfoRequestFromId;
import cm.aptoide.ptdev.webservices.GetApkInfoRequestFromMd5;
import cm.aptoide.ptdev.webservices.UpdateUserRequest;
import cm.aptoide.ptdev.webservices.json.CreateUserJson;
import cm.aptoide.ptdev.webservices.json.GetApkInfoJson;
import com.astuetz.viewpager.extensions.PagerSlidingTabStrip;
import com.google.api.client.util.Data;
import com.mopub.mobileads.MoPubView;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import com.squareup.otto.Produce;
import com.squareup.otto.Subscribe;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import roboguice.util.temp.Ln;

public class AppViewActivity
extends ActionBarActivity
implements LoaderManager.LoaderCallbacks<Cursor>,
MyAppsAddStoreInterface {
    public static final int DOWGRADE_REQUEST_CODE = 456;
    private static final int LOGIN_REQUEST_CODE = 123;
    private static GetApkInfoJson.Malware.Reason reason;
    private ImageView appIcon;
    private TextView appName;
    private TextView appVersionName;
    private boolean autoDownload;
    private Condition boundCondition;
    private String cacheKey;
    private ServiceConnection downloadConnection;
    private int downloadId;
    private int downloads;
    private String icon;
    private long id;
    private boolean isFromActivityResult;
    private boolean isInstalled;
    private boolean isShown = false;
    private boolean isUpdate;
    private GetApkInfoJson json;
    private TextView latestVersion;
    private ReentrantLock lock;
    private String md5;
    private int minSdk;
    private MoPubView moPubView;
    private String name;
    DialogInterface.OnDismissListener onDismissListener;
    private String package_name;
    private String repoName;
    private RequestListener<GetApkInfoJson> requestListener;
    private String screen;
    private DownloadService service;
    private SpiceManager spiceManager = new SpiceManager(HttpClientSpiceService.class);
    private String token;
    private int versionCode;
    private String versionInstalled;
    private String versionName;
    private String wUrl;

    public AppViewActivity() {
        this.lock = new ReentrantLock();
        this.boundCondition = this.lock.newCondition();
        this.requestListener = new RequestListener<GetApkInfoJson>(){

            @Override
            public void onRequestFailure(SpiceException spiceException) {
                AptoideDialog.errorDialog().show(AppViewActivity.this.getSupportFragmentManager(), "errorDialog");
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @TargetApi(value=11)
            public void onRequestSuccess(final GetApkInfoJson getApkInfoJson) {
                block22: {
                    block21: {
                        StringBuilder stringBuilder = new StringBuilder().append("Json is null? ");
                        boolean bl2 = getApkInfoJson == null;
                        Log.d((String)"Aptoide-AppView", (String)stringBuilder.append(String.valueOf(bl2)).toString());
                        if (getApkInfoJson == null) break block21;
                        AppViewActivity.access$002(AppViewActivity.this, getApkInfoJson);
                        if (!"OK".equals(AppViewActivity.this.json.getStatus())) break block22;
                        AppViewActivity.access$102(AppViewActivity.this, getApkInfoJson.getMeta().getTitle());
                        AppViewActivity.access$202(AppViewActivity.this, getApkInfoJson.getApk().getVername());
                        AppViewActivity.access$302(AppViewActivity.this, getApkInfoJson.getApk().getPackage());
                        AppViewActivity.access$402(AppViewActivity.this, getApkInfoJson.getApk().getRepo());
                        AppViewActivity.access$502(AppViewActivity.this, getApkInfoJson.getMeta().getWUrl());
                        AppViewActivity.access$602(AppViewActivity.this, getApkInfoJson.getApk().getMinScreen());
                        AppViewActivity.access$702(AppViewActivity.this, getApkInfoJson.getApk().getMinSdk().intValue());
                        Log.d((String)"AppView", (String)("wUrl " + AppViewActivity.this.wUrl));
                        if (getApkInfoJson.getApk().getIconHd() != null) {
                            AppViewActivity.access$802(AppViewActivity.this, getApkInfoJson.getApk().getIconHd());
                            String string2 = IconSizes.generateSizeString((Context)AppViewActivity.this);
                            String[] stringArray = AppViewActivity.this.icon.split("\\.(?=[^\\.]+$)");
                            AppViewActivity.access$802(AppViewActivity.this, stringArray[0] + "_" + string2 + "." + stringArray[1]);
                        } else {
                            AppViewActivity.access$802(AppViewActivity.this, getApkInfoJson.getApk().getIcon());
                        }
                        AppViewActivity.this.appName.setText((CharSequence)AppViewActivity.this.name);
                        AppViewActivity.this.appVersionName.setText((CharSequence)AppViewActivity.this.versionName);
                        ImageLoader.getInstance().displayImage(AppViewActivity.this.icon, AppViewActivity.this.appIcon);
                        AppViewActivity.this.checkInstallation(getApkInfoJson);
                        AppViewActivity.access$1302(AppViewActivity.this, AppViewActivity.this.json.getApk().getMd5sum().hashCode());
                        AppViewActivity.this.findViewById(R.id.ic_action_cancel).setOnClickListener(new View.OnClickListener(){

                            public void onClick(View view) {
                                if (AppViewActivity.this.service != null) {
                                    AppViewActivity.this.service.stopDownload(AppViewActivity.this.downloadId);
                                }
                            }
                        });
                        AppViewActivity.this.findViewById(R.id.ic_action_resume).setOnClickListener(new View.OnClickListener(){

                            public void onClick(View view) {
                                if (AppViewActivity.this.service != null) {
                                    AppViewActivity.this.service.resumeDownload(AppViewActivity.this.downloadId);
                                }
                            }
                        });
                        GetApkInfoJson.Malware malware = getApkInfoJson.getMalware();
                        boolean bl3 = false;
                        if (malware != null) {
                            boolean bl4;
                            Log.d((String)"AppViewActivity-malwareStatus", (String)("status: " + getApkInfoJson.getMalware().getStatus()));
                            if (getApkInfoJson.getMalware().getStatus().equals("scanned")) {
                                ((ImageView)AppViewActivity.this.findViewById(R.id.app_badge)).setImageResource(R.drawable.ic_trusted);
                                ((TextView)AppViewActivity.this.findViewById(R.id.app_badge_text)).setText((CharSequence)AppViewActivity.this.getString(R.string.trusted));
                                bl4 = true;
                                bl3 = true;
                            } else if (getApkInfoJson.getMalware().getStatus().equals("warn")) {
                                ((ImageView)AppViewActivity.this.findViewById(R.id.app_badge)).setImageResource(R.drawable.ic_warning);
                                ((TextView)AppViewActivity.this.findViewById(R.id.app_badge_text)).setText((CharSequence)AppViewActivity.this.getString(R.string.warning));
                                bl4 = true;
                                bl3 = false;
                            } else {
                                boolean bl5 = getApkInfoJson.getMalware().getStatus().equals("unknown");
                                bl4 = false;
                                bl3 = false;
                                if (bl5) {
                                    bl3 = true;
                                    bl4 = false;
                                }
                            }
                            AppViewActivity.access$1502(getApkInfoJson.getMalware().getReason());
                            if (bl4) {
                                AppViewActivity.this.findViewById(R.id.badge_layout).setVisibility(0);
                                AppViewActivity.this.findViewById(R.id.badge_layout).startAnimation(AnimationUtils.loadAnimation((Context)AppViewActivity.this, (int)0x10A0000));
                                AppViewActivity.this.findViewById(R.id.badge_layout).setOnClickListener(new View.OnClickListener(){

                                    public void onClick(View view) {
                                        AptoideDialog.badgeDialog(AppViewActivity.this.name, getApkInfoJson.getMalware().getStatus()).show(AppViewActivity.this.getSupportFragmentManager(), "badgeDialog");
                                    }
                                });
                            }
                        }
                        AppViewActivity.access$1602(AppViewActivity.this, AppViewActivity.this.json.getApk().getVercode().intValue());
                        AppViewActivity.access$1702(AppViewActivity.this, (TextView)AppViewActivity.this.findViewById(R.id.app_get_latest));
                        if (AppViewActivity.this.json.getLatest() != null) {
                            AppViewActivity.this.latestVersion.setVisibility(0);
                            String string3 = bl3 ? AppViewActivity.this.getString(R.string.get_latest_version) : AppViewActivity.this.getString(R.string.get_latest_version_and_trusted);
                            SpannableString spannableString = new SpannableString((CharSequence)string3);
                            spannableString.setSpan((Object)new UnderlineSpan(), 0, spannableString.length(), 0);
                            AppViewActivity.this.latestVersion.setText((CharSequence)spannableString);
                            AppViewActivity.this.latestVersion.setOnClickListener(new View.OnClickListener(){

                                public void onClick(View view) {
                                    String string2 = AppViewActivity.this.json.getLatest();
                                    Intent intent = new Intent("android.intent.action.VIEW");
                                    intent.setData(Uri.parse((String)string2.replaceAll(" ", "%20")));
                                    AppViewActivity.this.startActivity(intent);
                                }
                            });
                        } else {
                            AppViewActivity.this.latestVersion.setVisibility(8);
                        }
                        if (AppViewActivity.this.getIntent().getBooleanExtra("fromMyapp", false)) {
                            AppViewActivity.this.getIntent().removeExtra("fromMyapp");
                            AptoideDialog.myappInstall(AppViewActivity.this.name).show(AppViewActivity.this.getSupportFragmentManager(), "myApp");
                        }
                        AppViewActivity.access$1802(AppViewActivity.this, AppViewActivity.this.json.getApk().getMd5sum());
                        AppViewActivity.this.publishEvents();
                        AppViewActivity.this.supportInvalidateOptionsMenu();
                        if (AppViewActivity.this.isFromActivityResult || AppViewActivity.this.autoDownload) {
                            Log.d((String)"Downgrade", (String)"iffromactivityresult");
                            Download download = new Download();
                            if (!PreferenceManager.getDefaultSharedPreferences((Context)AppViewActivity.this.getApplicationContext()).contains("allowRoot") && !Aptoide.IS_SYSTEM) {
                                new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (AppViewActivity.isRooted()) {
                                            AppViewActivity.this.runOnUiThread(new Runnable(){

                                                @Override
                                                public void run() {
                                                    AptoideDialog.allowRootDialog().show(AppViewActivity.this.getSupportFragmentManager(), "allowRoot");
                                                }
                                            });
                                        }
                                    }
                                }).start();
                            }
                            download.setId(AppViewActivity.this.downloadId);
                            download.setName(AppViewActivity.this.name);
                            download.setVersion(AppViewActivity.this.versionName);
                            download.setIcon(AppViewActivity.this.icon);
                            download.setPackageName(AppViewActivity.this.package_name);
                            try {
                                AppViewActivity.this.waitForServiceToBeBound();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            AppViewActivity.this.service.startDownloadFromJson(AppViewActivity.this.json, AppViewActivity.this.downloadId, download);
                            AppViewActivity.access$2002(AppViewActivity.this, false);
                            AppViewActivity.access$2102(AppViewActivity.this, false);
                        }
                        if (AppViewActivity.this.service != null && AppViewActivity.this.service.getDownload(AppViewActivity.this.downloadId).getDownload() != null) {
                            AppViewActivity.this.onDownloadUpdate(AppViewActivity.this.service.getDownload(AppViewActivity.this.downloadId).getDownload());
                        }
                    }
                    return;
                }
                Iterator<Error> iterator = AppViewActivity.this.json.getErrors().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        AppViewActivity.this.finish();
                        return;
                    }
                    Error error = iterator.next();
                    Toast.makeText((Context)AppViewActivity.this, (CharSequence)error.getMsg(), (int)1).show();
                }
            }
        };
        this.onDismissListener = new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                if (!new Database(Aptoide.getDb()).existsServer(AptoideUtils.RepoUtils.formatRepoUri(AppViewActivity.this.repoName + ".store.aptoide.com/"))) {
                    AptoideDialog.addMyAppStore("http://" + AppViewActivity.this.repoName + ".store.aptoide.com/").show(AppViewActivity.this.getSupportFragmentManager(), "myAppStore");
                }
            }
        };
        this.downloadConnection = new ServiceConnection(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                AppViewActivity.access$1402(AppViewActivity.this, ((DownloadService.LocalBinder)iBinder).getService());
                if (AppViewActivity.this.service.getDownload(AppViewActivity.this.downloadId).getDownload() != null) {
                    AppViewActivity.this.onDownloadUpdate(AppViewActivity.this.service.getDownload(AppViewActivity.this.downloadId).getDownload());
                } else {
                    AppViewActivity.this.findViewById(R.id.btinstall).setVisibility(0);
                    AppViewActivity.this.findViewById(R.id.btinstall).startAnimation(AnimationUtils.loadAnimation((Context)AppViewActivity.this, (int)0x10A0000));
                }
                AppViewActivity.this.lock.lock();
                try {
                    AppViewActivity.this.boundCondition.signalAll();
                    return;
                }
                finally {
                    AppViewActivity.this.lock.unlock();
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
            }
        };
    }

    static /* synthetic */ GetApkInfoJson access$002(AppViewActivity appViewActivity, GetApkInfoJson getApkInfoJson) {
        appViewActivity.json = getApkInfoJson;
        return getApkInfoJson;
    }

    static /* synthetic */ String access$102(AppViewActivity appViewActivity, String string2) {
        appViewActivity.name = string2;
        return string2;
    }

    static /* synthetic */ int access$1302(AppViewActivity appViewActivity, int n2) {
        appViewActivity.downloadId = n2;
        return n2;
    }

    static /* synthetic */ DownloadService access$1402(AppViewActivity appViewActivity, DownloadService downloadService) {
        appViewActivity.service = downloadService;
        return downloadService;
    }

    static /* synthetic */ GetApkInfoJson.Malware.Reason access$1502(GetApkInfoJson.Malware.Reason reason) {
        AppViewActivity.reason = reason;
        return reason;
    }

    static /* synthetic */ int access$1602(AppViewActivity appViewActivity, int n2) {
        appViewActivity.versionCode = n2;
        return n2;
    }

    static /* synthetic */ TextView access$1702(AppViewActivity appViewActivity, TextView textView) {
        appViewActivity.latestVersion = textView;
        return textView;
    }

    static /* synthetic */ String access$1802(AppViewActivity appViewActivity, String string2) {
        appViewActivity.md5 = string2;
        return string2;
    }

    static /* synthetic */ boolean access$2002(AppViewActivity appViewActivity, boolean bl2) {
        appViewActivity.isFromActivityResult = bl2;
        return bl2;
    }

    static /* synthetic */ String access$202(AppViewActivity appViewActivity, String string2) {
        appViewActivity.versionName = string2;
        return string2;
    }

    static /* synthetic */ boolean access$2102(AppViewActivity appViewActivity, boolean bl2) {
        appViewActivity.autoDownload = bl2;
        return bl2;
    }

    static /* synthetic */ String access$3002(AppViewActivity appViewActivity, String string2) {
        appViewActivity.token = string2;
        return string2;
    }

    static /* synthetic */ String access$302(AppViewActivity appViewActivity, String string2) {
        appViewActivity.package_name = string2;
        return string2;
    }

    static /* synthetic */ String access$402(AppViewActivity appViewActivity, String string2) {
        appViewActivity.repoName = string2;
        return string2;
    }

    static /* synthetic */ String access$502(AppViewActivity appViewActivity, String string2) {
        appViewActivity.wUrl = string2;
        return string2;
    }

    static /* synthetic */ String access$602(AppViewActivity appViewActivity, String string2) {
        appViewActivity.screen = string2;
        return string2;
    }

    static /* synthetic */ int access$702(AppViewActivity appViewActivity, int n2) {
        appViewActivity.minSdk = n2;
        return n2;
    }

    static /* synthetic */ String access$802(AppViewActivity appViewActivity, String string2) {
        appViewActivity.icon = string2;
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkInstallation(GetApkInfoJson getApkInfoJson) {
        block5: {
            block6: {
                try {
                    PackageInfo packageInfo = this.getPackageManager().getPackageInfo(this.package_name, 64);
                    this.isInstalled = true;
                    if (getApkInfoJson.getApk().getVercode().intValue() > packageInfo.versionCode) {
                        this.isUpdate = true;
                        ((TextView)this.findViewById(R.id.btinstall)).setText((CharSequence)this.getString(R.string.update));
                        this.findViewById(R.id.btinstall).setOnClickListener((View.OnClickListener)new InstallListener(this.icon, this.name, this.versionName, this.package_name));
                        ((TextView)this.findViewById(R.id.app_version_installed)).setVisibility(0);
                        ((TextView)this.findViewById(R.id.app_version_installed)).setText((CharSequence)(this.getString(R.string.installed_tab) + ": " + packageInfo.versionName));
                        break block5;
                    }
                    if (getApkInfoJson.getApk().getVercode().intValue() < packageInfo.versionCode) {
                        ((TextView)this.findViewById(R.id.btinstall)).setText((CharSequence)this.getString(R.string.downgrade));
                        this.findViewById(R.id.btinstall).setOnClickListener((View.OnClickListener)new DowngradeListener(this.icon, this.name, packageInfo.versionName, this.versionName, packageInfo.packageName));
                        ((TextView)this.findViewById(R.id.app_version_installed)).setVisibility(0);
                        ((TextView)this.findViewById(R.id.app_version_installed)).setText((CharSequence)(this.getString(R.string.installed_tab) + ": " + packageInfo.versionName));
                        break block5;
                    }
                    final Intent intent = this.getPackageManager().getLaunchIntentForPackage(this.package_name);
                    ((TextView)this.findViewById(R.id.btinstall)).setText((CharSequence)this.getString(R.string.open));
                    if (intent == null) break block6;
                    this.findViewById(R.id.btinstall).setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            try {
                                AppViewActivity.this.startActivity(intent);
                                return;
                            }
                            catch (ActivityNotFoundException activityNotFoundException) {
                                return;
                            }
                        }
                    });
                    break block5;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    ((TextView)this.findViewById(R.id.btinstall)).setText((CharSequence)this.getString(R.string.install));
                    this.findViewById(R.id.btinstall).setOnClickListener((View.OnClickListener)new InstallListener(this.icon, this.name, this.versionName, this.package_name));
                    return;
                }
            }
            this.findViewById(R.id.btinstall).setEnabled(false);
        }
        this.supportInvalidateOptionsMenu();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void continueLoading(Bundle bundle) {
        this.appIcon = (ImageView)this.findViewById(R.id.app_icon);
        this.appName = (TextView)this.findViewById(R.id.app_name);
        this.appVersionName = (TextView)this.findViewById(R.id.app_version);
        ViewPager viewPager = (ViewPager)this.findViewById(R.id.pager);
        this.id = this.getIntent().getExtras().getLong("id");
        if (this.getIntent().getExtras().containsKey("appName")) {
            this.name = this.getIntent().getExtras().getString("appName");
            this.appName.setText((CharSequence)this.name);
        }
        if (this.getIntent().getExtras().containsKey("versionName")) {
            this.versionName = this.getIntent().getExtras().getString("versionName");
            this.appVersionName.setText((CharSequence)this.versionName);
        }
        if (viewPager != null) {
            viewPager.setAdapter(new AppViewPager(this.getSupportFragmentManager(), (Context)this));
            ((PagerSlidingTabStrip)this.findViewById(R.id.tabs)).setViewPager(viewPager);
        }
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(true);
        this.getSupportActionBar().setTitle(R.string.applications);
        if (this.getIntent().getBooleanExtra("fromRollback", false)) {
            GetApkInfoRequestFromMd5 getApkInfoRequestFromMd5 = new GetApkInfoRequestFromMd5(this.getApplicationContext());
            String string2 = this.getIntent().getStringExtra("md5sum");
            getApkInfoRequestFromMd5.setMd5Sum(string2);
            if (this.token != null) {
                getApkInfoRequestFromMd5.setToken(this.token);
            }
            this.cacheKey = string2;
            this.spiceManager.getFromCacheAndLoadFromNetworkIfExpired(getApkInfoRequestFromMd5, string2, 3600000L, this.requestListener);
        } else if (this.getIntent().getBooleanExtra("fromMyapp", false)) {
            GetApkInfoRequestFromId getApkInfoRequestFromId = new GetApkInfoRequestFromId(this.getApplicationContext());
            long l2 = this.getIntent().getLongExtra("id", 0L);
            getApkInfoRequestFromId.setAppId(String.valueOf(l2));
            if (this.token != null) {
                getApkInfoRequestFromId.setToken(this.token);
            }
            this.cacheKey = String.valueOf(l2);
            this.spiceManager.getFromCacheAndLoadFromNetworkIfExpired(getApkInfoRequestFromId, l2, 3600000L, this.requestListener);
        } else if (this.getIntent().getBooleanExtra("fromRelated", false)) {
            GetApkInfoRequestFromMd5 getApkInfoRequestFromMd5 = new GetApkInfoRequestFromMd5(this.getApplicationContext());
            this.repoName = this.getIntent().getStringExtra("repoName");
            String string3 = this.getIntent().getStringExtra("md5sum");
            getApkInfoRequestFromMd5.setMd5Sum(string3);
            getApkInfoRequestFromMd5.setRepoName(this.repoName);
            if (this.token != null) {
                getApkInfoRequestFromMd5.setToken(this.token);
            }
            this.cacheKey = string3;
            this.spiceManager.getFromCacheAndLoadFromNetworkIfExpired(getApkInfoRequestFromMd5, this.cacheKey, 3600000L, this.requestListener);
        } else if (this.getIntent().getBooleanExtra("fromApkInstaller", false)) {
            GetApkInfoRequestFromId getApkInfoRequestFromId = new GetApkInfoRequestFromId(this.getApplicationContext());
            long l3 = this.getIntent().getLongExtra("id", 0L);
            getApkInfoRequestFromId.setAppId(String.valueOf(l3));
            if (this.token != null) {
                getApkInfoRequestFromId.setToken(this.token);
            }
            this.cacheKey = String.valueOf(l3);
            this.autoDownload = true;
            this.spiceManager.getFromCacheAndLoadFromNetworkIfExpired(getApkInfoRequestFromId, this.cacheKey, 3600000L, this.requestListener);
        } else {
            this.getSupportLoaderManager().initLoader(50, this.getIntent().getExtras(), this);
        }
        this.bindService(new Intent((Context)this, DownloadService.class), this.downloadConnection, 1);
        this.moPubView = (MoPubView)this.findViewById(R.id.adview);
        if (Build.VERSION.SDK_INT > 11) {
            this.moPubView.setLayerType(1, null);
        }
        this.moPubView.setVisibility(0);
        this.moPubView.setAdUnitId("85aa542ded4e49f79bc6a1db8563ca66");
        this.moPubView.loadAd();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean findBinary(String string2) {
        boolean bl2 = false;
        if (false) return bl2;
        String[] stringArray = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"};
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            bl2 = false;
            if (n3 >= n2) return bl2;
            String string3 = stringArray[n3];
            if (new File(string3 + string2).exists()) {
                return true;
            }
            ++n3;
        }
    }

    private Account getCurrentAccount() {
        Account[] accountArray = AccountManager.get((Context)this).getAccountsByType("cm.aptoide.pt");
        if (accountArray.length != 0) {
            return accountArray[0];
        }
        Intent intent = new Intent((Context)this, LoginActivity.class);
        intent.putExtra("login", true);
        this.startActivityForResult(intent, 123);
        return null;
    }

    private static boolean isRooted() {
        return AppViewActivity.findBinary("su");
    }

    private void publishEvents() {
        Log.d((String)"Aptoide-AppViewActivity", (String)"Publishing revents");
        BusProvider.getInstance().post(this.publishDetails());
        BusProvider.getInstance().post(this.publishRelatedApps());
        BusProvider.getInstance().post(this.publishSpecs());
        BusProvider.getInstance().post(this.publishRating());
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public DialogInterface.OnClickListener getCancelListener() {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                AppViewActivity.this.finish();
            }
        };
    }

    public DialogInterface.OnClickListener getMyAppListener() {
        return new InstallListener(this.icon, this.name, this.versionName, this.package_name);
    }

    public String getName() {
        return this.name;
    }

    public DialogInterface.OnDismissListener getOnDismissListener() {
        return this.onDismissListener;
    }

    @Override
    public DialogInterface.OnClickListener getOnMyAppAddStoreListener(String string2) {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("http://" + AppViewActivity.this.repoName + ".store.aptoide.com/");
                Intent intent = new Intent((Context)AppViewActivity.this, Start.class);
                intent.putExtra("nodialog", true);
                intent.putExtra("newrepo", arrayList);
                intent.addFlags(12345);
                AppViewActivity.this.startActivity(intent);
            }
        };
    }

    public String getPackage_name() {
        return this.package_name;
    }

    public GetApkInfoJson.Malware.Reason getReason() {
        return reason;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public SpiceManager getSpice() {
        return this.spiceManager;
    }

    public String getToken() {
        return this.token;
    }

    public DialogInterface.OnClickListener getTryAgainListener() {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                AppViewActivity.this.continueLoading(null);
            }
        };
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onActivityResult(int n2, int n3, Intent intent) {
        block9: {
            super.onActivityResult(n2, n3, intent);
            if (n2 == 123) {
                if (n3 != -1) return;
                // empty if block
            }
            if (n2 == 456) break block9;
            return;
        }
        Log.d((String)"Downgrade", (String)"OnactivityResult");
        try {
            this.getPackageManager().getPackageInfo(this.package_name, 0);
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.downgrade_requires_uninstall), (int)0).show();
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.isFromActivityResult = true;
            this.spiceManager.getFromCache(GetApkInfoJson.class, this.cacheKey, 3600000L, this.requestListener);
            return;
        }
    }

    @Override
    protected void onCreate(final Bundle bundle) {
        AccountManager accountManager;
        Aptoide.getThemePicker().setAptoideTheme((Context)this);
        super.onCreate(bundle);
        this.setContentView(R.layout.page_app_view);
        if (bundle != null) {
            this.package_name = bundle.getString("packageName");
            this.downloadId = bundle.getInt("downloadId");
            this.cacheKey = bundle.getString("cacheKey");
        }
        if ((accountManager = AccountManager.get((Context)this)).getAccountsByType("cm.aptoide.pt").length > 0) {
            accountManager.getAuthToken(accountManager.getAccountsByType("cm.aptoide.pt")[0], "Full access", null, (Activity)this, (AccountManagerCallback)new AccountManagerCallback<Bundle>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(AccountManagerFuture<Bundle> accountManagerFuture) {
                    try {
                        AppViewActivity.access$3002(AppViewActivity.this, ((Bundle)accountManagerFuture.getResult()).getString("authtoken"));
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        operationCanceledException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (AuthenticatorException authenticatorException) {
                        authenticatorException.printStackTrace();
                    }
                    AppViewActivity.this.continueLoading(bundle);
                }
            }, null);
            return;
        }
        this.continueLoading(bundle);
    }

    @Override
    public Loader<Cursor> onCreateLoader(int n2, final Bundle bundle) {
        return new SimpleCursorLoader((Context)this){

            @Override
            public Cursor loadInBackground() {
                long l2 = bundle.getLong("id");
                Log.d((String)"Aptoide-AppView", (String)("getapk id: " + l2));
                return new Database(Aptoide.getDb()).getApkInfo(l2);
            }
        };
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_app_view, menu2);
        if (this.isInstalled) {
            menu2.findItem(R.id.menu_uninstall).setVisible(true);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    protected void onDestroy() {
        if (this.service != null) {
            this.unbindService(this.downloadConnection);
        }
        if (this.moPubView != null) {
            this.moPubView.destroy();
        }
        super.onDestroy();
    }

    @Subscribe
    public void onDownloadEventUpdate(DownloadEvent downloadEvent) {
        if (this.service != null && downloadEvent.getId() == (long)this.downloadId) {
            this.onDownloadUpdate(this.service.getDownload(downloadEvent.getId()).getDownload());
        }
    }

    @Subscribe
    public void onDownloadStatusUpdate(Download download) {
        if (download.getId() == (long)this.downloadId) {
            this.onDownloadUpdate(download);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Subscribe
    public void onDownloadUpdate(Download download) {
        if (download == null || download.getId() != (long)this.downloadId) return;
        TextView textView = (TextView)this.findViewById(R.id.progress);
        ProgressBar progressBar = (ProgressBar)this.findViewById(R.id.downloading_progress);
        this.findViewById(R.id.download_progress).setVisibility(0);
        this.findViewById(R.id.btinstall).setVisibility(8);
        this.findViewById(R.id.badge_layout).setVisibility(8);
        switch (12.$SwitchMap$cm$aptoide$ptdev$downloadmanager$state$EnumState[download.getDownloadState().ordinal()]) {
            default: {
                return;
            }
            case 1: {
                this.findViewById(R.id.ic_action_resume).setVisibility(8);
                progressBar.setIndeterminate(false);
                progressBar.setProgress(download.getProgress());
                textView.setText((CharSequence)(download.getProgress() + "% - " + Utils.formatBits((long)download.getSpeed()) + "/s"));
                return;
            }
            case 3: {
                this.findViewById(R.id.ic_action_resume).setVisibility(8);
                this.findViewById(R.id.download_progress).setVisibility(8);
                this.findViewById(R.id.btinstall).setVisibility(0);
                this.findViewById(R.id.badge_layout).setVisibility(0);
                progressBar.setProgress(download.getProgress());
                textView.setText((CharSequence)download.getDownloadState().name());
                return;
            }
            case 5: {
                this.findViewById(R.id.ic_action_resume).setVisibility(8);
                progressBar.setIndeterminate(false);
                progressBar.setProgress(download.getProgress());
                textView.setText((CharSequence)this.getString(R.string.download_pending));
                return;
            }
            case 6: 
        }
        this.findViewById(R.id.ic_action_resume).setVisibility(0);
        textView.setText((CharSequence)download.getDownloadState().name());
        progressBar.setIndeterminate(false);
        progressBar.setProgress(download.getProgress());
    }

    @Subscribe
    public void onInstalledEvent(InstalledApkEvent installedApkEvent) {
        this.onRefresh(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        GetApkInfoRequest getApkInfoRequest;
        block11: {
            block9: {
                block10: {
                    String string2;
                    if (cursor.getCount() <= 0) {
                        Toast.makeText((Context)this, (int)R.string.error_occured, (int)1).show();
                        this.finish();
                        return;
                    }
                    this.repoName = cursor.getString(cursor.getColumnIndex("reponame"));
                    this.name = cursor.getString(cursor.getColumnIndex("name"));
                    this.package_name = cursor.getString(cursor.getColumnIndex("package_name"));
                    this.versionName = cursor.getString(cursor.getColumnIndex("version_name"));
                    String string3 = cursor.getString(cursor.getColumnIndex("icon"));
                    String string4 = cursor.getString(cursor.getColumnIndex("iconpath"));
                    this.downloads = cursor.getInt(cursor.getColumnIndex("downloads"));
                    this.minSdk = cursor.getInt(cursor.getColumnIndex("sdk"));
                    this.screen = cursor.getString(cursor.getColumnIndex("screen"));
                    this.md5 = cursor.getString(cursor.getColumnIndex("md5"));
                    String string5 = cursor.getString(cursor.getColumnIndex("apk_path"));
                    String string6 = cursor.getString(cursor.getColumnIndex("path"));
                    this.versionCode = cursor.getInt(cursor.getColumnIndex("version_code"));
                    cursor.getFloat(cursor.getColumnIndex("rating"));
                    this.appName.setText((CharSequence)Html.fromHtml((String)this.name).toString());
                    this.appVersionName.setText((CharSequence)Html.fromHtml((String)this.versionName).toString());
                    String string7 = IconSizes.generateSizeString((Context)this);
                    if (string3.contains("_icon")) {
                        String[] stringArray = string3.split("\\.(?=[^\\.]+$)");
                        string3 = stringArray[0] + "_" + string7 + "." + stringArray[1];
                    }
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    this.icon = string2 = string4 + string3;
                    imageLoader.displayImage(string2, this.appIcon);
                    this.downloadId = this.md5.hashCode();
                    getApkInfoRequest = new GetApkInfoRequest(this.getApplicationContext());
                    getApkInfoRequest.setRepoName(this.repoName);
                    getApkInfoRequest.setPackageName(this.package_name);
                    getApkInfoRequest.setVersionName(this.versionName);
                    getApkInfoRequest.setVercode(this.versionCode);
                    if (this.token != null) {
                        getApkInfoRequest.setToken(this.token);
                    }
                    this.cacheKey = this.package_name + this.repoName + this.versionCode;
                    BusProvider.getInstance().post(this.publishDetails());
                    try {
                        PackageInfo packageInfo = this.getPackageManager().getPackageInfo(this.package_name, 64);
                        this.isInstalled = true;
                        if (this.versionCode > packageInfo.versionCode) {
                            this.isUpdate = true;
                            ((TextView)this.findViewById(R.id.btinstall)).setText((CharSequence)this.getString(R.string.update));
                            this.findViewById(R.id.btinstall).setEnabled(true);
                            this.findViewById(R.id.btinstall).setOnClickListener((View.OnClickListener)new InstallFromUrlListener(this.icon, this.name, this.versionName, this.package_name, this.md5, string5 + string6));
                            ((TextView)this.findViewById(R.id.app_version_installed)).setVisibility(0);
                            ((TextView)this.findViewById(R.id.app_version_installed)).setText((CharSequence)(this.getString(R.string.installed_tab) + ": " + packageInfo.versionName));
                            break block9;
                        }
                        if (this.versionCode < packageInfo.versionCode) {
                            ((TextView)this.findViewById(R.id.btinstall)).setText((CharSequence)this.getString(R.string.downgrade));
                            this.findViewById(R.id.btinstall).setOnClickListener((View.OnClickListener)new DowngradeListener(this.icon, this.name, packageInfo.versionName, this.versionName, packageInfo.packageName));
                            ((TextView)this.findViewById(R.id.app_version_installed)).setVisibility(0);
                            ((TextView)this.findViewById(R.id.app_version_installed)).setText((CharSequence)(this.getString(R.string.installed_tab) + ": " + packageInfo.versionName));
                            break block9;
                        }
                        final Intent intent = this.getPackageManager().getLaunchIntentForPackage(this.package_name);
                        ((TextView)this.findViewById(R.id.btinstall)).setText((CharSequence)this.getString(R.string.open));
                        if (intent == null) break block10;
                        this.findViewById(R.id.btinstall).setOnClickListener(new View.OnClickListener(){

                            public void onClick(View view) {
                                try {
                                    AppViewActivity.this.startActivity(intent);
                                    return;
                                }
                                catch (ActivityNotFoundException activityNotFoundException) {
                                    return;
                                }
                            }
                        });
                        break block9;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        ((TextView)this.findViewById(R.id.btinstall)).setText((CharSequence)this.getString(R.string.install));
                        this.findViewById(R.id.btinstall).setOnClickListener((View.OnClickListener)new InstallFromUrlListener(this.icon, this.name, this.versionName, this.package_name, this.md5, string5 + string6));
                        break block11;
                    }
                }
                this.findViewById(R.id.btinstall).setEnabled(false);
            }
            this.supportInvalidateOptionsMenu();
        }
        this.spiceManager.getFromCacheAndLoadFromNetworkIfExpired(getApkInfoRequest, this.cacheKey, 3600000L, this.requestListener);
    }

    @Override
    public void onLoaderReset(Loader<Cursor> loader) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 == R.id.home) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 == R.id.menu_schedule) {
            if (this.md5 != null) {
                new Database(Aptoide.getDb()).insertScheduledDownload(this.package_name, this.md5, this.versionName, this.repoName, this.name, this.icon);
                Toast.makeText((Context)this, (int)R.string.addSchDown, (int)0).show();
                return super.onOptionsItemSelected(menuItem);
            }
            Toast.makeText((Context)this, (int)R.string.please_wait, (int)0).show();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 == R.id.menu_uninstall) {
            UninstallRetainFragment uninstallRetainFragment = new UninstallRetainFragment(this.name, this.package_name, this.versionName, this.icon);
            this.getSupportFragmentManager().beginTransaction().add(uninstallRetainFragment, "uninstallFrag").commit();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 != R.id.menu_search_other) {
            if (n2 != R.id.menu_share) return super.onOptionsItemSelected(menuItem);
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType("text/plain");
            intent.putExtra("android.intent.extra.SUBJECT", this.getString(R.string.install) + " \"" + this.name + "\"");
            intent.putExtra("android.intent.extra.TEXT", this.wUrl);
            if (this.wUrl == null) return super.onOptionsItemSelected(menuItem);
            this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.share)));
            return super.onOptionsItemSelected(menuItem);
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)("market://details?id=" + this.package_name)));
        try {
            this.startActivity(intent);
            return super.onOptionsItemSelected(menuItem);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.error_no_market), (int)0).show();
            return super.onOptionsItemSelected(menuItem);
        }
    }

    @Override
    protected void onPause() {
        BusProvider.getInstance().unregister(this);
        super.onPause();
    }

    @Subscribe
    public void onRefresh(AppViewRefresh appViewRefresh) {
        GetApkInfoRequest getApkInfoRequest = new GetApkInfoRequest(this.getApplicationContext());
        getApkInfoRequest.setRepoName(this.repoName);
        getApkInfoRequest.setPackageName(this.package_name);
        getApkInfoRequest.setVersionName(this.versionName);
        if (this.token != null) {
            getApkInfoRequest.setToken(this.token);
        }
        this.spiceManager.getFromCacheAndLoadFromNetworkIfExpired(getApkInfoRequest, this.cacheKey, 3600000L, this.requestListener);
    }

    protected void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        this.spiceManager.addListenerIfPending(GetApkInfoJson.class, (Object)this.cacheKey, this.requestListener);
        this.spiceManager.getFromCache(GetApkInfoJson.class, this.cacheKey, 3600000L, this.requestListener);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.spiceManager.addListenerIfPending(GetApkInfoJson.class, (Object)this.cacheKey, this.requestListener);
        BusProvider.getInstance().register(this);
        if (this.json != null) {
            this.checkInstallation(this.json);
        }
        if (this.service != null && this.service.getDownload(this.downloadId).getDownload() != null) {
            this.onDownloadUpdate(this.service.getDownload(this.downloadId).getDownload());
            return;
        }
        this.findViewById(R.id.btinstall).setVisibility(0);
        this.findViewById(R.id.btinstall).startAnimation(AnimationUtils.loadAnimation((Context)this, (int)0x10A0000));
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putString("cacheKey", this.cacheKey);
        bundle.putString("packageName", this.package_name);
        bundle.putInt("downloadId", this.downloadId);
    }

    @Override
    protected void onStart() {
        this.spiceManager.start((Context)this);
        super.onStart();
    }

    @Override
    protected void onStop() {
        this.spiceManager.shouldStop();
        super.onStop();
    }

    @Subscribe
    public void onUnInstalledEvent(UnInstalledApkEvent unInstalledApkEvent) {
        this.onRefresh(null);
        Toast.makeText((Context)this, (CharSequence)"Uninstalled", (int)1).show();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Produce
    public DetailsEvent publishDetails() {
        Details details = new Details();
        Log.d((String)"Aptoide-AppView", (String)"PublishingDetails");
        details.setDownloads(this.downloads);
        details.setStore(this.repoName);
        if (this.json != null && !this.json.getStatus().equals("FAIL")) {
            if (this.json.getMeta().getDeveloper() != null) {
                details.setDeveloper(this.json.getMeta().getDeveloper());
            }
            if (this.json.getMeta().getNews() != null) {
                details.setNews(this.json.getMeta().getNews());
            }
            Log.d((String)"Aptoide-AppView", (String)("Description: " + this.json.getMeta().getDescription()));
            details.setDescription(this.json.getMeta().getDescription());
            long l2 = this.json.getApk().getSize().longValue();
            if (this.json.getObb() != null && !Data.isNull(this.json.getObb())) {
                l2 += this.json.getObb().getMain().getFilesize().longValue();
                if (this.json.getObb().getPatch() != null && !Data.isNull(this.json.getObb().getPatch())) {
                    l2 += this.json.getObb().getPatch().getFilesize().longValue();
                }
            }
            details.setSize(l2);
            if (this.json.getMedia().getSshots_hd() != null) {
                details.setScreenshotsHd(this.json.getMedia().getSshots_hd());
            } else {
                details.setScreenshots(this.json.getMedia().getSshots());
            }
            if (this.json.getMedia().getVideos() != null) {
                details.setVideos(this.json.getMedia().getVideos());
            }
            details.setRating(this.json.getMeta().getLikevotes().getRating().floatValue());
            details.setLikes("" + this.json.getMeta().getLikevotes().getLikes());
            details.setDontLikes("" + this.json.getMeta().getLikevotes().getDislikes());
        }
        return new DetailsEvent(details);
    }

    @Produce
    public RatingEvent publishRating() {
        RatingEvent ratingEvent = new RatingEvent();
        if (this.json != null && !this.json.getStatus().equals("FAIL")) {
            ratingEvent.setComments(new ArrayList<Comment>(this.json.getMeta().getComments()));
            ratingEvent.setCacheString(this.json.getApk().getPackage() + this.json.getApk().getVername());
            if (this.json.getMeta().getLikevotes().getUservote() != null) {
                ratingEvent.setUservote(this.json.getMeta().getLikevotes().getUservote());
            }
        }
        return ratingEvent;
    }

    @Produce
    public RelatedAppsEvent publishRelatedApps() {
        return new RelatedAppsEvent(new Related());
    }

    @Produce
    public SpecsEvent publishSpecs() {
        SpecsEvent specsEvent = new SpecsEvent();
        if (this.json != null && !this.json.getStatus().equals("FAIL")) {
            specsEvent.setPermissions(new ArrayList<String>(this.json.getApk().getPermissions()));
            specsEvent.setMinSdk(this.minSdk);
            specsEvent.setMinScreen(Filters.Screen.lookup(this.screen));
        }
        return specsEvent;
    }

    public void setName(String string2) {
        this.name = string2;
    }

    public void setToken(String string2) {
        this.token = string2;
    }

    public void updateUsername(final String string2) {
        UpdateUserRequest updateUserRequest = new UpdateUserRequest((Context)this);
        updateUserRequest.setName(string2);
        AptoideDialog.pleaseWaitDialog().show(this.getSupportFragmentManager(), "pleaseWaitDialog");
        this.spiceManager.execute(updateUserRequest, new RequestListener<CreateUserJson>(){

            @Override
            public void onRequestFailure(SpiceException spiceException) {
                DialogFragment dialogFragment = (DialogFragment)AppViewActivity.this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
                if (dialogFragment != null) {
                    dialogFragment.dismiss();
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onRequestSuccess(CreateUserJson createUserJson) {
                DialogFragment dialogFragment = (DialogFragment)AppViewActivity.this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
                if (dialogFragment != null) {
                    dialogFragment.dismiss();
                }
                if (createUserJson.getStatus().equals("OK")) {
                    Toast.makeText((Context)Aptoide.getContext(), (int)R.string.username_success, (int)1).show();
                    PreferenceManager.getDefaultSharedPreferences((Context)AppViewActivity.this).edit().putString("username", string2).commit();
                    return;
                } else {
                    for (String string22 : createUserJson.getErrors()) {
                        Toast.makeText((Context)AppViewActivity.this, (CharSequence)string22, (int)1).show();
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForServiceToBeBound() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.service == null) {
                this.boundCondition.await();
            }
            Ln.d("Bound ok.", new Object[0]);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class AppViewPager
    extends FixedFragmentStatePagerAdapter {
        private final String[] TITLES;

        public AppViewPager(FragmentManager fragmentManager, Context context) {
            super(fragmentManager);
            String[] stringArray = new String[]{context.getString(R.string.info), context.getString(R.string.review), context.getString(R.string.related), context.getString(R.string.advanced)};
            this.TITLES = stringArray;
        }

        @Override
        public int getCount() {
            return this.TITLES.length;
        }

        @Override
        public Fragment getItem(int n2) {
            switch (n2) {
                default: {
                    return null;
                }
                case 0: {
                    return new FragmentAppView.FragmentAppViewDetails();
                }
                case 1: {
                    return new FragmentAppView.FragmentAppViewRating();
                }
                case 2: {
                    return new FragmentAppView.FragmentAppViewRelated();
                }
                case 3: 
            }
            return new FragmentAppView.FragmentAppViewSpecs();
        }

        @Override
        public CharSequence getPageTitle(int n2) {
            return this.TITLES[n2];
        }
    }

    private static class Details {
        private String description;
        private GetApkInfoJson.Meta.Developer developer;
        private String dontLikes;
        private int downloads;
        private String likes;
        private String news;
        private String publisher;
        public float rating;
        private List<String> screenshots;
        private List<GetApkInfoJson.Media.Screenshots> screenshotsHd;
        private long size;
        private String store;
        private String version;
        private List<GetApkInfoJson.Media.Videos> videos;

        private Details() {
        }

        public String getDescription() {
            return this.description;
        }

        public GetApkInfoJson.Meta.Developer getDeveloper() {
            return this.developer;
        }

        public String getDontLikes() {
            return this.dontLikes;
        }

        public int getDownloads() {
            return this.downloads;
        }

        public String getLikes() {
            return this.likes;
        }

        public String getNews() {
            return this.news;
        }

        public String getPublisher() {
            return this.publisher;
        }

        public float getRating() {
            return this.rating;
        }

        public List<String> getScreenshots() {
            return this.screenshots;
        }

        public List<GetApkInfoJson.Media.Screenshots> getScreenshotsHd() {
            return this.screenshotsHd;
        }

        public long getSize() {
            return this.size;
        }

        public String getStore() {
            return this.store;
        }

        public String getVersion() {
            return this.version;
        }

        public List<GetApkInfoJson.Media.Videos> getVideos() {
            return this.videos;
        }

        public void setDescription(String string2) {
            this.description = string2;
        }

        public void setDeveloper(GetApkInfoJson.Meta.Developer developer) {
            this.developer = developer;
        }

        public void setDontLikes(String string2) {
            this.dontLikes = string2;
        }

        public void setDownloads(int n2) {
            this.downloads = n2;
        }

        public void setLikes(String string2) {
            this.likes = string2;
        }

        public void setNews(String string2) {
            this.news = string2;
        }

        public void setPublisher(String string2) {
            this.publisher = string2;
        }

        public void setRating(float f2) {
            this.rating = f2;
        }

        public void setScreenshots(List<String> list) {
            this.screenshots = list;
        }

        public void setScreenshotsHd(List<GetApkInfoJson.Media.Screenshots> list) {
            this.screenshotsHd = list;
        }

        public void setSize(long l2) {
            this.size = l2;
        }

        public void setStore(String string2) {
            this.store = string2;
        }

        public void setVersion(String string2) {
            this.version = string2;
        }

        public void setVideos(List<GetApkInfoJson.Media.Videos> list) {
            this.videos = list;
        }
    }

    public static class DetailsEvent {
        Details details;

        public DetailsEvent(Details details) {
            this.details = details;
        }

        public String getDescription() {
            return this.details.getDescription();
        }

        public GetApkInfoJson.Meta.Developer getDeveloper() {
            return this.details.getDeveloper();
        }

        public String getDontLikes() {
            return this.details.getDontLikes();
        }

        public int getDownloads() {
            return this.details.getDownloads();
        }

        public String getLikes() {
            return this.details.getLikes();
        }

        public String getNews() {
            return this.details.getNews();
        }

        public String getPublisher() {
            if (this.details.getDeveloper() != null) {
                return this.details.getDeveloper().getInfo().getName();
            }
            return "N/A";
        }

        public float getRating() {
            return this.details.rating;
        }

        public List<String> getScreenshots() {
            ArrayList<String> arrayList;
            if (this.details.getScreenshotsHd() != null) {
                arrayList = new ArrayList();
                for (GetApkInfoJson.Media.Screenshots screenshots : this.details.getScreenshotsHd()) {
                    arrayList.add(screenshots.getOrient() + "|" + screenshots.getPath());
                }
            } else {
                arrayList = this.details.getScreenshots();
            }
            return arrayList;
        }

        public ArrayList<MediaObject> getScreenshotsAndThumbVideo() {
            ArrayList<MediaObject> arrayList;
            block5: {
                block4: {
                    arrayList = new ArrayList<MediaObject>();
                    if (this.details.getVideos() != null) {
                        for (GetApkInfoJson.Media.Videos videos : this.details.getVideos()) {
                            arrayList.add(new Video(videos.getThumb(), videos.getUrl()));
                            Log.d((String)"AppView", (String)("media objects [thumb]: " + videos.getThumb()));
                            Log.d((String)"AppView", (String)("media objects [url]: " + videos.getUrl()));
                        }
                    }
                    if (this.details.getScreenshotsHd() == null) break block4;
                    for (GetApkInfoJson.Media.Screenshots screenshots : this.details.getScreenshotsHd()) {
                        arrayList.add(new Screenshot(screenshots.getPath(), screenshots.getOrient(), true));
                    }
                    break block5;
                }
                if (this.details.getScreenshots() == null) break block5;
                Iterator<String> iterator = this.details.getScreenshots().iterator();
                while (iterator.hasNext()) {
                    arrayList.add(new Screenshot(iterator.next(), "portrait", false));
                }
            }
            return arrayList;
        }

        public long getSize() {
            return this.details.getSize();
        }

        public String getStore() {
            return this.details.getStore();
        }

        public String getVersionName() {
            return this.details.getVersion();
        }
    }

    public class DowngradeListener
    implements View.OnClickListener {
        private String downgradeVersion;
        private String icon;
        private String name;
        private String package_name;
        private String versionName;

        public DowngradeListener(String string2, String string3, String string4, String string5, String string6) {
            this.icon = string2;
            this.name = string3;
            this.versionName = string4;
            this.downgradeVersion = string5;
            this.package_name = string6;
        }

        public void onClick(View view) {
            UninstallRetainFragment uninstallRetainFragment = new UninstallRetainFragment(this.name, this.package_name, this.versionName, this.downgradeVersion, this.icon);
            AppViewActivity.this.getSupportFragmentManager().beginTransaction().add(uninstallRetainFragment, "downgrade").commit();
        }
    }

    public class InstallFromUrlListener
    implements View.OnClickListener,
    DialogInterface.OnClickListener {
        private String icon;
        private final String md5;
        private String name;
        private String package_name;
        private final String url;
        private String versionName;

        public InstallFromUrlListener(String string2, String string3, String string4, String string5, String string6, String string7) {
            this.icon = string2;
            this.name = string3;
            this.versionName = string4;
            this.package_name = string5;
            this.md5 = string6;
            this.url = string7;
        }

        public void onClick(DialogInterface dialogInterface, int n2) {
            this.onClick(null);
        }

        public void onClick(View view) {
            Download download = new Download();
            if (!PreferenceManager.getDefaultSharedPreferences((Context)AppViewActivity.this.getApplicationContext()).contains("allowRoot") && !Aptoide.IS_SYSTEM) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (AppViewActivity.isRooted()) {
                            AppViewActivity.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    AptoideDialog.allowRootDialog().show(AppViewActivity.this.getSupportFragmentManager(), "allowRoot");
                                }
                            });
                        }
                    }
                }).start();
            }
            download.setId(AppViewActivity.this.downloadId);
            download.setName(this.name);
            download.setVersion(this.versionName);
            download.setIcon(this.icon);
            download.setPackageName(this.package_name);
            AppViewActivity.this.service.startDownloadFromUrl(this.url, this.md5, AppViewActivity.this.downloadId, download);
            Toast.makeText((Context)AppViewActivity.this.getApplicationContext(), (CharSequence)AppViewActivity.this.getApplicationContext().getString(R.string.starting_download), (int)1).show();
        }
    }

    public class InstallListener
    implements View.OnClickListener,
    DialogInterface.OnClickListener {
        private String icon;
        private String name;
        private String package_name;
        private String versionName;

        public InstallListener(String string2, String string3, String string4, String string5) {
            this.icon = string2;
            this.name = string3;
            this.versionName = string4;
            this.package_name = string5;
        }

        public void onClick(DialogInterface dialogInterface, int n2) {
            this.onClick(null);
        }

        public void onClick(View view) {
            Download download = new Download();
            if (!PreferenceManager.getDefaultSharedPreferences((Context)AppViewActivity.this.getApplicationContext()).contains("allowRoot") && !Aptoide.IS_SYSTEM) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (AppViewActivity.isRooted()) {
                            AppViewActivity.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    AptoideDialog.allowRootDialog().show(AppViewActivity.this.getSupportFragmentManager(), "allowRoot");
                                }
                            });
                        }
                    }
                }).start();
            }
            download.setId(AppViewActivity.this.downloadId);
            download.setName(this.name);
            download.setVersion(this.versionName);
            download.setIcon(this.icon);
            download.setPackageName(this.package_name);
            if (AppViewActivity.this.service != null) {
                AppViewActivity.this.service.startDownloadFromJson(AppViewActivity.this.json, AppViewActivity.this.downloadId, download);
                Toast.makeText((Context)AppViewActivity.this.getApplicationContext(), (CharSequence)AppViewActivity.this.getApplicationContext().getString(R.string.starting_download), (int)1).show();
            }
        }
    }

    private static class Rating {
        private Rating() {
        }
    }

    public static class RatingEvent {
        private String cacheString;
        private ArrayList<Comment> comments;
        private String uservote;

        public String getCacheString() {
            return this.cacheString;
        }

        public ArrayList<Comment> getComments() {
            return this.comments;
        }

        public String getUservote() {
            return this.uservote;
        }

        public void setCacheString(String string2) {
            this.cacheString = string2;
        }

        public void setComments(ArrayList<Comment> arrayList) {
            this.comments = arrayList;
        }

        public void setUservote(String string2) {
            this.uservote = string2;
        }
    }

    private static class Related {
        private Related() {
        }
    }

    public static class RelatedAppsEvent {
        private RelatedAppsEvent(Related related) {
        }
    }

    private static class Screenshots {
        private List<String> screenshots;

        private Screenshots() {
        }

        public List<String> getScreenshots() {
            return this.screenshots;
        }

        public void setScreenshots(List<String> list) {
            this.screenshots = list;
        }
    }

    public class ScreenshotsEvent {
        Screenshots screenshots;

        public ScreenshotsEvent(Screenshots screenshots) {
            this.screenshots = screenshots;
        }

        public List getScreenshots() {
            return this.screenshots.getScreenshots();
        }
    }

    private static class Specs {
        private Specs() {
        }
    }

    public static class SpecsEvent {
        private Filters.Screen minScreen = Filters.Screen.normal;
        private int minSdk;
        private ArrayList<String> permissions;

        private SpecsEvent() {
        }

        public Filters.Screen getMinScreen() {
            return this.minScreen;
        }

        public int getMinSdk() {
            return this.minSdk;
        }

        public ArrayList getPermissions() {
            return this.permissions;
        }

        public void setMinScreen(Filters.Screen screen) {
            this.minScreen = screen;
        }

        public void setMinSdk(int n2) {
            this.minSdk = n2;
        }

        public void setPermissions(ArrayList<String> arrayList) {
            this.permissions = arrayList;
        }
    }
}

