/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.accounts.AbstractAccountAuthenticator;
import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.NetworkErrorException;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import cm.aptoide.ptdev.LoginActivity;
import cm.aptoide.ptdev.services.RabbitMqService;
import com.facebook.Session;

public class AccountAuthenticator
extends AbstractAccountAuthenticator {
    private String TAG = "UdinicAuthenticator";
    private final Context mContext;

    public AccountAuthenticator(Context context) {
        super(context);
        this.mContext = context;
    }

    public Bundle addAccount(AccountAuthenticatorResponse accountAuthenticatorResponse, String string2, String string3, String[] stringArray, Bundle bundle) throws NetworkErrorException {
        Log.d((String)"udinic", (String)(this.TAG + "> addAccount"));
        Intent intent = new Intent(this.mContext, LoginActivity.class);
        intent.putExtra("ACCOUNT_TYPE", string2);
        intent.putExtra("AUTH_TYPE", string3);
        intent.putExtra("IS_ADDING_ACCOUNT", true);
        intent.putExtra("accountAuthenticatorResponse", (Parcelable)accountAuthenticatorResponse);
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("intent", (Parcelable)intent);
        return bundle2;
    }

    public Bundle confirmCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, Bundle bundle) throws NetworkErrorException {
        return null;
    }

    public Bundle editProperties(AccountAuthenticatorResponse accountAuthenticatorResponse, String string2) {
        return null;
    }

    public Bundle getAccountRemovalAllowed(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account) throws NetworkErrorException {
        Bundle bundle = new Bundle();
        bundle.putBoolean("booleanResult", true);
        if (Build.VERSION.SDK_INT >= 8) {
            Session.setActiveSession(new Session(this.mContext));
            if (Session.getActiveSession() != null) {
                Session.getActiveSession().closeAndClearTokenInformation();
            }
        }
        PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).edit().remove("queueName").commit();
        this.mContext.stopService(new Intent(this.mContext, RabbitMqService.class));
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bundle getAuthToken(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws NetworkErrorException {
        Log.d((String)"udinic", (String)(this.TAG + "> getAuthToken"));
        if (!string2.equals("Read only") && !string2.equals("Full access")) {
            Bundle bundle2 = new Bundle();
            bundle2.putString("errorMessage", "invalid authTokenType");
            return bundle2;
        }
        AccountManager accountManager = AccountManager.get((Context)this.mContext);
        String string3 = accountManager.peekAuthToken(account, string2);
        Log.d((String)"udinic", (String)(this.TAG + "> peekAuthToken returned - " + string3));
        if (TextUtils.isEmpty((CharSequence)string3) && accountManager.getPassword(account) != null) {
            try {
                Log.d((String)"udinic", (String)(this.TAG + "> re-authenticating with the existing password"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            Bundle bundle3 = new Bundle();
            bundle3.putString("authAccount", account.name);
            bundle3.putString("accountType", account.type);
            bundle3.putString("authtoken", string3);
            return bundle3;
        }
        Intent intent = new Intent(this.mContext, LoginActivity.class);
        intent.putExtra("accountAuthenticatorResponse", (Parcelable)accountAuthenticatorResponse);
        intent.putExtra("ACCOUNT_TYPE", account.type);
        intent.putExtra("AUTH_TYPE", string2);
        intent.putExtra("ACCOUNT_NAME", account.name);
        Bundle bundle4 = new Bundle();
        bundle4.putParcelable("intent", (Parcelable)intent);
        return bundle4;
    }

    public String getAuthTokenLabel(String string2) {
        if ("Full access".equals(string2)) {
            return "Full access to an Udinic account";
        }
        if ("Read only".equals(string2)) {
            return "Read only access to an Udinic account";
        }
        return string2 + " (Label)";
    }

    public Bundle hasFeatures(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String[] stringArray) throws NetworkErrorException {
        Bundle bundle = new Bundle();
        bundle.putBoolean("booleanResult", false);
        return bundle;
    }

    public Bundle updateCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws NetworkErrorException {
        return null;
    }
}

