/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.widget.ResourceCursorAdapter;
import android.support.v7.appcompat.R;
import android.support.v7.widget.SearchView;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.WeakHashMap;

class SuggestionsAdapter
extends ResourceCursorAdapter
implements View.OnClickListener {
    private static final boolean DBG = false;
    static final int INVALID_INDEX = -1;
    private static final String LOG_TAG = "SuggestionsAdapter";
    private static final int QUERY_LIMIT = 50;
    static final int REFINE_ALL = 2;
    static final int REFINE_BY_ENTRY = 1;
    static final int REFINE_NONE;
    private boolean mClosed = false;
    private int mFlagsCol = -1;
    private int mIconName1Col = -1;
    private int mIconName2Col = -1;
    private WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private Context mProviderContext;
    private int mQueryRefinement = 1;
    private SearchManager mSearchManager = (SearchManager)this.mContext.getSystemService("search");
    private SearchView mSearchView;
    private SearchableInfo mSearchable;
    private int mText1Col = -1;
    private int mText2Col = -1;
    private int mText2UrlCol = -1;
    private ColorStateList mUrlColor;

    public SuggestionsAdapter(Context context, SearchView searchView, SearchableInfo searchableInfo, WeakHashMap<String, Drawable.ConstantState> weakHashMap) {
        super(context, R.layout.abc_search_dropdown_item_icons_2line, null, true);
        this.mSearchView = searchView;
        this.mSearchable = searchableInfo;
        this.mProviderContext = context;
        this.mOutsideDrawablesCache = weakHashMap;
    }

    private Drawable checkIconCache(String string2) {
        Drawable.ConstantState constantState = this.mOutsideDrawablesCache.get(string2);
        if (constantState == null) {
            return null;
        }
        return constantState.newDrawable();
    }

    private CharSequence formatUrl(CharSequence charSequence) {
        if (this.mUrlColor == null) {
            TypedValue typedValue = new TypedValue();
            this.mContext.getTheme().resolveAttribute(R.attr.textColorSearchUrl, typedValue, true);
            this.mUrlColor = this.mContext.getResources().getColorStateList(typedValue.resourceId);
        }
        SpannableString spannableString = new SpannableString(charSequence);
        spannableString.setSpan((Object)new TextAppearanceSpan(null, 0, 0, this.mUrlColor, null), 0, charSequence.length(), 33);
        return spannableString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getActivityIcon(ComponentName componentName) {
        ActivityInfo activityInfo;
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            activityInfo = packageManager.getActivityInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)LOG_TAG, (String)nameNotFoundException.toString());
            return null;
        }
        int n2 = activityInfo.getIconResource();
        if (n2 == 0) {
            return null;
        }
        Drawable drawable2 = packageManager.getDrawable(componentName.getPackageName(), n2, activityInfo.applicationInfo);
        if (drawable2 != null) return drawable2;
        Log.w((String)LOG_TAG, (String)("Invalid icon resource " + n2 + " for " + componentName.flattenToShortString()));
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable getActivityIconWithCache(ComponentName componentName) {
        String string2 = componentName.flattenToShortString();
        if (this.mOutsideDrawablesCache.containsKey(string2)) {
            Drawable.ConstantState constantState = this.mOutsideDrawablesCache.get(string2);
            if (constantState == null) {
                return null;
            }
            return constantState.newDrawable(this.mProviderContext.getResources());
        }
        Drawable drawable2 = this.getActivityIcon(componentName);
        Drawable.ConstantState constantState = drawable2 == null ? null : drawable2.getConstantState();
        this.mOutsideDrawablesCache.put(string2, constantState);
        return drawable2;
    }

    public static String getColumnString(Cursor cursor, String string2) {
        return SuggestionsAdapter.getStringOrNull(cursor, cursor.getColumnIndex(string2));
    }

    private Drawable getDefaultIcon1(Cursor cursor) {
        Drawable drawable2 = this.getActivityIconWithCache(this.mSearchable.getSearchActivity());
        if (drawable2 != null) {
            return drawable2;
        }
        return this.mContext.getPackageManager().getDefaultActivityIcon();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable getDrawable(Uri uri) {
        InputStream inputStream;
        block13: {
            try {
                boolean bl2 = "android.resource".equals(uri.getScheme());
                if (bl2) {
                    try {
                        return this.getDrawableFromResourceUri(uri);
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        throw new FileNotFoundException("Resource does not exist: " + uri);
                    }
                }
                inputStream = this.mProviderContext.getContentResolver().openInputStream(uri);
                if (inputStream != null) break block13;
                throw new FileNotFoundException("Failed to open " + uri);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.w((String)LOG_TAG, (String)("Icon not found: " + uri + ", " + fileNotFoundException.getMessage()));
                return null;
            }
        }
        Drawable drawable2 = Drawable.createFromStream((InputStream)inputStream, null);
        {
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)LOG_TAG, (String)("Error closing icon stream for " + uri), (Throwable)iOException);
                    throw throwable;
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return drawable2;
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)("Error closing icon stream for " + uri), (Throwable)iOException);
            return drawable2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getDrawableFromResourceValue(String string2) {
        if (string2 == null) return null;
        if (string2.length() == 0) return null;
        if ("0".equals(string2)) {
            return null;
        }
        int n2 = Integer.parseInt(string2);
        String string3 = "android.resource://" + this.mProviderContext.getPackageName() + "/" + n2;
        Drawable drawable2 = this.checkIconCache(string3);
        if (drawable2 != null) return drawable2;
        try {
            Drawable drawable3 = this.mProviderContext.getResources().getDrawable(n2);
            this.storeInIconCache(string3, drawable3);
            return drawable3;
        }
        catch (NumberFormatException numberFormatException) {
            drawable2 = this.checkIconCache(string2);
            if (drawable2 != null) return drawable2;
            Drawable drawable4 = this.getDrawable(Uri.parse((String)string2));
            this.storeInIconCache(string2, drawable4);
            return drawable4;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.w((String)LOG_TAG, (String)("Icon resource not found: " + string2));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getIcon1(Cursor cursor) {
        if (this.mIconName1Col == -1) {
            return null;
        }
        Drawable drawable2 = this.getDrawableFromResourceValue(cursor.getString(this.mIconName1Col));
        if (drawable2 != null) return drawable2;
        return this.getDefaultIcon1(cursor);
    }

    private Drawable getIcon2(Cursor cursor) {
        if (this.mIconName2Col == -1) {
            return null;
        }
        return this.getDrawableFromResourceValue(cursor.getString(this.mIconName2Col));
    }

    private static String getStringOrNull(Cursor cursor, int n2) {
        if (n2 == -1) {
            return null;
        }
        try {
            String string2 = cursor.getString(n2);
            return string2;
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"unexpected error retrieving valid column from cursor, did the remote process die?", (Throwable)exception);
            return null;
        }
    }

    private void setViewDrawable(ImageView imageView, Drawable drawable2, int n2) {
        imageView.setImageDrawable(drawable2);
        if (drawable2 == null) {
            imageView.setVisibility(n2);
            return;
        }
        imageView.setVisibility(0);
        drawable2.setVisible(false, false);
        drawable2.setVisible(true, false);
    }

    private void setViewText(TextView textView, CharSequence charSequence) {
        textView.setText(charSequence);
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            textView.setVisibility(8);
            return;
        }
        textView.setVisibility(0);
    }

    private void storeInIconCache(String string2, Drawable drawable2) {
        if (drawable2 != null) {
            this.mOutsideDrawablesCache.put(string2, drawable2.getConstantState());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSpinnerState(Cursor cursor) {
        if (cursor == null) return;
        Bundle bundle = cursor.getExtras();
        if (bundle == null) return;
        if (!bundle.getBoolean("in_progress")) return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        ChildViewCache childViewCache = (ChildViewCache)view.getTag();
        int n2 = this.mFlagsCol;
        int n3 = 0;
        if (n2 != -1) {
            n3 = cursor.getInt(this.mFlagsCol);
        }
        if (childViewCache.mText1 != null) {
            String string2 = SuggestionsAdapter.getStringOrNull(cursor, this.mText1Col);
            this.setViewText(childViewCache.mText1, string2);
        }
        if (childViewCache.mText2 != null) {
            String string3 = SuggestionsAdapter.getStringOrNull(cursor, this.mText2UrlCol);
            CharSequence charSequence = string3 != null ? this.formatUrl(string3) : SuggestionsAdapter.getStringOrNull(cursor, this.mText2Col);
            if (TextUtils.isEmpty((CharSequence)charSequence)) {
                if (childViewCache.mText1 != null) {
                    childViewCache.mText1.setSingleLine(false);
                    childViewCache.mText1.setMaxLines(2);
                }
            } else if (childViewCache.mText1 != null) {
                childViewCache.mText1.setSingleLine(true);
                childViewCache.mText1.setMaxLines(1);
            }
            this.setViewText(childViewCache.mText2, charSequence);
        }
        if (childViewCache.mIcon1 != null) {
            this.setViewDrawable(childViewCache.mIcon1, this.getIcon1(cursor), 4);
        }
        if (childViewCache.mIcon2 != null) {
            this.setViewDrawable(childViewCache.mIcon2, this.getIcon2(cursor), 8);
        }
        if (this.mQueryRefinement == 2 || this.mQueryRefinement == 1 && (n3 & 1) != 0) {
            childViewCache.mIconRefine.setVisibility(0);
            childViewCache.mIconRefine.setTag((Object)childViewCache.mText1.getText());
            childViewCache.mIconRefine.setOnClickListener((View.OnClickListener)this);
            return;
        }
        childViewCache.mIconRefine.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void changeCursor(Cursor cursor) {
        if (this.mClosed) {
            Log.w((String)LOG_TAG, (String)"Tried to change cursor after adapter was closed.");
            if (cursor == null) return;
            cursor.close();
            return;
        }
        try {
            super.changeCursor(cursor);
            if (cursor == null) return;
            this.mText1Col = cursor.getColumnIndex("suggest_text_1");
            this.mText2Col = cursor.getColumnIndex("suggest_text_2");
            this.mText2UrlCol = cursor.getColumnIndex("suggest_text_2_url");
            this.mIconName1Col = cursor.getColumnIndex("suggest_icon_1");
            this.mIconName2Col = cursor.getColumnIndex("suggest_icon_2");
            this.mFlagsCol = cursor.getColumnIndex("suggest_flags");
            return;
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"error changing cursor and caching columns", (Throwable)exception);
            return;
        }
    }

    public void close() {
        this.changeCursor(null);
        this.mClosed = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence convertToString(Cursor cursor) {
        String string2;
        if (cursor == null) {
            return null;
        }
        String string3 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
        if (string3 != null) return string3;
        if (this.mSearchable.shouldRewriteQueryFromData() && (string2 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) != null) {
            return string2;
        }
        if (!this.mSearchable.shouldRewriteQueryFromText()) return null;
        String string4 = SuggestionsAdapter.getColumnString(cursor, "suggest_text_1");
        if (string4 == null) return null;
        return string4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Drawable getDrawableFromResourceUri(Uri uri) throws FileNotFoundException {
        int n2;
        Resources resources;
        String string2 = uri.getAuthority();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new FileNotFoundException("No authority: " + uri);
        }
        try {
            resources = this.mContext.getPackageManager().getResourcesForApplication(string2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new FileNotFoundException("No package found for authority: " + uri);
        }
        List list = uri.getPathSegments();
        if (list == null) {
            throw new FileNotFoundException("No path: " + uri);
        }
        int n3 = list.size();
        if (n3 == 1) {
            try {
                int n4;
                n2 = n4 = Integer.parseInt((String)list.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FileNotFoundException("Single path segment is not a resource ID: " + uri);
            }
        } else {
            if (n3 != 2) {
                throw new FileNotFoundException("More than two path segments: " + uri);
            }
            n2 = resources.getIdentifier((String)list.get(1), (String)list.get(0), string2);
        }
        if (n2 == 0) {
            throw new FileNotFoundException("No resource found for: " + uri);
        }
        return resources.getDrawable(n2);
    }

    public int getQueryRefinement() {
        return this.mQueryRefinement;
    }

    /*
     * Enabled aggressive block sorting
     */
    Cursor getSearchManagerSuggestions(SearchableInfo searchableInfo, String string2, int n2) {
        String[] stringArray;
        String string3;
        if (searchableInfo == null || (string3 = searchableInfo.getSuggestAuthority()) == null) {
            return null;
        }
        Uri.Builder builder = new Uri.Builder().scheme("content").authority(string3).query("").fragment("");
        String string4 = searchableInfo.getSuggestPath();
        if (string4 != null) {
            builder.appendEncodedPath(string4);
        }
        builder.appendPath("search_suggest_query");
        String string5 = searchableInfo.getSuggestSelection();
        if (string5 != null) {
            stringArray = new String[]{string2};
        } else {
            builder.appendPath(string2);
            stringArray = null;
        }
        if (n2 > 0) {
            builder.appendQueryParameter("limit", String.valueOf(n2));
        }
        Uri uri = builder.build();
        return this.mContext.getContentResolver().query(uri, null, string5, stringArray, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View getView(int n2, View view, ViewGroup viewGroup) {
        try {
            View view2 = super.getView(n2, view, viewGroup);
            return view2;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)LOG_TAG, (String)"Search suggestions cursor threw exception.", (Throwable)runtimeException);
            View view3 = this.newView(this.mContext, this.mCursor, viewGroup);
            if (view3 == null) return view3;
            ((ChildViewCache)view3.getTag()).mText1.setText((CharSequence)runtimeException.toString());
            return view3;
        }
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        View view = super.newView(context, cursor, viewGroup);
        view.setTag((Object)new ChildViewCache(view));
        return view;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.updateSpinnerState(this.getCursor());
    }

    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        this.updateSpinnerState(this.getCursor());
    }

    public void onClick(View view) {
        Object object = view.getTag();
        if (object instanceof CharSequence) {
            this.mSearchView.onQueryRefine((CharSequence)object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        String string2 = charSequence == null ? "" : ((Object)charSequence).toString();
        if (this.mSearchView.getVisibility() != 0 || this.mSearchView.getWindowVisibility() != 0) return null;
        try {
            Cursor cursor = this.getSearchManagerSuggestions(this.mSearchable, string2, 50);
            if (cursor == null) return null;
            cursor.getCount();
            return cursor;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)LOG_TAG, (String)"Search suggestions query threw an exception.", (Throwable)runtimeException);
            return null;
        }
    }

    public void setQueryRefinement(int n2) {
        this.mQueryRefinement = n2;
    }

    private static final class ChildViewCache {
        public final ImageView mIcon1;
        public final ImageView mIcon2;
        public final ImageView mIconRefine;
        public final TextView mText1;
        public final TextView mText2;

        public ChildViewCache(View view) {
            this.mText1 = (TextView)view.findViewById(16908308);
            this.mText2 = (TextView)view.findViewById(16908309);
            this.mIcon1 = (ImageView)view.findViewById(16908295);
            this.mIcon2 = (ImageView)view.findViewById(16908296);
            this.mIconRefine = (ImageView)view.findViewById(R.id.edit_query);
        }
    }
}

