/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.app.PendingIntent;
import android.app.SearchableInfo;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.widget.CursorAdapter;
import android.support.v7.appcompat.R;
import android.support.v7.view.CollapsibleActionView;
import android.support.v7.widget.SuggestionsAdapter;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.lang.reflect.Method;
import java.util.WeakHashMap;

public class SearchView
extends LinearLayout
implements CollapsibleActionView {
    private static final boolean DBG = false;
    static final AutoCompleteTextViewReflector HIDDEN_METHOD_INVOKER = new AutoCompleteTextViewReflector();
    private static final String IME_OPTION_NO_MICROPHONE = "nm";
    private static final String LOG_TAG = "SearchView";
    private Bundle mAppSearchData;
    private boolean mClearingFocus;
    private ImageView mCloseButton;
    private int mCollapsedImeOptions;
    private View mDropDownAnchor;
    private boolean mExpandedInActionView;
    private boolean mIconified;
    private boolean mIconifiedByDefault;
    private int mMaxWidth;
    private CharSequence mOldQueryText;
    private final View.OnClickListener mOnClickListener;
    private OnCloseListener mOnCloseListener;
    private final TextView.OnEditorActionListener mOnEditorActionListener;
    private final AdapterView.OnItemClickListener mOnItemClickListener;
    private final AdapterView.OnItemSelectedListener mOnItemSelectedListener;
    private OnQueryTextListener mOnQueryChangeListener;
    private View.OnFocusChangeListener mOnQueryTextFocusChangeListener;
    private View.OnClickListener mOnSearchClickListener;
    private OnSuggestionListener mOnSuggestionListener;
    private final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private CharSequence mQueryHint;
    private boolean mQueryRefinement;
    private SearchAutoComplete mQueryTextView;
    private Runnable mReleaseCursorRunnable;
    private View mSearchButton;
    private View mSearchEditFrame;
    private ImageView mSearchHintIcon;
    private View mSearchPlate;
    private SearchableInfo mSearchable;
    private Runnable mShowImeRunnable = new Runnable(){

        @Override
        public void run() {
            InputMethodManager inputMethodManager = (InputMethodManager)SearchView.this.getContext().getSystemService("input_method");
            if (inputMethodManager != null) {
                HIDDEN_METHOD_INVOKER.showSoftInputUnchecked(inputMethodManager, (View)SearchView.this, 0);
            }
        }
    };
    private View mSubmitArea;
    private View mSubmitButton;
    private boolean mSubmitButtonEnabled;
    private CursorAdapter mSuggestionsAdapter;
    View.OnKeyListener mTextKeyListener;
    private TextWatcher mTextWatcher;
    private Runnable mUpdateDrawableStateRunnable = new Runnable(){

        @Override
        public void run() {
            SearchView.this.updateFocusedState();
        }
    };
    private CharSequence mUserQuery;
    private final Intent mVoiceAppSearchIntent;
    private View mVoiceButton;
    private boolean mVoiceButtonEnabled;
    private final Intent mVoiceWebSearchIntent;

    public SearchView(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SearchView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n2;
        int n3;
        CharSequence charSequence;
        this.mReleaseCursorRunnable = new Runnable(){

            @Override
            public void run() {
                if (SearchView.this.mSuggestionsAdapter != null && SearchView.this.mSuggestionsAdapter instanceof SuggestionsAdapter) {
                    SearchView.this.mSuggestionsAdapter.changeCursor(null);
                }
            }
        };
        this.mOutsideDrawablesCache = new WeakHashMap();
        this.mOnClickListener = new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void onClick(View view) {
                if (view == SearchView.this.mSearchButton) {
                    SearchView.this.onSearchClicked();
                    return;
                } else {
                    if (view == SearchView.this.mCloseButton) {
                        SearchView.this.onCloseClicked();
                        return;
                    }
                    if (view == SearchView.this.mSubmitButton) {
                        SearchView.this.onSubmitQuery();
                        return;
                    }
                    if (view == SearchView.this.mVoiceButton) {
                        SearchView.this.onVoiceClicked();
                        return;
                    }
                    if (view != SearchView.this.mQueryTextView) return;
                    SearchView.this.forceSuggestionQuery();
                    return;
                }
            }
        };
        this.mTextKeyListener = new View.OnKeyListener(){

            /*
             * Enabled aggressive block sorting
             */
            public boolean onKey(View view, int n2, KeyEvent keyEvent) {
                block5: {
                    block4: {
                        if (SearchView.this.mSearchable == null) break block4;
                        if (SearchView.this.mQueryTextView.isPopupShowing() && SearchView.this.mQueryTextView.getListSelection() != -1) {
                            return SearchView.this.onSuggestionsKey(view, n2, keyEvent);
                        }
                        if (!SearchView.this.mQueryTextView.isEmpty() && KeyEventCompat.hasNoModifiers(keyEvent) && keyEvent.getAction() == 1 && n2 == 66) break block5;
                    }
                    return false;
                }
                view.cancelLongPress();
                SearchView.this.launchQuerySearch(0, null, SearchView.this.mQueryTextView.getText().toString());
                return true;
            }
        };
        this.mOnEditorActionListener = new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int n2, KeyEvent keyEvent) {
                SearchView.this.onSubmitQuery();
                return true;
            }
        };
        this.mOnItemClickListener = new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                SearchView.this.onItemClicked(n2, 0, null);
            }
        };
        this.mOnItemSelectedListener = new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int n2, long l2) {
                SearchView.this.onItemSelected(n2);
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        };
        this.mTextWatcher = new TextWatcher(){

            public void afterTextChanged(Editable editable) {
            }

            public void beforeTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
            }

            public void onTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
                SearchView.this.onTextChanged(charSequence);
            }
        };
        ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(R.layout.abc_search_view, (ViewGroup)this, true);
        this.mSearchButton = this.findViewById(R.id.search_button);
        this.mQueryTextView = (SearchAutoComplete)this.findViewById(R.id.search_src_text);
        this.mQueryTextView.setSearchView(this);
        this.mSearchEditFrame = this.findViewById(R.id.search_edit_frame);
        this.mSearchPlate = this.findViewById(R.id.search_plate);
        this.mSubmitArea = this.findViewById(R.id.submit_area);
        this.mSubmitButton = this.findViewById(R.id.search_go_btn);
        this.mCloseButton = (ImageView)this.findViewById(R.id.search_close_btn);
        this.mVoiceButton = this.findViewById(R.id.search_voice_btn);
        this.mSearchHintIcon = (ImageView)this.findViewById(R.id.search_mag_icon);
        this.mSearchButton.setOnClickListener(this.mOnClickListener);
        this.mCloseButton.setOnClickListener(this.mOnClickListener);
        this.mSubmitButton.setOnClickListener(this.mOnClickListener);
        this.mVoiceButton.setOnClickListener(this.mOnClickListener);
        this.mQueryTextView.setOnClickListener(this.mOnClickListener);
        this.mQueryTextView.addTextChangedListener(this.mTextWatcher);
        this.mQueryTextView.setOnEditorActionListener(this.mOnEditorActionListener);
        this.mQueryTextView.setOnItemClickListener(this.mOnItemClickListener);
        this.mQueryTextView.setOnItemSelectedListener(this.mOnItemSelectedListener);
        this.mQueryTextView.setOnKeyListener(this.mTextKeyListener);
        this.mQueryTextView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl2) {
                if (SearchView.this.mOnQueryTextFocusChangeListener != null) {
                    SearchView.this.mOnQueryTextFocusChangeListener.onFocusChange((View)SearchView.this, bl2);
                }
            }
        });
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SearchView, 0, 0);
        this.setIconifiedByDefault(typedArray.getBoolean(3, true));
        int n4 = typedArray.getDimensionPixelSize(0, -1);
        if (n4 != -1) {
            this.setMaxWidth(n4);
        }
        if (!TextUtils.isEmpty((CharSequence)(charSequence = typedArray.getText(4)))) {
            this.setQueryHint(charSequence);
        }
        if ((n3 = typedArray.getInt(2, -1)) != -1) {
            this.setImeOptions(n3);
        }
        if ((n2 = typedArray.getInt(1, -1)) != -1) {
            this.setInputType(n2);
        }
        typedArray.recycle();
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, R.styleable.View, 0, 0);
        boolean bl2 = typedArray2.getBoolean(0, true);
        typedArray2.recycle();
        this.setFocusable(bl2);
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
        this.mDropDownAnchor = this.findViewById(this.mQueryTextView.getDropDownAnchor());
        if (this.mDropDownAnchor != null) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.addOnLayoutChangeListenerToDropDownAnchorSDK11();
            } else {
                this.addOnLayoutChangeListenerToDropDownAnchorBase();
            }
        }
        this.updateViewsVisibility(this.mIconifiedByDefault);
        this.updateQueryHint();
    }

    private void addOnLayoutChangeListenerToDropDownAnchorBase() {
        this.mDropDownAnchor.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                SearchView.this.adjustDropDownSizeAndPosition();
            }
        });
    }

    private void addOnLayoutChangeListenerToDropDownAnchorSDK11() {
        this.mDropDownAnchor.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
                SearchView.this.adjustDropDownSizeAndPosition();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustDropDownSizeAndPosition() {
        if (this.mDropDownAnchor.getWidth() > 1) {
            Resources resources = this.getContext().getResources();
            int n2 = this.mSearchPlate.getPaddingLeft();
            Rect rect = new Rect();
            int n3 = this.mIconifiedByDefault ? resources.getDimensionPixelSize(R.dimen.abc_dropdownitem_icon_width) + resources.getDimensionPixelSize(R.dimen.abc_dropdownitem_text_padding_left) : 0;
            this.mQueryTextView.getDropDownBackground().getPadding(rect);
            int n4 = n2 - (n3 + rect.left);
            this.mQueryTextView.setDropDownHorizontalOffset(n4);
            int n5 = n3 + (this.mDropDownAnchor.getWidth() + rect.left + rect.right) - n2;
            this.mQueryTextView.setDropDownWidth(n5);
        }
    }

    private Intent createIntent(String string2, Uri uri, String string3, String string4, int n2, String string5) {
        Intent intent = new Intent(string2);
        intent.addFlags(0x10000000);
        if (uri != null) {
            intent.setData(uri);
        }
        intent.putExtra("user_query", this.mUserQuery);
        if (string4 != null) {
            intent.putExtra("query", string4);
        }
        if (string3 != null) {
            intent.putExtra("intent_extra_data_key", string3);
        }
        if (this.mAppSearchData != null) {
            intent.putExtra("app_data", this.mAppSearchData);
        }
        if (n2 != 0) {
            intent.putExtra("action_key", n2);
            intent.putExtra("action_msg", string5);
        }
        intent.setComponent(this.mSearchable.getSearchActivity());
        return intent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Intent createIntentFromSuggestion(Cursor cursor, int n2, String string2) {
        Uri uri;
        String string3;
        String string4;
        String string5;
        try {
            string5 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_action");
            if (string5 == null) {
                string5 = this.mSearchable.getSuggestIntentAction();
            }
        }
        catch (RuntimeException runtimeException) {
            int n3;
            try {
                int n4;
                n3 = n4 = cursor.getPosition();
            }
            catch (RuntimeException runtimeException2) {
                n3 = -1;
            }
            Log.w((String)LOG_TAG, (String)("Search suggestions cursor at row " + n3 + " returned exception."), (Throwable)runtimeException);
            return null;
        }
        if (string5 == null) {
            string5 = "android.intent.action.SEARCH";
        }
        if ((string4 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) == null) {
            string4 = this.mSearchable.getSuggestIntentData();
        }
        if (string4 != null && (string3 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data_id")) != null) {
            string4 = string4 + "/" + Uri.encode((String)string3);
        }
        Uri uri2 = string4 == null ? null : (uri = Uri.parse((String)string4));
        String string6 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
        return this.createIntent(string5, uri2, SuggestionsAdapter.getColumnString(cursor, "suggest_intent_extra_data"), string6, n2, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Intent createVoiceAppSearchIntent(Intent intent, SearchableInfo searchableInfo) {
        ComponentName componentName = searchableInfo.getSearchActivity();
        Intent intent2 = new Intent("android.intent.action.SEARCH");
        intent2.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.getContext(), (int)0, (Intent)intent2, (int)0x40000000);
        Bundle bundle = new Bundle();
        if (this.mAppSearchData != null) {
            bundle.putParcelable("app_data", (Parcelable)this.mAppSearchData);
        }
        Intent intent3 = new Intent(intent);
        String string2 = "free_form";
        int n2 = 1;
        Resources resources = this.getResources();
        if (searchableInfo.getVoiceLanguageModeId() != 0) {
            string2 = resources.getString(searchableInfo.getVoiceLanguageModeId());
        }
        int n3 = searchableInfo.getVoicePromptTextId();
        String string3 = null;
        if (n3 != 0) {
            string3 = resources.getString(searchableInfo.getVoicePromptTextId());
        }
        int n4 = searchableInfo.getVoiceLanguageId();
        String string4 = null;
        if (n4 != 0) {
            string4 = resources.getString(searchableInfo.getVoiceLanguageId());
        }
        if (searchableInfo.getVoiceMaxResults() != 0) {
            n2 = searchableInfo.getVoiceMaxResults();
        }
        intent3.putExtra("android.speech.extra.LANGUAGE_MODEL", string2);
        intent3.putExtra("android.speech.extra.PROMPT", string3);
        intent3.putExtra("android.speech.extra.LANGUAGE", string4);
        intent3.putExtra("android.speech.extra.MAX_RESULTS", n2);
        String string5 = componentName == null ? null : componentName.flattenToShortString();
        intent3.putExtra("calling_package", string5);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", (Parcelable)pendingIntent);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", bundle);
        return intent3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Intent createVoiceWebSearchIntent(Intent intent, SearchableInfo searchableInfo) {
        Intent intent2 = new Intent(intent);
        ComponentName componentName = searchableInfo.getSearchActivity();
        String string2 = componentName == null ? null : componentName.flattenToShortString();
        intent2.putExtra("calling_package", string2);
        return intent2;
    }

    private void dismissSuggestions() {
        this.mQueryTextView.dismissDropDown();
    }

    private void forceSuggestionQuery() {
        HIDDEN_METHOD_INVOKER.doBeforeTextChanged(this.mQueryTextView);
        HIDDEN_METHOD_INVOKER.doAfterTextChanged(this.mQueryTextView);
    }

    private CharSequence getDecoratedHint(CharSequence charSequence) {
        if (!this.mIconifiedByDefault) {
            return charSequence;
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)"   ");
        spannableStringBuilder.append(charSequence);
        Drawable drawable2 = this.getContext().getResources().getDrawable(this.getSearchIconId());
        int n2 = (int)(1.25 * (double)this.mQueryTextView.getTextSize());
        drawable2.setBounds(0, 0, n2, n2);
        spannableStringBuilder.setSpan((Object)new ImageSpan(drawable2), 1, 2, 33);
        return spannableStringBuilder;
    }

    private int getPreferredWidth() {
        return this.getContext().getResources().getDimensionPixelSize(R.dimen.abc_search_view_preferred_width);
    }

    private int getSearchIconId() {
        TypedValue typedValue = new TypedValue();
        this.getContext().getTheme().resolveAttribute(R.attr.searchViewSearchIcon, typedValue, true);
        return typedValue.resourceId;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasVoiceSearch() {
        Intent intent;
        SearchableInfo searchableInfo = this.mSearchable;
        boolean bl2 = false;
        if (searchableInfo == null) return bl2;
        boolean bl3 = this.mSearchable.getVoiceSearchEnabled();
        bl2 = false;
        if (!bl3) return bl2;
        if (this.mSearchable.getVoiceSearchLaunchWebSearch()) {
            intent = this.mVoiceWebSearchIntent;
        } else {
            boolean bl4 = this.mSearchable.getVoiceSearchLaunchRecognizer();
            intent = null;
            if (bl4) {
                intent = this.mVoiceAppSearchIntent;
            }
        }
        bl2 = false;
        if (intent == null) return bl2;
        ResolveInfo resolveInfo = this.getContext().getPackageManager().resolveActivity(intent, 65536);
        bl2 = false;
        if (resolveInfo == null) return bl2;
        return true;
    }

    static boolean isLandscapeMode(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    private boolean isSubmitAreaEnabled() {
        return (this.mSubmitButtonEnabled || this.mVoiceButtonEnabled) && !this.isIconified();
    }

    private void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        try {
            this.getContext().startActivity(intent);
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.e((String)LOG_TAG, (String)("Failed launch activity: " + intent), (Throwable)runtimeException);
            return;
        }
    }

    private void launchQuerySearch(int n2, String string2, String string3) {
        Intent intent = this.createIntent("android.intent.action.SEARCH", null, null, string3, n2, string2);
        this.getContext().startActivity(intent);
    }

    private boolean launchSuggestion(int n2, int n3, String string2) {
        Cursor cursor = this.mSuggestionsAdapter.getCursor();
        if (cursor != null && cursor.moveToPosition(n2)) {
            this.launchIntent(this.createIntentFromSuggestion(cursor, n3, string2));
            return true;
        }
        return false;
    }

    private void onCloseClicked() {
        if (TextUtils.isEmpty((CharSequence)this.mQueryTextView.getText())) {
            if (this.mIconifiedByDefault && (this.mOnCloseListener == null || !this.mOnCloseListener.onClose())) {
                this.clearFocus();
                this.updateViewsVisibility(true);
            }
            return;
        }
        this.mQueryTextView.setText("");
        this.mQueryTextView.requestFocus();
        this.setImeVisibility(true);
    }

    private boolean onItemClicked(int n2, int n3, String string2) {
        boolean bl2;
        block3: {
            block2: {
                if (this.mOnSuggestionListener == null) break block2;
                boolean bl3 = this.mOnSuggestionListener.onSuggestionClick(n2);
                bl2 = false;
                if (bl3) break block3;
            }
            this.launchSuggestion(n2, 0, null);
            this.setImeVisibility(false);
            this.dismissSuggestions();
            bl2 = true;
        }
        return bl2;
    }

    private boolean onItemSelected(int n2) {
        if (this.mOnSuggestionListener == null || !this.mOnSuggestionListener.onSuggestionSelect(n2)) {
            this.rewriteQueryFromSuggestion(n2);
            return true;
        }
        return false;
    }

    private void onSearchClicked() {
        this.updateViewsVisibility(false);
        this.mQueryTextView.requestFocus();
        this.setImeVisibility(true);
        if (this.mOnSearchClickListener != null) {
            this.mOnSearchClickListener.onClick((View)this);
        }
    }

    private void onSubmitQuery() {
        Editable editable = this.mQueryTextView.getText();
        if (!(editable == null || TextUtils.getTrimmedLength((CharSequence)editable) <= 0 || this.mOnQueryChangeListener != null && this.mOnQueryChangeListener.onQueryTextSubmit(editable.toString()))) {
            if (this.mSearchable != null) {
                this.launchQuerySearch(0, null, editable.toString());
                this.setImeVisibility(false);
            }
            this.dismissSuggestions();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean onSuggestionsKey(View view, int n2, KeyEvent keyEvent) {
        block6: {
            block5: {
                if (this.mSearchable == null || this.mSuggestionsAdapter == null || keyEvent.getAction() != 0 || !KeyEventCompat.hasNoModifiers(keyEvent)) break block5;
                if (n2 == 66 || n2 == 84 || n2 == 61) {
                    return this.onItemClicked(this.mQueryTextView.getListSelection(), 0, null);
                }
                if (n2 == 21 || n2 == 22) {
                    int n3 = n2 == 21 ? 0 : this.mQueryTextView.length();
                    this.mQueryTextView.setSelection(n3);
                    this.mQueryTextView.setListSelection(0);
                    this.mQueryTextView.clearListSelection();
                    HIDDEN_METHOD_INVOKER.ensureImeVisible(this.mQueryTextView, true);
                    return true;
                }
                if (n2 == 19 && this.mQueryTextView.getListSelection() == 0) break block6;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onTextChanged(CharSequence charSequence) {
        boolean bl2 = true;
        Editable editable = this.mQueryTextView.getText();
        this.mUserQuery = editable;
        boolean bl3 = !TextUtils.isEmpty((CharSequence)editable) ? bl2 : false;
        this.updateSubmitButton(bl3);
        if (bl3) {
            bl2 = false;
        }
        this.updateVoiceButton(bl2);
        this.updateCloseButton();
        this.updateSubmitArea();
        if (this.mOnQueryChangeListener != null && !TextUtils.equals((CharSequence)charSequence, (CharSequence)this.mOldQueryText)) {
            this.mOnQueryChangeListener.onQueryTextChange(((Object)charSequence).toString());
        }
        this.mOldQueryText = ((Object)charSequence).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onVoiceClicked() {
        SearchableInfo searchableInfo;
        block6: {
            block5: {
                if (this.mSearchable != null) {
                    searchableInfo = this.mSearchable;
                    try {
                        if (searchableInfo.getVoiceSearchLaunchWebSearch()) {
                            Intent intent = this.createVoiceWebSearchIntent(this.mVoiceWebSearchIntent, searchableInfo);
                            this.getContext().startActivity(intent);
                            return;
                        }
                        if (!searchableInfo.getVoiceSearchLaunchRecognizer()) break block5;
                        break block6;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        Log.w((String)LOG_TAG, (String)"Could not find voice search activity");
                        return;
                    }
                }
            }
            return;
        }
        Intent intent = this.createVoiceAppSearchIntent(this.mVoiceAppSearchIntent, searchableInfo);
        this.getContext().startActivity(intent);
    }

    private void postUpdateFocusedState() {
        this.post(this.mUpdateDrawableStateRunnable);
    }

    private void rewriteQueryFromSuggestion(int n2) {
        Editable editable = this.mQueryTextView.getText();
        Cursor cursor = this.mSuggestionsAdapter.getCursor();
        if (cursor == null) {
            return;
        }
        if (cursor.moveToPosition(n2)) {
            CharSequence charSequence = this.mSuggestionsAdapter.convertToString(cursor);
            if (charSequence != null) {
                this.setQuery(charSequence);
                return;
            }
            this.setQuery((CharSequence)editable);
            return;
        }
        this.setQuery((CharSequence)editable);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setImeVisibility(boolean bl2) {
        if (bl2) {
            this.post(this.mShowImeRunnable);
            return;
        } else {
            this.removeCallbacks(this.mShowImeRunnable);
            InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
            if (inputMethodManager == null) return;
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setQuery(CharSequence charSequence) {
        this.mQueryTextView.setText(charSequence);
        SearchAutoComplete searchAutoComplete = this.mQueryTextView;
        int n2 = TextUtils.isEmpty((CharSequence)charSequence) ? 0 : charSequence.length();
        searchAutoComplete.setSelection(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateCloseButton() {
        boolean bl2 = true;
        boolean bl3 = !TextUtils.isEmpty((CharSequence)this.mQueryTextView.getText()) ? bl2 : false;
        if (!(bl3 || this.mIconifiedByDefault && !this.mExpandedInActionView)) {
            bl2 = false;
        }
        ImageView imageView = this.mCloseButton;
        int n2 = 0;
        if (!bl2) {
            n2 = 8;
        }
        imageView.setVisibility(n2);
        Drawable drawable2 = this.mCloseButton.getDrawable();
        int[] nArray = bl3 ? ENABLED_STATE_SET : EMPTY_STATE_SET;
        drawable2.setState(nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateFocusedState() {
        boolean bl2 = this.mQueryTextView.hasFocus();
        Drawable drawable2 = this.mSearchPlate.getBackground();
        int[] nArray = bl2 ? FOCUSED_STATE_SET : EMPTY_STATE_SET;
        drawable2.setState(nArray);
        Drawable drawable3 = this.mSubmitArea.getBackground();
        int[] nArray2 = bl2 ? FOCUSED_STATE_SET : EMPTY_STATE_SET;
        drawable3.setState(nArray2);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateQueryHint() {
        if (this.mQueryHint != null) {
            this.mQueryTextView.setHint(this.getDecoratedHint(this.mQueryHint));
            return;
        } else {
            if (this.mSearchable == null) {
                this.mQueryTextView.setHint(this.getDecoratedHint(""));
                return;
            }
            int n2 = this.mSearchable.getHintId();
            String string2 = null;
            if (n2 != 0) {
                string2 = this.getContext().getString(n2);
            }
            if (string2 == null) return;
            this.mQueryTextView.setHint(this.getDecoratedHint(string2));
            return;
        }
    }

    private void updateSearchAutoComplete() {
        int n2 = 1;
        this.mQueryTextView.setThreshold(this.mSearchable.getSuggestThreshold());
        this.mQueryTextView.setImeOptions(this.mSearchable.getImeOptions());
        int n3 = this.mSearchable.getInputType();
        if ((n3 & 0xF) == n2) {
            n3 &= 0xFFFEFFFF;
            if (this.mSearchable.getSuggestAuthority() != null) {
                n3 = 0x80000 | (n3 | 0x10000);
            }
        }
        this.mQueryTextView.setInputType(n3);
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.changeCursor(null);
        }
        if (this.mSearchable.getSuggestAuthority() != null) {
            this.mSuggestionsAdapter = new SuggestionsAdapter(this.getContext(), this, this.mSearchable, this.mOutsideDrawablesCache);
            this.mQueryTextView.setAdapter((ListAdapter)this.mSuggestionsAdapter);
            SuggestionsAdapter suggestionsAdapter = (SuggestionsAdapter)this.mSuggestionsAdapter;
            if (this.mQueryRefinement) {
                n2 = 2;
            }
            suggestionsAdapter.setQueryRefinement(n2);
        }
    }

    private void updateSubmitArea() {
        int n2 = 8;
        if (this.isSubmitAreaEnabled() && (this.mSubmitButton.getVisibility() == 0 || this.mVoiceButton.getVisibility() == 0)) {
            n2 = 0;
        }
        this.mSubmitArea.setVisibility(n2);
    }

    private void updateSubmitButton(boolean bl2) {
        int n2 = 8;
        if (this.mSubmitButtonEnabled && this.isSubmitAreaEnabled() && this.hasFocus() && (bl2 || !this.mVoiceButtonEnabled)) {
            n2 = 0;
        }
        this.mSubmitButton.setVisibility(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateViewsVisibility(boolean bl2) {
        boolean bl3 = true;
        int n2 = 8;
        this.mIconified = bl2;
        int n3 = bl2 ? 0 : n2;
        boolean bl4 = !TextUtils.isEmpty((CharSequence)this.mQueryTextView.getText()) ? bl3 : false;
        this.mSearchButton.setVisibility(n3);
        this.updateSubmitButton(bl4);
        View view = this.mSearchEditFrame;
        int n4 = bl2 ? n2 : 0;
        view.setVisibility(n4);
        ImageView imageView = this.mSearchHintIcon;
        if (!this.mIconifiedByDefault) {
            n2 = 0;
        }
        imageView.setVisibility(n2);
        this.updateCloseButton();
        if (bl4) {
            bl3 = false;
        }
        this.updateVoiceButton(bl3);
        this.updateSubmitArea();
    }

    private void updateVoiceButton(boolean bl2) {
        int n2 = 8;
        if (this.mVoiceButtonEnabled && !this.isIconified() && bl2) {
            n2 = 0;
            this.mSubmitButton.setVisibility(8);
        }
        this.mVoiceButton.setVisibility(n2);
    }

    public void clearFocus() {
        this.mClearingFocus = true;
        this.setImeVisibility(false);
        super.clearFocus();
        this.mQueryTextView.clearFocus();
        this.mClearingFocus = false;
    }

    public int getImeOptions() {
        return this.mQueryTextView.getImeOptions();
    }

    public int getInputType() {
        return this.mQueryTextView.getInputType();
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public CharSequence getQuery() {
        return this.mQueryTextView.getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getQueryHint() {
        if (this.mQueryHint != null) {
            return this.mQueryHint;
        }
        if (this.mSearchable == null) return null;
        int n2 = this.mSearchable.getHintId();
        CharSequence charSequence = null;
        if (n2 == 0) return charSequence;
        return this.getContext().getString(n2);
    }

    public CursorAdapter getSuggestionsAdapter() {
        return this.mSuggestionsAdapter;
    }

    public boolean isIconfiedByDefault() {
        return this.mIconifiedByDefault;
    }

    public boolean isIconified() {
        return this.mIconified;
    }

    public boolean isQueryRefinementEnabled() {
        return this.mQueryRefinement;
    }

    public boolean isSubmitButtonEnabled() {
        return this.mSubmitButtonEnabled;
    }

    @Override
    public void onActionViewCollapsed() {
        this.clearFocus();
        this.updateViewsVisibility(true);
        this.mQueryTextView.setImeOptions(this.mCollapsedImeOptions);
        this.mExpandedInActionView = false;
    }

    @Override
    public void onActionViewExpanded() {
        if (this.mExpandedInActionView) {
            return;
        }
        this.mExpandedInActionView = true;
        this.mCollapsedImeOptions = this.mQueryTextView.getImeOptions();
        this.mQueryTextView.setImeOptions(0x2000000 | this.mCollapsedImeOptions);
        this.mQueryTextView.setText("");
        this.setIconified(false);
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mUpdateDrawableStateRunnable);
        this.post(this.mReleaseCursorRunnable);
        super.onDetachedFromWindow();
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (this.mSearchable == null) {
            return false;
        }
        return super.onKeyDown(n2, keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        if (this.isIconified()) {
            super.onMeasure(n2, n3);
            return;
        }
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n2);
        switch (n4) {
            case -2147483648: {
                if (this.mMaxWidth > 0) {
                    n5 = Math.min(this.mMaxWidth, n5);
                    break;
                }
                n5 = Math.min(this.getPreferredWidth(), n5);
                break;
            }
            case 0x40000000: {
                if (this.mMaxWidth <= 0) break;
                n5 = Math.min(this.mMaxWidth, n5);
                break;
            }
            case 0: {
                if (this.mMaxWidth > 0) {
                    n5 = this.mMaxWidth;
                    break;
                }
                n5 = this.getPreferredWidth();
                break;
            }
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n5, (int)0x40000000), n3);
    }

    void onQueryRefine(CharSequence charSequence) {
        this.setQuery(charSequence);
    }

    void onTextFocusChanged() {
        this.updateViewsVisibility(this.isIconified());
        this.postUpdateFocusedState();
        if (this.mQueryTextView.hasFocus()) {
            this.forceSuggestionQuery();
        }
    }

    public void onWindowFocusChanged(boolean bl2) {
        super.onWindowFocusChanged(bl2);
        this.postUpdateFocusedState();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requestFocus(int n2, Rect rect) {
        if (this.mClearingFocus) {
            return false;
        }
        if (!this.isFocusable()) {
            return false;
        }
        if (this.isIconified()) return super.requestFocus(n2, rect);
        boolean bl2 = this.mQueryTextView.requestFocus(n2, rect);
        if (!bl2) return bl2;
        this.updateViewsVisibility(false);
        return bl2;
    }

    public void setAppSearchData(Bundle bundle) {
        this.mAppSearchData = bundle;
    }

    public void setIconified(boolean bl2) {
        if (bl2) {
            this.onCloseClicked();
            return;
        }
        this.onSearchClicked();
    }

    public void setIconifiedByDefault(boolean bl2) {
        if (this.mIconifiedByDefault == bl2) {
            return;
        }
        this.mIconifiedByDefault = bl2;
        this.updateViewsVisibility(bl2);
        this.updateQueryHint();
    }

    public void setImeOptions(int n2) {
        this.mQueryTextView.setImeOptions(n2);
    }

    public void setInputType(int n2) {
        this.mQueryTextView.setInputType(n2);
    }

    public void setMaxWidth(int n2) {
        this.mMaxWidth = n2;
        this.requestLayout();
    }

    public void setOnCloseListener(OnCloseListener onCloseListener) {
        this.mOnCloseListener = onCloseListener;
    }

    public void setOnQueryTextFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.mOnQueryTextFocusChangeListener = onFocusChangeListener;
    }

    public void setOnQueryTextListener(OnQueryTextListener onQueryTextListener) {
        this.mOnQueryChangeListener = onQueryTextListener;
    }

    public void setOnSearchClickListener(View.OnClickListener onClickListener) {
        this.mOnSearchClickListener = onClickListener;
    }

    public void setOnSuggestionListener(OnSuggestionListener onSuggestionListener) {
        this.mOnSuggestionListener = onSuggestionListener;
    }

    public void setQuery(CharSequence charSequence, boolean bl2) {
        this.mQueryTextView.setText(charSequence);
        if (charSequence != null) {
            this.mQueryTextView.setSelection(this.mQueryTextView.length());
            this.mUserQuery = charSequence;
        }
        if (bl2 && !TextUtils.isEmpty((CharSequence)charSequence)) {
            this.onSubmitQuery();
        }
    }

    public void setQueryHint(CharSequence charSequence) {
        this.mQueryHint = charSequence;
        this.updateQueryHint();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setQueryRefinementEnabled(boolean bl2) {
        this.mQueryRefinement = bl2;
        if (this.mSuggestionsAdapter instanceof SuggestionsAdapter) {
            SuggestionsAdapter suggestionsAdapter = (SuggestionsAdapter)this.mSuggestionsAdapter;
            int n2 = bl2 ? 2 : 1;
            suggestionsAdapter.setQueryRefinement(n2);
        }
    }

    public void setSearchableInfo(SearchableInfo searchableInfo) {
        this.mSearchable = searchableInfo;
        if (this.mSearchable != null) {
            this.updateSearchAutoComplete();
            this.updateQueryHint();
        }
        this.mVoiceButtonEnabled = this.hasVoiceSearch();
        if (this.mVoiceButtonEnabled) {
            this.mQueryTextView.setPrivateImeOptions(IME_OPTION_NO_MICROPHONE);
        }
        this.updateViewsVisibility(this.isIconified());
    }

    public void setSubmitButtonEnabled(boolean bl2) {
        this.mSubmitButtonEnabled = bl2;
        this.updateViewsVisibility(this.isIconified());
    }

    public void setSuggestionsAdapter(CursorAdapter cursorAdapter) {
        this.mSuggestionsAdapter = cursorAdapter;
        this.mQueryTextView.setAdapter((ListAdapter)this.mSuggestionsAdapter);
    }

    private static class AutoCompleteTextViewReflector {
        private Method doAfterTextChanged;
        private Method doBeforeTextChanged;
        private Method ensureImeVisible;
        private Method showSoftInputUnchecked;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        AutoCompleteTextViewReflector() {
            try {
                this.doBeforeTextChanged = AutoCompleteTextView.class.getDeclaredMethod("doBeforeTextChanged", new Class[0]);
                this.doBeforeTextChanged.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                this.doAfterTextChanged = AutoCompleteTextView.class.getDeclaredMethod("doAfterTextChanged", new Class[0]);
                this.doAfterTextChanged.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                Class[] classArray = new Class[]{Boolean.TYPE};
                this.ensureImeVisible = AutoCompleteTextView.class.getMethod("ensureImeVisible", classArray);
                this.ensureImeVisible.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                Class[] classArray = new Class[]{Integer.TYPE, ResultReceiver.class};
                this.showSoftInputUnchecked = InputMethodManager.class.getMethod("showSoftInputUnchecked", classArray);
                this.showSoftInputUnchecked.setAccessible(true);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void doAfterTextChanged(AutoCompleteTextView autoCompleteTextView) {
            if (this.doAfterTextChanged == null) return;
            try {
                this.doAfterTextChanged.invoke((Object)autoCompleteTextView, new Object[0]);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void doBeforeTextChanged(AutoCompleteTextView autoCompleteTextView) {
            if (this.doBeforeTextChanged == null) return;
            try {
                this.doBeforeTextChanged.invoke((Object)autoCompleteTextView, new Object[0]);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void ensureImeVisible(AutoCompleteTextView autoCompleteTextView, boolean bl2) {
            if (this.ensureImeVisible == null) return;
            try {
                Method method = this.ensureImeVisible;
                Object[] objectArray = new Object[]{bl2};
                method.invoke((Object)autoCompleteTextView, objectArray);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        void showSoftInputUnchecked(InputMethodManager inputMethodManager, View view, int n2) {
            if (this.showSoftInputUnchecked != null) {
                try {
                    Method method = this.showSoftInputUnchecked;
                    Object[] objectArray = new Object[]{n2, null};
                    method.invoke((Object)inputMethodManager, objectArray);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            inputMethodManager.showSoftInput(view, n2);
        }
    }

    public static interface OnCloseListener {
        public boolean onClose();
    }

    public static interface OnQueryTextListener {
        public boolean onQueryTextChange(String var1);

        public boolean onQueryTextSubmit(String var1);
    }

    public static interface OnSuggestionListener {
        public boolean onSuggestionClick(int var1);

        public boolean onSuggestionSelect(int var1);
    }

    public static class SearchAutoComplete
    extends AutoCompleteTextView {
        private SearchView mSearchView;
        private int mThreshold = this.getThreshold();

        public SearchAutoComplete(Context context) {
            super(context);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet, int n2) {
            super(context, attributeSet, n2);
        }

        private boolean isEmpty() {
            return TextUtils.getTrimmedLength((CharSequence)this.getText()) == 0;
        }

        public boolean enoughToFilter() {
            return this.mThreshold <= 0 || super.enoughToFilter();
        }

        protected void onFocusChanged(boolean bl2, int n2, Rect rect) {
            super.onFocusChanged(bl2, n2, rect);
            this.mSearchView.onTextFocusChanged();
        }

        public boolean onKeyPreIme(int n2, KeyEvent keyEvent) {
            if (n2 == 4) {
                if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
                    if (dispatcherState != null) {
                        dispatcherState.startTracking(keyEvent, (Object)this);
                    }
                    return true;
                }
                if (keyEvent.getAction() == 1) {
                    KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
                    if (dispatcherState != null) {
                        dispatcherState.handleUpEvent(keyEvent);
                    }
                    if (keyEvent.isTracking() && !keyEvent.isCanceled()) {
                        this.mSearchView.clearFocus();
                        this.mSearchView.setImeVisibility(false);
                        return true;
                    }
                }
            }
            return super.onKeyPreIme(n2, keyEvent);
        }

        public void onWindowFocusChanged(boolean bl2) {
            super.onWindowFocusChanged(bl2);
            if (bl2 && this.mSearchView.hasFocus() && this.getVisibility() == 0) {
                ((InputMethodManager)this.getContext().getSystemService("input_method")).showSoftInput((View)this, 0);
                if (SearchView.isLandscapeMode(this.getContext())) {
                    HIDDEN_METHOD_INVOKER.ensureImeVisible(this, true);
                }
            }
        }

        public void performCompletion() {
        }

        protected void replaceText(CharSequence charSequence) {
        }

        void setSearchView(SearchView searchView) {
            this.mSearchView = searchView;
        }

        public void setThreshold(int n2) {
            super.setThreshold(n2);
            this.mThreshold = n2;
        }
    }
}

