/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v7.gridlayout.R;
import android.support.v7.widget.Space;
import android.support.v7.widget.ViewGroup;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GridLayout
extends ViewGroup {
    private static final int ALIGNMENT_MODE = 4;
    public static final int ALIGN_BOUNDS = 0;
    public static final int ALIGN_MARGINS = 1;
    public static final Alignment BASELINE;
    public static final Alignment BOTTOM;
    private static final int CAN_STRETCH = 2;
    public static final Alignment CENTER;
    private static final int COLUMN_COUNT = 2;
    private static final int COLUMN_ORDER_PRESERVED = 6;
    static final boolean DEBUG = false;
    private static final int DEFAULT_ALIGNMENT_MODE = 1;
    static final int DEFAULT_CONTAINER_MARGIN = 0;
    private static final int DEFAULT_COUNT = Integer.MIN_VALUE;
    private static final boolean DEFAULT_ORDER_PRESERVED = true;
    private static final int DEFAULT_ORIENTATION = 0;
    private static final boolean DEFAULT_USE_DEFAULT_MARGINS = false;
    public static final Alignment END;
    public static final Alignment FILL;
    public static final int HORIZONTAL = 0;
    private static final int INFLEXIBLE = 0;
    private static final Alignment LEADING;
    public static final Alignment LEFT;
    static final int MAX_SIZE = 100000;
    private static final int ORIENTATION = 0;
    public static final Alignment RIGHT;
    private static final int ROW_COUNT = 1;
    private static final int ROW_ORDER_PRESERVED = 5;
    public static final Alignment START;
    static final String TAG;
    public static final Alignment TOP;
    private static final Alignment TRAILING;
    public static final int UNDEFINED = Integer.MIN_VALUE;
    static final Alignment UNDEFINED_ALIGNMENT;
    static final int UNINITIALIZED_HASH = 0;
    private static final int USE_DEFAULT_MARGINS = 3;
    public static final int VERTICAL = 1;
    int alignmentMode = 1;
    int defaultGap;
    final Axis horizontalAxis = new Axis(true);
    int lastLayoutParamsHashCode = 0;
    boolean layoutParamsValid = false;
    int orientation = 0;
    boolean useDefaultMargins = false;
    final Axis verticalAxis = new Axis(false);

    static {
        TAG = GridLayout.class.getName();
        UNDEFINED_ALIGNMENT = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n2) {
                return Integer.MIN_VALUE;
            }

            @Override
            int getGravityOffset(View view, int n2) {
                return Integer.MIN_VALUE;
            }
        };
        LEADING = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n2) {
                return 0;
            }

            @Override
            int getGravityOffset(View view, int n2) {
                return 0;
            }
        };
        TRAILING = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n2) {
                return n2;
            }

            @Override
            int getGravityOffset(View view, int n2) {
                return n2;
            }
        };
        TOP = LEADING;
        BOTTOM = TRAILING;
        START = LEADING;
        END = TRAILING;
        LEFT = GridLayout.createSwitchingAlignment(START, END);
        RIGHT = GridLayout.createSwitchingAlignment(END, START);
        CENTER = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n2) {
                return n2 >> 1;
            }

            @Override
            int getGravityOffset(View view, int n2) {
                return n2 >> 1;
            }
        };
        BASELINE = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n2) {
                int n3 = view.getBaseline();
                if (n3 == -1) {
                    n3 = Integer.MIN_VALUE;
                }
                return n3;
            }

            @Override
            public Bounds getBounds() {
                return new Bounds(){
                    private int size;

                    @Override
                    protected int getOffset(View view, Alignment alignment, int n2) {
                        return Math.max(0, super.getOffset(view, alignment, n2));
                    }

                    @Override
                    protected void include(int n2, int n3) {
                        super.include(n2, n3);
                        this.size = Math.max(this.size, n2 + n3);
                    }

                    @Override
                    protected void reset() {
                        super.reset();
                        this.size = Integer.MIN_VALUE;
                    }

                    @Override
                    protected int size(boolean bl2) {
                        return Math.max(super.size(bl2), this.size);
                    }
                };
            }

            @Override
            int getGravityOffset(View view, int n2) {
                return 0;
            }
        };
        FILL = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n2) {
                return Integer.MIN_VALUE;
            }

            @Override
            int getGravityOffset(View view, int n2) {
                return 0;
            }

            @Override
            public int getSizeInCell(View view, int n2, int n3) {
                return n3;
            }
        };
    }

    public GridLayout(Context context) {
        this(context, null);
    }

    public GridLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public GridLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.defaultGap = context.getResources().getDimensionPixelOffset(R.dimen.default_gap);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GridLayout);
        try {
            this.setRowCount(typedArray.getInt(1, Integer.MIN_VALUE));
            this.setColumnCount(typedArray.getInt(2, Integer.MIN_VALUE));
            this.setOrientation(typedArray.getInt(0, 0));
            this.setUseDefaultMargins(typedArray.getBoolean(3, false));
            this.setAlignmentMode(typedArray.getInt(4, 1));
            this.setRowOrderPreserved(typedArray.getBoolean(5, true));
            this.setColumnOrderPreserved(typedArray.getBoolean(6, true));
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    static <T> T[] append(T[] TArray, T[] TArray2) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        System.arraycopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
        return objectArray;
    }

    static boolean canStretch(int n2) {
        return (n2 & 2) != 0;
    }

    private void checkForLayoutParamsModification() {
        int n2 = this.computeLayoutParamsHashCode();
        if (this.lastLayoutParamsHashCode != 0 && this.lastLayoutParamsHashCode != n2) {
            this.invalidateStructure();
            Log.w((String)TAG, (String)"The fields of some layout parameters were modified in between layout operations. Check the javadoc for GridLayout.LayoutParams#rowSpec.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int clip(Interval interval, boolean bl2, int n2) {
        int n3;
        int n4 = interval.size();
        if (n2 == 0) {
            return n4;
        }
        if (bl2) {
            n3 = Math.min(interval.min, n2);
            return Math.min(n4, n2 - n3);
        }
        n3 = 0;
        return Math.min(n4, n2 - n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int computeLayoutParamsHashCode() {
        int n2 = 1;
        int n3 = 0;
        int n4 = this.getChildCount();
        while (n3 < n4) {
            View view = this.getChildAt(n3);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                n2 = n2 * 31 + layoutParams.hashCode();
            }
            ++n3;
        }
        return n2;
    }

    private static Alignment createSwitchingAlignment(final Alignment alignment, final Alignment alignment2) {
        return new Alignment(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int getAlignmentValue(View view, int n2) {
                Alignment alignment3;
                if (!ViewGroup.isLayoutRtl(view)) {
                    alignment3 = alignment;
                    return alignment3.getAlignmentValue(view, n2);
                }
                alignment3 = alignment2;
                return alignment3.getAlignmentValue(view, n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            int getGravityOffset(View view, int n2) {
                Alignment alignment3;
                if (!ViewGroup.isLayoutRtl(view)) {
                    alignment3 = alignment;
                    return alignment3.getGravityOffset(view, n2);
                }
                alignment3 = alignment2;
                return alignment3.getGravityOffset(view, n2);
            }
        };
    }

    private void drawLine(Canvas canvas, int n2, int n3, int n4, int n5, Paint paint) {
        int n6 = this.getPaddingLeft();
        int n7 = this.getPaddingTop();
        if (GridLayout.isLayoutRtl((View)this)) {
            int n8 = this.getWidth();
            canvas.drawLine((float)(n8 - n6 - n2), (float)(n7 + n3), (float)(n8 - n6 - n4), (float)(n7 + n5), paint);
            return;
        }
        canvas.drawLine((float)(n6 + n2), (float)(n7 + n3), (float)(n6 + n4), (float)(n7 + n5), paint);
    }

    private static void drawRect(Canvas canvas, int n2, int n3, int n4, int n5, Paint paint) {
        canvas.drawRect((float)n2, (float)n3, (float)(n4 - 1), (float)(n5 - 1), paint);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean fits(int[] nArray, int n2, int n3, int n4) {
        if (n4 <= nArray.length) {
            int n5 = n3;
            while (true) {
                if (n5 >= n4) {
                    return true;
                }
                if (nArray[n5] > n2) break;
                ++n5;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    static Alignment getAlignment(int n2, boolean bl2) {
        int n3 = bl2 ? 7 : 112;
        int n4 = bl2 ? 0 : 4;
        switch ((n2 & n3) >> n4) {
            default: {
                return UNDEFINED_ALIGNMENT;
            }
            case 3: {
                return LEADING;
            }
            case 5: {
                return TRAILING;
            }
            case 7: {
                return FILL;
            }
            case 1: {
                return CENTER;
            }
            case 0x800003: {
                return START;
            }
            case 0x800005: 
        }
        return END;
    }

    private int getDefaultMargin(View view, boolean bl2, boolean bl3) {
        if (view.getClass() == Space.class) {
            return 0;
        }
        return this.defaultGap / 2;
    }

    private int getDefaultMargin(View view, boolean bl2, boolean bl3, boolean bl4) {
        if (bl2) {
            return 0;
        }
        return this.getDefaultMargin(view, bl3, bl4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getDefaultMarginValue(View view, LayoutParams layoutParams, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        if (!this.useDefaultMargins) {
            return 0;
        }
        Spec spec = bl2 ? layoutParams.columnSpec : layoutParams.rowSpec;
        Axis axis = bl2 ? this.horizontalAxis : this.verticalAxis;
        Interval interval = spec.span;
        boolean bl5 = bl2 && GridLayout.isLayoutRtl((View)this) ? (!bl3 ? bl4 : false) : bl3;
        if (!bl5) {
            if (interval.max == axis.getCount()) return this.getDefaultMargin(view, bl4, bl2, bl3);
            bl4 = false;
            return this.getDefaultMargin(view, bl4, bl2, bl3);
        }
        if (interval.min == 0) {
            return this.getDefaultMargin(view, bl4, bl2, bl3);
        }
        bl4 = false;
        return this.getDefaultMargin(view, bl4, bl2, bl3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getMargin(View view, boolean bl2, boolean bl3) {
        int n2;
        if (this.alignmentMode == 1) {
            return this.getMargin1(view, bl2, bl3);
        }
        Axis axis = bl2 ? this.horizontalAxis : this.verticalAxis;
        int[] nArray = bl3 ? axis.getLeadingMargins() : axis.getTrailingMargins();
        LayoutParams layoutParams = this.getLayoutParams(view);
        Spec spec = bl2 ? layoutParams.columnSpec : layoutParams.rowSpec;
        if (bl3) {
            n2 = spec.span.min;
            return nArray[n2];
        }
        n2 = spec.span.max;
        return nArray[n2];
    }

    private int getMeasurement(View view, boolean bl2) {
        if (bl2) {
            return view.getMeasuredWidth();
        }
        return view.getMeasuredHeight();
    }

    private int getTotalMargin(View view, boolean bl2) {
        return this.getMargin(view, bl2, true) + this.getMargin(view, bl2, false);
    }

    private void invalidateStructure() {
        this.layoutParamsValid = false;
        this.horizontalAxis.invalidateStructure();
        this.verticalAxis.invalidateStructure();
        this.invalidateValues();
    }

    private void invalidateValues() {
        if (this.horizontalAxis != null && this.verticalAxis != null) {
            this.horizontalAxis.invalidateValues();
            this.verticalAxis.invalidateValues();
        }
    }

    static int max2(int[] nArray, int n2) {
        int n3 = n2;
        int n4 = nArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 = Math.max(n3, nArray[i2]);
        }
        return n3;
    }

    private void measureChildWithMargins2(View view, int n2, int n3, int n4, int n5) {
        view.measure(GridLayout.getChildMeasureSpec((int)n2, (int)(this.mPaddingLeft + this.mPaddingRight + this.getTotalMargin(view, true)), (int)n4), GridLayout.getChildMeasureSpec((int)n3, (int)(this.mPaddingTop + this.mPaddingBottom + this.getTotalMargin(view, false)), (int)n5));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureChildrenWithMargins(int n2, int n3, boolean bl2) {
        int n4 = 0;
        int n5 = this.getChildCount();
        while (n4 < n5) {
            View view = this.getChildAt(n4);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = this.getLayoutParams(view);
                if (bl2) {
                    this.measureChildWithMargins2(view, n2, n3, layoutParams.width, layoutParams.height);
                } else {
                    boolean bl3 = this.orientation == 0;
                    Spec spec = bl3 ? layoutParams.columnSpec : layoutParams.rowSpec;
                    if (spec.alignment == FILL) {
                        Interval interval = spec.span;
                        Axis axis = bl3 ? this.horizontalAxis : this.verticalAxis;
                        int[] nArray = axis.getLocations();
                        int n6 = nArray[interval.max] - nArray[interval.min] - this.getTotalMargin(view, bl3);
                        if (bl3) {
                            this.measureChildWithMargins2(view, n2, n3, n6, layoutParams.height);
                        } else {
                            this.measureChildWithMargins2(view, n2, n3, layoutParams.width, n6);
                        }
                    }
                }
            }
            ++n4;
        }
        return;
    }

    private static void procrusteanFill(int[] nArray, int n2, int n3, int n4) {
        int n5 = nArray.length;
        Arrays.fill(nArray, Math.min(n2, n5), Math.min(n3, n5), n4);
    }

    private static void setCellGroup(LayoutParams layoutParams, int n2, int n3, int n4, int n5) {
        layoutParams.setRowSpecSpan(new Interval(n2, n2 + n3));
        layoutParams.setColumnSpecSpan(new Interval(n4, n4 + n5));
    }

    public static Spec spec(int n2) {
        return GridLayout.spec(n2, 1);
    }

    public static Spec spec(int n2, int n3) {
        return GridLayout.spec(n2, n3, UNDEFINED_ALIGNMENT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Spec spec(int n2, int n3, Alignment alignment) {
        boolean bl2;
        if (n2 != Integer.MIN_VALUE) {
            bl2 = true;
            return new Spec(bl2, n2, n3, alignment);
        }
        bl2 = false;
        return new Spec(bl2, n2, n3, alignment);
    }

    public static Spec spec(int n2, Alignment alignment) {
        return GridLayout.spec(n2, 1, alignment);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateLayoutParams() {
        boolean bl2 = this.orientation == 0;
        Axis axis = bl2 ? this.horizontalAxis : this.verticalAxis;
        int n2 = axis.definedCount != Integer.MIN_VALUE ? axis.definedCount : 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[n2];
        int n5 = 0;
        int n6 = this.getChildCount();
        while (true) {
            if (n5 >= n6) {
                this.lastLayoutParamsHashCode = this.computeLayoutParamsHashCode();
                this.invalidateStructure();
                return;
            }
            LayoutParams layoutParams = (LayoutParams)this.getChildAt(n5).getLayoutParams();
            Spec spec = bl2 ? layoutParams.rowSpec : layoutParams.columnSpec;
            Interval interval = spec.span;
            boolean bl3 = spec.startDefined;
            int n7 = interval.size();
            if (bl3) {
                n3 = interval.min;
            }
            Spec spec2 = bl2 ? layoutParams.columnSpec : layoutParams.rowSpec;
            Interval interval2 = spec2.span;
            boolean bl4 = spec2.startDefined;
            int n8 = GridLayout.clip(interval2, bl4, n2);
            if (bl4) {
                n4 = interval2.min;
            }
            if (n2 != 0) {
                if (!bl3 || !bl4) {
                    while (!GridLayout.fits(nArray, n3, n4, n4 + n8)) {
                        if (bl4) {
                            ++n3;
                            continue;
                        }
                        if (n4 + n8 <= n2) {
                            ++n4;
                            continue;
                        }
                        ++n3;
                        n4 = 0;
                    }
                }
                GridLayout.procrusteanFill(nArray, n4, n4 + n8, n3 + n7);
            }
            if (bl2) {
                GridLayout.setCellGroup(layoutParams, n3, n7, n4, n8);
            } else {
                GridLayout.setCellGroup(layoutParams, n4, n8, n3, n7);
            }
            n4 += n8;
            ++n5;
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    final Alignment getAlignment(Alignment alignment, boolean bl2) {
        if (alignment != UNDEFINED_ALIGNMENT) {
            return alignment;
        }
        if (bl2) {
            return START;
        }
        return BASELINE;
    }

    public int getAlignmentMode() {
        return this.alignmentMode;
    }

    public int getColumnCount() {
        return this.horizontalAxis.getCount();
    }

    final LayoutParams getLayoutParams(View view) {
        if (!this.layoutParamsValid) {
            this.validateLayoutParams();
            this.layoutParamsValid = true;
        }
        return (LayoutParams)view.getLayoutParams();
    }

    /*
     * Enabled aggressive block sorting
     */
    int getMargin1(View view, boolean bl2, boolean bl3) {
        LayoutParams layoutParams = this.getLayoutParams(view);
        int n2 = bl2 ? (bl3 ? layoutParams.leftMargin : layoutParams.rightMargin) : (bl3 ? layoutParams.topMargin : layoutParams.bottomMargin);
        if (n2 != Integer.MIN_VALUE) return n2;
        return this.getDefaultMarginValue(view, layoutParams, bl2, bl3);
    }

    final int getMeasurementIncludingMargin(View view, boolean bl2) {
        if (view.getVisibility() == 8) {
            return 0;
        }
        return this.getMeasurement(view, bl2) + this.getTotalMargin(view, bl2);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getRowCount() {
        return this.verticalAxis.getCount();
    }

    public boolean getUseDefaultMargins() {
        return this.useDefaultMargins;
    }

    public boolean isColumnOrderPreserved() {
        return this.horizontalAxis.isOrderPreserved();
    }

    public boolean isRowOrderPreserved() {
        return this.verticalAxis.isOrderPreserved();
    }

    protected void onChildVisibilityChanged(View view, int n2, int n3) {
        super.onChildVisibilityChanged(view, n2, n3);
        if (n2 == 8 || n3 == 8) {
            this.invalidateStructure();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)GridLayout.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)GridLayout.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        this.checkForLayoutParamsModification();
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        int n8 = this.getPaddingLeft();
        int n9 = this.getPaddingTop();
        int n10 = this.getPaddingRight();
        int n11 = this.getPaddingBottom();
        this.horizontalAxis.layout(n6 - n8 - n10);
        this.verticalAxis.layout(n7 - n9 - n11);
        int[] nArray = this.horizontalAxis.getLocations();
        int[] nArray2 = this.verticalAxis.getLocations();
        int n12 = 0;
        int n13 = this.getChildCount();
        while (n12 < n13) {
            View view = this.getChildAt(n12);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = this.getLayoutParams(view);
                Spec spec = layoutParams.columnSpec;
                Spec spec2 = layoutParams.rowSpec;
                Interval interval = spec.span;
                Interval interval2 = spec2.span;
                int n14 = nArray[interval.min];
                int n15 = nArray2[interval2.min];
                int n16 = nArray[interval.max];
                int n17 = nArray2[interval2.max];
                int n18 = n16 - n14;
                int n19 = n17 - n15;
                int n20 = this.getMeasurement(view, true);
                int n21 = this.getMeasurement(view, false);
                Alignment alignment = this.getAlignment(spec.alignment, true);
                Alignment alignment2 = this.getAlignment(spec2.alignment, false);
                Bounds bounds = this.horizontalAxis.getGroupBounds().getValue(n12);
                Bounds bounds2 = this.verticalAxis.getGroupBounds().getValue(n12);
                int n22 = alignment.getGravityOffset(view, n18 - bounds.size(true));
                int n23 = alignment2.getGravityOffset(view, n19 - bounds2.size(true));
                int n24 = this.getMargin(view, true, true);
                int n25 = this.getMargin(view, false, true);
                int n26 = this.getMargin(view, true, false);
                int n27 = this.getMargin(view, false, false);
                int n28 = bounds.getOffset(view, alignment, n26 + (n24 + n20));
                int n29 = bounds2.getOffset(view, alignment2, n27 + (n25 + n21));
                int n30 = alignment.getSizeInCell(view, n20, n18 - n24 - n26);
                int n31 = alignment2.getSizeInCell(view, n21, n19 - n25 - n27);
                int n32 = n28 + (n14 + n22);
                int n33 = !GridLayout.isLayoutRtl((View)this) ? n32 + (n8 + n24) : n6 - n30 - n10 - n26 - n32;
                int n34 = n25 + (n29 + (n23 + (n9 + n15)));
                if (n30 != view.getMeasuredWidth() || n31 != view.getMeasuredHeight()) {
                    view.measure(View.MeasureSpec.makeMeasureSpec((int)n30, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n31, (int)0x40000000));
                }
                view.layout(n33, n34, n33 + n30, n34 + n31);
            }
            ++n12;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5;
        this.checkForLayoutParamsModification();
        this.invalidateValues();
        this.measureChildrenWithMargins(n2, n3, true);
        if (this.orientation == 0) {
            n5 = this.horizontalAxis.getMeasure(n2);
            this.measureChildrenWithMargins(n2, n3, false);
            n4 = this.verticalAxis.getMeasure(n3);
        } else {
            n4 = this.verticalAxis.getMeasure(n3);
            this.measureChildrenWithMargins(n2, n3, false);
            n5 = this.horizontalAxis.getMeasure(n2);
        }
        int n6 = this.getPaddingLeft() + this.getPaddingRight();
        int n7 = this.getPaddingTop() + this.getPaddingBottom();
        int n8 = Math.max(n6 + n5, this.getSuggestedMinimumWidth());
        int n9 = Math.max(n7 + n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(GridLayout.resolveSizeAndState(n8, n2, 0), GridLayout.resolveSizeAndState(n9, n3, 0));
    }

    protected void onSetLayoutParams(View view, ViewGroup.LayoutParams layoutParams) {
        super.onSetLayoutParams(view, layoutParams);
        this.invalidateStructure();
    }

    protected void onViewAdded(View view) {
        super.onViewAdded(view);
        this.invalidateStructure();
    }

    protected void onViewRemoved(View view) {
        super.onViewRemoved(view);
        this.invalidateStructure();
    }

    public void requestLayout() {
        super.requestLayout();
        this.invalidateValues();
    }

    public void setAlignmentMode(int n2) {
        this.alignmentMode = n2;
        this.requestLayout();
    }

    public void setColumnCount(int n2) {
        this.horizontalAxis.setCount(n2);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setColumnOrderPreserved(boolean bl2) {
        this.horizontalAxis.setOrderPreserved(bl2);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setOrientation(int n2) {
        if (this.orientation != n2) {
            this.orientation = n2;
            this.invalidateStructure();
            this.requestLayout();
        }
    }

    public void setRowCount(int n2) {
        this.verticalAxis.setCount(n2);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setRowOrderPreserved(boolean bl2) {
        this.verticalAxis.setOrderPreserved(bl2);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setUseDefaultMargins(boolean bl2) {
        this.useDefaultMargins = bl2;
        this.requestLayout();
    }

    public static abstract class Alignment {
        Alignment() {
        }

        abstract int getAlignmentValue(View var1, int var2);

        Bounds getBounds() {
            return new Bounds();
        }

        abstract int getGravityOffset(View var1, int var2);

        int getSizeInCell(View view, int n2, int n3) {
            return n2;
        }
    }

    static final class Arc {
        public final Interval span;
        public boolean valid = true;
        public final MutableInt value;

        public Arc(Interval interval, MutableInt mutableInt) {
            this.span = interval;
            this.value = mutableInt;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            String string2;
            StringBuilder stringBuilder = new StringBuilder().append(this.span).append(" ");
            if (!this.valid) {
                string2 = "+>";
                return stringBuilder.append(string2).append(" ").append(this.value).toString();
            }
            string2 = "->";
            return stringBuilder.append(string2).append(" ").append(this.value).toString();
        }
    }

    static final class Assoc<K, V>
    extends ArrayList<Pair<K, V>> {
        private final Class<K> keyType;
        private final Class<V> valueType;

        private Assoc(Class<K> clazz, Class<V> clazz2) {
            this.keyType = clazz;
            this.valueType = clazz2;
        }

        public static <K, V> Assoc<K, V> of(Class<K> clazz, Class<V> clazz2) {
            return new Assoc<K, V>(clazz, clazz2);
        }

        public PackedMap<K, V> pack() {
            int n2 = this.size();
            Object[] objectArray = (Object[])Array.newInstance(this.keyType, n2);
            Object[] objectArray2 = (Object[])Array.newInstance(this.valueType, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = ((Pair)this.get((int)i2)).first;
                objectArray2[i2] = ((Pair)this.get((int)i2)).second;
            }
            return new PackedMap(objectArray, objectArray2);
        }

        public void put(K k2, V v2) {
            this.add(Pair.create(k2, v2));
        }
    }

    final class Axis {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        private static final int COMPLETE = 2;
        private static final int NEW = 0;
        private static final int PENDING = 1;
        public Arc[] arcs;
        public boolean arcsValid = false;
        PackedMap<Interval, MutableInt> backwardLinks;
        public boolean backwardLinksValid = false;
        public int definedCount = Integer.MIN_VALUE;
        PackedMap<Interval, MutableInt> forwardLinks;
        public boolean forwardLinksValid = false;
        PackedMap<Spec, Bounds> groupBounds;
        public boolean groupBoundsValid = false;
        public final boolean horizontal;
        public int[] leadingMargins;
        public boolean leadingMarginsValid = false;
        public int[] locations;
        public boolean locationsValid = false;
        private int maxIndex = Integer.MIN_VALUE;
        boolean orderPreserved = true;
        private MutableInt parentMax;
        private MutableInt parentMin = new MutableInt(0);
        public int[] trailingMargins;
        public boolean trailingMarginsValid = false;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl2 = !GridLayout.class.desiredAssertionStatus();
            $assertionsDisabled = bl2;
        }

        private Axis(boolean bl2) {
            this.parentMax = new MutableInt(-100000);
            this.horizontal = bl2;
        }

        private void addComponentSizes(List<Arc> list, PackedMap<Interval, MutableInt> packedMap) {
            for (int i2 = 0; i2 < ((Interval[])packedMap.keys).length; ++i2) {
                this.include(list, ((Interval[])packedMap.keys)[i2], ((MutableInt[])packedMap.values)[i2], false);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private String arcsToString(List<Arc> list) {
            String string2 = this.horizontal ? "x" : "y";
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = true;
            Iterator<Arc> iterator = list.iterator();
            while (iterator.hasNext()) {
                Arc arc = iterator.next();
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder = stringBuilder.append(", ");
                }
                int n2 = arc.span.min;
                int n3 = arc.span.max;
                int n4 = arc.value.value;
                String string3 = n2 < n3 ? string2 + n3 + " - " + string2 + n2 + " > " + n4 : string2 + n2 + " - " + string2 + n3 + " < " + -n4;
                stringBuilder.append(string3);
            }
            return stringBuilder.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        private int calculateMaxIndex() {
            int n2 = -1;
            int n3 = GridLayout.this.getChildCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                View view = GridLayout.this.getChildAt(i2);
                LayoutParams layoutParams = GridLayout.this.getLayoutParams(view);
                Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                Interval interval = spec.span;
                n2 = Math.max(Math.max(n2, interval.min), interval.max);
            }
            if (n2 != -1) return n2;
            return Integer.MIN_VALUE;
        }

        private void computeArcs() {
            this.getForwardLinks();
            this.getBackwardLinks();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void computeGroupBounds() {
            Bounds[] boundsArray = (Bounds[])this.groupBounds.values;
            for (int i2 = 0; i2 < boundsArray.length; ++i2) {
                boundsArray[i2].reset();
            }
            int n2 = 0;
            int n3 = GridLayout.this.getChildCount();
            while (n2 < n3) {
                View view = GridLayout.this.getChildAt(n2);
                LayoutParams layoutParams = GridLayout.this.getLayoutParams(view);
                Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                this.groupBounds.getValue(n2).include(view, spec, GridLayout.this, this);
                ++n2;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void computeLinks(PackedMap<Interval, MutableInt> packedMap, boolean bl2) {
            MutableInt[] mutableIntArray = (MutableInt[])packedMap.values;
            for (int i2 = 0; i2 < mutableIntArray.length; ++i2) {
                mutableIntArray[i2].reset();
            }
            Bounds[] boundsArray = (Bounds[])this.getGroupBounds().values;
            int n2 = 0;
            while (n2 < boundsArray.length) {
                int n3 = boundsArray[n2].size(bl2);
                MutableInt mutableInt = packedMap.getValue(n2);
                int n4 = mutableInt.value;
                if (!bl2) {
                    n3 = -n3;
                }
                mutableInt.value = Math.max(n4, n3);
                ++n2;
            }
            return;
        }

        private void computeLocations(int[] nArray) {
            this.solve(this.getArcs(), nArray);
            if (!this.orderPreserved) {
                int n2 = nArray[0];
                int n3 = nArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    nArray[i2] = nArray[i2] - n2;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void computeMargins(boolean bl2) {
            int[] nArray = bl2 ? this.leadingMargins : this.trailingMargins;
            int n2 = 0;
            int n3 = GridLayout.this.getChildCount();
            while (n2 < n3) {
                View view = GridLayout.this.getChildAt(n2);
                if (view.getVisibility() != 8) {
                    LayoutParams layoutParams = GridLayout.this.getLayoutParams(view);
                    Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                    Interval interval = spec.span;
                    int n4 = bl2 ? interval.min : interval.max;
                    nArray[n4] = Math.max(nArray[n4], GridLayout.this.getMargin1(view, this.horizontal, bl2));
                }
                ++n2;
            }
            return;
        }

        private Arc[] createArcs() {
            ArrayList<Arc> arrayList = new ArrayList<Arc>();
            ArrayList<Arc> arrayList2 = new ArrayList<Arc>();
            this.addComponentSizes(arrayList, this.getForwardLinks());
            this.addComponentSizes(arrayList2, this.getBackwardLinks());
            if (this.orderPreserved) {
                for (int i2 = 0; i2 < this.getCount(); ++i2) {
                    this.include(arrayList, new Interval(i2, i2 + 1), new MutableInt(0));
                }
            }
            int n2 = this.getCount();
            this.include(arrayList, new Interval(0, n2), this.parentMin, false);
            this.include(arrayList2, new Interval(n2, 0), this.parentMax, false);
            return GridLayout.append(this.topologicalSort(arrayList), this.topologicalSort(arrayList2));
        }

        /*
         * Enabled aggressive block sorting
         */
        private PackedMap<Spec, Bounds> createGroupBounds() {
            Assoc<Spec, Bounds> assoc = Assoc.of(Spec.class, Bounds.class);
            int n2 = 0;
            int n3 = GridLayout.this.getChildCount();
            while (n2 < n3) {
                View view = GridLayout.this.getChildAt(n2);
                LayoutParams layoutParams = GridLayout.this.getLayoutParams(view);
                Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                assoc.put(spec, GridLayout.this.getAlignment(spec.alignment, this.horizontal).getBounds());
                ++n2;
            }
            return assoc.pack();
        }

        /*
         * Enabled aggressive block sorting
         */
        private PackedMap<Interval, MutableInt> createLinks(boolean bl2) {
            Assoc<Interval, MutableInt> assoc = Assoc.of(Interval.class, MutableInt.class);
            Spec[] specArray = (Spec[])this.getGroupBounds().keys;
            int n2 = 0;
            int n3 = specArray.length;
            while (n2 < n3) {
                Interval interval = bl2 ? specArray[n2].span : specArray[n2].span.inverse();
                assoc.put(interval, new MutableInt());
                ++n2;
            }
            return assoc.pack();
        }

        private PackedMap<Interval, MutableInt> getBackwardLinks() {
            if (this.backwardLinks == null) {
                this.backwardLinks = this.createLinks(false);
            }
            if (!this.backwardLinksValid) {
                this.computeLinks(this.backwardLinks, false);
                this.backwardLinksValid = true;
            }
            return this.backwardLinks;
        }

        private PackedMap<Interval, MutableInt> getForwardLinks() {
            if (this.forwardLinks == null) {
                this.forwardLinks = this.createLinks(true);
            }
            if (!this.forwardLinksValid) {
                this.computeLinks(this.forwardLinks, true);
                this.forwardLinksValid = true;
            }
            return this.forwardLinks;
        }

        private int getMaxIndex() {
            if (this.maxIndex == Integer.MIN_VALUE) {
                this.maxIndex = Math.max(0, this.calculateMaxIndex());
            }
            return this.maxIndex;
        }

        private int getMeasure(int n2, int n3) {
            this.setParentConstraints(n2, n3);
            return this.size(this.getLocations());
        }

        private void include(List<Arc> list, Interval interval, MutableInt mutableInt) {
            this.include(list, interval, mutableInt, true);
        }

        private void include(List<Arc> list, Interval interval, MutableInt mutableInt, boolean bl2) {
            if (interval.size() == 0) {
                return;
            }
            if (bl2) {
                Iterator<Arc> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().span.equals(interval)) continue;
                    return;
                }
            }
            list.add(new Arc(interval, mutableInt));
        }

        private void init(int[] nArray) {
            Arrays.fill(nArray, 0);
        }

        private void logError(String string2, Arc[] arcArray, boolean[] blArray) {
            ArrayList<Arc> arrayList = new ArrayList<Arc>();
            ArrayList<Arc> arrayList2 = new ArrayList<Arc>();
            for (int i2 = 0; i2 < arcArray.length; ++i2) {
                Arc arc = arcArray[i2];
                if (blArray[i2]) {
                    arrayList.add(arc);
                }
                if (arc.valid) continue;
                arrayList2.add(arc);
            }
            Log.d((String)TAG, (String)(string2 + " constraints: " + this.arcsToString(arrayList) + " are inconsistent; " + "permanently removing: " + this.arcsToString(arrayList2) + ". "));
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean relax(int[] nArray, Arc arc) {
            int n2;
            block3: {
                block2: {
                    if (!arc.valid) break block2;
                    Interval interval = arc.span;
                    int n3 = interval.min;
                    n2 = arc.value.value + nArray[n3];
                    int n4 = interval.max;
                    if (n2 > nArray[n4]) break block3;
                }
                return false;
            }
            nArray[n4] = n2;
            return true;
        }

        private void setParentConstraints(int n2, int n3) {
            this.parentMin.value = n2;
            this.parentMax.value = -n3;
            this.locationsValid = false;
        }

        private int size(int[] nArray) {
            return nArray[this.getCount()];
        }

        /*
         * Enabled aggressive block sorting
         */
        private void solve(Arc[] arcArray, int[] nArray) {
            String string2 = this.horizontal ? "horizontal" : "vertical";
            int n2 = 1 + this.getCount();
            boolean[] blArray = null;
            int n3 = 0;
            while (n3 < arcArray.length) {
                this.init(nArray);
                for (int i2 = 0; i2 < n2; ++i2) {
                    boolean bl2 = false;
                    int n4 = arcArray.length;
                    for (int i3 = 0; i3 < n4; bl2 |= this.relax(nArray, arcArray[i3]), ++i3) {
                    }
                    if (bl2) continue;
                    if (blArray == null) return;
                    this.logError(string2, arcArray, blArray);
                    return;
                }
                boolean[] blArray2 = new boolean[arcArray.length];
                for (int i4 = 0; i4 < n2; ++i4) {
                    int n5 = arcArray.length;
                    for (int i5 = 0; i5 < n5; ++i5) {
                        blArray2[i5] = blArray2[i5] | this.relax(nArray, arcArray[i5]);
                    }
                }
                if (n3 == 0) {
                    blArray = blArray2;
                }
                for (int i6 = 0; i6 < arcArray.length; ++i6) {
                    if (!blArray2[i6]) continue;
                    Arc arc = arcArray[i6];
                    if (arc.span.min < arc.span.max) {
                        continue;
                    }
                    arc.valid = false;
                    break;
                }
                ++n3;
            }
            return;
        }

        private Arc[] topologicalSort(List<Arc> list) {
            return this.topologicalSort(list.toArray(new Arc[list.size()]));
        }

        private Arc[] topologicalSort(final Arc[] arcArray) {
            return new Object(){
                static final /* synthetic */ boolean $assertionsDisabled;
                Arc[][] arcsByVertex;
                int cursor;
                Arc[] result;
                int[] visited;

                /*
                 * Enabled aggressive block sorting
                 */
                static {
                    boolean bl2 = !GridLayout.class.desiredAssertionStatus();
                    $assertionsDisabled = bl2;
                }
                {
                    this.result = new Arc[arcArray.length];
                    this.cursor = -1 + this.result.length;
                    this.arcsByVertex = Axis.this.groupArcsByFirstVertex(arcArray);
                    this.visited = new int[1 + Axis.this.getCount()];
                }

                Arc[] sort() {
                    int n2 = this.arcsByVertex.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        this.walk(i2);
                    }
                    if (!$assertionsDisabled && this.cursor != -1) {
                        throw new AssertionError();
                    }
                    return this.result;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                void walk(int n2) {
                    switch (this.visited[n2]) {
                        default: {
                            return;
                        }
                        case 0: {
                            this.visited[n2] = 1;
                            Arc[] arcArray3 = this.arcsByVertex[n2];
                            int n3 = arcArray3.length;
                            int n4 = 0;
                            while (true) {
                                if (n4 >= n3) {
                                    this.visited[n2] = 2;
                                    return;
                                }
                                Arc arc = arcArray3[n4];
                                this.walk(arc.span.max);
                                Arc[] arcArray2 = this.result;
                                int n5 = this.cursor;
                                this.cursor = n5 - 1;
                                arcArray2[n5] = arc;
                                ++n4;
                            }
                        }
                        case 1: {
                            if ($assertionsDisabled) return;
                            throw new AssertionError();
                        }
                    }
                }
            }.sort();
        }

        public Arc[] getArcs() {
            if (this.arcs == null) {
                this.arcs = this.createArcs();
            }
            if (!this.arcsValid) {
                this.computeArcs();
                this.arcsValid = true;
            }
            return this.arcs;
        }

        public int getCount() {
            return Math.max(this.definedCount, this.getMaxIndex());
        }

        public PackedMap<Spec, Bounds> getGroupBounds() {
            if (this.groupBounds == null) {
                this.groupBounds = this.createGroupBounds();
            }
            if (!this.groupBoundsValid) {
                this.computeGroupBounds();
                this.groupBoundsValid = true;
            }
            return this.groupBounds;
        }

        public int[] getLeadingMargins() {
            if (this.leadingMargins == null) {
                this.leadingMargins = new int[1 + this.getCount()];
            }
            if (!this.leadingMarginsValid) {
                this.computeMargins(true);
                this.leadingMarginsValid = true;
            }
            return this.leadingMargins;
        }

        public int[] getLocations() {
            if (this.locations == null) {
                this.locations = new int[1 + this.getCount()];
            }
            if (!this.locationsValid) {
                this.computeLocations(this.locations);
                this.locationsValid = true;
            }
            return this.locations;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getMeasure(int n2) {
            int n3 = View.MeasureSpec.getMode((int)n2);
            int n4 = View.MeasureSpec.getSize((int)n2);
            switch (n3) {
                default: {
                    boolean bl2 = $assertionsDisabled;
                    int n5 = 0;
                    if (bl2) return n5;
                    throw new AssertionError();
                }
                case 0: {
                    return this.getMeasure(0, 100000);
                }
                case 0x40000000: {
                    return this.getMeasure(n4, n4);
                }
                case -2147483648: 
            }
            return this.getMeasure(0, n4);
        }

        public int[] getTrailingMargins() {
            if (this.trailingMargins == null) {
                this.trailingMargins = new int[1 + this.getCount()];
            }
            if (!this.trailingMarginsValid) {
                this.computeMargins(false);
                this.trailingMarginsValid = true;
            }
            return this.trailingMargins;
        }

        Arc[][] groupArcsByFirstVertex(Arc[] arcArray) {
            int n2 = 1 + this.getCount();
            Arc[][] arcArray2 = new Arc[n2][];
            int[] nArray = new int[n2];
            int n3 = arcArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = arcArray[i2].span.min;
                nArray[n4] = 1 + nArray[n4];
            }
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                arcArray2[i3] = new Arc[nArray[i3]];
            }
            Arrays.fill(nArray, 0);
            for (Arc arc : arcArray) {
                int n5 = arc.span.min;
                Arc[] arcArray3 = arcArray2[n5];
                int n6 = nArray[n5];
                nArray[n5] = n6 + 1;
                arcArray3[n6] = arc;
            }
            return arcArray2;
        }

        public void invalidateStructure() {
            this.maxIndex = Integer.MIN_VALUE;
            this.groupBounds = null;
            this.forwardLinks = null;
            this.backwardLinks = null;
            this.leadingMargins = null;
            this.trailingMargins = null;
            this.arcs = null;
            this.locations = null;
            this.invalidateValues();
        }

        public void invalidateValues() {
            this.groupBoundsValid = false;
            this.forwardLinksValid = false;
            this.backwardLinksValid = false;
            this.leadingMarginsValid = false;
            this.trailingMarginsValid = false;
            this.arcsValid = false;
            this.locationsValid = false;
        }

        public boolean isOrderPreserved() {
            return this.orderPreserved;
        }

        public void layout(int n2) {
            this.setParentConstraints(n2, n2);
            this.getLocations();
        }

        public void setCount(int n2) {
            this.definedCount = n2;
        }

        public void setOrderPreserved(boolean bl2) {
            this.orderPreserved = bl2;
            this.invalidateStructure();
        }
    }

    static class Bounds {
        public int after;
        public int before;
        public int flexibility;

        private Bounds() {
            this.reset();
        }

        protected int getOffset(View view, Alignment alignment, int n2) {
            return this.before - alignment.getAlignmentValue(view, n2);
        }

        protected void include(int n2, int n3) {
            this.before = Math.max(this.before, n2);
            this.after = Math.max(this.after, n3);
        }

        protected final void include(View view, Spec spec, GridLayout gridLayout, Axis axis) {
            this.flexibility &= spec.getFlexibility();
            int n2 = gridLayout.getMeasurementIncludingMargin(view, axis.horizontal);
            int n3 = gridLayout.getAlignment(spec.alignment, axis.horizontal).getAlignmentValue(view, n2);
            this.include(n3, n2 - n3);
        }

        protected void reset() {
            this.before = Integer.MIN_VALUE;
            this.after = Integer.MIN_VALUE;
            this.flexibility = 2;
        }

        protected int size(boolean bl2) {
            if (!bl2 && GridLayout.canStretch(this.flexibility)) {
                return 100000;
            }
            return this.before + this.after;
        }

        public String toString() {
            return "Bounds{before=" + this.before + ", after=" + this.after + '}';
        }
    }

    static final class Interval {
        public final int max;
        public final int min;

        public Interval(int n2, int n3) {
            this.min = n2;
            this.max = n3;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block6: {
                block5: {
                    if (this == object) break block5;
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Interval interval = (Interval)object;
                    if (this.max != interval.max) {
                        return false;
                    }
                    if (this.min != interval.min) break block6;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.min + this.max;
        }

        Interval inverse() {
            return new Interval(this.max, this.min);
        }

        int size() {
            return this.max - this.min;
        }

        public String toString() {
            return "[" + this.min + ", " + this.max + "]";
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int BOTTOM_MARGIN = 6;
        private static final int COLUMN = 9;
        private static final int COLUMN_SPAN = 10;
        private static final int DEFAULT_COLUMN = Integer.MIN_VALUE;
        private static final int DEFAULT_HEIGHT = -2;
        private static final int DEFAULT_MARGIN = Integer.MIN_VALUE;
        private static final int DEFAULT_ROW = Integer.MIN_VALUE;
        private static final Interval DEFAULT_SPAN = new Interval(Integer.MIN_VALUE, -2147483647);
        private static final int DEFAULT_SPAN_SIZE = 0;
        private static final int DEFAULT_WIDTH = -2;
        private static final int GRAVITY = 11;
        private static final int LEFT_MARGIN = 3;
        private static final int MARGIN = 2;
        private static final int RIGHT_MARGIN = 5;
        private static final int ROW = 7;
        private static final int ROW_SPAN = 8;
        private static final int TOP_MARGIN = 4;
        public Spec columnSpec;
        public Spec rowSpec = Spec.UNDEFINED;

        static {
            DEFAULT_SPAN_SIZE = DEFAULT_SPAN.size();
        }

        public LayoutParams() {
            this(Spec.UNDEFINED, Spec.UNDEFINED);
        }

        private LayoutParams(int n2, int n3, int n4, int n5, int n6, int n7, Spec spec, Spec spec2) {
            super(n2, n3);
            this.columnSpec = Spec.UNDEFINED;
            this.setMargins(n4, n5, n6, n7);
            this.rowSpec = spec;
            this.columnSpec = spec2;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.columnSpec = Spec.UNDEFINED;
            this.reInitSuper(context, attributeSet);
            this.init(context, attributeSet);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
            this.columnSpec = Spec.UNDEFINED;
            this.rowSpec = layoutParams.rowSpec;
            this.columnSpec = layoutParams.columnSpec;
        }

        public LayoutParams(Spec spec, Spec spec2) {
            this(-2, -2, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, spec, spec2);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.columnSpec = Spec.UNDEFINED;
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.columnSpec = Spec.UNDEFINED;
        }

        private void init(Context context, AttributeSet attributeSet) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GridLayout_Layout);
            try {
                int n2 = typedArray.getInt(11, 0);
                this.columnSpec = GridLayout.spec(typedArray.getInt(9, Integer.MIN_VALUE), typedArray.getInt(10, DEFAULT_SPAN_SIZE), GridLayout.getAlignment(n2, true));
                this.rowSpec = GridLayout.spec(typedArray.getInt(7, Integer.MIN_VALUE), typedArray.getInt(8, DEFAULT_SPAN_SIZE), GridLayout.getAlignment(n2, false));
                return;
            }
            finally {
                typedArray.recycle();
            }
        }

        private void reInitSuper(Context context, AttributeSet attributeSet) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GridLayout_Layout);
            try {
                int n2 = typedArray.getDimensionPixelSize(2, Integer.MIN_VALUE);
                this.leftMargin = typedArray.getDimensionPixelSize(3, n2);
                this.topMargin = typedArray.getDimensionPixelSize(4, n2);
                this.rightMargin = typedArray.getDimensionPixelSize(5, n2);
                this.bottomMargin = typedArray.getDimensionPixelSize(6, n2);
                return;
            }
            finally {
                typedArray.recycle();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block6: {
                block5: {
                    if (this == object) break block5;
                    if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
                        return false;
                    }
                    LayoutParams layoutParams = (LayoutParams)((Object)object);
                    if (!this.columnSpec.equals(layoutParams.columnSpec)) {
                        return false;
                    }
                    if (!this.rowSpec.equals(layoutParams.rowSpec)) break block6;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.rowSpec.hashCode() + this.columnSpec.hashCode();
        }

        protected void setBaseAttributes(TypedArray typedArray, int n2, int n3) {
            this.width = typedArray.getLayoutDimension(n2, -2);
            this.height = typedArray.getLayoutDimension(n3, -2);
        }

        final void setColumnSpecSpan(Interval interval) {
            this.columnSpec = this.columnSpec.copyWriteSpan(interval);
        }

        public void setGravity(int n2) {
            this.rowSpec = this.rowSpec.copyWriteAlignment(GridLayout.getAlignment(n2, false));
            this.columnSpec = this.columnSpec.copyWriteAlignment(GridLayout.getAlignment(n2, true));
        }

        final void setRowSpecSpan(Interval interval) {
            this.rowSpec = this.rowSpec.copyWriteSpan(interval);
        }
    }

    static final class MutableInt {
        public int value;

        public MutableInt() {
            this.reset();
        }

        public MutableInt(int n2) {
            this.value = n2;
        }

        public void reset() {
            this.value = Integer.MIN_VALUE;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    static final class PackedMap<K, V> {
        public final int[] index;
        public final K[] keys;
        public final V[] values;

        private PackedMap(K[] KArray, V[] VArray) {
            this.index = PackedMap.createIndex(KArray);
            this.keys = PackedMap.compact(KArray, this.index);
            this.values = PackedMap.compact(VArray, this.index);
        }

        private static <K> K[] compact(K[] KArray, int[] nArray) {
            int n2 = KArray.length;
            Object[] objectArray = (Object[])Array.newInstance(KArray.getClass().getComponentType(), 1 + GridLayout.max2(nArray, -1));
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[nArray[i2]] = KArray[i2];
            }
            return objectArray;
        }

        private static <K> int[] createIndex(K[] KArray) {
            int n2 = KArray.length;
            int[] nArray = new int[n2];
            HashMap<K, Integer> hashMap = new HashMap<K, Integer>();
            for (int i2 = 0; i2 < n2; ++i2) {
                K k2 = KArray[i2];
                Integer n3 = (Integer)hashMap.get(k2);
                if (n3 == null) {
                    n3 = hashMap.size();
                    hashMap.put(k2, n3);
                }
                nArray[i2] = n3;
            }
            return nArray;
        }

        public V getValue(int n2) {
            return this.values[this.index[n2]];
        }
    }

    public static class Spec {
        static final Spec UNDEFINED = GridLayout.spec(Integer.MIN_VALUE);
        final Alignment alignment;
        final Interval span;
        final boolean startDefined;

        private Spec(boolean bl2, int n2, int n3, Alignment alignment) {
            this(bl2, new Interval(n2, n2 + n3), alignment);
        }

        private Spec(boolean bl2, Interval interval, Alignment alignment) {
            this.startDefined = bl2;
            this.span = interval;
            this.alignment = alignment;
        }

        final Spec copyWriteAlignment(Alignment alignment) {
            return new Spec(this.startDefined, this.span, alignment);
        }

        final Spec copyWriteSpan(Interval interval) {
            return new Spec(this.startDefined, interval, this.alignment);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block6: {
                block5: {
                    if (this == object) break block5;
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Spec spec = (Spec)object;
                    if (!this.alignment.equals(spec.alignment)) {
                        return false;
                    }
                    if (!this.span.equals(spec.span)) break block6;
                }
                return true;
            }
            return false;
        }

        final int getFlexibility() {
            if (this.alignment == UNDEFINED_ALIGNMENT) {
                return 0;
            }
            return 2;
        }

        public int hashCode() {
            return 31 * this.span.hashCode() + this.alignment.hashCode();
        }
    }
}

