/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.appcompat.R;
import android.support.v7.internal.widget.AbsSpinnerICS;
import android.support.v7.internal.widget.AdapterViewICS;
import android.support.v7.internal.widget.ListPopupWindow;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.SpinnerAdapter;

class SpinnerICS
extends AbsSpinnerICS
implements DialogInterface.OnClickListener {
    private static final int MAX_ITEMS_MEASURED = 15;
    static final int MODE_DIALOG = 0;
    static final int MODE_DROPDOWN = 1;
    private static final int MODE_THEME = -1;
    private static final String TAG = "Spinner";
    int mDropDownWidth;
    private int mGravity;
    private SpinnerPopup mPopup;
    private DropDownAdapter mTempAdapter;
    private Rect mTempRect = new Rect();

    SpinnerICS(Context context) {
        this(context, null);
    }

    SpinnerICS(Context context, int n2) {
        this(context, null, R.attr.spinnerStyle, n2);
    }

    SpinnerICS(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.spinnerStyle);
    }

    SpinnerICS(Context context, AttributeSet attributeSet, int n2) {
        this(context, attributeSet, n2, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    SpinnerICS(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Spinner, n2, 0);
        if (n3 == -1) {
            n3 = typedArray.getInt(7, 0);
        }
        switch (n3) {
            case 0: {
                this.mPopup = new DialogPopup();
            }
            default: {
                break;
            }
            case 1: {
                int n4;
                DropdownPopup dropdownPopup = new DropdownPopup(context, attributeSet, n2);
                this.mDropDownWidth = typedArray.getLayoutDimension(3, -2);
                dropdownPopup.setBackgroundDrawable(typedArray.getDrawable(2));
                int n5 = typedArray.getDimensionPixelOffset(5, 0);
                if (n5 != 0) {
                    dropdownPopup.setVerticalOffset(n5);
                }
                if ((n4 = typedArray.getDimensionPixelOffset(4, 0)) != 0) {
                    dropdownPopup.setHorizontalOffset(n4);
                }
                this.mPopup = dropdownPopup;
            }
        }
        this.mGravity = typedArray.getInt(0, 17);
        this.mPopup.setPromptText(typedArray.getString(6));
        typedArray.recycle();
        if (this.mTempAdapter != null) {
            this.mPopup.setAdapter(this.mTempAdapter);
            this.mTempAdapter = null;
        }
    }

    private View makeAndAddView(int n2) {
        View view;
        if (!this.mDataChanged && (view = this.mRecycler.get(n2)) != null) {
            this.setUpChild(view);
            return view;
        }
        View view2 = this.mAdapter.getView(n2, null, (ViewGroup)this);
        this.setUpChild(view2);
        return view2;
    }

    private void setUpChild(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(view, 0, layoutParams);
        view.setSelected(this.hasFocus());
        int n2 = ViewGroup.getChildMeasureSpec((int)this.mHeightMeasureSpec, (int)(this.mSpinnerPadding.top + this.mSpinnerPadding.bottom), (int)layoutParams.height);
        view.measure(ViewGroup.getChildMeasureSpec((int)this.mWidthMeasureSpec, (int)(this.mSpinnerPadding.left + this.mSpinnerPadding.right), (int)layoutParams.width), n2);
        int n3 = this.mSpinnerPadding.top + (this.getMeasuredHeight() - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - view.getMeasuredHeight()) / 2;
        int n4 = n3 + view.getMeasuredHeight();
        view.layout(0, n3, 0 + view.getMeasuredWidth(), n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getBaseline() {
        View view;
        int n2 = -1;
        if (this.getChildCount() > 0) {
            view = this.getChildAt(0);
        } else {
            SpinnerAdapter spinnerAdapter = this.mAdapter;
            view = null;
            if (spinnerAdapter != null) {
                int n3 = this.mAdapter.getCount();
                view = null;
                if (n3 > 0) {
                    view = this.makeAndAddView(0);
                    this.mRecycler.put(0, view);
                    this.removeAllViewsInLayout();
                }
            }
        }
        if (view == null) return n2;
        int n4 = view.getBaseline();
        if (n4 < 0) return n2;
        return n4 + view.getTop();
    }

    public CharSequence getPrompt() {
        return this.mPopup.getHintText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void layout(int n2, boolean bl2) {
        int n3 = this.mSpinnerPadding.left;
        int n4 = this.getRight() - this.getLeft() - this.mSpinnerPadding.left - this.mSpinnerPadding.right;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.removeAllViewsInLayout();
        this.mFirstPosition = this.mSelectedPosition;
        View view = this.makeAndAddView(this.mSelectedPosition);
        int n5 = view.getMeasuredWidth();
        int n6 = n3;
        switch (7 & this.mGravity) {
            case 1: {
                n6 = n3 + n4 / 2 - n5 / 2;
            }
            default: {
                break;
            }
            case 5: {
                n6 = n3 + n4 - n5;
            }
        }
        view.offsetLeftAndRight(n6);
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int measureContentWidth(SpinnerAdapter spinnerAdapter, Drawable drawable2) {
        if (spinnerAdapter == null) {
            return 0;
        }
        int n2 = 0;
        View view = null;
        int n3 = 0;
        int n4 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int n5 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int n6 = Math.max(0, this.getSelectedItemPosition());
        int n7 = Math.min(spinnerAdapter.getCount(), n6 + 15);
        for (int i2 = Math.max(0, n6 - (15 - (n7 - n6))); i2 < n7; ++i2) {
            int n8 = spinnerAdapter.getItemViewType(i2);
            if (n8 != n3) {
                n3 = n8;
                view = null;
            }
            if ((view = spinnerAdapter.getView(i2, view, (ViewGroup)this)).getLayoutParams() == null) {
                view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            view.measure(n4, n5);
            n2 = Math.max(n2, view.getMeasuredWidth());
        }
        if (drawable2 == null) return n2;
        drawable2.getPadding(this.mTempRect);
        return n2 + (this.mTempRect.left + this.mTempRect.right);
    }

    public void onClick(DialogInterface dialogInterface, int n2) {
        this.setSelection(n2);
        dialogInterface.dismiss();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    @Override
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        super.onLayout(bl2, n2, n3, n4, n5);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    @Override
    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        if (this.mPopup != null && View.MeasureSpec.getMode((int)n2) == Integer.MIN_VALUE) {
            this.setMeasuredDimension(Math.min(Math.max(this.getMeasuredWidth(), this.measureContentWidth(this.getAdapter(), this.getBackground())), View.MeasureSpec.getSize((int)n2)), this.getMeasuredHeight());
        }
    }

    public boolean performClick() {
        boolean bl2 = super.performClick();
        if (!bl2) {
            bl2 = true;
            if (!this.mPopup.isShowing()) {
                this.mPopup.show();
            }
        }
        return bl2;
    }

    @Override
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        super.setAdapter(spinnerAdapter);
        if (this.mPopup != null) {
            this.mPopup.setAdapter(new DropDownAdapter(spinnerAdapter));
            return;
        }
        this.mTempAdapter = new DropDownAdapter(spinnerAdapter);
    }

    public void setGravity(int n2) {
        if (this.mGravity != n2) {
            if ((n2 & 7) == 0) {
                n2 |= 3;
            }
            this.mGravity = n2;
            this.requestLayout();
        }
    }

    @Override
    public void setOnItemClickListener(AdapterViewICS.OnItemClickListener onItemClickListener) {
        throw new RuntimeException("setOnItemClickListener cannot be used with a spinner.");
    }

    void setOnItemClickListenerInt(AdapterViewICS.OnItemClickListener onItemClickListener) {
        super.setOnItemClickListener(onItemClickListener);
    }

    public void setPrompt(CharSequence charSequence) {
        this.mPopup.setPromptText(charSequence);
    }

    public void setPromptId(int n2) {
        this.setPrompt(this.getContext().getText(n2));
    }

    private class DialogPopup
    implements SpinnerPopup,
    DialogInterface.OnClickListener {
        private ListAdapter mListAdapter;
        private AlertDialog mPopup;
        private CharSequence mPrompt;

        private DialogPopup() {
        }

        @Override
        public void dismiss() {
            this.mPopup.dismiss();
            this.mPopup = null;
        }

        @Override
        public CharSequence getHintText() {
            return this.mPrompt;
        }

        @Override
        public boolean isShowing() {
            if (this.mPopup != null) {
                return this.mPopup.isShowing();
            }
            return false;
        }

        public void onClick(DialogInterface dialogInterface, int n2) {
            SpinnerICS.this.setSelection(n2);
            if (SpinnerICS.this.mOnItemClickListener != null) {
                SpinnerICS.this.performItemClick(null, n2, this.mListAdapter.getItemId(n2));
            }
            this.dismiss();
        }

        @Override
        public void setAdapter(ListAdapter listAdapter) {
            this.mListAdapter = listAdapter;
        }

        @Override
        public void setPromptText(CharSequence charSequence) {
            this.mPrompt = charSequence;
        }

        @Override
        public void show() {
            AlertDialog.Builder builder = new AlertDialog.Builder(SpinnerICS.this.getContext());
            if (this.mPrompt != null) {
                builder.setTitle(this.mPrompt);
            }
            this.mPopup = builder.setSingleChoiceItems(this.mListAdapter, SpinnerICS.this.getSelectedItemPosition(), (DialogInterface.OnClickListener)this).show();
        }
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter {
        private SpinnerAdapter mAdapter;
        private ListAdapter mListAdapter;

        public DropDownAdapter(SpinnerAdapter spinnerAdapter) {
            this.mAdapter = spinnerAdapter;
            if (spinnerAdapter instanceof ListAdapter) {
                this.mListAdapter = (ListAdapter)spinnerAdapter;
            }
        }

        public boolean areAllItemsEnabled() {
            ListAdapter listAdapter = this.mListAdapter;
            if (listAdapter != null) {
                return listAdapter.areAllItemsEnabled();
            }
            return true;
        }

        public int getCount() {
            if (this.mAdapter == null) {
                return 0;
            }
            return this.mAdapter.getCount();
        }

        public View getDropDownView(int n2, View view, ViewGroup viewGroup) {
            if (this.mAdapter == null) {
                return null;
            }
            return this.mAdapter.getDropDownView(n2, view, viewGroup);
        }

        public Object getItem(int n2) {
            if (this.mAdapter == null) {
                return null;
            }
            return this.mAdapter.getItem(n2);
        }

        public long getItemId(int n2) {
            if (this.mAdapter == null) {
                return -1L;
            }
            return this.mAdapter.getItemId(n2);
        }

        public int getItemViewType(int n2) {
            return 0;
        }

        public View getView(int n2, View view, ViewGroup viewGroup) {
            return this.getDropDownView(n2, view, viewGroup);
        }

        public int getViewTypeCount() {
            return 1;
        }

        public boolean hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        public boolean isEmpty() {
            return this.getCount() == 0;
        }

        public boolean isEnabled(int n2) {
            ListAdapter listAdapter = this.mListAdapter;
            if (listAdapter != null) {
                return listAdapter.isEnabled(n2);
            }
            return true;
        }

        public void registerDataSetObserver(DataSetObserver dataSetObserver) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(dataSetObserver);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(dataSetObserver);
            }
        }
    }

    private class DropdownPopup
    extends ListPopupWindow
    implements SpinnerPopup {
        private ListAdapter mAdapter;
        private CharSequence mHintText;

        public DropdownPopup(Context context, AttributeSet attributeSet, int n2) {
            super(context, attributeSet, n2);
            this.setAnchorView((View)SpinnerICS.this);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnItemClickListener(new AdapterViewICS.OnItemClickListenerWrapper(new AdapterViewICS.OnItemClickListener(){

                public void onItemClick(AdapterViewICS adapterViewICS, View view, int n2, long l2) {
                    SpinnerICS.this.setSelection(n2);
                    if (SpinnerICS.this.mOnItemClickListener != null) {
                        SpinnerICS.this.performItemClick(view, n2, DropdownPopup.this.mAdapter.getItemId(n2));
                    }
                    DropdownPopup.this.dismiss();
                }
            }));
        }

        @Override
        public CharSequence getHintText() {
            return this.mHintText;
        }

        @Override
        public void setAdapter(ListAdapter listAdapter) {
            super.setAdapter(listAdapter);
            this.mAdapter = listAdapter;
        }

        @Override
        public void setPromptText(CharSequence charSequence) {
            this.mHintText = charSequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void show() {
            int n2 = SpinnerICS.this.getPaddingLeft();
            if (SpinnerICS.this.mDropDownWidth == -2) {
                int n3 = SpinnerICS.this.getWidth();
                int n4 = SpinnerICS.this.getPaddingRight();
                this.setContentWidth(Math.max(SpinnerICS.this.measureContentWidth((SpinnerAdapter)this.mAdapter, this.getBackground()), n3 - n2 - n4));
            } else if (SpinnerICS.this.mDropDownWidth == -1) {
                int n5 = SpinnerICS.this.getWidth();
                int n6 = SpinnerICS.this.getPaddingRight();
                this.setContentWidth(n5 - n2 - n6);
            } else {
                this.setContentWidth(SpinnerICS.this.mDropDownWidth);
            }
            Drawable drawable2 = this.getBackground();
            int n7 = 0;
            if (drawable2 != null) {
                drawable2.getPadding(SpinnerICS.this.mTempRect);
                n7 = -((SpinnerICS)SpinnerICS.this).mTempRect.left;
            }
            this.setHorizontalOffset(n7 + n2);
            this.setInputMethodMode(2);
            super.show();
            this.getListView().setChoiceMode(1);
            this.setSelection(SpinnerICS.this.getSelectedItemPosition());
        }
    }

    private static interface SpinnerPopup {
        public void dismiss();

        public CharSequence getHintText();

        public boolean isShowing();

        public void setAdapter(ListAdapter var1);

        public void setPromptText(CharSequence var1);

        public void show();
    }
}

