/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;

public class ProgressBarICS
extends View {
    private static final int ANIMATION_RESOLUTION = 200;
    private static final int MAX_LEVEL = 10000;
    private static final int[] android_R_styleable_ProgressBar = new int[]{16843062, 16843063, 16843064, 16843065, 16843066, 16843067, 16843068, 16843069, 16843070, 16843071, 0x101011F, 0x1010140, 0x1010120, 0x1010141};
    private AlphaAnimation mAnimation;
    private int mBehavior;
    private Drawable mCurrentDrawable;
    private int mDuration;
    private boolean mInDrawing;
    private boolean mIndeterminate;
    private Drawable mIndeterminateDrawable;
    private Interpolator mInterpolator;
    private long mLastDrawTime;
    private int mMax;
    int mMaxHeight;
    int mMaxWidth;
    int mMinHeight;
    int mMinWidth;
    private boolean mNoInvalidate;
    private boolean mOnlyIndeterminate;
    private int mProgress;
    private Drawable mProgressDrawable;
    private RefreshProgressRunnable mRefreshProgressRunnable;
    Bitmap mSampleTile;
    private int mSecondaryProgress;
    private boolean mShouldStartAnimationDrawable;
    private Transformation mTransformation;
    private long mUiThreadId;

    public ProgressBarICS(Context context, AttributeSet attributeSet, int n2, int n3) {
        boolean bl2;
        block7: {
            block6: {
                Drawable drawable2;
                super(context, attributeSet, n2);
                this.mUiThreadId = Thread.currentThread().getId();
                this.initProgressBar();
                TypedArray typedArray = context.obtainStyledAttributes(attributeSet, android_R_styleable_ProgressBar, n2, n3);
                this.mNoInvalidate = true;
                this.setMax(typedArray.getInt(0, this.mMax));
                this.setProgress(typedArray.getInt(1, this.mProgress));
                this.setSecondaryProgress(typedArray.getInt(2, this.mSecondaryProgress));
                boolean bl3 = typedArray.getBoolean(3, this.mIndeterminate);
                this.mOnlyIndeterminate = typedArray.getBoolean(4, this.mOnlyIndeterminate);
                Drawable drawable3 = typedArray.getDrawable(5);
                if (drawable3 != null) {
                    this.setIndeterminateDrawable(this.tileifyIndeterminate(drawable3));
                }
                if ((drawable2 = typedArray.getDrawable(6)) != null) {
                    this.setProgressDrawable(this.tileify(drawable2, false));
                }
                this.mDuration = typedArray.getInt(7, this.mDuration);
                this.mBehavior = typedArray.getInt(8, this.mBehavior);
                this.mMinWidth = typedArray.getDimensionPixelSize(9, this.mMinWidth);
                this.mMaxWidth = typedArray.getDimensionPixelSize(10, this.mMaxWidth);
                this.mMinHeight = typedArray.getDimensionPixelSize(11, this.mMinHeight);
                this.mMaxHeight = typedArray.getDimensionPixelSize(12, this.mMaxHeight);
                int n4 = typedArray.getResourceId(13, 17432587);
                if (n4 > 0) {
                    this.setInterpolator(context, n4);
                }
                typedArray.recycle();
                this.mNoInvalidate = false;
                if (this.mOnlyIndeterminate) break block6;
                bl2 = false;
                if (!bl3) break block7;
            }
            bl2 = true;
        }
        this.setIndeterminate(bl2);
    }

    static /* synthetic */ RefreshProgressRunnable access$102(ProgressBarICS progressBarICS, RefreshProgressRunnable refreshProgressRunnable) {
        progressBarICS.mRefreshProgressRunnable = refreshProgressRunnable;
        return refreshProgressRunnable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRefreshProgress(int n2, int n3, boolean bl2, boolean bl3) {
        synchronized (this) {
            float f2 = this.mMax > 0 ? (float)n3 / (float)this.mMax : 0.0f;
            Drawable drawable2 = this.mCurrentDrawable;
            if (drawable2 == null) {
                this.invalidate();
            } else {
                boolean bl4 = drawable2 instanceof LayerDrawable;
                Drawable drawable3 = null;
                if (bl4) {
                    drawable3 = ((LayerDrawable)drawable2).findDrawableByLayerId(n2);
                }
                int n4 = (int)(10000.0f * f2);
                if (drawable3 == null) {
                    drawable3 = drawable2;
                }
                drawable3.setLevel(n4);
            }
            return;
        }
    }

    private void initProgressBar() {
        this.mMax = 100;
        this.mProgress = 0;
        this.mSecondaryProgress = 0;
        this.mIndeterminate = false;
        this.mOnlyIndeterminate = false;
        this.mDuration = 4000;
        this.mBehavior = 1;
        this.mMinWidth = 24;
        this.mMaxWidth = 48;
        this.mMinHeight = 24;
        this.mMaxHeight = 48;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshProgress(int n2, int n3, boolean bl2) {
        synchronized (this) {
            if (this.mUiThreadId == Thread.currentThread().getId()) {
                this.doRefreshProgress(n2, n3, bl2, true);
            } else {
                RefreshProgressRunnable refreshProgressRunnable;
                if (this.mRefreshProgressRunnable != null) {
                    refreshProgressRunnable = this.mRefreshProgressRunnable;
                    this.mRefreshProgressRunnable = null;
                    refreshProgressRunnable.setup(n2, n3, bl2);
                } else {
                    refreshProgressRunnable = new RefreshProgressRunnable(n2, n3, bl2);
                }
                this.post(refreshProgressRunnable);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable tileify(Drawable drawable2, boolean bl2) {
        Drawable[] drawableArray;
        int n2;
        LayerDrawable layerDrawable;
        if (drawable2 instanceof LayerDrawable) {
            layerDrawable = (LayerDrawable)drawable2;
            n2 = layerDrawable.getNumberOfLayers();
            drawableArray = new Drawable[n2];
        } else {
            if (!(drawable2 instanceof BitmapDrawable)) {
                return drawable2;
            }
            Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
            if (this.mSampleTile == null) {
                this.mSampleTile = bitmap;
            }
            ShapeDrawable shapeDrawable = new ShapeDrawable(this.getDrawableShape());
            BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
            shapeDrawable.getPaint().setShader((Shader)bitmapShader);
            if (!bl2) return shapeDrawable;
            shapeDrawable = new ClipDrawable((Drawable)shapeDrawable, 3, 1);
            return shapeDrawable;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = layerDrawable.getId(i2);
            Drawable drawable3 = layerDrawable.getDrawable(i2);
            boolean bl3 = n3 == 16908301 || n3 == 16908303;
            drawableArray[i2] = this.tileify(drawable3, bl3);
        }
        LayerDrawable layerDrawable2 = new LayerDrawable(drawableArray);
        int n4 = 0;
        while (n4 < n2) {
            layerDrawable2.setId(n4, layerDrawable.getId(n4));
            ++n4;
        }
        return layerDrawable2;
    }

    private Drawable tileifyIndeterminate(Drawable drawable2) {
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable)drawable2;
            int n2 = animationDrawable.getNumberOfFrames();
            AnimationDrawable animationDrawable2 = new AnimationDrawable();
            animationDrawable2.setOneShot(animationDrawable.isOneShot());
            for (int i2 = 0; i2 < n2; ++i2) {
                Drawable drawable3 = this.tileify(animationDrawable.getFrame(i2), true);
                drawable3.setLevel(10000);
                animationDrawable2.addFrame(drawable3, animationDrawable.getDuration(i2));
            }
            animationDrawable2.setLevel(10000);
            drawable2 = animationDrawable2;
        }
        return drawable2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateDrawableBounds(int n2, int n3) {
        int n4 = n2 - this.getPaddingRight() - this.getPaddingLeft();
        int n5 = n3 - this.getPaddingBottom() - this.getPaddingTop();
        if (this.mIndeterminateDrawable != null) {
            boolean bl2 = this.mOnlyIndeterminate;
            int n6 = 0;
            int n7 = 0;
            if (bl2) {
                boolean bl3 = this.mIndeterminateDrawable instanceof AnimationDrawable;
                n6 = 0;
                n7 = 0;
                if (!bl3) {
                    int n8 = this.mIndeterminateDrawable.getIntrinsicWidth();
                    int n9 = this.mIndeterminateDrawable.getIntrinsicHeight();
                    float f2 = (float)n8 / (float)n9;
                    float f3 = (float)n2 / (float)n3;
                    float f4 = f2 == f3 ? 0 : (f2 > f3 ? 1 : -1);
                    n6 = 0;
                    n7 = 0;
                    if (f4 != false) {
                        if (f3 > f2) {
                            int n10 = (int)(f2 * (float)n3);
                            n6 = (n2 - n10) / 2;
                            n4 = n6 + n10;
                        } else {
                            int n11 = (int)((float)n2 * (1.0f / f2));
                            n7 = (n3 - n11) / 2;
                            n5 = n7 + n11;
                            n6 = 0;
                        }
                    }
                }
            }
            this.mIndeterminateDrawable.setBounds(n6, n7, n4, n5);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setBounds(0, 0, n4, n5);
        }
    }

    private void updateDrawableState() {
        int[] nArray = this.getDrawableState();
        if (this.mProgressDrawable != null && this.mProgressDrawable.isStateful()) {
            this.mProgressDrawable.setState(nArray);
        }
        if (this.mIndeterminateDrawable != null && this.mIndeterminateDrawable.isStateful()) {
            this.mIndeterminateDrawable.setState(nArray);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateDrawableState();
    }

    Shape getDrawableShape() {
        return new RoundRectShape(new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f}, null, null);
    }

    public Drawable getIndeterminateDrawable() {
        return this.mIndeterminateDrawable;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public int getMax() {
        synchronized (this) {
            int n2 = this.mMax;
            return n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getProgress() {
        synchronized (this) {
            block6: {
                boolean bl2 = this.mIndeterminate;
                if (!bl2) break block6;
                return 0;
            }
            int n2 = this.mProgress;
            return n2;
        }
    }

    public Drawable getProgressDrawable() {
        return this.mProgressDrawable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSecondaryProgress() {
        synchronized (this) {
            block6: {
                boolean bl2 = this.mIndeterminate;
                if (!bl2) break block6;
                return 0;
            }
            int n2 = this.mSecondaryProgress;
            return n2;
        }
    }

    public final void incrementProgressBy(int n2) {
        synchronized (this) {
            this.setProgress(n2 + this.mProgress);
            return;
        }
    }

    public final void incrementSecondaryProgressBy(int n2) {
        synchronized (this) {
            this.setSecondaryProgress(n2 + this.mSecondaryProgress);
            return;
        }
    }

    public void invalidateDrawable(Drawable drawable2) {
        block3: {
            block2: {
                if (this.mInDrawing) break block2;
                if (!this.verifyDrawable(drawable2)) break block3;
                Rect rect = drawable2.getBounds();
                int n2 = this.getScrollX() + this.getPaddingLeft();
                int n3 = this.getScrollY() + this.getPaddingTop();
                this.invalidate(n2 + rect.left, n3 + rect.top, n2 + rect.right, n3 + rect.bottom);
            }
            return;
        }
        super.invalidateDrawable(drawable2);
    }

    public boolean isIndeterminate() {
        synchronized (this) {
            boolean bl2 = this.mIndeterminate;
            return bl2;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIndeterminate) {
            this.startAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mIndeterminate) {
            this.stopAnimation();
        }
        if (this.mRefreshProgressRunnable != null) {
            this.removeCallbacks(this.mRefreshProgressRunnable);
        }
        super.onDetachedFromWindow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onDraw(Canvas canvas) {
        synchronized (this) {
            super.onDraw(canvas);
            Drawable drawable2 = this.mCurrentDrawable;
            if (drawable2 != null) {
                block9: {
                    canvas.save();
                    canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
                    long l2 = this.getDrawingTime();
                    if (this.mAnimation != null) {
                        this.mAnimation.getTransformation(l2, this.mTransformation);
                        float f2 = this.mTransformation.getAlpha();
                        this.mInDrawing = true;
                        drawable2.setLevel((int)(10000.0f * f2));
                        if (SystemClock.uptimeMillis() - this.mLastDrawTime < 200L) break block9;
                        this.mLastDrawTime = SystemClock.uptimeMillis();
                        this.postInvalidateDelayed(200L);
                    }
                }
                drawable2.draw(canvas);
                canvas.restore();
                if (this.mShouldStartAnimationDrawable && drawable2 instanceof Animatable) {
                    ((Animatable)drawable2).start();
                    this.mShouldStartAnimationDrawable = false;
                }
            }
            return;
            finally {
                this.mInDrawing = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int n2, int n3) {
        synchronized (this) {
            Drawable drawable2 = this.mCurrentDrawable;
            int n4 = 0;
            int n5 = 0;
            if (drawable2 != null) {
                n5 = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, drawable2.getIntrinsicWidth()));
                n4 = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, drawable2.getIntrinsicHeight()));
            }
            this.updateDrawableState();
            int n6 = n5 + (this.getPaddingLeft() + this.getPaddingRight());
            int n7 = n4 + (this.getPaddingTop() + this.getPaddingBottom());
            this.setMeasuredDimension(ProgressBarICS.resolveSize((int)n6, (int)n2), ProgressBarICS.resolveSize((int)n7, (int)n3));
            return;
        }
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setProgress(savedState.progress);
        this.setSecondaryProgress(savedState.secondaryProgress);
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.progress = this.mProgress;
        savedState.secondaryProgress = this.mSecondaryProgress;
        return savedState;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        this.updateDrawableBounds(n2, n3);
    }

    protected void onVisibilityChanged(View view, int n2) {
        block3: {
            block2: {
                super.onVisibilityChanged(view, n2);
                if (!this.mIndeterminate) break block2;
                if (n2 != 8 && n2 != 4) break block3;
                this.stopAnimation();
            }
            return;
        }
        this.startAnimation();
    }

    public void postInvalidate() {
        if (!this.mNoInvalidate) {
            super.postInvalidate();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIndeterminate(boolean bl2) {
        synchronized (this) {
            block9: {
                block8: {
                    if (this.mOnlyIndeterminate && this.mIndeterminate || bl2 == this.mIndeterminate) break block8;
                    this.mIndeterminate = bl2;
                    if (!bl2) break block9;
                    this.mCurrentDrawable = this.mIndeterminateDrawable;
                    this.startAnimation();
                }
                return;
            }
            this.mCurrentDrawable = this.mProgressDrawable;
            this.stopAnimation();
            return;
        }
    }

    public void setIndeterminateDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
        this.mIndeterminateDrawable = drawable2;
        if (this.mIndeterminate) {
            this.mCurrentDrawable = drawable2;
            this.postInvalidate();
        }
    }

    public void setInterpolator(Context context, int n2) {
        this.setInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)n2));
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setMax(int n2) {
        synchronized (this) {
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 != this.mMax) {
                this.mMax = n2;
                this.postInvalidate();
                if (this.mProgress > n2) {
                    this.mProgress = n2;
                }
                this.refreshProgress(16908301, this.mProgress, false);
            }
            return;
        }
    }

    public void setProgress(int n2) {
        synchronized (this) {
            this.setProgress(n2, false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setProgress(int n2, boolean bl2) {
        synchronized (this) {
            boolean bl3 = this.mIndeterminate;
            if (!bl3) {
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > this.mMax) {
                    n2 = this.mMax;
                }
                if (n2 != this.mProgress) {
                    this.mProgress = n2;
                    this.refreshProgress(16908301, this.mProgress, bl2);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setProgressDrawable(Drawable drawable2) {
        boolean bl2;
        if (this.mProgressDrawable != null && drawable2 != this.mProgressDrawable) {
            this.mProgressDrawable.setCallback(null);
            bl2 = true;
        } else {
            bl2 = false;
        }
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
            int n2 = drawable2.getMinimumHeight();
            if (this.mMaxHeight < n2) {
                this.mMaxHeight = n2;
                this.requestLayout();
            }
        }
        this.mProgressDrawable = drawable2;
        if (!this.mIndeterminate) {
            this.mCurrentDrawable = drawable2;
            this.postInvalidate();
        }
        if (bl2) {
            this.updateDrawableBounds(this.getWidth(), this.getHeight());
            this.updateDrawableState();
            this.doRefreshProgress(16908301, this.mProgress, false, false);
            this.doRefreshProgress(16908303, this.mSecondaryProgress, false, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSecondaryProgress(int n2) {
        synchronized (this) {
            boolean bl2 = this.mIndeterminate;
            if (!bl2) {
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > this.mMax) {
                    n2 = this.mMax;
                }
                if (n2 != this.mSecondaryProgress) {
                    this.mSecondaryProgress = n2;
                    this.refreshProgress(16908303, this.mSecondaryProgress, false);
                }
            }
            return;
        }
    }

    public void setVisibility(int n2) {
        block3: {
            block2: {
                if (this.getVisibility() == n2) break block2;
                super.setVisibility(n2);
                if (!this.mIndeterminate) break block2;
                if (n2 != 8 && n2 != 4) break block3;
                this.stopAnimation();
            }
            return;
        }
        this.startAnimation();
    }

    /*
     * Enabled aggressive block sorting
     */
    void startAnimation() {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.mIndeterminateDrawable instanceof Animatable) {
            this.mShouldStartAnimationDrawable = true;
            this.mAnimation = null;
        } else {
            if (this.mInterpolator == null) {
                this.mInterpolator = new LinearInterpolator();
            }
            this.mTransformation = new Transformation();
            this.mAnimation = new AlphaAnimation(0.0f, 1.0f);
            this.mAnimation.setRepeatMode(this.mBehavior);
            this.mAnimation.setRepeatCount(-1);
            this.mAnimation.setDuration((long)this.mDuration);
            this.mAnimation.setInterpolator(this.mInterpolator);
            this.mAnimation.setStartTime(-1L);
        }
        this.postInvalidate();
    }

    void stopAnimation() {
        this.mAnimation = null;
        this.mTransformation = null;
        if (this.mIndeterminateDrawable instanceof Animatable) {
            ((Animatable)this.mIndeterminateDrawable).stop();
            this.mShouldStartAnimationDrawable = false;
        }
        this.postInvalidate();
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        return drawable2 == this.mProgressDrawable || drawable2 == this.mIndeterminateDrawable || super.verifyDrawable(drawable2);
    }

    private class RefreshProgressRunnable
    implements Runnable {
        private boolean mFromUser;
        private int mId;
        private int mProgress;

        RefreshProgressRunnable(int n2, int n3, boolean bl2) {
            this.mId = n2;
            this.mProgress = n3;
            this.mFromUser = bl2;
        }

        @Override
        public void run() {
            ProgressBarICS.this.doRefreshProgress(this.mId, this.mProgress, this.mFromUser, true);
            ProgressBarICS.access$102(ProgressBarICS.this, this);
        }

        public void setup(int n2, int n3, boolean bl2) {
            this.mId = n2;
            this.mProgress = n3;
            this.mFromUser = bl2;
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        int progress;
        int secondaryProgress;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.progress = parcel.readInt();
            this.secondaryProgress = parcel.readInt();
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeInt(this.progress);
            parcel.writeInt(this.secondaryProgress);
        }
    }
}

