/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.v7.appcompat.R;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import java.util.Locale;

public class ListPopupWindow {
    private static final boolean DEBUG = false;
    private static final int EXPAND_LIST_TIMEOUT = 250;
    public static final int FILL_PARENT = -1;
    public static final int INPUT_METHOD_FROM_FOCUSABLE = 0;
    public static final int INPUT_METHOD_NEEDED = 1;
    public static final int INPUT_METHOD_NOT_NEEDED = 2;
    public static final int POSITION_PROMPT_ABOVE = 0;
    public static final int POSITION_PROMPT_BELOW = 1;
    private static final String TAG = "ListPopupWindow";
    public static final int WRAP_CONTENT = -2;
    private ListAdapter mAdapter;
    private Context mContext;
    private boolean mDropDownAlwaysVisible = false;
    private View mDropDownAnchorView;
    private int mDropDownHeight = -2;
    private int mDropDownHorizontalOffset;
    private DropDownListView mDropDownList;
    private Drawable mDropDownListHighlight;
    private int mDropDownVerticalOffset;
    private boolean mDropDownVerticalOffsetSet;
    private int mDropDownWidth = -2;
    private boolean mForceIgnoreOutsideTouch = false;
    private Handler mHandler;
    private final ListSelectorHider mHideSelector;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    private int mLayoutDirection;
    int mListItemExpandMaximum = Integer.MAX_VALUE;
    private boolean mModal;
    private DataSetObserver mObserver;
    private PopupWindow mPopup;
    private int mPromptPosition = 0;
    private View mPromptView;
    private final ResizePopupRunnable mResizePopupRunnable = new ResizePopupRunnable();
    private final PopupScrollListener mScrollListener;
    private Runnable mShowDropDownRunnable;
    private Rect mTempRect;
    private final PopupTouchInterceptor mTouchInterceptor = new PopupTouchInterceptor();

    public ListPopupWindow(Context context) {
        this(context, null, R.attr.listPopupWindowStyle);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.listPopupWindowStyle);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int n2) {
        this.mScrollListener = new PopupScrollListener();
        this.mHideSelector = new ListSelectorHider();
        this.mHandler = new Handler();
        this.mTempRect = new Rect();
        this.mContext = context;
        this.mPopup = new PopupWindow(context, attributeSet, n2);
        this.mPopup.setInputMethodMode(1);
        Locale cfr_ignored_0 = this.mContext.getResources().getConfiguration().locale;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int buildDropDown() {
        int n2;
        int n3;
        int n4;
        Drawable drawable2;
        int n5;
        if (this.mDropDownList == null) {
            Context context = this.mContext;
            this.mShowDropDownRunnable = new Runnable(){

                @Override
                public void run() {
                    View view = ListPopupWindow.this.getAnchorView();
                    if (view != null && view.getWindowToken() != null) {
                        ListPopupWindow.this.show();
                    }
                }
            };
            boolean bl2 = !this.mModal;
            this.mDropDownList = new DropDownListView(context, bl2);
            if (this.mDropDownListHighlight != null) {
                this.mDropDownList.setSelector(this.mDropDownListHighlight);
            }
            this.mDropDownList.setAdapter(this.mAdapter);
            this.mDropDownList.setOnItemClickListener(this.mItemClickListener);
            this.mDropDownList.setFocusable(true);
            this.mDropDownList.setFocusableInTouchMode(true);
            this.mDropDownList.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> adapterView, View view, int n2, long l2) {
                    DropDownListView dropDownListView;
                    if (n2 != -1 && (dropDownListView = ListPopupWindow.this.mDropDownList) != null) {
                        DropDownListView.access$502(dropDownListView, false);
                    }
                }

                public void onNothingSelected(AdapterView<?> adapterView) {
                }
            });
            this.mDropDownList.setOnScrollListener(this.mScrollListener);
            if (this.mItemSelectedListener != null) {
                this.mDropDownList.setOnItemSelectedListener(this.mItemSelectedListener);
            }
            DropDownListView dropDownListView = this.mDropDownList;
            View view = this.mPromptView;
            n5 = 0;
            if (view != null) {
                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(1);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                switch (this.mPromptPosition) {
                    default: {
                        Log.e((String)TAG, (String)("Invalid hint position " + this.mPromptPosition));
                        break;
                    }
                    case 1: {
                        linearLayout.addView((View)dropDownListView, (ViewGroup.LayoutParams)layoutParams);
                        linearLayout.addView(view);
                        break;
                    }
                    case 0: {
                        linearLayout.addView(view);
                        linearLayout.addView((View)dropDownListView, (ViewGroup.LayoutParams)layoutParams);
                        break;
                    }
                }
                view.measure(View.MeasureSpec.makeMeasureSpec((int)this.mDropDownWidth, (int)Integer.MIN_VALUE), 0);
                LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams)view.getLayoutParams();
                n5 = view.getMeasuredHeight() + layoutParams2.topMargin + layoutParams2.bottomMargin;
                dropDownListView = linearLayout;
            }
            this.mPopup.setContentView((View)dropDownListView);
        } else {
            ViewGroup cfr_ignored_0 = (ViewGroup)this.mPopup.getContentView();
            View view = this.mPromptView;
            n5 = 0;
            if (view != null) {
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                n5 = view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            }
        }
        if ((drawable2 = this.mPopup.getBackground()) != null) {
            drawable2.getPadding(this.mTempRect);
            n4 = this.mTempRect.top + this.mTempRect.bottom;
            if (!this.mDropDownVerticalOffsetSet) {
                this.mDropDownVerticalOffset = -this.mTempRect.top;
            }
        } else {
            this.mTempRect.setEmpty();
            n4 = 0;
        }
        boolean bl3 = this.mPopup.getInputMethodMode() == 2;
        int n6 = this.getMaxAvailableHeight(this.getAnchorView(), this.mDropDownVerticalOffset, bl3);
        if (this.mDropDownAlwaysVisible || this.mDropDownHeight == -1) {
            return n6 + n4;
        }
        switch (this.mDropDownWidth) {
            default: {
                n3 = View.MeasureSpec.makeMeasureSpec((int)this.mDropDownWidth, (int)0x40000000);
                break;
            }
            case -2: {
                n3 = View.MeasureSpec.makeMeasureSpec((int)(this.mContext.getResources().getDisplayMetrics().widthPixels - (this.mTempRect.left + this.mTempRect.right)), (int)Integer.MIN_VALUE);
                break;
            }
            case -1: {
                n3 = View.MeasureSpec.makeMeasureSpec((int)(this.mContext.getResources().getDisplayMetrics().widthPixels - (this.mTempRect.left + this.mTempRect.right)), (int)0x40000000);
            }
        }
        if ((n2 = this.mDropDownList.measureHeightOfChildrenCompat(n3, 0, -1, n6 - n5, -1)) > 0) {
            n5 += n4;
        }
        return n2 + n5;
    }

    private void removePromptView() {
        ViewParent viewParent;
        if (this.mPromptView != null && (viewParent = this.mPromptView.getParent()) instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.mPromptView);
        }
    }

    public void clearListSelection() {
        DropDownListView dropDownListView = this.mDropDownList;
        if (dropDownListView != null) {
            DropDownListView.access$502(dropDownListView, true);
            dropDownListView.requestLayout();
        }
    }

    public void dismiss() {
        this.mPopup.dismiss();
        this.removePromptView();
        this.mPopup.setContentView(null);
        this.mDropDownList = null;
        this.mHandler.removeCallbacks((Runnable)this.mResizePopupRunnable);
    }

    public View getAnchorView() {
        return this.mDropDownAnchorView;
    }

    public int getAnimationStyle() {
        return this.mPopup.getAnimationStyle();
    }

    public Drawable getBackground() {
        return this.mPopup.getBackground();
    }

    public int getHeight() {
        return this.mDropDownHeight;
    }

    public int getHorizontalOffset() {
        return this.mDropDownHorizontalOffset;
    }

    public int getInputMethodMode() {
        return this.mPopup.getInputMethodMode();
    }

    public ListView getListView() {
        return this.mDropDownList;
    }

    public int getMaxAvailableHeight(View view, int n2, boolean bl2) {
        Rect rect = new Rect();
        view.getWindowVisibleDisplayFrame(rect);
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        int n3 = rect.bottom;
        if (bl2) {
            n3 = view.getContext().getResources().getDisplayMetrics().heightPixels;
        }
        int n4 = Math.max(n3 - (nArray[1] + view.getHeight()) - n2, n2 + (nArray[1] - rect.top));
        if (this.mPopup.getBackground() != null) {
            this.mPopup.getBackground().getPadding(this.mTempRect);
            n4 -= this.mTempRect.top + this.mTempRect.bottom;
        }
        return n4;
    }

    public int getPromptPosition() {
        return this.mPromptPosition;
    }

    public Object getSelectedItem() {
        if (!this.isShowing()) {
            return null;
        }
        return this.mDropDownList.getSelectedItem();
    }

    public long getSelectedItemId() {
        if (!this.isShowing()) {
            return Long.MIN_VALUE;
        }
        return this.mDropDownList.getSelectedItemId();
    }

    public int getSelectedItemPosition() {
        if (!this.isShowing()) {
            return -1;
        }
        return this.mDropDownList.getSelectedItemPosition();
    }

    public View getSelectedView() {
        if (!this.isShowing()) {
            return null;
        }
        return this.mDropDownList.getSelectedView();
    }

    public int getSoftInputMode() {
        return this.mPopup.getSoftInputMode();
    }

    public int getVerticalOffset() {
        if (!this.mDropDownVerticalOffsetSet) {
            return 0;
        }
        return this.mDropDownVerticalOffset;
    }

    public int getWidth() {
        return this.mDropDownWidth;
    }

    public boolean isDropDownAlwaysVisible() {
        return this.mDropDownAlwaysVisible;
    }

    public boolean isInputMethodNotNeeded() {
        return this.mPopup.getInputMethodMode() == 2;
    }

    public boolean isModal() {
        return this.mModal;
    }

    public boolean isShowing() {
        return this.mPopup.isShowing();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (!this.isShowing()) return false;
        if (n2 == 62) return false;
        if (this.mDropDownList.getSelectedItemPosition() < 0) {
            if (n2 == 66) return false;
            if (n2 == 23) return false;
        }
        int n3 = this.mDropDownList.getSelectedItemPosition();
        boolean bl2 = !this.mPopup.isAboveAnchor();
        ListAdapter listAdapter = this.mAdapter;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        if (listAdapter != null) {
            boolean bl3 = listAdapter.areAllItemsEnabled();
            n4 = bl3 ? 0 : this.mDropDownList.lookForSelectablePosition(0, true);
            n5 = bl3 ? -1 + listAdapter.getCount() : this.mDropDownList.lookForSelectablePosition(-1 + listAdapter.getCount(), false);
        }
        if (bl2 && n2 == 19 && n3 <= n4 || !bl2 && n2 == 20 && n3 >= n5) {
            this.clearListSelection();
            this.mPopup.setInputMethodMode(1);
            this.show();
            return true;
        }
        DropDownListView.access$502(this.mDropDownList, false);
        if (this.mDropDownList.onKeyDown(n2, keyEvent)) {
            this.mPopup.setInputMethodMode(2);
            this.mDropDownList.requestFocusFromTouch();
            this.show();
            switch (n2) {
                case 19: 
                case 20: 
                case 23: 
                case 66: {
                    return true;
                }
            }
            return false;
        }
        if (bl2 && n2 == 20) {
            if (n3 != n5) return false;
            return true;
        }
        if (bl2) return false;
        if (n2 != 19) return false;
        if (n3 != n4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        if (!this.isShowing() || this.mDropDownList.getSelectedItemPosition() < 0) return false;
        boolean bl2 = this.mDropDownList.onKeyUp(n2, keyEvent);
        if (!bl2) return bl2;
        switch (n2) {
            default: {
                return bl2;
            }
            case 23: 
            case 66: 
        }
        this.dismiss();
        return bl2;
    }

    public boolean performItemClick(int n2) {
        if (this.isShowing()) {
            if (this.mItemClickListener != null) {
                DropDownListView dropDownListView = this.mDropDownList;
                View view = dropDownListView.getChildAt(n2 - dropDownListView.getFirstVisiblePosition());
                ListAdapter listAdapter = dropDownListView.getAdapter();
                this.mItemClickListener.onItemClick((AdapterView)dropDownListView, view, n2, listAdapter.getItemId(n2));
            }
            return true;
        }
        return false;
    }

    public void postShow() {
        this.mHandler.post(this.mShowDropDownRunnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAdapter(ListAdapter listAdapter) {
        if (this.mObserver == null) {
            this.mObserver = new PopupDataSetObserver();
        } else if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
        }
        this.mAdapter = listAdapter;
        if (this.mAdapter != null) {
            listAdapter.registerDataSetObserver(this.mObserver);
        }
        if (this.mDropDownList != null) {
            this.mDropDownList.setAdapter(this.mAdapter);
        }
    }

    public void setAnchorView(View view) {
        this.mDropDownAnchorView = view;
    }

    public void setAnimationStyle(int n2) {
        this.mPopup.setAnimationStyle(n2);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        this.mPopup.setBackgroundDrawable(drawable2);
    }

    public void setContentWidth(int n2) {
        Drawable drawable2 = this.mPopup.getBackground();
        if (drawable2 != null) {
            drawable2.getPadding(this.mTempRect);
            this.mDropDownWidth = n2 + (this.mTempRect.left + this.mTempRect.right);
            return;
        }
        this.setWidth(n2);
    }

    public void setDropDownAlwaysVisible(boolean bl2) {
        this.mDropDownAlwaysVisible = bl2;
    }

    public void setForceIgnoreOutsideTouch(boolean bl2) {
        this.mForceIgnoreOutsideTouch = bl2;
    }

    public void setHeight(int n2) {
        this.mDropDownHeight = n2;
    }

    public void setHorizontalOffset(int n2) {
        this.mDropDownHorizontalOffset = n2;
    }

    public void setInputMethodMode(int n2) {
        this.mPopup.setInputMethodMode(n2);
    }

    void setListItemExpandMax(int n2) {
        this.mListItemExpandMaximum = n2;
    }

    public void setListSelector(Drawable drawable2) {
        this.mDropDownListHighlight = drawable2;
    }

    public void setModal(boolean bl2) {
        this.mModal = true;
        this.mPopup.setFocusable(bl2);
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.mPopup.setOnDismissListener(onDismissListener);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.mItemClickListener = onItemClickListener;
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        this.mItemSelectedListener = onItemSelectedListener;
    }

    public void setPromptPosition(int n2) {
        this.mPromptPosition = n2;
    }

    public void setPromptView(View view) {
        boolean bl2 = this.isShowing();
        if (bl2) {
            this.removePromptView();
        }
        this.mPromptView = view;
        if (bl2) {
            this.show();
        }
    }

    public void setSelection(int n2) {
        DropDownListView dropDownListView = this.mDropDownList;
        if (this.isShowing() && dropDownListView != null) {
            DropDownListView.access$502(dropDownListView, false);
            dropDownListView.setSelection(n2);
            if (dropDownListView.getChoiceMode() != 0) {
                dropDownListView.setItemChecked(n2, true);
            }
        }
    }

    public void setSoftInputMode(int n2) {
        this.mPopup.setSoftInputMode(n2);
    }

    public void setVerticalOffset(int n2) {
        this.mDropDownVerticalOffset = n2;
        this.mDropDownVerticalOffsetSet = true;
    }

    public void setWidth(int n2) {
        this.mDropDownWidth = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void show() {
        int n2;
        int n3;
        boolean bl2 = true;
        int n4 = -1;
        int n5 = this.buildDropDown();
        boolean bl3 = this.isInputMethodNotNeeded();
        if (this.mPopup.isShowing()) {
            int n6;
            int n7 = this.mDropDownWidth == n4 ? -1 : (this.mDropDownWidth == -2 ? this.getAnchorView().getWidth() : this.mDropDownWidth);
            if (this.mDropDownHeight == n4) {
                n6 = bl3 ? n5 : n4;
                if (bl3) {
                    PopupWindow popupWindow = this.mPopup;
                    if (this.mDropDownWidth != n4) {
                        n4 = 0;
                    }
                    popupWindow.setWindowLayoutMode(n4, 0);
                } else {
                    PopupWindow popupWindow = this.mPopup;
                    int n8 = this.mDropDownWidth == n4 ? n4 : 0;
                    popupWindow.setWindowLayoutMode(n8, n4);
                }
            } else {
                n6 = this.mDropDownHeight == -2 ? n5 : this.mDropDownHeight;
            }
            PopupWindow popupWindow = this.mPopup;
            boolean bl4 = this.mForceIgnoreOutsideTouch;
            boolean bl5 = false;
            if (!bl4) {
                boolean bl6 = this.mDropDownAlwaysVisible;
                bl5 = false;
                if (!bl6) {
                    bl5 = bl2;
                }
            }
            popupWindow.setOutsideTouchable(bl5);
            this.mPopup.update(this.getAnchorView(), this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset, n7, n6);
            return;
        }
        if (this.mDropDownWidth == n4) {
            n3 = -1;
        } else if (this.mDropDownWidth == -2) {
            this.mPopup.setWidth(this.getAnchorView().getWidth());
            n3 = 0;
        } else {
            this.mPopup.setWidth(this.mDropDownWidth);
            n3 = 0;
        }
        if (this.mDropDownHeight == n4) {
            n2 = -1;
        } else if (this.mDropDownHeight == -2) {
            this.mPopup.setHeight(n5);
            n2 = 0;
        } else {
            this.mPopup.setHeight(this.mDropDownHeight);
            n2 = 0;
        }
        this.mPopup.setWindowLayoutMode(n3, n2);
        PopupWindow popupWindow = this.mPopup;
        if (this.mForceIgnoreOutsideTouch || this.mDropDownAlwaysVisible) {
            bl2 = false;
        }
        popupWindow.setOutsideTouchable(bl2);
        this.mPopup.setTouchInterceptor((View.OnTouchListener)this.mTouchInterceptor);
        this.mPopup.showAsDropDown(this.getAnchorView(), this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset);
        this.mDropDownList.setSelection(n4);
        if (!this.mModal || this.mDropDownList.isInTouchMode()) {
            this.clearListSelection();
        }
        if (this.mModal) return;
        this.mHandler.post((Runnable)this.mHideSelector);
    }

    private static class DropDownListView
    extends ListView {
        public static final int INVALID_POSITION = -1;
        static final int NO_POSITION = -1;
        private static final String TAG = "ListPopupWindow.DropDownListView";
        private boolean mHijackFocus;
        private boolean mListSelectionHidden;

        public DropDownListView(Context context, boolean bl2) {
            super(context, null, R.attr.dropDownListViewStyle);
            this.mHijackFocus = bl2;
            this.setCacheColorHint(0);
        }

        static /* synthetic */ boolean access$502(DropDownListView dropDownListView, boolean bl2) {
            dropDownListView.mListSelectionHidden = bl2;
            return bl2;
        }

        /*
         * Enabled aggressive block sorting
         */
        private int lookForSelectablePosition(int n2, boolean bl2) {
            ListAdapter listAdapter = this.getAdapter();
            if (listAdapter == null || this.isInTouchMode()) return -1;
            int n3 = listAdapter.getCount();
            if (!this.getAdapter().areAllItemsEnabled()) {
                int n4;
                if (bl2) {
                    for (n4 = Math.max(0, n2); n4 < n3 && !listAdapter.isEnabled(n4); ++n4) {
                    }
                } else {
                    for (n4 = Math.min(n2, n3 - 1); n4 >= 0 && !listAdapter.isEnabled(n4); --n4) {
                    }
                }
                if (n4 < 0 || n4 >= n3) return -1;
                return n4;
            }
            if (n2 >= 0 && n2 < n3) return n2;
            return -1;
        }

        public boolean hasFocus() {
            return this.mHijackFocus || super.hasFocus();
        }

        public boolean hasWindowFocus() {
            return this.mHijackFocus || super.hasWindowFocus();
        }

        public boolean isFocused() {
            return this.mHijackFocus || super.isFocused();
        }

        public boolean isInTouchMode() {
            return this.mHijackFocus && this.mListSelectionHidden || super.isInTouchMode();
        }

        /*
         * Enabled aggressive block sorting
         */
        final int measureHeightOfChildrenCompat(int n2, int n3, int n4, int n5, int n6) {
            int n7 = this.getListPaddingTop();
            int n8 = this.getListPaddingBottom();
            this.getListPaddingLeft();
            this.getListPaddingRight();
            int n9 = this.getDividerHeight();
            Drawable drawable2 = this.getDivider();
            ListAdapter listAdapter = this.getAdapter();
            if (listAdapter == null) {
                return n7 + n8;
            }
            int n10 = n7 + n8;
            int n11 = n9 > 0 && drawable2 != null ? n9 : 0;
            int n12 = 0;
            View view = null;
            int n13 = 0;
            int n14 = listAdapter.getCount();
            int n15 = 0;
            while (n15 < n14) {
                int n16 = listAdapter.getItemViewType(n15);
                if (n16 != n13) {
                    view = null;
                    n13 = n16;
                }
                view = listAdapter.getView(n15, view, (ViewGroup)this);
                int n17 = view.getLayoutParams().height;
                int n18 = n17 > 0 ? View.MeasureSpec.makeMeasureSpec((int)n17, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                view.measure(n2, n18);
                if (n15 > 0) {
                    n10 += n11;
                }
                if ((n10 += view.getMeasuredHeight()) >= n5) {
                    if (n6 < 0) return n5;
                    if (n15 <= n6) return n5;
                    if (n12 <= 0) return n5;
                    if (n10 != n5) return n12;
                    return n5;
                }
                if (n6 >= 0 && n15 >= n6) {
                    n12 = n10;
                }
                ++n15;
            }
            return n10;
        }
    }

    private class ListSelectorHider
    implements Runnable {
        private ListSelectorHider() {
        }

        @Override
        public void run() {
            ListPopupWindow.this.clearListSelection();
        }
    }

    private class PopupDataSetObserver
    extends DataSetObserver {
        private PopupDataSetObserver() {
        }

        public void onChanged() {
            if (ListPopupWindow.this.isShowing()) {
                ListPopupWindow.this.show();
            }
        }

        public void onInvalidated() {
            ListPopupWindow.this.dismiss();
        }
    }

    private class PopupScrollListener
    implements AbsListView.OnScrollListener {
        private PopupScrollListener() {
        }

        public void onScroll(AbsListView absListView, int n2, int n3, int n4) {
        }

        public void onScrollStateChanged(AbsListView absListView, int n2) {
            if (n2 == 1 && !ListPopupWindow.this.isInputMethodNotNeeded() && ListPopupWindow.this.mPopup.getContentView() != null) {
                ListPopupWindow.this.mHandler.removeCallbacks((Runnable)ListPopupWindow.this.mResizePopupRunnable);
                ListPopupWindow.this.mResizePopupRunnable.run();
            }
        }
    }

    private class PopupTouchInterceptor
    implements View.OnTouchListener {
        private PopupTouchInterceptor() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean onTouch(View view, MotionEvent motionEvent) {
            int n2 = motionEvent.getAction();
            int n3 = (int)motionEvent.getX();
            int n4 = (int)motionEvent.getY();
            if (n2 == 0 && ListPopupWindow.this.mPopup != null && ListPopupWindow.this.mPopup.isShowing() && n3 >= 0 && n3 < ListPopupWindow.this.mPopup.getWidth() && n4 >= 0 && n4 < ListPopupWindow.this.mPopup.getHeight()) {
                ListPopupWindow.this.mHandler.postDelayed((Runnable)ListPopupWindow.this.mResizePopupRunnable, 250L);
                return false;
            }
            if (n2 != 1) return false;
            ListPopupWindow.this.mHandler.removeCallbacks((Runnable)ListPopupWindow.this.mResizePopupRunnable);
            return false;
        }
    }

    private class ResizePopupRunnable
    implements Runnable {
        private ResizePopupRunnable() {
        }

        @Override
        public void run() {
            if (ListPopupWindow.this.mDropDownList != null && ListPopupWindow.this.mDropDownList.getCount() > ListPopupWindow.this.mDropDownList.getChildCount() && ListPopupWindow.this.mDropDownList.getChildCount() <= ListPopupWindow.this.mListItemExpandMaximum) {
                ListPopupWindow.this.mPopup.setInputMethodMode(2);
                ListPopupWindow.this.show();
            }
        }
    }
}

