/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v7.appcompat.R;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

public class LinearLayoutICS
extends LinearLayout {
    private static final int SHOW_DIVIDER_BEGINNING = 1;
    private static final int SHOW_DIVIDER_END = 4;
    private static final int SHOW_DIVIDER_MIDDLE = 2;
    private static final int SHOW_DIVIDER_NONE;
    private final Drawable mDivider;
    private final int mDividerHeight;
    private final int mDividerPadding;
    private final int mDividerWidth;
    private final int mShowDividers;

    /*
     * Enabled aggressive block sorting
     */
    public LinearLayoutICS(Context context, AttributeSet attributeSet) {
        boolean bl2 = true;
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.LinearLayoutICS);
        this.mDivider = typedArray.getDrawable(0);
        if (this.mDivider != null) {
            this.mDividerWidth = this.mDivider.getIntrinsicWidth();
            this.mDividerHeight = this.mDivider.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        this.mShowDividers = typedArray.getInt(bl2 ? 1 : 0, 0);
        this.mDividerPadding = typedArray.getDimensionPixelSize(2, 0);
        typedArray.recycle();
        if (this.mDivider != null) {
            bl2 = false;
        }
        this.setWillNotDraw(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawSupportDividersHorizontal(Canvas canvas) {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            if (view == null || view.getVisibility() == 8 || !this.hasSupportDividerBeforeChildAt(i2)) continue;
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
            this.drawSupportVerticalDivider(canvas, view.getLeft() - layoutParams.leftMargin);
        }
        if (this.hasSupportDividerBeforeChildAt(n2)) {
            View view = this.getChildAt(n2 - 1);
            int n3 = view == null ? this.getWidth() - this.getPaddingRight() - this.mDividerWidth : view.getRight();
            this.drawSupportVerticalDivider(canvas, n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawSupportDividersVertical(Canvas canvas) {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            if (view == null || view.getVisibility() == 8 || !this.hasSupportDividerBeforeChildAt(i2)) continue;
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
            this.drawSupportHorizontalDivider(canvas, view.getTop() - layoutParams.topMargin);
        }
        if (this.hasSupportDividerBeforeChildAt(n2)) {
            View view = this.getChildAt(n2 - 1);
            int n3 = view == null ? this.getHeight() - this.getPaddingBottom() - this.mDividerHeight : view.getBottom();
            this.drawSupportHorizontalDivider(canvas, n3);
        }
    }

    void drawSupportHorizontalDivider(Canvas canvas, int n2) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, n2, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, n2 + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    void drawSupportVerticalDivider(Canvas canvas, int n2) {
        this.mDivider.setBounds(n2, this.getPaddingTop() + this.mDividerPadding, n2 + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    public int getSupportDividerWidth() {
        return this.mDividerWidth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasSupportDividerBeforeChildAt(int n2) {
        if (n2 == 0) {
            if ((1 & this.mShowDividers) == 0) return false;
            return true;
        }
        if (n2 == this.getChildCount()) {
            if ((4 & this.mShowDividers) != 0) return true;
            return false;
        }
        if ((2 & this.mShowDividers) == 0) return false;
        int n3 = n2 - 1;
        while (true) {
            boolean bl2 = false;
            if (n3 < 0) return bl2;
            if (this.getChildAt(n3).getVisibility() != 8) {
                return true;
            }
            --n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void measureChildWithMargins(View view, int n2, int n3, int n4, int n5) {
        block6: {
            int n6;
            int n7;
            block7: {
                if (this.mDivider == null) break block6;
                n7 = this.indexOfChild(view);
                n6 = this.getChildCount();
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                if (this.getOrientation() != 1) break block7;
                if (this.hasSupportDividerBeforeChildAt(n7)) {
                    layoutParams.topMargin = this.mDividerHeight;
                    break block6;
                } else if (n7 == n6 - 1 && this.hasSupportDividerBeforeChildAt(n6)) {
                    layoutParams.bottomMargin = this.mDividerHeight;
                }
                break block6;
            }
            if (this.hasSupportDividerBeforeChildAt(n7)) {
                layoutParams.leftMargin = this.mDividerWidth;
            } else if (n7 == n6 - 1 && this.hasSupportDividerBeforeChildAt(n6)) {
                layoutParams.rightMargin = this.mDividerWidth;
            }
        }
        super.measureChildWithMargins(view, n2, n3, n4, n5);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDivider == null) {
            return;
        }
        if (this.getOrientation() == 1) {
            this.drawSupportDividersVertical(canvas);
            return;
        }
        this.drawSupportDividersHorizontal(canvas);
    }
}

