/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.Adapter;
import android.widget.AdapterView;

abstract class AdapterViewICS<T extends Adapter>
extends ViewGroup {
    public static final int INVALID_POSITION = -1;
    public static final long INVALID_ROW_ID = Long.MIN_VALUE;
    static final int ITEM_VIEW_TYPE_HEADER_OR_FOOTER = -2;
    static final int ITEM_VIEW_TYPE_IGNORE = -1;
    static final int SYNC_FIRST_POSITION = 1;
    static final int SYNC_MAX_DURATION_MILLIS = 100;
    static final int SYNC_SELECTED_POSITION;
    boolean mBlockLayoutRequests = false;
    boolean mDataChanged;
    private boolean mDesiredFocusableInTouchModeState;
    private boolean mDesiredFocusableState;
    private View mEmptyView;
    @ViewDebug.ExportedProperty(category="scrolling")
    int mFirstPosition = 0;
    boolean mInLayout = false;
    @ViewDebug.ExportedProperty(category="list")
    int mItemCount;
    private int mLayoutHeight;
    boolean mNeedSync = false;
    @ViewDebug.ExportedProperty(category="list")
    int mNextSelectedPosition = -1;
    long mNextSelectedRowId;
    int mOldItemCount;
    int mOldSelectedPosition = -1;
    long mOldSelectedRowId;
    OnItemClickListener mOnItemClickListener;
    OnItemLongClickListener mOnItemLongClickListener;
    OnItemSelectedListener mOnItemSelectedListener;
    @ViewDebug.ExportedProperty(category="list")
    int mSelectedPosition = -1;
    long mSelectedRowId;
    private SelectionNotifier mSelectionNotifier;
    int mSpecificTop;
    long mSyncHeight;
    int mSyncMode;
    int mSyncPosition;
    long mSyncRowId = Long.MIN_VALUE;

    AdapterViewICS(Context context) {
        super(context);
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mOldSelectedRowId = Long.MIN_VALUE;
    }

    AdapterViewICS(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mOldSelectedRowId = Long.MIN_VALUE;
    }

    AdapterViewICS(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mOldSelectedRowId = Long.MIN_VALUE;
    }

    private void fireOnSelected() {
        if (this.mOnItemSelectedListener == null) {
            return;
        }
        int n2 = this.getSelectedItemPosition();
        if (n2 >= 0) {
            View view = this.getSelectedView();
            this.mOnItemSelectedListener.onItemSelected(this, view, n2, this.getAdapter().getItemId(n2));
            return;
        }
        this.mOnItemSelectedListener.onNothingSelected(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateEmptyStatus(boolean bl2) {
        if (this.isInFilterMode()) {
            bl2 = false;
        }
        if (bl2) {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(0);
                this.setVisibility(8);
            } else {
                this.setVisibility(0);
            }
            if (this.mDataChanged) {
                this.onLayout(false, this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            }
            return;
        }
        if (this.mEmptyView != null) {
            this.mEmptyView.setVisibility(8);
        }
        this.setVisibility(0);
    }

    public void addView(View view) {
        throw new UnsupportedOperationException("addView(View) is not supported in AdapterView");
    }

    public void addView(View view, int n2) {
        throw new UnsupportedOperationException("addView(View, int) is not supported in AdapterView");
    }

    public void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        throw new UnsupportedOperationException("addView(View, int, LayoutParams) is not supported in AdapterView");
    }

    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        throw new UnsupportedOperationException("addView(View, LayoutParams) is not supported in AdapterView");
    }

    protected boolean canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    void checkFocus() {
        block2: {
            boolean bl2;
            block4: {
                block3: {
                    T t2 = this.getAdapter();
                    boolean bl3 = t2 == null || t2.getCount() == 0;
                    boolean bl4 = !bl3 || this.isInFilterMode();
                    boolean bl5 = bl4 && this.mDesiredFocusableInTouchModeState;
                    super.setFocusableInTouchMode(bl5);
                    boolean bl6 = bl4 && this.mDesiredFocusableState;
                    super.setFocusable(bl6);
                    if (this.mEmptyView == null) break block2;
                    if (t2 == null) break block3;
                    boolean bl7 = t2.isEmpty();
                    bl2 = false;
                    if (!bl7) break block4;
                }
                bl2 = true;
            }
            this.updateEmptyStatus(bl2);
        }
    }

    void checkSelectionChanged() {
        if (this.mSelectedPosition != this.mOldSelectedPosition || this.mSelectedRowId != this.mOldSelectedRowId) {
            this.selectionChanged();
            this.mOldSelectedPosition = this.mSelectedPosition;
            this.mOldSelectedRowId = this.mSelectedRowId;
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        View view = this.getSelectedView();
        return view != null && view.getVisibility() == 0 && view.dispatchPopulateAccessibilityEvent(accessibilityEvent);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchThawSelfOnly(sparseArray);
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchFreezeSelfOnly(sparseArray);
    }

    /*
     * Unable to fully structure code
     */
    int findSyncPosition() {
        var1_1 = this.mItemCount;
        if (var1_1 == 0) {
            var6_2 = -1;
            return var6_2;
        }
        var2_3 = this.mSyncRowId;
        var4_4 = this.mSyncPosition;
        if (var2_3 == -9223372036854775808L) {
            return -1;
        }
        var5_5 = Math.max(0, var4_4);
        var6_2 = Math.min(var1_1 - 1, var5_5);
        var7_6 = 100L + SystemClock.uptimeMillis();
        var9_7 = var6_2;
        var10_8 = var6_2;
        var11_9 = this.getAdapter();
        var12_10 = false;
        if (var11_9 != null) ** GOTO lbl22
        return -1;
        block1: while (var14_12 || var12_10 && !var13_11) {
            var6_2 = ++var10_8;
            var12_10 = false;
lbl22:
            // 4 sources

            while (true) {
                block8: {
                    block7: {
                        if (SystemClock.uptimeMillis() > var7_6) ** GOTO lbl-1000
                        if (var11_9.getItemId(var6_2) == var2_3) ** continue;
                        if (var10_8 != var1_1 - 1) break block7;
                        var13_11 = true;
lbl27:
                        // 2 sources

                        while (var9_7 == 0) {
                            var14_12 = true;
lbl29:
                            // 2 sources

                            while (var13_11 && var14_12) lbl-1000:
                            // 2 sources

                            {
                                return -1;
                            }
                            continue block1;
                        }
                        break block8;
                    }
                    var13_11 = false;
                    ** GOTO lbl27
                }
                var14_12 = false;
                ** GOTO lbl29
                break;
            }
        }
        if (!var13_11 && (var12_10 || var14_12)) ** GOTO lbl22
        var6_2 = --var9_7;
        var12_10 = true;
        ** while (true)
    }

    public abstract T getAdapter();

    @ViewDebug.CapturedViewProperty
    public int getCount() {
        return this.mItemCount;
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public int getFirstVisiblePosition() {
        return this.mFirstPosition;
    }

    public Object getItemAtPosition(int n2) {
        T t2 = this.getAdapter();
        if (t2 == null || n2 < 0) {
            return null;
        }
        return t2.getItem(n2);
    }

    public long getItemIdAtPosition(int n2) {
        T t2 = this.getAdapter();
        if (t2 == null || n2 < 0) {
            return Long.MIN_VALUE;
        }
        return t2.getItemId(n2);
    }

    public int getLastVisiblePosition() {
        return -1 + (this.mFirstPosition + this.getChildCount());
    }

    public final OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public final OnItemLongClickListener getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    public final OnItemSelectedListener getOnItemSelectedListener() {
        return this.mOnItemSelectedListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public int getPositionForView(View view) {
        View view2 = view;
        try {
            View view3;
            boolean bl2;
            while (!(bl2 = (view3 = (View)view2.getParent()).equals((Object)this))) {
                view2 = view3;
            }
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.getChildAt(n3).equals(view2)) {
                return n3 + this.mFirstPosition;
            }
            ++n3;
        }
        return -1;
    }

    public Object getSelectedItem() {
        T t2 = this.getAdapter();
        int n2 = this.getSelectedItemPosition();
        if (t2 != null && t2.getCount() > 0 && n2 >= 0) {
            return t2.getItem(n2);
        }
        return null;
    }

    @ViewDebug.CapturedViewProperty
    public long getSelectedItemId() {
        return this.mNextSelectedRowId;
    }

    @ViewDebug.CapturedViewProperty
    public int getSelectedItemPosition() {
        return this.mNextSelectedPosition;
    }

    public abstract View getSelectedView();

    void handleDataChanged() {
        int n2 = this.mItemCount;
        boolean bl2 = false;
        if (n2 > 0) {
            boolean bl3 = this.mNeedSync;
            bl2 = false;
            if (bl3) {
                this.mNeedSync = false;
                int n3 = this.findSyncPosition();
                bl2 = false;
                if (n3 >= 0) {
                    int n4 = this.lookForSelectablePosition(n3, true);
                    bl2 = false;
                    if (n4 == n3) {
                        this.setNextSelectedPositionInt(n3);
                        bl2 = true;
                    }
                }
            }
            if (!bl2) {
                int n5;
                int n6 = this.getSelectedItemPosition();
                if (n6 >= n2) {
                    n6 = n2 - 1;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if ((n5 = this.lookForSelectablePosition(n6, true)) < 0) {
                    n5 = this.lookForSelectablePosition(n6, false);
                }
                if (n5 >= 0) {
                    this.setNextSelectedPositionInt(n5);
                    this.checkSelectionChanged();
                    bl2 = true;
                }
            }
        }
        if (!bl2) {
            this.mSelectedPosition = -1;
            this.mSelectedRowId = Long.MIN_VALUE;
            this.mNextSelectedPosition = -1;
            this.mNextSelectedRowId = Long.MIN_VALUE;
            this.mNeedSync = false;
            this.checkSelectionChanged();
        }
    }

    boolean isInFilterMode() {
        return false;
    }

    int lookForSelectablePosition(int n2, boolean bl2) {
        return n2;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mSelectionNotifier);
    }

    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        this.mLayoutHeight = this.getHeight();
    }

    public boolean performItemClick(View view, int n2, long l2) {
        OnItemClickListener onItemClickListener = this.mOnItemClickListener;
        boolean bl2 = false;
        if (onItemClickListener != null) {
            this.playSoundEffect(0);
            if (view != null) {
                view.sendAccessibilityEvent(1);
            }
            this.mOnItemClickListener.onItemClick(this, view, n2, l2);
            bl2 = true;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    void rememberSyncState() {
        block6: {
            block5: {
                if (this.getChildCount() <= 0) break block5;
                this.mNeedSync = true;
                this.mSyncHeight = this.mLayoutHeight;
                if (this.mSelectedPosition < 0) break block6;
                View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                this.mSyncRowId = this.mNextSelectedRowId;
                this.mSyncPosition = this.mNextSelectedPosition;
                if (view != null) {
                    this.mSpecificTop = view.getTop();
                }
                this.mSyncMode = 0;
            }
            return;
        }
        View view = this.getChildAt(0);
        T t2 = this.getAdapter();
        this.mSyncRowId = this.mFirstPosition >= 0 && this.mFirstPosition < t2.getCount() ? t2.getItemId(this.mFirstPosition) : -1L;
        this.mSyncPosition = this.mFirstPosition;
        if (view != null) {
            this.mSpecificTop = view.getTop();
        }
        this.mSyncMode = 1;
    }

    public void removeAllViews() {
        throw new UnsupportedOperationException("removeAllViews() is not supported in AdapterView");
    }

    public void removeView(View view) {
        throw new UnsupportedOperationException("removeView(View) is not supported in AdapterView");
    }

    public void removeViewAt(int n2) {
        throw new UnsupportedOperationException("removeViewAt(int) is not supported in AdapterView");
    }

    /*
     * Enabled aggressive block sorting
     */
    void selectionChanged() {
        if (this.mOnItemSelectedListener != null) {
            if (this.mInLayout || this.mBlockLayoutRequests) {
                if (this.mSelectionNotifier == null) {
                    this.mSelectionNotifier = new SelectionNotifier();
                }
                this.post(this.mSelectionNotifier);
            } else {
                this.fireOnSelected();
            }
        }
        if (this.mSelectedPosition != -1 && this.isShown() && !this.isInTouchMode()) {
            this.sendAccessibilityEvent(4);
        }
    }

    public abstract void setAdapter(T var1);

    /*
     * Enabled aggressive block sorting
     */
    public void setEmptyView(View view) {
        this.mEmptyView = view;
        T t2 = this.getAdapter();
        boolean bl2 = t2 == null || t2.isEmpty();
        this.updateEmptyStatus(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFocusable(boolean bl2) {
        boolean bl3 = true;
        T t2 = this.getAdapter();
        boolean bl4 = t2 == null || t2.getCount() == 0 ? bl3 : false;
        this.mDesiredFocusableState = bl2;
        if (!bl2) {
            this.mDesiredFocusableInTouchModeState = false;
        }
        if (!bl2 || bl4 && !this.isInFilterMode()) {
            bl3 = false;
        }
        super.setFocusable(bl3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFocusableInTouchMode(boolean bl2) {
        boolean bl3 = true;
        T t2 = this.getAdapter();
        boolean bl4 = t2 == null || t2.getCount() == 0 ? bl3 : false;
        this.mDesiredFocusableInTouchModeState = bl2;
        if (bl2) {
            this.mDesiredFocusableState = bl3;
        }
        if (!bl2 || bl4 && !this.isInFilterMode()) {
            bl3 = false;
        }
        super.setFocusableInTouchMode(bl3);
    }

    void setNextSelectedPositionInt(int n2) {
        this.mNextSelectedPosition = n2;
        this.mNextSelectedRowId = this.getItemIdAtPosition(n2);
        if (this.mNeedSync && this.mSyncMode == 0 && n2 >= 0) {
            this.mSyncPosition = n2;
            this.mSyncRowId = this.mNextSelectedRowId;
        }
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        throw new RuntimeException("Don't call setOnClickListener for an AdapterView. You probably want setOnItemClickListener instead");
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        this.mOnItemSelectedListener = onItemSelectedListener;
    }

    void setSelectedPositionInt(int n2) {
        this.mSelectedPosition = n2;
        this.mSelectedRowId = this.getItemIdAtPosition(n2);
    }

    public abstract void setSelection(int var1);

    public static class AdapterContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public long id;
        public int position;
        public View targetView;

        public AdapterContextMenuInfo(View view, int n2, long l2) {
            this.targetView = view;
            this.position = n2;
            this.id = l2;
        }
    }

    class AdapterDataSetObserver
    extends DataSetObserver {
        private Parcelable mInstanceState = null;

        AdapterDataSetObserver() {
        }

        public void clearSavedState() {
            this.mInstanceState = null;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onChanged() {
            AdapterViewICS.this.mDataChanged = true;
            AdapterViewICS.this.mOldItemCount = AdapterViewICS.this.mItemCount;
            AdapterViewICS.this.mItemCount = AdapterViewICS.this.getAdapter().getCount();
            if (AdapterViewICS.this.getAdapter().hasStableIds() && this.mInstanceState != null && AdapterViewICS.this.mOldItemCount == 0 && AdapterViewICS.this.mItemCount > 0) {
                AdapterViewICS.this.onRestoreInstanceState(this.mInstanceState);
                this.mInstanceState = null;
            } else {
                AdapterViewICS.this.rememberSyncState();
            }
            AdapterViewICS.this.checkFocus();
            AdapterViewICS.this.requestLayout();
        }

        public void onInvalidated() {
            AdapterViewICS.this.mDataChanged = true;
            if (AdapterViewICS.this.getAdapter().hasStableIds()) {
                this.mInstanceState = AdapterViewICS.this.onSaveInstanceState();
            }
            AdapterViewICS.this.mOldItemCount = AdapterViewICS.this.mItemCount;
            AdapterViewICS.this.mItemCount = 0;
            AdapterViewICS.this.mSelectedPosition = -1;
            AdapterViewICS.this.mSelectedRowId = Long.MIN_VALUE;
            AdapterViewICS.this.mNextSelectedPosition = -1;
            AdapterViewICS.this.mNextSelectedRowId = Long.MIN_VALUE;
            AdapterViewICS.this.mNeedSync = false;
            AdapterViewICS.this.checkFocus();
            AdapterViewICS.this.requestLayout();
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(AdapterViewICS<?> var1, View var2, int var3, long var4);
    }

    class OnItemClickListenerWrapper
    implements AdapterView.OnItemClickListener {
        private final OnItemClickListener mWrappedListener;

        public OnItemClickListenerWrapper(OnItemClickListener onItemClickListener) {
            this.mWrappedListener = onItemClickListener;
        }

        public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
            this.mWrappedListener.onItemClick(AdapterViewICS.this, view, n2, l2);
        }
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(AdapterViewICS<?> var1, View var2, int var3, long var4);
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(AdapterViewICS<?> var1, View var2, int var3, long var4);

        public void onNothingSelected(AdapterViewICS<?> var1);
    }

    private class SelectionNotifier
    implements Runnable {
        private SelectionNotifier() {
        }

        @Override
        public void run() {
            if (AdapterViewICS.this.mDataChanged) {
                if (AdapterViewICS.this.getAdapter() != null) {
                    AdapterViewICS.this.post(this);
                }
                return;
            }
            AdapterViewICS.this.fireOnSelected();
        }
    }
}

