/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.internal.view.SupportMenu;
import android.support.v4.internal.view.SupportMenuItem;
import android.support.v7.app.ActionBar;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.menu.ActionMenuItem;
import android.support.v7.internal.view.menu.ActionMenuPresenter;
import android.support.v7.internal.view.menu.ActionMenuView;
import android.support.v7.internal.view.menu.MenuBuilder;
import android.support.v7.internal.view.menu.MenuItemImpl;
import android.support.v7.internal.view.menu.MenuPresenter;
import android.support.v7.internal.view.menu.MenuView;
import android.support.v7.internal.view.menu.SubMenuBuilder;
import android.support.v7.internal.widget.AbsActionBarView;
import android.support.v7.internal.widget.ActionBarContainer;
import android.support.v7.internal.widget.ActionBarContextView;
import android.support.v7.internal.widget.AdapterViewICS;
import android.support.v7.internal.widget.ProgressBarICS;
import android.support.v7.internal.widget.ScrollingTabContainerView;
import android.support.v7.internal.widget.SpinnerICS;
import android.support.v7.view.CollapsibleActionView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SpinnerAdapter;
import android.widget.TextView;

public class ActionBarView
extends AbsActionBarView {
    private static final int DEFAULT_CUSTOM_GRAVITY = 19;
    public static final int DISPLAY_DEFAULT = 0;
    private static final int DISPLAY_RELAYOUT_MASK = 31;
    private static final String TAG = "ActionBarView";
    private ActionBar.OnNavigationListener mCallback;
    private Context mContext;
    private ActionBarContextView mContextView;
    private View mCustomNavView;
    private int mDisplayOptions = -1;
    View mExpandedActionView;
    private final View.OnClickListener mExpandedActionViewUpListener;
    private HomeView mExpandedHomeLayout;
    private ExpandedActionViewMenuPresenter mExpandedMenuPresenter;
    private HomeView mHomeLayout;
    private Drawable mIcon;
    private boolean mIncludeTabs;
    private int mIndeterminateProgressStyle;
    private ProgressBarICS mIndeterminateProgressView;
    private boolean mIsCollapsable;
    private boolean mIsCollapsed;
    private int mItemPadding;
    private LinearLayout mListNavLayout;
    private Drawable mLogo;
    private ActionMenuItem mLogoNavItem;
    private final AdapterViewICS.OnItemSelectedListener mNavItemSelectedListener = new AdapterViewICS.OnItemSelectedListener(){

        @Override
        public void onItemSelected(AdapterViewICS<?> adapterViewICS, View view, int n2, long l2) {
            if (ActionBarView.this.mCallback != null) {
                ActionBarView.this.mCallback.onNavigationItemSelected(n2, l2);
            }
        }

        @Override
        public void onNothingSelected(AdapterViewICS<?> adapterViewICS) {
        }
    };
    private int mNavigationMode;
    private MenuBuilder mOptionsMenu;
    private int mProgressBarPadding;
    private int mProgressStyle;
    private ProgressBarICS mProgressView;
    private SpinnerICS mSpinner;
    private SpinnerAdapter mSpinnerAdapter;
    private CharSequence mSubtitle;
    private int mSubtitleStyleRes;
    private TextView mSubtitleView;
    private ScrollingTabContainerView mTabScrollView;
    private Runnable mTabSelector;
    private CharSequence mTitle;
    private LinearLayout mTitleLayout;
    private int mTitleStyleRes;
    private View mTitleUpView;
    private TextView mTitleView;
    private final View.OnClickListener mUpClickListener;
    private boolean mUserTitle;
    Window.Callback mWindowCallback;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionBarView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mExpandedActionViewUpListener = new View.OnClickListener(){

            public void onClick(View view) {
                MenuItemImpl menuItemImpl = ((ActionBarView)ActionBarView.this).mExpandedMenuPresenter.mCurrentExpandedItem;
                if (menuItemImpl != null) {
                    menuItemImpl.collapseActionView();
                }
            }
        };
        this.mUpClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                ActionBarView.this.mWindowCallback.onMenuItemSelected(0, (MenuItem)ActionBarView.this.mLogoNavItem);
            }
        };
        this.mContext = context;
        this.setBackgroundResource(0);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ActionBar, R.attr.actionBarStyle, 0);
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        PackageManager packageManager = context.getPackageManager();
        this.mNavigationMode = typedArray.getInt(2, 0);
        this.mTitle = typedArray.getText(1);
        this.mSubtitle = typedArray.getText(4);
        this.mLogo = typedArray.getDrawable(8);
        if (this.mLogo == null && Build.VERSION.SDK_INT >= 9) {
            if (context instanceof Activity) {
                try {
                    this.mLogo = packageManager.getActivityLogo(((Activity)context).getComponentName());
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.e((String)TAG, (String)"Activity component name not found!", (Throwable)nameNotFoundException);
                }
            }
            if (this.mLogo == null) {
                this.mLogo = applicationInfo.loadLogo(packageManager);
            }
        }
        this.mIcon = typedArray.getDrawable(7);
        if (this.mIcon == null) {
            if (context instanceof Activity) {
                try {
                    this.mIcon = packageManager.getActivityIcon(((Activity)context).getComponentName());
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.e((String)TAG, (String)"Activity component name not found!", (Throwable)nameNotFoundException);
                }
            }
            if (this.mIcon == null) {
                this.mIcon = applicationInfo.loadIcon(packageManager);
            }
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        int n2 = typedArray.getResourceId(14, R.layout.abc_action_bar_home);
        this.mHomeLayout = (HomeView)layoutInflater.inflate(n2, (ViewGroup)this, false);
        this.mExpandedHomeLayout = (HomeView)layoutInflater.inflate(n2, (ViewGroup)this, false);
        this.mExpandedHomeLayout.setUp(true);
        this.mExpandedHomeLayout.setOnClickListener(this.mExpandedActionViewUpListener);
        this.mExpandedHomeLayout.setContentDescription(this.getResources().getText(R.string.abc_action_bar_up_description));
        this.mTitleStyleRes = typedArray.getResourceId(5, 0);
        this.mSubtitleStyleRes = typedArray.getResourceId(6, 0);
        this.mProgressStyle = typedArray.getResourceId(15, 0);
        this.mIndeterminateProgressStyle = typedArray.getResourceId(16, 0);
        this.mProgressBarPadding = typedArray.getDimensionPixelOffset(17, 0);
        this.mItemPadding = typedArray.getDimensionPixelOffset(18, 0);
        this.setDisplayOptions(typedArray.getInt(3, 0));
        int n3 = typedArray.getResourceId(13, 0);
        if (n3 != 0) {
            this.mCustomNavView = layoutInflater.inflate(n3, (ViewGroup)this, false);
            this.mNavigationMode = 0;
            this.setDisplayOptions(0x10 | this.mDisplayOptions);
        }
        this.mContentHeight = typedArray.getLayoutDimension(0, 0);
        typedArray.recycle();
        this.mLogoNavItem = new ActionMenuItem(context, 0, 16908332, 0, 0, this.mTitle);
        this.mHomeLayout.setOnClickListener(this.mUpClickListener);
        this.mHomeLayout.setClickable(true);
        this.mHomeLayout.setFocusable(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void configPresenters(MenuBuilder menuBuilder) {
        if (menuBuilder != null) {
            menuBuilder.addMenuPresenter(this.mActionMenuPresenter);
            menuBuilder.addMenuPresenter(this.mExpandedMenuPresenter);
        } else {
            this.mActionMenuPresenter.initForMenu(this.mContext, null);
            this.mExpandedMenuPresenter.initForMenu(this.mContext, null);
        }
        this.mActionMenuPresenter.updateMenuView(true);
        this.mExpandedMenuPresenter.updateMenuView(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initTitle() {
        boolean bl2 = true;
        if (this.mTitleLayout == null) {
            this.mTitleLayout = (LinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.abc_action_bar_title_item, (ViewGroup)this, false);
            this.mTitleView = (TextView)this.mTitleLayout.findViewById(R.id.action_bar_title);
            this.mSubtitleView = (TextView)this.mTitleLayout.findViewById(R.id.action_bar_subtitle);
            this.mTitleUpView = this.mTitleLayout.findViewById(R.id.up);
            this.mTitleLayout.setOnClickListener(this.mUpClickListener);
            if (this.mTitleStyleRes != 0) {
                this.mTitleView.setTextAppearance(this.mContext, this.mTitleStyleRes);
            }
            if (this.mTitle != null) {
                this.mTitleView.setText(this.mTitle);
            }
            if (this.mSubtitleStyleRes != 0) {
                this.mSubtitleView.setTextAppearance(this.mContext, this.mSubtitleStyleRes);
            }
            if (this.mSubtitle != null) {
                this.mSubtitleView.setText(this.mSubtitle);
                this.mSubtitleView.setVisibility(0);
            }
            boolean bl3 = (4 & this.mDisplayOptions) != 0 ? bl2 : false;
            boolean bl4 = (2 & this.mDisplayOptions) != 0 ? bl2 : false;
            View view = this.mTitleUpView;
            int n2 = !bl4 ? (bl3 ? 0 : 4) : 8;
            view.setVisibility(n2);
            LinearLayout linearLayout = this.mTitleLayout;
            if (!bl3 || bl4) {
                bl2 = false;
            }
            linearLayout.setEnabled(bl2);
        }
        this.addView((View)this.mTitleLayout);
        if (this.mExpandedActionView != null || TextUtils.isEmpty((CharSequence)this.mTitle) && TextUtils.isEmpty((CharSequence)this.mSubtitle)) {
            this.mTitleLayout.setVisibility(8);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setTitleImpl(CharSequence charSequence) {
        this.mTitle = charSequence;
        if (this.mTitleView != null) {
            this.mTitleView.setText(charSequence);
            boolean bl2 = this.mExpandedActionView == null && (8 & this.mDisplayOptions) != 0 && (!TextUtils.isEmpty((CharSequence)this.mTitle) || !TextUtils.isEmpty((CharSequence)this.mSubtitle));
            LinearLayout linearLayout = this.mTitleLayout;
            int n2 = 0;
            if (!bl2) {
                n2 = 8;
            }
            linearLayout.setVisibility(n2);
        }
        if (this.mLogoNavItem != null) {
            this.mLogoNavItem.setTitle(charSequence);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void collapseActionView() {
        if (this.mExpandedMenuPresenter == null) {
            return;
        }
        MenuItemImpl menuItemImpl = this.mExpandedMenuPresenter.mCurrentExpandedItem;
        if (menuItemImpl == null) return;
        menuItemImpl.collapseActionView();
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ActionBar.LayoutParams(19);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ActionBar.LayoutParams(this.getContext(), attributeSet);
    }

    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams == null) {
            layoutParams = this.generateDefaultLayoutParams();
        }
        return layoutParams;
    }

    public View getCustomNavigationView() {
        return this.mCustomNavView;
    }

    public int getDisplayOptions() {
        return this.mDisplayOptions;
    }

    public SpinnerAdapter getDropdownAdapter() {
        return this.mSpinnerAdapter;
    }

    public int getDropdownSelectedPosition() {
        return this.mSpinner.getSelectedItemPosition();
    }

    public int getNavigationMode() {
        return this.mNavigationMode;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public boolean hasEmbeddedTabs() {
        return this.mIncludeTabs;
    }

    public boolean hasExpandedActionView() {
        return this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null;
    }

    public void initIndeterminateProgress() {
        this.mIndeterminateProgressView = new ProgressBarICS(this.mContext, null, 0, this.mIndeterminateProgressStyle);
        this.mIndeterminateProgressView.setId(R.id.progress_circular);
        this.mIndeterminateProgressView.setVisibility(8);
        this.addView(this.mIndeterminateProgressView);
    }

    public void initProgress() {
        this.mProgressView = new ProgressBarICS(this.mContext, null, 0, this.mProgressStyle);
        this.mProgressView.setId(R.id.progress_horizontal);
        this.mProgressView.setMax(10000);
        this.mProgressView.setVisibility(8);
        this.addView(this.mProgressView);
    }

    public boolean isCollapsed() {
        return this.mIsCollapsed;
    }

    public boolean isSplitActionBar() {
        return this.mSplitActionBar;
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mTitleView = null;
        this.mSubtitleView = null;
        this.mTitleUpView = null;
        if (this.mTitleLayout != null && this.mTitleLayout.getParent() == this) {
            this.removeView((View)this.mTitleLayout);
        }
        this.mTitleLayout = null;
        if ((8 & this.mDisplayOptions) != 0) {
            this.initTitle();
        }
        if (this.mTabScrollView != null && this.mIncludeTabs) {
            ViewGroup.LayoutParams layoutParams = this.mTabScrollView.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = -2;
                layoutParams.height = -1;
            }
            this.mTabScrollView.setAllowCollapse(true);
        }
        if (this.mProgressView != null) {
            this.removeView(this.mProgressView);
            this.initProgress();
        }
        if (this.mIndeterminateProgressView != null) {
            this.removeView(this.mIndeterminateProgressView);
            this.initIndeterminateProgress();
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mTabSelector);
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.hideOverflowMenu();
            this.mActionMenuPresenter.hideSubMenus();
        }
    }

    protected void onFinishInflate() {
        ViewParent viewParent;
        super.onFinishInflate();
        this.addView((View)this.mHomeLayout);
        if (this.mCustomNavView != null && (0x10 & this.mDisplayOptions) != 0 && (viewParent = this.mCustomNavView.getParent()) != this) {
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.mCustomNavView);
            }
            this.addView(this.mCustomNavView);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        block40: {
            block36: {
                block37: {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    View view;
                    int n11;
                    int n12;
                    block39: {
                        block38: {
                            n12 = this.getPaddingLeft();
                            int n13 = this.getPaddingTop();
                            int n14 = n5 - n3 - this.getPaddingTop() - this.getPaddingBottom();
                            if (n14 <= 0) break block36;
                            HomeView homeView = this.mExpandedActionView != null ? this.mExpandedHomeLayout : this.mHomeLayout;
                            if (homeView.getVisibility() != 8) {
                                int n15 = homeView.getLeftOffset();
                                n12 += n15 + this.positionChild((View)homeView, n12 + n15, n13, n14);
                            }
                            if (this.mExpandedActionView == null) {
                                boolean bl3 = this.mTitleLayout != null && this.mTitleLayout.getVisibility() != 8 && (8 & this.mDisplayOptions) != 0;
                                if (bl3) {
                                    n12 += this.positionChild((View)this.mTitleLayout, n12, n13, n14);
                                }
                                switch (this.mNavigationMode) {
                                    case 1: {
                                        if (this.mListNavLayout == null) break;
                                        if (bl3) {
                                            n12 += this.mItemPadding;
                                        }
                                        n12 += this.positionChild((View)this.mListNavLayout, n12, n13, n14) + this.mItemPadding;
                                        break;
                                    }
                                    case 2: {
                                        if (this.mTabScrollView == null) break;
                                        if (bl3) {
                                            n12 += this.mItemPadding;
                                        }
                                        n12 += this.positionChild((View)this.mTabScrollView, n12, n13, n14) + this.mItemPadding;
                                        break;
                                    }
                                }
                            }
                            n11 = n4 - n2 - this.getPaddingRight();
                            if (this.mMenuView != null && this.mMenuView.getParent() == this) {
                                this.positionChildInverse((View)this.mMenuView, n11, n13, n14);
                                n11 -= this.mMenuView.getMeasuredWidth();
                            }
                            if (this.mIndeterminateProgressView != null && this.mIndeterminateProgressView.getVisibility() != 8) {
                                this.positionChildInverse(this.mIndeterminateProgressView, n11, n13, n14);
                                n11 -= this.mIndeterminateProgressView.getMeasuredWidth();
                            }
                            if (this.mExpandedActionView != null) {
                                view = this.mExpandedActionView;
                            } else {
                                int n16 = 0x10 & this.mDisplayOptions;
                                view = null;
                                if (n16 != 0) {
                                    View view2 = this.mCustomNavView;
                                    view = null;
                                    if (view2 != null) {
                                        view = this.mCustomNavView;
                                    }
                                }
                            }
                            if (view == null) break block37;
                            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                            ActionBar.LayoutParams layoutParams2 = layoutParams instanceof ActionBar.LayoutParams ? (ActionBar.LayoutParams)layoutParams : null;
                            n10 = layoutParams2 != null ? layoutParams2.gravity : 19;
                            n9 = view.getMeasuredWidth();
                            n8 = 0;
                            n7 = 0;
                            if (layoutParams2 != null) {
                                n12 += layoutParams2.leftMargin;
                                n11 -= layoutParams2.rightMargin;
                                n7 = layoutParams2.topMargin;
                                n8 = layoutParams2.bottomMargin;
                            }
                            if ((n6 = n10 & 7) != 1) break block38;
                            int n17 = (this.getWidth() - n9) / 2;
                            if (n17 < n12) {
                                n6 = 3;
                                break block39;
                            } else if (n17 + n9 > n11) {
                                n6 = 5;
                            }
                            break block39;
                        }
                        if (n10 == -1) {
                            n6 = 3;
                        }
                    }
                    int n18 = 0;
                    switch (n6) {
                        case 1: {
                            n18 = (this.getWidth() - n9) / 2;
                            break;
                        }
                        case 3: {
                            n18 = n12;
                            break;
                        }
                        case 5: {
                            n18 = n11 - n9;
                            break;
                        }
                    }
                    int n19 = n10 & 0x70;
                    if (n10 == -1) {
                        n19 = 16;
                    }
                    int n20 = 0;
                    switch (n19) {
                        case 16: {
                            int n21 = this.getPaddingTop();
                            n20 = (this.getHeight() - this.getPaddingBottom() - n21 - view.getMeasuredHeight()) / 2;
                            break;
                        }
                        case 48: {
                            n20 = n7 + this.getPaddingTop();
                            break;
                        }
                        case 80: {
                            n20 = this.getHeight() - this.getPaddingBottom() - view.getMeasuredHeight() - n8;
                            break;
                        }
                    }
                    int n22 = view.getMeasuredWidth();
                    int n23 = n18 + n22;
                    int n24 = n20 + view.getMeasuredHeight();
                    view.layout(n18, n20, n23, n24);
                    int cfr_ignored_0 = n12 + n22;
                }
                if (this.mProgressView != null) break block40;
            }
            return;
        }
        this.mProgressView.bringToFront();
        int n25 = this.mProgressView.getMeasuredHeight() / 2;
        this.mProgressView.layout(this.mProgressBarPadding, -n25, this.mProgressBarPadding + this.mProgressView.getMeasuredWidth(), n25);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    protected void onMeasure(int n2, int n3) {
        View view;
        int n4;
        int n5 = this.getChildCount();
        if (this.mIsCollapsable) {
            int n6 = 0;
            for (int i2 = 0; i2 < n5; ++i2) {
                View view2 = this.getChildAt(i2);
                if (view2.getVisibility() == 8 || view2 == this.mMenuView && this.mMenuView.getChildCount() == 0) continue;
                ++n6;
            }
            if (n6 == 0) {
                this.setMeasuredDimension(0, 0);
                this.mIsCollapsed = true;
                return;
            }
        }
        this.mIsCollapsed = false;
        if (View.MeasureSpec.getMode((int)n2) != 0x40000000) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " can only be used " + "with android:layout_width=\"MATCH_PARENT\" (or fill_parent)");
        }
        if (View.MeasureSpec.getMode((int)n3) != Integer.MIN_VALUE) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " can only be used " + "with android:layout_height=\"wrap_content\"");
        }
        int n7 = View.MeasureSpec.getSize((int)n2);
        int n8 = this.mContentHeight > 0 ? this.mContentHeight : View.MeasureSpec.getSize((int)n3);
        int n9 = this.getPaddingTop() + this.getPaddingBottom();
        int n10 = this.getPaddingLeft();
        int n11 = this.getPaddingRight();
        int n12 = n8 - n9;
        int n13 = View.MeasureSpec.makeMeasureSpec((int)n12, (int)Integer.MIN_VALUE);
        int n14 = n7 - n10 - n11;
        int n15 = n4 = n14 / 2;
        HomeView homeView = this.mExpandedActionView != null ? this.mExpandedHomeLayout : this.mHomeLayout;
        if (homeView.getVisibility() != 8) {
            ViewGroup.LayoutParams layoutParams = homeView.getLayoutParams();
            int n16 = layoutParams.width < 0 ? View.MeasureSpec.makeMeasureSpec((int)n14, (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)layoutParams.width, (int)0x40000000);
            int n17 = View.MeasureSpec.makeMeasureSpec((int)n12, (int)0x40000000);
            homeView.measure(n16, n17);
            int n18 = homeView.getMeasuredWidth() + homeView.getLeftOffset();
            n14 = Math.max(0, n14 - n18);
            n4 = Math.max(0, n14 - n18);
        }
        if (this.mMenuView != null && this.mMenuView.getParent() == this) {
            n14 = this.measureChildView((View)this.mMenuView, n14, n13, 0);
            n15 = Math.max(0, n15 - this.mMenuView.getMeasuredWidth());
        }
        if (this.mIndeterminateProgressView != null && this.mIndeterminateProgressView.getVisibility() != 8) {
            n14 = this.measureChildView(this.mIndeterminateProgressView, n14, n13, 0);
            n15 = Math.max(0, n15 - this.mIndeterminateProgressView.getMeasuredWidth());
        }
        boolean bl2 = this.mTitleLayout != null && this.mTitleLayout.getVisibility() != 8 && (8 & this.mDisplayOptions) != 0;
        if (this.mExpandedActionView == null) {
            switch (this.mNavigationMode) {
                case 1: {
                    if (this.mListNavLayout == null) break;
                    int n19 = bl2 ? 2 * this.mItemPadding : this.mItemPadding;
                    int n20 = Math.max(0, n14 - n19);
                    int n21 = Math.max(0, n4 - n19);
                    this.mListNavLayout.measure(View.MeasureSpec.makeMeasureSpec((int)n20, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)n12, (int)0x40000000));
                    int n22 = this.mListNavLayout.getMeasuredWidth();
                    n14 = Math.max(0, n20 - n22);
                    n4 = Math.max(0, n21 - n22);
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null) break;
                    int n23 = bl2 ? 2 * this.mItemPadding : this.mItemPadding;
                    int n24 = Math.max(0, n14 - n23);
                    int n25 = Math.max(0, n4 - n23);
                    this.mTabScrollView.measure(View.MeasureSpec.makeMeasureSpec((int)n24, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)n12, (int)0x40000000));
                    int n26 = this.mTabScrollView.getMeasuredWidth();
                    n14 = Math.max(0, n24 - n26);
                    n4 = Math.max(0, n25 - n26);
                }
            }
        }
        if (this.mExpandedActionView != null) {
            view = this.mExpandedActionView;
        } else {
            int n27 = 0x10 & this.mDisplayOptions;
            view = null;
            if (n27 != 0) {
                View view3 = this.mCustomNavView;
                view = null;
                if (view3 != null) {
                    view = this.mCustomNavView;
                }
            }
        }
        if (view != null) {
            ViewGroup.LayoutParams layoutParams = this.generateLayoutParams(view.getLayoutParams());
            ActionBar.LayoutParams layoutParams2 = layoutParams instanceof ActionBar.LayoutParams ? (ActionBar.LayoutParams)layoutParams : null;
            int n28 = 0;
            int n29 = 0;
            if (layoutParams2 != null) {
                n28 = layoutParams2.leftMargin + layoutParams2.rightMargin;
                n29 = layoutParams2.topMargin + layoutParams2.bottomMargin;
            }
            int n30 = this.mContentHeight <= 0 ? Integer.MIN_VALUE : (layoutParams.height != -2 ? 0x40000000 : Integer.MIN_VALUE);
            if (layoutParams.height >= 0) {
                n12 = Math.min(layoutParams.height, n12);
            }
            int n31 = Math.max(0, n12 - n29);
            int n32 = layoutParams.width != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int n33 = layoutParams.width >= 0 ? Math.min(layoutParams.width, n14) : n14;
            int n34 = Math.max(0, n33 - n28);
            int n35 = layoutParams2 != null ? layoutParams2.gravity : 19;
            if ((n35 & 7) == 1 && layoutParams.width == -1) {
                n34 = 2 * Math.min(n4, n15);
            }
            view.measure(View.MeasureSpec.makeMeasureSpec((int)n34, (int)n32), View.MeasureSpec.makeMeasureSpec((int)n31, (int)n30));
            n14 -= n28 + view.getMeasuredWidth();
        }
        if (this.mExpandedActionView == null && bl2) {
            this.measureChildView((View)this.mTitleLayout, n14, View.MeasureSpec.makeMeasureSpec((int)this.mContentHeight, (int)0x40000000), 0);
            Math.max(0, n4 - this.mTitleLayout.getMeasuredWidth());
        }
        if (this.mContentHeight <= 0) {
            int n36 = 0;
            for (int i3 = 0; i3 < n5; ++i3) {
                int n37 = n9 + this.getChildAt(i3).getMeasuredHeight();
                if (n37 <= n36) continue;
                n36 = n37;
            }
            this.setMeasuredDimension(n7, n36);
        } else {
            this.setMeasuredDimension(n7, n8);
        }
        if (this.mContextView != null) {
            this.mContextView.setContentHeight(this.getMeasuredHeight());
        }
        if (this.mProgressView == null) return;
        if (this.mProgressView.getVisibility() == 8) return;
        this.mProgressView.measure(View.MeasureSpec.makeMeasureSpec((int)(n7 - 2 * this.mProgressBarPadding), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)Integer.MIN_VALUE));
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        SupportMenuItem supportMenuItem;
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.expandedMenuItemId != 0 && this.mExpandedMenuPresenter != null && this.mOptionsMenu != null && (supportMenuItem = (SupportMenuItem)this.mOptionsMenu.findItem(savedState.expandedMenuItemId)) != null) {
            supportMenuItem.expandActionView();
        }
        if (savedState.isOverflowOpen) {
            this.postShowOverflowMenu();
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        if (this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null) {
            savedState.expandedMenuItemId = this.mExpandedMenuPresenter.mCurrentExpandedItem.getItemId();
        }
        savedState.isOverflowOpen = this.isOverflowMenuShowing();
        return savedState;
    }

    public void setCallback(ActionBar.OnNavigationListener onNavigationListener) {
        this.mCallback = onNavigationListener;
    }

    public void setCollapsable(boolean bl2) {
        this.mIsCollapsable = bl2;
    }

    public void setContextView(ActionBarContextView actionBarContextView) {
        this.mContextView = actionBarContextView;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCustomNavigationView(View view) {
        boolean bl2 = (0x10 & this.mDisplayOptions) != 0;
        if (this.mCustomNavView != null && bl2) {
            this.removeView(this.mCustomNavView);
        }
        this.mCustomNavView = view;
        if (this.mCustomNavView != null && bl2) {
            this.addView(this.mCustomNavView);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDisplayOptions(int n2) {
        int n3 = 8;
        int n4 = -1;
        boolean bl2 = true;
        if (this.mDisplayOptions != n4) {
            n4 = n2 ^ this.mDisplayOptions;
        }
        this.mDisplayOptions = n2;
        if ((n4 & 0x1F) != 0) {
            boolean bl3 = (n2 & 2) != 0 ? bl2 : false;
            int n5 = bl3 && this.mExpandedActionView == null ? 0 : n3;
            this.mHomeLayout.setVisibility(n5);
            if ((n4 & 4) != 0) {
                boolean bl4 = (n2 & 4) != 0 ? bl2 : false;
                this.mHomeLayout.setUp(bl4);
                if (bl4) {
                    this.setHomeButtonEnabled(bl2);
                }
            }
            if ((n4 & 1) != 0) {
                boolean bl5 = this.mLogo != null && (n2 & 1) != 0 ? bl2 : false;
                HomeView homeView = this.mHomeLayout;
                Drawable drawable2 = bl5 ? this.mLogo : this.mIcon;
                homeView.setIcon(drawable2);
            }
            if ((n4 & 8) != 0) {
                if ((n2 & 8) != 0) {
                    this.initTitle();
                } else {
                    this.removeView((View)this.mTitleLayout);
                }
            }
            if (this.mTitleLayout != null && (n4 & 6) != 0) {
                boolean bl6 = (4 & this.mDisplayOptions) != 0 ? bl2 : false;
                View view = this.mTitleUpView;
                if (!bl3) {
                    n3 = bl6 ? 0 : 4;
                }
                view.setVisibility(n3);
                LinearLayout linearLayout = this.mTitleLayout;
                if (bl3 || !bl6) {
                    bl2 = false;
                }
                linearLayout.setEnabled(bl2);
            }
            if ((n4 & 0x10) != 0 && this.mCustomNavView != null) {
                if ((n2 & 0x10) != 0) {
                    this.addView(this.mCustomNavView);
                } else {
                    this.removeView(this.mCustomNavView);
                }
            }
            this.requestLayout();
        } else {
            this.invalidate();
        }
        if (!this.mHomeLayout.isEnabled()) {
            this.mHomeLayout.setContentDescription(null);
            return;
        }
        if ((n2 & 4) != 0) {
            this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(R.string.abc_action_bar_up_description));
            return;
        }
        this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(R.string.abc_action_bar_home_description));
    }

    public void setDropdownAdapter(SpinnerAdapter spinnerAdapter) {
        this.mSpinnerAdapter = spinnerAdapter;
        if (this.mSpinner != null) {
            this.mSpinner.setAdapter(spinnerAdapter);
        }
    }

    public void setDropdownSelectedPosition(int n2) {
        this.mSpinner.setSelection(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setEmbeddedTabView(ScrollingTabContainerView scrollingTabContainerView) {
        if (this.mTabScrollView != null) {
            this.removeView((View)this.mTabScrollView);
        }
        this.mTabScrollView = scrollingTabContainerView;
        boolean bl2 = scrollingTabContainerView != null;
        this.mIncludeTabs = bl2;
        if (this.mIncludeTabs && this.mNavigationMode == 2) {
            this.addView((View)this.mTabScrollView);
            ViewGroup.LayoutParams layoutParams = this.mTabScrollView.getLayoutParams();
            layoutParams.width = -2;
            layoutParams.height = -1;
            scrollingTabContainerView.setAllowCollapse(true);
        }
    }

    public void setHomeAsUpIndicator(int n2) {
        this.mHomeLayout.setUpIndicator(n2);
    }

    public void setHomeAsUpIndicator(Drawable drawable2) {
        this.mHomeLayout.setUpIndicator(drawable2);
    }

    public void setHomeButtonEnabled(boolean bl2) {
        this.mHomeLayout.setEnabled(bl2);
        this.mHomeLayout.setFocusable(bl2);
        if (!bl2) {
            this.mHomeLayout.setContentDescription(null);
            return;
        }
        if ((4 & this.mDisplayOptions) != 0) {
            this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(R.string.abc_action_bar_up_description));
            return;
        }
        this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(R.string.abc_action_bar_home_description));
    }

    public void setIcon(int n2) {
        this.setIcon(this.mContext.getResources().getDrawable(n2));
    }

    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (drawable2 != null && ((1 & this.mDisplayOptions) == 0 || this.mLogo == null)) {
            this.mHomeLayout.setIcon(drawable2);
        }
        if (this.mExpandedActionView != null) {
            this.mExpandedHomeLayout.setIcon(this.mIcon.getConstantState().newDrawable(this.getResources()));
        }
    }

    public void setLogo(int n2) {
        this.setLogo(this.mContext.getResources().getDrawable(n2));
    }

    public void setLogo(Drawable drawable2) {
        this.mLogo = drawable2;
        if (drawable2 != null && (1 & this.mDisplayOptions) != 0) {
            this.mHomeLayout.setIcon(drawable2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMenu(SupportMenu supportMenu, MenuPresenter.Callback callback) {
        ActionMenuView actionMenuView;
        ViewGroup viewGroup;
        MenuBuilder menuBuilder;
        if (supportMenu == this.mOptionsMenu) {
            return;
        }
        if (this.mOptionsMenu != null) {
            this.mOptionsMenu.removeMenuPresenter(this.mActionMenuPresenter);
            this.mOptionsMenu.removeMenuPresenter(this.mExpandedMenuPresenter);
        }
        this.mOptionsMenu = menuBuilder = (MenuBuilder)supportMenu;
        if (this.mMenuView != null && (viewGroup = (ViewGroup)this.mMenuView.getParent()) != null) {
            viewGroup.removeView((View)this.mMenuView);
        }
        if (this.mActionMenuPresenter == null) {
            this.mActionMenuPresenter = new ActionMenuPresenter(this.mContext);
            this.mActionMenuPresenter.setCallback(callback);
            this.mActionMenuPresenter.setId(R.id.action_menu_presenter);
            this.mExpandedMenuPresenter = new ExpandedActionViewMenuPresenter();
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        if (!this.mSplitActionBar) {
            this.mActionMenuPresenter.setExpandedActionViewsExclusive(this.getResources().getBoolean(R.bool.abc_action_bar_expanded_action_views_exclusive));
            this.configPresenters(menuBuilder);
            actionMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            actionMenuView.initialize(menuBuilder);
            ViewGroup viewGroup2 = (ViewGroup)actionMenuView.getParent();
            if (viewGroup2 != null && viewGroup2 != this) {
                viewGroup2.removeView((View)actionMenuView);
            }
            this.addView((View)actionMenuView, layoutParams);
        } else {
            this.mActionMenuPresenter.setExpandedActionViewsExclusive(false);
            this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
            this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
            layoutParams.width = -1;
            this.configPresenters(menuBuilder);
            actionMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            if (this.mSplitView != null) {
                ViewGroup viewGroup3 = (ViewGroup)actionMenuView.getParent();
                if (viewGroup3 != null && viewGroup3 != this.mSplitView) {
                    viewGroup3.removeView((View)actionMenuView);
                }
                actionMenuView.setVisibility(this.getAnimatedVisibility());
                this.mSplitView.addView((View)actionMenuView, layoutParams);
            } else {
                actionMenuView.setLayoutParams(layoutParams);
            }
        }
        this.mMenuView = actionMenuView;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setNavigationMode(int n2) {
        int n3 = this.mNavigationMode;
        if (n2 != n3) {
            switch (n3) {
                case 1: {
                    if (this.mListNavLayout != null) {
                        this.removeView((View)this.mListNavLayout);
                    }
                }
                default: {
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null || !this.mIncludeTabs) break;
                    this.removeView((View)this.mTabScrollView);
                }
            }
            switch (n2) {
                case 1: {
                    if (this.mSpinner == null) {
                        this.mSpinner = new SpinnerICS(this.mContext, null, R.attr.actionDropDownStyle);
                        this.mListNavLayout = (LinearLayout)LayoutInflater.from((Context)this.mContext).inflate(R.layout.abc_action_bar_view_list_nav_layout, null);
                        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -1);
                        layoutParams.gravity = 17;
                        this.mListNavLayout.addView((View)this.mSpinner, (ViewGroup.LayoutParams)layoutParams);
                    }
                    if (this.mSpinner.getAdapter() != this.mSpinnerAdapter) {
                        this.mSpinner.setAdapter(this.mSpinnerAdapter);
                    }
                    this.mSpinner.setOnItemSelectedListener(this.mNavItemSelectedListener);
                    this.addView((View)this.mListNavLayout);
                }
                default: {
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null || !this.mIncludeTabs) break;
                    this.addView((View)this.mTabScrollView);
                }
            }
            this.mNavigationMode = n2;
            this.requestLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSplitActionBar(boolean bl2) {
        if (this.mSplitActionBar != bl2) {
            if (this.mMenuView != null) {
                ViewGroup viewGroup = (ViewGroup)this.mMenuView.getParent();
                if (viewGroup != null) {
                    viewGroup.removeView((View)this.mMenuView);
                }
                if (bl2) {
                    if (this.mSplitView != null) {
                        this.mSplitView.addView((View)this.mMenuView);
                    }
                    this.mMenuView.getLayoutParams().width = -1;
                } else {
                    this.addView((View)this.mMenuView);
                    this.mMenuView.getLayoutParams().width = -2;
                }
                this.mMenuView.requestLayout();
            }
            if (this.mSplitView != null) {
                ActionBarContainer actionBarContainer = this.mSplitView;
                int n2 = bl2 ? 0 : 8;
                actionBarContainer.setVisibility(n2);
            }
            if (this.mActionMenuPresenter != null) {
                if (!bl2) {
                    this.mActionMenuPresenter.setExpandedActionViewsExclusive(this.getResources().getBoolean(R.bool.abc_action_bar_expanded_action_views_exclusive));
                } else {
                    this.mActionMenuPresenter.setExpandedActionViewsExclusive(false);
                    this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
                    this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
                }
            }
            super.setSplitActionBar(bl2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSubtitle(CharSequence charSequence) {
        this.mSubtitle = charSequence;
        if (this.mSubtitleView != null) {
            this.mSubtitleView.setText(charSequence);
            TextView textView = this.mSubtitleView;
            int n2 = charSequence != null ? 0 : 8;
            textView.setVisibility(n2);
            boolean bl2 = this.mExpandedActionView == null && (8 & this.mDisplayOptions) != 0 && (!TextUtils.isEmpty((CharSequence)this.mTitle) || !TextUtils.isEmpty((CharSequence)this.mSubtitle));
            LinearLayout linearLayout = this.mTitleLayout;
            int n3 = 0;
            if (!bl2) {
                n3 = 8;
            }
            linearLayout.setVisibility(n3);
        }
    }

    public void setTitle(CharSequence charSequence) {
        this.mUserTitle = true;
        this.setTitleImpl(charSequence);
    }

    public void setWindowCallback(Window.Callback callback) {
        this.mWindowCallback = callback;
    }

    public void setWindowTitle(CharSequence charSequence) {
        if (!this.mUserTitle) {
            this.setTitleImpl(charSequence);
        }
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    private class ExpandedActionViewMenuPresenter
    implements MenuPresenter {
        MenuItemImpl mCurrentExpandedItem;
        MenuBuilder mMenu;

        private ExpandedActionViewMenuPresenter() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean collapseItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
            if (ActionBarView.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)ActionBarView.this.mExpandedActionView).onActionViewCollapsed();
            }
            ActionBarView.this.removeView(ActionBarView.this.mExpandedActionView);
            ActionBarView.this.removeView((View)ActionBarView.this.mExpandedHomeLayout);
            ActionBarView.this.mExpandedActionView = null;
            if ((2 & ActionBarView.this.mDisplayOptions) != 0) {
                ActionBarView.this.mHomeLayout.setVisibility(0);
            }
            if ((8 & ActionBarView.this.mDisplayOptions) != 0) {
                if (ActionBarView.this.mTitleLayout == null) {
                    ActionBarView.this.initTitle();
                } else {
                    ActionBarView.this.mTitleLayout.setVisibility(0);
                }
            }
            if (ActionBarView.this.mTabScrollView != null && ActionBarView.this.mNavigationMode == 2) {
                ActionBarView.this.mTabScrollView.setVisibility(0);
            }
            if (ActionBarView.this.mSpinner != null && ActionBarView.this.mNavigationMode == 1) {
                ActionBarView.this.mSpinner.setVisibility(0);
            }
            if (ActionBarView.this.mCustomNavView != null && (0x10 & ActionBarView.this.mDisplayOptions) != 0) {
                ActionBarView.this.mCustomNavView.setVisibility(0);
            }
            ActionBarView.this.mExpandedHomeLayout.setIcon(null);
            this.mCurrentExpandedItem = null;
            ActionBarView.this.requestLayout();
            menuItemImpl.setActionViewExpanded(false);
            return true;
        }

        @Override
        public boolean expandItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
            ActionBarView.this.mExpandedActionView = menuItemImpl.getActionView();
            ActionBarView.this.mExpandedHomeLayout.setIcon(ActionBarView.this.mIcon.getConstantState().newDrawable(ActionBarView.this.getResources()));
            this.mCurrentExpandedItem = menuItemImpl;
            if (ActionBarView.this.mExpandedActionView.getParent() != ActionBarView.this) {
                ActionBarView.this.addView(ActionBarView.this.mExpandedActionView);
            }
            if (ActionBarView.this.mExpandedHomeLayout.getParent() != ActionBarView.this) {
                ActionBarView.this.addView((View)ActionBarView.this.mExpandedHomeLayout);
            }
            ActionBarView.this.mHomeLayout.setVisibility(8);
            if (ActionBarView.this.mTitleLayout != null) {
                ActionBarView.this.mTitleLayout.setVisibility(8);
            }
            if (ActionBarView.this.mTabScrollView != null) {
                ActionBarView.this.mTabScrollView.setVisibility(8);
            }
            if (ActionBarView.this.mSpinner != null) {
                ActionBarView.this.mSpinner.setVisibility(8);
            }
            if (ActionBarView.this.mCustomNavView != null) {
                ActionBarView.this.mCustomNavView.setVisibility(8);
            }
            ActionBarView.this.requestLayout();
            menuItemImpl.setActionViewExpanded(true);
            if (ActionBarView.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)ActionBarView.this.mExpandedActionView).onActionViewExpanded();
            }
            return true;
        }

        @Override
        public boolean flagActionItems() {
            return false;
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public MenuView getMenuView(ViewGroup viewGroup) {
            return null;
        }

        @Override
        public void initForMenu(Context context, MenuBuilder menuBuilder) {
            if (this.mMenu != null && this.mCurrentExpandedItem != null) {
                this.mMenu.collapseItemActionView(this.mCurrentExpandedItem);
            }
            this.mMenu = menuBuilder;
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl2) {
        }

        @Override
        public void onRestoreInstanceState(Parcelable parcelable) {
        }

        @Override
        public Parcelable onSaveInstanceState() {
            return null;
        }

        @Override
        public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
            return false;
        }

        @Override
        public void setCallback(MenuPresenter.Callback callback) {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void updateMenuView(boolean bl2) {
            if (this.mCurrentExpandedItem == null) return;
            MenuBuilder menuBuilder = this.mMenu;
            boolean bl3 = false;
            if (menuBuilder != null) {
                int n2 = this.mMenu.size();
                int n3 = 0;
                while (true) {
                    bl3 = false;
                    if (n3 >= n2) break;
                    if ((SupportMenuItem)this.mMenu.getItem(n3) == this.mCurrentExpandedItem) {
                        return;
                    }
                    ++n3;
                }
            }
            if (bl3) return;
            this.collapseItemActionView(this.mMenu, this.mCurrentExpandedItem);
        }
    }

    private static class HomeView
    extends FrameLayout {
        private Drawable mDefaultUpIndicator;
        private ImageView mIconView;
        private int mUpIndicatorRes;
        private ImageView mUpView;
        private int mUpWidth;

        public HomeView(Context context) {
            this(context, null);
        }

        public HomeView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            CharSequence charSequence = this.getContentDescription();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                accessibilityEvent.getText().add(charSequence);
            }
            return true;
        }

        public int getLeftOffset() {
            if (this.mUpView.getVisibility() == 8) {
                return this.mUpWidth;
            }
            return 0;
        }

        protected void onConfigurationChanged(Configuration configuration) {
            super.onConfigurationChanged(configuration);
            if (this.mUpIndicatorRes != 0) {
                this.setUpIndicator(this.mUpIndicatorRes);
            }
        }

        protected void onFinishInflate() {
            this.mUpView = (ImageView)this.findViewById(R.id.up);
            this.mIconView = (ImageView)this.findViewById(R.id.home);
            this.mDefaultUpIndicator = this.mUpView.getDrawable();
        }

        protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
            int n6 = (n5 - n3) / 2;
            int n7 = n4 - n2;
            int n8 = this.mUpView.getVisibility();
            int n9 = 0;
            if (n8 != 8) {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mUpView.getLayoutParams();
                int n10 = this.mUpView.getMeasuredHeight();
                int n11 = this.mUpView.getMeasuredWidth();
                int n12 = n6 - n10 / 2;
                this.mUpView.layout(0, n12, n11, n12 + n10);
                n9 = n11 + layoutParams.leftMargin + layoutParams.rightMargin;
                int cfr_ignored_0 = n7 - n9;
                n2 += n9;
            }
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mIconView.getLayoutParams();
            int n13 = this.mIconView.getMeasuredHeight();
            int n14 = this.mIconView.getMeasuredWidth();
            int n15 = (n4 - n2) / 2;
            int n16 = n9 + Math.max(layoutParams.leftMargin, n15 - n14 / 2);
            int n17 = Math.max(layoutParams.topMargin, n6 - n13 / 2);
            this.mIconView.layout(n16, n17, n16 + n14, n17 + n13);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void onMeasure(int n2, int n3) {
            this.measureChildWithMargins((View)this.mUpView, n2, 0, n3, 0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mUpView.getLayoutParams();
            this.mUpWidth = layoutParams.leftMargin + this.mUpView.getMeasuredWidth() + layoutParams.rightMargin;
            int n4 = this.mUpView.getVisibility() == 8 ? 0 : this.mUpWidth;
            int n5 = layoutParams.topMargin + this.mUpView.getMeasuredHeight() + layoutParams.bottomMargin;
            this.measureChildWithMargins((View)this.mIconView, n2, n4, n3, 0);
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)this.mIconView.getLayoutParams();
            int n6 = n4 + (layoutParams2.leftMargin + this.mIconView.getMeasuredWidth() + layoutParams2.rightMargin);
            int n7 = Math.max(n5, layoutParams2.topMargin + this.mIconView.getMeasuredHeight() + layoutParams2.bottomMargin);
            int n8 = View.MeasureSpec.getMode((int)n2);
            int n9 = View.MeasureSpec.getMode((int)n3);
            int n10 = View.MeasureSpec.getSize((int)n2);
            int n11 = View.MeasureSpec.getSize((int)n3);
            switch (n8) {
                case -2147483648: {
                    n6 = Math.min(n6, n10);
                }
                default: {
                    break;
                }
                case 0x40000000: {
                    n6 = n10;
                }
            }
            switch (n9) {
                case -2147483648: {
                    n7 = Math.min(n7, n11);
                }
                default: {
                    break;
                }
                case 0x40000000: {
                    n7 = n11;
                }
            }
            this.setMeasuredDimension(n6, n7);
        }

        public void setIcon(Drawable drawable2) {
            this.mIconView.setImageDrawable(drawable2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setUp(boolean bl2) {
            ImageView imageView = this.mUpView;
            int n2 = bl2 ? 0 : 8;
            imageView.setVisibility(n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setUpIndicator(int n2) {
            this.mUpIndicatorRes = n2;
            ImageView imageView = this.mUpView;
            Drawable drawable2 = n2 != 0 ? this.getResources().getDrawable(n2) : null;
            imageView.setImageDrawable(drawable2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setUpIndicator(Drawable drawable2) {
            ImageView imageView = this.mUpView;
            if (drawable2 == null) {
                drawable2 = this.mDefaultUpIndicator;
            }
            imageView.setImageDrawable(drawable2);
            this.mUpIndicatorRes = 0;
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        int expandedMenuItemId;
        boolean isOverflowOpen;

        /*
         * Enabled aggressive block sorting
         */
        private SavedState(Parcel parcel) {
            super(parcel);
            this.expandedMenuItemId = parcel.readInt();
            boolean bl2 = parcel.readInt() != 0;
            this.isOverflowOpen = bl2;
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeInt(this.expandedMenuItemId);
            int n3 = this.isOverflowOpen ? 1 : 0;
            parcel.writeInt(n3);
        }
    }
}

