/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.support.v7.app.ActionBar;
import android.support.v7.appcompat.R;
import android.support.v7.internal.widget.ActionBarContainer;
import android.support.v7.internal.widget.ActionBarView;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

public class ActionBarOverlayLayout
extends FrameLayout {
    static final int[] mActionBarSizeAttr;
    private ActionBar mActionBar;
    private View mActionBarBottom;
    private int mActionBarHeight;
    private View mActionBarTop;
    private ActionBarView mActionView;
    private ActionBarContainer mContainerView;
    private View mContent;
    private final Rect mZeroRect = new Rect(0, 0, 0, 0);

    static {
        int[] nArray = new int[]{R.attr.actionBarSize};
        mActionBarSizeAttr = nArray;
    }

    public ActionBarOverlayLayout(Context context) {
        super(context);
        this.init(context);
    }

    public ActionBarOverlayLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    private boolean applyInsets(View view, Rect rect, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        boolean bl6 = false;
        if (bl2) {
            int n2 = layoutParams.leftMargin;
            int n3 = rect.left;
            bl6 = false;
            if (n2 != n3) {
                bl6 = true;
                layoutParams.leftMargin = rect.left;
            }
        }
        if (bl3 && layoutParams.topMargin != rect.top) {
            bl6 = true;
            layoutParams.topMargin = rect.top;
        }
        if (bl5 && layoutParams.rightMargin != rect.right) {
            bl6 = true;
            layoutParams.rightMargin = rect.right;
        }
        if (bl4 && layoutParams.bottomMargin != rect.bottom) {
            bl6 = true;
            layoutParams.bottomMargin = rect.bottom;
        }
        return bl6;
    }

    private void init(Context context) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(mActionBarSizeAttr);
        this.mActionBarHeight = typedArray.getDimensionPixelSize(0, 0);
        typedArray.recycle();
    }

    void pullChildren() {
        if (this.mContent == null) {
            this.mContent = this.findViewById(R.id.action_bar_activity_content);
            if (this.mContent == null) {
                this.mContent = this.findViewById(0x1020002);
            }
            this.mActionBarTop = this.findViewById(R.id.top_action_bar);
            this.mContainerView = (ActionBarContainer)this.findViewById(R.id.action_bar_container);
            this.mActionView = (ActionBarView)this.findViewById(R.id.action_bar);
            this.mActionBarBottom = this.findViewById(R.id.split_action_bar);
        }
    }

    public void setActionBar(ActionBar actionBar) {
        this.mActionBar = actionBar;
    }
}

