/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.menu.ActionMenuPresenter;
import android.support.v7.internal.view.menu.ActionMenuView;
import android.support.v7.internal.view.menu.MenuBuilder;
import android.support.v7.internal.widget.AbsActionBarView;
import android.support.v7.view.ActionMode;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

public class ActionBarContextView
extends AbsActionBarView {
    private static final String TAG = "ActionBarContextView";
    private View mClose;
    private View mCustomView;
    private Drawable mSplitBackground;
    private CharSequence mSubtitle;
    private int mSubtitleStyleRes;
    private TextView mSubtitleView;
    private CharSequence mTitle;
    private LinearLayout mTitleLayout;
    private boolean mTitleOptional;
    private int mTitleStyleRes;
    private TextView mTitleView;

    public ActionBarContextView(Context context) {
        this(context, null);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.actionModeStyle);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ActionMode, n2, 0);
        this.setBackgroundDrawable(typedArray.getDrawable(3));
        this.mTitleStyleRes = typedArray.getResourceId(1, 0);
        this.mSubtitleStyleRes = typedArray.getResourceId(2, 0);
        this.mContentHeight = typedArray.getLayoutDimension(0, 0);
        this.mSplitBackground = typedArray.getDrawable(4);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initTitle() {
        int n2 = 8;
        if (this.mTitleLayout == null) {
            LayoutInflater.from((Context)this.getContext()).inflate(R.layout.abc_action_bar_title_item, (ViewGroup)this);
            this.mTitleLayout = (LinearLayout)this.getChildAt(-1 + this.getChildCount());
            this.mTitleView = (TextView)this.mTitleLayout.findViewById(R.id.action_bar_title);
            this.mSubtitleView = (TextView)this.mTitleLayout.findViewById(R.id.action_bar_subtitle);
            if (this.mTitleStyleRes != 0) {
                this.mTitleView.setTextAppearance(this.getContext(), this.mTitleStyleRes);
            }
            if (this.mSubtitleStyleRes != 0) {
                this.mSubtitleView.setTextAppearance(this.getContext(), this.mSubtitleStyleRes);
            }
        }
        this.mTitleView.setText(this.mTitle);
        this.mSubtitleView.setText(this.mSubtitle);
        boolean bl2 = !TextUtils.isEmpty((CharSequence)this.mTitle);
        boolean bl3 = !TextUtils.isEmpty((CharSequence)this.mSubtitle);
        TextView textView = this.mSubtitleView;
        int n3 = bl3 ? 0 : n2;
        textView.setVisibility(n3);
        LinearLayout linearLayout = this.mTitleLayout;
        if (bl2 || bl3) {
            n2 = 0;
        }
        linearLayout.setVisibility(n2);
        if (this.mTitleLayout.getParent() == null) {
            this.addView((View)this.mTitleLayout);
        }
    }

    public void closeMode() {
        if (this.mClose == null) {
            this.killMode();
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -2);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Override
    public boolean hideOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.hideOverflowMenu();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initForMode(final ActionMode actionMode) {
        if (this.mClose == null) {
            this.mClose = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.abc_action_mode_close_item, (ViewGroup)this, false);
            this.addView(this.mClose);
        } else if (this.mClose.getParent() == null) {
            this.addView(this.mClose);
        }
        this.mClose.findViewById(R.id.action_mode_close_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                actionMode.finish();
            }
        });
        MenuBuilder menuBuilder = (MenuBuilder)actionMode.getMenu();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.dismissPopupMenus();
        }
        this.mActionMenuPresenter = new ActionMenuPresenter(this.getContext());
        this.mActionMenuPresenter.setReserveOverflow(true);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        if (!this.mSplitActionBar) {
            menuBuilder.addMenuPresenter(this.mActionMenuPresenter);
            this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            this.mMenuView.setBackgroundDrawable(null);
            this.addView((View)this.mMenuView, layoutParams);
            return;
        }
        this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
        this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
        layoutParams.width = -1;
        layoutParams.height = this.mContentHeight;
        menuBuilder.addMenuPresenter(this.mActionMenuPresenter);
        this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
        this.mMenuView.setBackgroundDrawable(this.mSplitBackground);
        this.mSplitView.addView((View)this.mMenuView, layoutParams);
    }

    @Override
    public boolean isOverflowMenuShowing() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.isOverflowMenuShowing();
        }
        return false;
    }

    public boolean isTitleOptional() {
        return this.mTitleOptional;
    }

    public void killMode() {
        this.removeAllViews();
        if (this.mSplitView != null) {
            this.mSplitView.removeView((View)this.mMenuView);
        }
        this.mCustomView = null;
        this.mMenuView = null;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.hideOverflowMenu();
            this.mActionMenuPresenter.hideSubMenus();
        }
    }

    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        int n6 = this.getPaddingLeft();
        int n7 = this.getPaddingTop();
        int n8 = n5 - n3 - this.getPaddingTop() - this.getPaddingBottom();
        if (this.mClose != null && this.mClose.getVisibility() != 8) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
            int n9 = n6 + marginLayoutParams.leftMargin;
            n6 = n9 + this.positionChild(this.mClose, n9, n7, n8) + marginLayoutParams.rightMargin;
        }
        if (this.mTitleLayout != null && this.mCustomView == null && this.mTitleLayout.getVisibility() != 8) {
            n6 += this.positionChild((View)this.mTitleLayout, n6, n7, n8);
        }
        if (this.mCustomView != null) {
            int cfr_ignored_0 = n6 + this.positionChild(this.mCustomView, n6, n7, n8);
        }
        int n10 = n4 - n2 - this.getPaddingRight();
        if (this.mMenuView != null) {
            int cfr_ignored_1 = n10 - this.positionChildInverse((View)this.mMenuView, n10, n7, n8);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        if (View.MeasureSpec.getMode((int)n2) != 0x40000000) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " can only be used " + "with android:layout_width=\"FILL_PARENT\" (or fill_parent)");
        }
        if (View.MeasureSpec.getMode((int)n3) == 0) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " can only be used " + "with android:layout_height=\"wrap_content\"");
        }
        int n4 = View.MeasureSpec.getSize((int)n2);
        int n5 = this.mContentHeight > 0 ? this.mContentHeight : View.MeasureSpec.getSize((int)n3);
        int n6 = this.getPaddingTop() + this.getPaddingBottom();
        int n7 = n4 - this.getPaddingLeft() - this.getPaddingRight();
        int n8 = n5 - n6;
        int n9 = View.MeasureSpec.makeMeasureSpec((int)n8, (int)Integer.MIN_VALUE);
        if (this.mClose != null) {
            int n10 = this.measureChildView(this.mClose, n7, n9, 0);
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
            n7 = n10 - (marginLayoutParams.leftMargin + marginLayoutParams.rightMargin);
        }
        if (this.mMenuView != null && this.mMenuView.getParent() == this) {
            n7 = this.measureChildView((View)this.mMenuView, n7, n9, 0);
        }
        if (this.mTitleLayout != null && this.mCustomView == null) {
            if (this.mTitleOptional) {
                int n11 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                this.mTitleLayout.measure(n11, n9);
                int n12 = this.mTitleLayout.getMeasuredWidth();
                boolean bl2 = n12 <= n7;
                if (bl2) {
                    n7 -= n12;
                }
                LinearLayout linearLayout = this.mTitleLayout;
                int n13 = bl2 ? 0 : 8;
                linearLayout.setVisibility(n13);
            } else {
                n7 = this.measureChildView((View)this.mTitleLayout, n7, n9, 0);
            }
        }
        if (this.mCustomView != null) {
            ViewGroup.LayoutParams layoutParams = this.mCustomView.getLayoutParams();
            int n14 = layoutParams.width != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int n15 = layoutParams.width >= 0 ? Math.min(layoutParams.width, n7) : n7;
            int n16 = layoutParams.height != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int n17 = layoutParams.height >= 0 ? Math.min(layoutParams.height, n8) : n8;
            this.mCustomView.measure(View.MeasureSpec.makeMeasureSpec((int)n15, (int)n14), View.MeasureSpec.makeMeasureSpec((int)n17, (int)n16));
        }
        if (this.mContentHeight > 0) {
            this.setMeasuredDimension(n4, n5);
            return;
        }
        int n18 = 0;
        int n19 = this.getChildCount();
        int n20 = 0;
        while (true) {
            if (n20 >= n19) {
                this.setMeasuredDimension(n4, n18);
                return;
            }
            int n21 = n6 + this.getChildAt(n20).getMeasuredHeight();
            if (n21 > n18) {
                n18 = n21;
            }
            ++n20;
        }
    }

    @Override
    public void setContentHeight(int n2) {
        this.mContentHeight = n2;
    }

    public void setCustomView(View view) {
        if (this.mCustomView != null) {
            this.removeView(this.mCustomView);
        }
        this.mCustomView = view;
        if (this.mTitleLayout != null) {
            this.removeView((View)this.mTitleLayout);
            this.mTitleLayout = null;
        }
        if (view != null) {
            this.addView(view);
        }
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSplitActionBar(boolean bl2) {
        if (this.mSplitActionBar != bl2) {
            if (this.mActionMenuPresenter != null) {
                ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
                if (!bl2) {
                    this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
                    this.mMenuView.setBackgroundDrawable(null);
                    ViewGroup viewGroup = (ViewGroup)this.mMenuView.getParent();
                    if (viewGroup != null) {
                        viewGroup.removeView((View)this.mMenuView);
                    }
                    this.addView((View)this.mMenuView, layoutParams);
                } else {
                    this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
                    this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
                    layoutParams.width = -1;
                    layoutParams.height = this.mContentHeight;
                    this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
                    this.mMenuView.setBackgroundDrawable(this.mSplitBackground);
                    ViewGroup viewGroup = (ViewGroup)this.mMenuView.getParent();
                    if (viewGroup != null) {
                        viewGroup.removeView((View)this.mMenuView);
                    }
                    this.mSplitView.addView((View)this.mMenuView, layoutParams);
                }
            }
            super.setSplitActionBar(bl2);
        }
    }

    public void setSubtitle(CharSequence charSequence) {
        this.mSubtitle = charSequence;
        this.initTitle();
    }

    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.initTitle();
    }

    public void setTitleOptional(boolean bl2) {
        if (bl2 != this.mTitleOptional) {
            this.requestLayout();
        }
        this.mTitleOptional = bl2;
    }

    @Override
    public boolean showOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.showOverflowMenu();
        }
        return false;
    }
}

