/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v7.appcompat.R;
import android.support.v7.internal.widget.ActionBarView;
import android.support.v7.internal.widget.ScrollingTabContainerView;
import android.support.v7.view.ActionMode;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class ActionBarContainer
extends FrameLayout {
    private ActionBarView mActionBarView;
    private Drawable mBackground;
    private boolean mIsSplit;
    private boolean mIsStacked;
    private boolean mIsTransitioning;
    private Drawable mSplitBackground;
    private Drawable mStackedBackground;
    private View mTabContainer;

    public ActionBarContainer(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionBarContainer(Context context, AttributeSet attributeSet) {
        boolean bl2 = true;
        super(context, attributeSet);
        this.setBackgroundDrawable(null);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ActionBar);
        this.mBackground = typedArray.getDrawable(10);
        this.mStackedBackground = typedArray.getDrawable(11);
        if (this.getId() == R.id.split_action_bar) {
            this.mIsSplit = bl2;
            this.mSplitBackground = typedArray.getDrawable(12);
        }
        typedArray.recycle();
        if (this.mIsSplit) {
            if (this.mSplitBackground != null) {
                bl2 = false;
            }
        } else if (this.mBackground != null || this.mStackedBackground != null) {
            bl2 = false;
        }
        this.setWillNotDraw(bl2);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mBackground != null && this.mBackground.isStateful()) {
            this.mBackground.setState(this.getDrawableState());
        }
        if (this.mStackedBackground != null && this.mStackedBackground.isStateful()) {
            this.mStackedBackground.setState(this.getDrawableState());
        }
        if (this.mSplitBackground != null && this.mSplitBackground.isStateful()) {
            this.mSplitBackground.setState(this.getDrawableState());
        }
    }

    public View getTabContainer() {
        return this.mTabContainer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onDraw(Canvas canvas) {
        if (this.getWidth() == 0 || this.getHeight() == 0) return;
        if (this.mIsSplit) {
            if (this.mSplitBackground == null) return;
            this.mSplitBackground.draw(canvas);
            return;
        }
        if (this.mBackground != null) {
            this.mBackground.draw(canvas);
        }
        if (this.mStackedBackground == null || !this.mIsStacked) {
            return;
        }
        this.mStackedBackground.draw(canvas);
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        this.mActionBarView = (ActionBarView)this.findViewById(R.id.action_bar);
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return this.mIsTransitioning || super.onInterceptTouchEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        boolean bl3;
        super.onLayout(bl2, n2, n3, n4, n5);
        boolean bl4 = this.mTabContainer != null && this.mTabContainer.getVisibility() != 8;
        if (this.mTabContainer != null && this.mTabContainer.getVisibility() != 8) {
            int n6 = this.getMeasuredHeight();
            int n7 = this.mTabContainer.getMeasuredHeight();
            if ((2 & this.mActionBarView.getDisplayOptions()) != 0) {
                this.mTabContainer.layout(n2, n6 - n7, n4, n6);
            } else {
                int n8 = this.getChildCount();
                for (int i2 = 0; i2 < n8; ++i2) {
                    View view = this.getChildAt(i2);
                    if (view == this.mTabContainer || this.mActionBarView.isCollapsed()) continue;
                    view.offsetTopAndBottom(n7);
                }
                this.mTabContainer.layout(n2, 0, n4, n7);
            }
        }
        if (this.mIsSplit) {
            Drawable drawable2 = this.mSplitBackground;
            bl3 = false;
            if (drawable2 != null) {
                this.mSplitBackground.setBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
                bl3 = true;
            }
        } else {
            Drawable drawable3 = this.mBackground;
            bl3 = false;
            if (drawable3 != null) {
                this.mBackground.setBounds(this.mActionBarView.getLeft(), this.mActionBarView.getTop(), this.mActionBarView.getRight(), this.mActionBarView.getBottom());
                bl3 = true;
            }
            boolean bl5 = bl4 && this.mStackedBackground != null;
            this.mIsStacked = bl5;
            if (bl5) {
                this.mStackedBackground.setBounds(this.mTabContainer.getLeft(), this.mTabContainer.getTop(), this.mTabContainer.getRight(), this.mTabContainer.getBottom());
                bl3 = true;
            }
        }
        if (bl3) {
            this.invalidate();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onMeasure(int n2, int n3) {
        int n4;
        block3: {
            block2: {
                super.onMeasure(n2, n3);
                if (this.mActionBarView == null) break block2;
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mActionBarView.getLayoutParams();
                n4 = this.mActionBarView.isCollapsed() ? 0 : this.mActionBarView.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
                if (this.mTabContainer != null && this.mTabContainer.getVisibility() != 8 && View.MeasureSpec.getMode((int)n3) == Integer.MIN_VALUE) break block3;
            }
            return;
        }
        int n5 = View.MeasureSpec.getSize((int)n3);
        this.setMeasuredDimension(this.getMeasuredWidth(), Math.min(n4 + this.mTabContainer.getMeasuredHeight(), n5));
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPrimaryBackground(Drawable drawable2) {
        boolean bl2 = true;
        if (this.mBackground != null) {
            this.mBackground.setCallback(null);
            this.unscheduleDrawable(this.mBackground);
        }
        this.mBackground = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
        if (this.mIsSplit) {
            if (this.mSplitBackground != null) {
                bl2 = false;
            }
        } else if (this.mBackground != null || this.mStackedBackground != null) {
            bl2 = false;
        }
        this.setWillNotDraw(bl2);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSplitBackground(Drawable drawable2) {
        boolean bl2 = true;
        if (this.mSplitBackground != null) {
            this.mSplitBackground.setCallback(null);
            this.unscheduleDrawable(this.mSplitBackground);
        }
        this.mSplitBackground = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
        if (this.mIsSplit) {
            if (this.mSplitBackground != null) {
                bl2 = false;
            }
        } else if (this.mBackground != null || this.mStackedBackground != null) {
            bl2 = false;
        }
        this.setWillNotDraw(bl2);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStackedBackground(Drawable drawable2) {
        boolean bl2 = true;
        if (this.mStackedBackground != null) {
            this.mStackedBackground.setCallback(null);
            this.unscheduleDrawable(this.mStackedBackground);
        }
        this.mStackedBackground = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
        if (this.mIsSplit) {
            if (this.mSplitBackground != null) {
                bl2 = false;
            }
        } else if (this.mBackground != null || this.mStackedBackground != null) {
            bl2 = false;
        }
        this.setWillNotDraw(bl2);
        this.invalidate();
    }

    public void setTabContainer(ScrollingTabContainerView scrollingTabContainerView) {
        if (this.mTabContainer != null) {
            this.removeView(this.mTabContainer);
        }
        this.mTabContainer = scrollingTabContainerView;
        if (scrollingTabContainerView != null) {
            this.addView((View)scrollingTabContainerView);
            ViewGroup.LayoutParams layoutParams = scrollingTabContainerView.getLayoutParams();
            layoutParams.width = -1;
            layoutParams.height = -2;
            scrollingTabContainerView.setAllowCollapse(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTransitioning(boolean bl2) {
        this.mIsTransitioning = bl2;
        int n2 = bl2 ? 393216 : 262144;
        this.setDescendantFocusability(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setVisibility(int n2) {
        super.setVisibility(n2);
        boolean bl2 = n2 == 0;
        if (this.mBackground != null) {
            this.mBackground.setVisible(bl2, false);
        }
        if (this.mStackedBackground != null) {
            this.mStackedBackground.setVisible(bl2, false);
        }
        if (this.mSplitBackground != null) {
            this.mSplitBackground.setVisible(bl2, false);
        }
    }

    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback) {
        return null;
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        return drawable2 == this.mBackground && !this.mIsSplit || drawable2 == this.mStackedBackground && this.mIsStacked || drawable2 == this.mSplitBackground && this.mIsSplit || super.verifyDrawable(drawable2);
    }
}

