/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.internal.widget.AdapterViewICS;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SpinnerAdapter;

abstract class AbsSpinnerICS
extends AdapterViewICS<SpinnerAdapter> {
    SpinnerAdapter mAdapter;
    boolean mBlockLayoutRequests;
    private DataSetObserver mDataSetObserver;
    int mHeightMeasureSpec;
    final RecycleBin mRecycler;
    int mSelectionBottomPadding = 0;
    int mSelectionLeftPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionTopPadding = 0;
    final Rect mSpinnerPadding = new Rect();
    private Rect mTouchFrame;
    int mWidthMeasureSpec;

    AbsSpinnerICS(Context context) {
        super(context);
        this.mRecycler = new RecycleBin();
        this.initAbsSpinner();
    }

    AbsSpinnerICS(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    AbsSpinnerICS(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mRecycler = new RecycleBin();
        this.initAbsSpinner();
    }

    private void initAbsSpinner() {
        this.setFocusable(true);
        this.setWillNotDraw(false);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -2);
    }

    @Override
    public SpinnerAdapter getAdapter() {
        return this.mAdapter;
    }

    int getChildHeight(View view) {
        return view.getMeasuredHeight();
    }

    int getChildWidth(View view) {
        return view.getMeasuredWidth();
    }

    @Override
    public int getCount() {
        return this.mItemCount;
    }

    @Override
    public View getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    abstract void layout(int var1, boolean var2);

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = this.getPaddingLeft();
        int n6 = this.getPaddingTop();
        int n7 = this.getPaddingRight();
        int n8 = this.getPaddingBottom();
        Rect rect = this.mSpinnerPadding;
        if (n5 <= this.mSelectionLeftPadding) {
            n5 = this.mSelectionLeftPadding;
        }
        rect.left = n5;
        Rect rect2 = this.mSpinnerPadding;
        if (n6 <= this.mSelectionTopPadding) {
            n6 = this.mSelectionTopPadding;
        }
        rect2.top = n6;
        Rect rect3 = this.mSpinnerPadding;
        if (n7 <= this.mSelectionRightPadding) {
            n7 = this.mSelectionRightPadding;
        }
        rect3.right = n7;
        Rect rect4 = this.mSpinnerPadding;
        if (n8 <= this.mSelectionBottomPadding) {
            n8 = this.mSelectionBottomPadding;
        }
        rect4.bottom = n8;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        boolean bl2 = true;
        int n9 = this.getSelectedItemPosition();
        int n10 = 0;
        int n11 = 0;
        if (n9 >= 0) {
            SpinnerAdapter spinnerAdapter = this.mAdapter;
            n10 = 0;
            n11 = 0;
            if (spinnerAdapter != null) {
                int n12 = this.mAdapter.getCount();
                n10 = 0;
                n11 = 0;
                if (n9 < n12) {
                    View view = this.mRecycler.get(n9);
                    if (view == null) {
                        view = this.mAdapter.getView(n9, null, (ViewGroup)this);
                    }
                    if (view != null) {
                        this.mRecycler.put(n9, view);
                    }
                    n10 = 0;
                    n11 = 0;
                    if (view != null) {
                        if (view.getLayoutParams() == null) {
                            this.mBlockLayoutRequests = true;
                            view.setLayoutParams(this.generateDefaultLayoutParams());
                            this.mBlockLayoutRequests = false;
                        }
                        this.measureChild(view, n2, n3);
                        n10 = this.getChildHeight(view) + this.mSpinnerPadding.top + this.mSpinnerPadding.bottom;
                        n11 = this.getChildWidth(view) + this.mSpinnerPadding.left + this.mSpinnerPadding.right;
                        bl2 = false;
                    }
                }
            }
        }
        if (bl2) {
            n10 = this.mSpinnerPadding.top + this.mSpinnerPadding.bottom;
            if (n4 == 0) {
                n11 = this.mSpinnerPadding.left + this.mSpinnerPadding.right;
            }
        }
        int n13 = Math.max(n10, this.getSuggestedMinimumHeight());
        int n14 = Math.max(n11, this.getSuggestedMinimumWidth());
        int n15 = AbsSpinnerICS.resolveSize((int)n13, (int)n3);
        this.setMeasuredDimension(AbsSpinnerICS.resolveSize((int)n14, (int)n2), n15);
        this.mHeightMeasureSpec = n3;
        this.mWidthMeasureSpec = n2;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.selectedId >= 0L) {
            this.mDataChanged = true;
            this.mNeedSync = true;
            this.mSyncRowId = savedState.selectedId;
            this.mSyncPosition = savedState.position;
            this.mSyncMode = 0;
            this.requestLayout();
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.selectedId = this.getSelectedItemId();
        if (savedState.selectedId >= 0L) {
            savedState.position = this.getSelectedItemPosition();
            return savedState;
        }
        savedState.position = -1;
        return savedState;
    }

    public int pointToPosition(int n2, int n3) {
        Rect rect = this.mTouchFrame;
        if (rect == null) {
            rect = this.mTouchFrame = new Rect();
        }
        for (int i2 = -1 + this.getChildCount(); i2 >= 0; --i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0) continue;
            view.getHitRect(rect);
            if (!rect.contains(n2, n3)) continue;
            return i2 + this.mFirstPosition;
        }
        return -1;
    }

    void recycleAllViews() {
        int n2 = this.getChildCount();
        RecycleBin recycleBin = this.mRecycler;
        int n3 = this.mFirstPosition;
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            recycleBin.put(n3 + i2, view);
        }
    }

    public void requestLayout() {
        if (!this.mBlockLayoutRequests) {
            super.requestLayout();
        }
    }

    void resetList() {
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.removeAllViewsInLayout();
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        int n2 = -1;
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.resetList();
        }
        this.mAdapter = spinnerAdapter;
        this.mOldSelectedPosition = n2;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = new AdapterViewICS.AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            if (this.mItemCount > 0) {
                n2 = 0;
            }
            this.setSelectedPositionInt(n2);
            this.setNextSelectedPositionInt(n2);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.checkFocus();
            this.resetList();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    @Override
    public void setSelection(int n2) {
        this.setNextSelectedPositionInt(n2);
        this.requestLayout();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSelection(int n2, boolean bl2) {
        boolean bl3 = bl2 && this.mFirstPosition <= n2 && n2 <= -1 + (this.mFirstPosition + this.getChildCount());
        this.setSelectionInt(n2, bl3);
    }

    void setSelectionInt(int n2, boolean bl2) {
        if (n2 != this.mOldSelectedPosition) {
            this.mBlockLayoutRequests = true;
            int n3 = n2 - this.mSelectedPosition;
            this.setNextSelectedPositionInt(n2);
            this.layout(n3, bl2);
            this.mBlockLayoutRequests = false;
        }
    }

    class RecycleBin {
        private final SparseArray<View> mScrapHeap = new SparseArray();

        RecycleBin() {
        }

        void clear() {
            SparseArray<View> sparseArray = this.mScrapHeap;
            int n2 = sparseArray.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view = (View)sparseArray.valueAt(i2);
                if (view == null) continue;
                AbsSpinnerICS.this.removeDetachedView(view, true);
            }
            sparseArray.clear();
        }

        View get(int n2) {
            View view = (View)this.mScrapHeap.get(n2);
            if (view != null) {
                this.mScrapHeap.delete(n2);
            }
            return view;
        }

        public void put(int n2, View view) {
            this.mScrapHeap.put(n2, (Object)view);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        int position;
        long selectedId;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.selectedId = parcel.readLong();
            this.position = parcel.readInt();
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "AbsSpinner.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " selectedId=" + this.selectedId + " position=" + this.position + "}";
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeLong(this.selectedId);
            parcel.writeInt(this.position);
        }
    }
}

