/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.menu.ActionMenuPresenter;
import android.support.v7.internal.view.menu.ActionMenuView;
import android.support.v7.internal.widget.ActionBarContainer;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;

abstract class AbsActionBarView
extends ViewGroup {
    private static final int FADE_DURATION = 200;
    protected ActionMenuPresenter mActionMenuPresenter;
    protected int mContentHeight;
    protected ActionMenuView mMenuView;
    protected boolean mSplitActionBar;
    protected ActionBarContainer mSplitView;
    protected boolean mSplitWhenNarrow;

    AbsActionBarView(Context context) {
        super(context);
    }

    AbsActionBarView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    AbsActionBarView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void animateToVisibility(int n2) {
        this.clearAnimation();
        if (n2 != this.getVisibility()) {
            Context context = this.getContext();
            int n3 = n2 == 0 ? R.anim.abc_fade_in : R.anim.abc_fade_out;
            Animation animation = AnimationUtils.loadAnimation((Context)context, (int)n3);
            this.startAnimation(animation);
            this.setVisibility(n2);
            if (this.mSplitView != null && this.mMenuView != null) {
                this.mMenuView.startAnimation(animation);
                this.mMenuView.setVisibility(n2);
            }
        }
    }

    public void dismissPopupMenus() {
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.dismissPopupMenus();
        }
    }

    public int getAnimatedVisibility() {
        return this.getVisibility();
    }

    public int getContentHeight() {
        return this.mContentHeight;
    }

    public boolean hideOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.hideOverflowMenu();
        }
        return false;
    }

    public boolean isOverflowMenuShowing() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.isOverflowMenuShowing();
        }
        return false;
    }

    public boolean isOverflowReserved() {
        return this.mActionMenuPresenter != null && this.mActionMenuPresenter.isOverflowReserved();
    }

    protected int measureChildView(View view, int n2, int n3, int n4) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)n2, (int)Integer.MIN_VALUE), n3);
        return Math.max(0, n2 - view.getMeasuredWidth() - n4);
    }

    protected void onConfigurationChanged(Configuration configuration) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onConfigurationChanged(configuration);
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(null, R.styleable.ActionBar, R.attr.actionBarStyle, 0);
        this.setContentHeight(typedArray.getLayoutDimension(0, 0));
        typedArray.recycle();
        if (this.mSplitWhenNarrow) {
            this.setSplitActionBar(this.getContext().getResources().getBoolean(R.bool.abc_split_action_bar_is_narrow));
        }
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.onConfigurationChanged(configuration);
        }
    }

    protected int positionChild(View view, int n2, int n3, int n4) {
        int n5 = view.getMeasuredWidth();
        int n6 = view.getMeasuredHeight();
        int n7 = n3 + (n4 - n6) / 2;
        view.layout(n2, n7, n2 + n5, n7 + n6);
        return n5;
    }

    protected int positionChildInverse(View view, int n2, int n3, int n4) {
        int n5 = view.getMeasuredWidth();
        int n6 = view.getMeasuredHeight();
        int n7 = n3 + (n4 - n6) / 2;
        view.layout(n2 - n5, n7, n2, n7 + n6);
        return n5;
    }

    public void postShowOverflowMenu() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AbsActionBarView.this.showOverflowMenu();
            }
        });
    }

    public void setContentHeight(int n2) {
        this.mContentHeight = n2;
        this.requestLayout();
    }

    public void setSplitActionBar(boolean bl2) {
        this.mSplitActionBar = bl2;
    }

    public void setSplitView(ActionBarContainer actionBarContainer) {
        this.mSplitView = actionBarContainer;
    }

    public void setSplitWhenNarrow(boolean bl2) {
        this.mSplitWhenNarrow = bl2;
    }

    public void setVisibility(int n2) {
        if (n2 != this.getVisibility()) {
            super.setVisibility(n2);
        }
    }

    public boolean showOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.showOverflowMenu();
        }
        return false;
    }
}

