/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.view.menu;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.v4.internal.view.SupportMenuItem;
import android.support.v4.view.ActionProvider;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.internal.view.menu.BaseMenuWrapper;
import android.support.v7.internal.view.menu.BaseWrapper;
import android.util.Log;
import android.view.CollapsibleActionView;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.widget.FrameLayout;
import java.lang.reflect.Method;

public class MenuItemWrapperICS
extends BaseMenuWrapper<MenuItem>
implements SupportMenuItem {
    static final String LOG_TAG = "MenuItemWrapper";
    private final boolean mEmulateProviderVisibilityOverride;
    private boolean mLastRequestVisible;
    private Method mSetExclusiveCheckableMethod;

    MenuItemWrapperICS(MenuItem menuItem) {
        this(menuItem, true);
    }

    MenuItemWrapperICS(MenuItem menuItem, boolean bl2) {
        super(menuItem);
        this.mLastRequestVisible = menuItem.isVisible();
        this.mEmulateProviderVisibilityOverride = bl2;
    }

    final boolean checkActionProviderOverrideVisibility() {
        boolean bl2 = this.mLastRequestVisible;
        boolean bl3 = false;
        if (bl2) {
            ActionProvider actionProvider = this.getSupportActionProvider();
            bl3 = false;
            if (actionProvider != null) {
                boolean bl4 = actionProvider.overridesItemVisibility();
                bl3 = false;
                if (bl4) {
                    boolean bl5 = actionProvider.isVisible();
                    bl3 = false;
                    if (!bl5) {
                        this.wrappedSetVisible(false);
                        bl3 = true;
                    }
                }
            }
        }
        return bl3;
    }

    @Override
    public boolean collapseActionView() {
        return ((MenuItem)this.mWrappedObject).collapseActionView();
    }

    ActionProviderWrapper createActionProviderWrapper(ActionProvider actionProvider) {
        return new ActionProviderWrapper(actionProvider);
    }

    @Override
    public boolean expandActionView() {
        return ((MenuItem)this.mWrappedObject).expandActionView();
    }

    public android.view.ActionProvider getActionProvider() {
        return ((MenuItem)this.mWrappedObject).getActionProvider();
    }

    @Override
    public View getActionView() {
        View view = ((MenuItem)this.mWrappedObject).getActionView();
        if (view instanceof CollapsibleActionViewWrapper) {
            view = ((CollapsibleActionViewWrapper)view).getWrappedView();
        }
        return view;
    }

    public char getAlphabeticShortcut() {
        return ((MenuItem)this.mWrappedObject).getAlphabeticShortcut();
    }

    public int getGroupId() {
        return ((MenuItem)this.mWrappedObject).getGroupId();
    }

    public Drawable getIcon() {
        return ((MenuItem)this.mWrappedObject).getIcon();
    }

    public Intent getIntent() {
        return ((MenuItem)this.mWrappedObject).getIntent();
    }

    public int getItemId() {
        return ((MenuItem)this.mWrappedObject).getItemId();
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return ((MenuItem)this.mWrappedObject).getMenuInfo();
    }

    public char getNumericShortcut() {
        return ((MenuItem)this.mWrappedObject).getNumericShortcut();
    }

    public int getOrder() {
        return ((MenuItem)this.mWrappedObject).getOrder();
    }

    public SubMenu getSubMenu() {
        return this.getSubMenuWrapper(((MenuItem)this.mWrappedObject).getSubMenu());
    }

    @Override
    public ActionProvider getSupportActionProvider() {
        ActionProviderWrapper actionProviderWrapper = (ActionProviderWrapper)((MenuItem)this.mWrappedObject).getActionProvider();
        if (actionProviderWrapper != null) {
            return actionProviderWrapper.mInner;
        }
        return null;
    }

    public CharSequence getTitle() {
        return ((MenuItem)this.mWrappedObject).getTitle();
    }

    public CharSequence getTitleCondensed() {
        return ((MenuItem)this.mWrappedObject).getTitleCondensed();
    }

    public boolean hasSubMenu() {
        return ((MenuItem)this.mWrappedObject).hasSubMenu();
    }

    @Override
    public boolean isActionViewExpanded() {
        return ((MenuItem)this.mWrappedObject).isActionViewExpanded();
    }

    public boolean isCheckable() {
        return ((MenuItem)this.mWrappedObject).isCheckable();
    }

    public boolean isChecked() {
        return ((MenuItem)this.mWrappedObject).isChecked();
    }

    public boolean isEnabled() {
        return ((MenuItem)this.mWrappedObject).isEnabled();
    }

    public boolean isVisible() {
        return ((MenuItem)this.mWrappedObject).isVisible();
    }

    public MenuItem setActionProvider(android.view.ActionProvider actionProvider) {
        ((MenuItem)this.mWrappedObject).setActionProvider(actionProvider);
        if (actionProvider != null && this.mEmulateProviderVisibilityOverride) {
            this.checkActionProviderOverrideVisibility();
        }
        return this;
    }

    @Override
    public MenuItem setActionView(int n2) {
        ((MenuItem)this.mWrappedObject).setActionView(n2);
        View view = ((MenuItem)this.mWrappedObject).getActionView();
        if (view instanceof android.support.v7.view.CollapsibleActionView) {
            ((MenuItem)this.mWrappedObject).setActionView((View)new CollapsibleActionViewWrapper(view));
        }
        return this;
    }

    @Override
    public MenuItem setActionView(View object) {
        if (object instanceof android.support.v7.view.CollapsibleActionView) {
            object = new CollapsibleActionViewWrapper((View)object);
        }
        ((MenuItem)this.mWrappedObject).setActionView(object);
        return this;
    }

    public MenuItem setAlphabeticShortcut(char c2) {
        ((MenuItem)this.mWrappedObject).setAlphabeticShortcut(c2);
        return this;
    }

    public MenuItem setCheckable(boolean bl2) {
        ((MenuItem)this.mWrappedObject).setCheckable(bl2);
        return this;
    }

    public MenuItem setChecked(boolean bl2) {
        ((MenuItem)this.mWrappedObject).setChecked(bl2);
        return this;
    }

    public MenuItem setEnabled(boolean bl2) {
        ((MenuItem)this.mWrappedObject).setEnabled(bl2);
        return this;
    }

    public void setExclusiveCheckable(boolean bl2) {
        try {
            if (this.mSetExclusiveCheckableMethod == null) {
                Class<?> clazz = ((MenuItem)this.mWrappedObject).getClass();
                Class[] classArray = new Class[]{Boolean.TYPE};
                this.mSetExclusiveCheckableMethod = clazz.getDeclaredMethod("setExclusiveCheckable", classArray);
            }
            Method method = this.mSetExclusiveCheckableMethod;
            Object object = this.mWrappedObject;
            Object[] objectArray = new Object[]{bl2};
            method.invoke(object, objectArray);
            return;
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Error while calling setExclusiveCheckable", (Throwable)exception);
            return;
        }
    }

    public MenuItem setIcon(int n2) {
        ((MenuItem)this.mWrappedObject).setIcon(n2);
        return this;
    }

    public MenuItem setIcon(Drawable drawable2) {
        ((MenuItem)this.mWrappedObject).setIcon(drawable2);
        return this;
    }

    public MenuItem setIntent(Intent intent) {
        ((MenuItem)this.mWrappedObject).setIntent(intent);
        return this;
    }

    public MenuItem setNumericShortcut(char c2) {
        ((MenuItem)this.mWrappedObject).setNumericShortcut(c2);
        return this;
    }

    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        ((MenuItem)this.mWrappedObject).setOnActionExpandListener(onActionExpandListener);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        MenuItem menuItem = (MenuItem)this.mWrappedObject;
        OnMenuItemClickListenerWrapper onMenuItemClickListenerWrapper = onMenuItemClickListener != null ? new OnMenuItemClickListenerWrapper(onMenuItemClickListener) : null;
        menuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)onMenuItemClickListenerWrapper);
        return this;
    }

    public MenuItem setShortcut(char c2, char c3) {
        ((MenuItem)this.mWrappedObject).setShortcut(c2, c3);
        return this;
    }

    @Override
    public void setShowAsAction(int n2) {
        ((MenuItem)this.mWrappedObject).setShowAsAction(n2);
    }

    @Override
    public MenuItem setShowAsActionFlags(int n2) {
        ((MenuItem)this.mWrappedObject).setShowAsActionFlags(n2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public SupportMenuItem setSupportActionProvider(ActionProvider actionProvider) {
        MenuItem menuItem = (MenuItem)this.mWrappedObject;
        ActionProviderWrapper actionProviderWrapper = actionProvider != null ? this.createActionProviderWrapper(actionProvider) : null;
        menuItem.setActionProvider((android.view.ActionProvider)actionProviderWrapper);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public SupportMenuItem setSupportOnActionExpandListener(MenuItemCompat.OnActionExpandListener onActionExpandListener) {
        MenuItem menuItem = (MenuItem)this.mWrappedObject;
        OnActionExpandListenerWrapper onActionExpandListenerWrapper = onActionExpandListener != null ? new OnActionExpandListenerWrapper(onActionExpandListener) : null;
        menuItem.setOnActionExpandListener((MenuItem.OnActionExpandListener)onActionExpandListenerWrapper);
        return null;
    }

    public MenuItem setTitle(int n2) {
        ((MenuItem)this.mWrappedObject).setTitle(n2);
        return this;
    }

    public MenuItem setTitle(CharSequence charSequence) {
        ((MenuItem)this.mWrappedObject).setTitle(charSequence);
        return this;
    }

    public MenuItem setTitleCondensed(CharSequence charSequence) {
        ((MenuItem)this.mWrappedObject).setTitleCondensed(charSequence);
        return this;
    }

    public MenuItem setVisible(boolean bl2) {
        if (this.mEmulateProviderVisibilityOverride) {
            this.mLastRequestVisible = bl2;
            if (this.checkActionProviderOverrideVisibility()) {
                return this;
            }
        }
        return this.wrappedSetVisible(bl2);
    }

    final MenuItem wrappedSetVisible(boolean bl2) {
        return ((MenuItem)this.mWrappedObject).setVisible(bl2);
    }

    class ActionProviderWrapper
    extends android.view.ActionProvider {
        final ActionProvider mInner;

        public ActionProviderWrapper(ActionProvider actionProvider) {
            super(actionProvider.getContext());
            this.mInner = actionProvider;
            if (MenuItemWrapperICS.this.mEmulateProviderVisibilityOverride) {
                this.mInner.setVisibilityListener(new ActionProvider.VisibilityListener(){

                    @Override
                    public void onActionProviderVisibilityChanged(boolean bl2) {
                        if (ActionProviderWrapper.this.mInner.overridesItemVisibility() && MenuItemWrapperICS.this.mLastRequestVisible) {
                            MenuItemWrapperICS.this.wrappedSetVisible(bl2);
                        }
                    }
                });
            }
        }

        public boolean hasSubMenu() {
            return this.mInner.hasSubMenu();
        }

        public View onCreateActionView() {
            if (MenuItemWrapperICS.this.mEmulateProviderVisibilityOverride) {
                MenuItemWrapperICS.this.checkActionProviderOverrideVisibility();
            }
            return this.mInner.onCreateActionView();
        }

        public boolean onPerformDefaultAction() {
            return this.mInner.onPerformDefaultAction();
        }

        public void onPrepareSubMenu(SubMenu subMenu) {
            this.mInner.onPrepareSubMenu(MenuItemWrapperICS.this.getSubMenuWrapper(subMenu));
        }
    }

    static class CollapsibleActionViewWrapper
    extends FrameLayout
    implements CollapsibleActionView {
        final android.support.v7.view.CollapsibleActionView mWrappedView;

        CollapsibleActionViewWrapper(View view) {
            super(view.getContext());
            this.mWrappedView = (android.support.v7.view.CollapsibleActionView)view;
            this.addView(view);
        }

        View getWrappedView() {
            return (View)this.mWrappedView;
        }

        public void onActionViewCollapsed() {
            this.mWrappedView.onActionViewCollapsed();
        }

        public void onActionViewExpanded() {
            this.mWrappedView.onActionViewExpanded();
        }
    }

    private class OnActionExpandListenerWrapper
    extends BaseWrapper<MenuItemCompat.OnActionExpandListener>
    implements MenuItem.OnActionExpandListener {
        OnActionExpandListenerWrapper(MenuItemCompat.OnActionExpandListener onActionExpandListener) {
            super(onActionExpandListener);
        }

        public boolean onMenuItemActionCollapse(MenuItem menuItem) {
            return ((MenuItemCompat.OnActionExpandListener)this.mWrappedObject).onMenuItemActionCollapse(MenuItemWrapperICS.this.getMenuItemWrapper(menuItem));
        }

        public boolean onMenuItemActionExpand(MenuItem menuItem) {
            return ((MenuItemCompat.OnActionExpandListener)this.mWrappedObject).onMenuItemActionExpand(MenuItemWrapperICS.this.getMenuItemWrapper(menuItem));
        }
    }

    private class OnMenuItemClickListenerWrapper
    extends BaseWrapper<MenuItem.OnMenuItemClickListener>
    implements MenuItem.OnMenuItemClickListener {
        OnMenuItemClickListenerWrapper(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
            super(onMenuItemClickListener);
        }

        public boolean onMenuItemClick(MenuItem menuItem) {
            return ((MenuItem.OnMenuItemClickListener)this.mWrappedObject).onMenuItemClick((MenuItem)MenuItemWrapperICS.this.getMenuItemWrapper(menuItem));
        }
    }
}

