/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.view.menu;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.v4.internal.view.SupportMenuItem;
import android.support.v4.view.ActionProvider;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.internal.view.menu.MenuBuilder;
import android.support.v7.internal.view.menu.MenuView;
import android.support.v7.internal.view.menu.SubMenuBuilder;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.LinearLayout;

public final class MenuItemImpl
implements SupportMenuItem {
    private static final int CHECKABLE = 1;
    private static final int CHECKED = 2;
    private static final int ENABLED = 16;
    private static final int EXCLUSIVE = 4;
    private static final int HIDDEN = 8;
    private static final int IS_ACTION = 32;
    static final int NO_ICON = 0;
    private static final int SHOW_AS_ACTION_MASK = 3;
    private static final String TAG = "MenuItemImpl";
    private static String sDeleteShortcutLabel;
    private static String sEnterShortcutLabel;
    private static String sPrependShortcutLabel;
    private static String sSpaceShortcutLabel;
    private ActionProvider mActionProvider;
    private View mActionView;
    private final int mCategoryOrder;
    private MenuItem.OnMenuItemClickListener mClickListener;
    private int mFlags = 16;
    private final int mGroup;
    private Drawable mIconDrawable;
    private int mIconResId = 0;
    private final int mId;
    private Intent mIntent;
    private boolean mIsActionViewExpanded = false;
    private Runnable mItemCallback;
    private MenuBuilder mMenu;
    private ContextMenu.ContextMenuInfo mMenuInfo;
    private MenuItemCompat.OnActionExpandListener mOnActionExpandListener;
    private final int mOrdering;
    private char mShortcutAlphabeticChar;
    private char mShortcutNumericChar;
    private int mShowAsAction = 0;
    private SubMenuBuilder mSubMenu;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;

    MenuItemImpl(MenuBuilder menuBuilder, int n2, int n3, int n4, int n5, CharSequence charSequence, int n6) {
        this.mMenu = menuBuilder;
        this.mId = n3;
        this.mGroup = n2;
        this.mCategoryOrder = n4;
        this.mOrdering = n5;
        this.mTitle = charSequence;
        this.mShowAsAction = n6;
    }

    public void actionFormatChanged() {
        this.mMenu.onItemActionRequestChanged(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean collapseActionView() {
        block5: {
            block4: {
                if ((8 & this.mShowAsAction) == 0) break block4;
                if (this.mActionView == null) {
                    return true;
                }
                if (this.mOnActionExpandListener == null || this.mOnActionExpandListener.onMenuItemActionCollapse(this)) break block5;
            }
            return false;
        }
        return this.mMenu.collapseItemActionView(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean expandActionView() {
        if ((8 & this.mShowAsAction) == 0 || this.mActionView == null || this.mOnActionExpandListener != null && !this.mOnActionExpandListener.onMenuItemActionExpand(this)) {
            return false;
        }
        return this.mMenu.expandItemActionView(this);
    }

    public android.view.ActionProvider getActionProvider() {
        throw new UnsupportedOperationException("Implementation should use getSupportActionProvider!");
    }

    @Override
    public View getActionView() {
        if (this.mActionView != null) {
            return this.mActionView;
        }
        if (this.mActionProvider != null) {
            this.mActionView = this.mActionProvider.onCreateActionView(this);
            return this.mActionView;
        }
        return null;
    }

    public char getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    Runnable getCallback() {
        return this.mItemCallback;
    }

    public int getGroupId() {
        return this.mGroup;
    }

    public Drawable getIcon() {
        if (this.mIconDrawable != null) {
            return this.mIconDrawable;
        }
        if (this.mIconResId != 0) {
            Drawable drawable2 = this.mMenu.getResources().getDrawable(this.mIconResId);
            this.mIconResId = 0;
            this.mIconDrawable = drawable2;
            return drawable2;
        }
        return null;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    @ViewDebug.CapturedViewProperty
    public int getItemId() {
        return this.mId;
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return this.mMenuInfo;
    }

    public char getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    public int getOrder() {
        return this.mCategoryOrder;
    }

    public int getOrdering() {
        return this.mOrdering;
    }

    char getShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getShortcutLabel() {
        char c2 = this.getShortcut();
        if (c2 == '\u0000') {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(sPrependShortcutLabel);
        switch (c2) {
            default: {
                stringBuilder.append(c2);
                return stringBuilder.toString();
            }
            case '\n': {
                stringBuilder.append(sEnterShortcutLabel);
                return stringBuilder.toString();
            }
            case '\b': {
                stringBuilder.append(sDeleteShortcutLabel);
                return stringBuilder.toString();
            }
            case ' ': 
        }
        stringBuilder.append(sSpaceShortcutLabel);
        return stringBuilder.toString();
    }

    public SubMenu getSubMenu() {
        return this.mSubMenu;
    }

    @Override
    public ActionProvider getSupportActionProvider() {
        return this.mActionProvider;
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getTitleCondensed() {
        if (this.mTitleCondensed != null) {
            return this.mTitleCondensed;
        }
        return this.mTitle;
    }

    CharSequence getTitleForItemView(MenuView.ItemView itemView) {
        if (itemView != null && itemView.prefersCondensedTitle()) {
            return this.getTitleCondensed();
        }
        return this.getTitle();
    }

    public boolean hasCollapsibleActionView() {
        return (8 & this.mShowAsAction) != 0 && this.mActionView != null;
    }

    public boolean hasSubMenu() {
        return this.mSubMenu != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invoke() {
        block8: {
            block7: {
                if (this.mClickListener != null && this.mClickListener.onMenuItemClick((MenuItem)this) || this.mMenu.dispatchMenuItemSelected(this.mMenu.getRootMenu(), this)) break block7;
                if (this.mItemCallback != null) {
                    this.mItemCallback.run();
                    return true;
                }
                if (this.mIntent != null) {
                    try {
                        this.mMenu.getContext().startActivity(this.mIntent);
                        return true;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        Log.e((String)TAG, (String)"Can't find activity to handle intent; ignoring", (Throwable)activityNotFoundException);
                    }
                }
                if (this.mActionProvider == null || !this.mActionProvider.onPerformDefaultAction()) break block8;
            }
            return true;
        }
        return false;
    }

    public boolean isActionButton() {
        return (0x20 & this.mFlags) == 32;
    }

    @Override
    public boolean isActionViewExpanded() {
        return this.mIsActionViewExpanded;
    }

    public boolean isCheckable() {
        return (1 & this.mFlags) == 1;
    }

    public boolean isChecked() {
        return (2 & this.mFlags) == 2;
    }

    public boolean isEnabled() {
        return (0x10 & this.mFlags) != 0;
    }

    public boolean isExclusiveCheckable() {
        return (4 & this.mFlags) != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isVisible() {
        if (this.mActionProvider != null && this.mActionProvider.overridesItemVisibility()) {
            if ((8 & this.mFlags) == 0 && this.mActionProvider.isVisible()) return true;
            return false;
        }
        if ((8 & this.mFlags) != 0) return false;
        return true;
    }

    public boolean requestsActionButton() {
        return (1 & this.mShowAsAction) == 1;
    }

    public boolean requiresActionButton() {
        return (2 & this.mShowAsAction) == 2;
    }

    public MenuItem setActionProvider(android.view.ActionProvider actionProvider) {
        throw new UnsupportedOperationException("Implementation should use setSupportActionProvider!");
    }

    @Override
    public SupportMenuItem setActionView(int n2) {
        Context context = this.mMenu.getContext();
        this.setActionView(LayoutInflater.from((Context)context).inflate(n2, (ViewGroup)new LinearLayout(context), false));
        return this;
    }

    @Override
    public SupportMenuItem setActionView(View view) {
        this.mActionView = view;
        this.mActionProvider = null;
        if (view != null && view.getId() == -1 && this.mId > 0) {
            view.setId(this.mId);
        }
        this.mMenu.onItemActionRequestChanged(this);
        return this;
    }

    public void setActionViewExpanded(boolean bl2) {
        this.mIsActionViewExpanded = bl2;
        this.mMenu.onItemsChanged(false);
    }

    public MenuItem setAlphabeticShortcut(char c2) {
        if (this.mShortcutAlphabeticChar == c2) {
            return this;
        }
        this.mShortcutAlphabeticChar = Character.toLowerCase(c2);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setCallback(Runnable runnable) {
        this.mItemCallback = runnable;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MenuItem setCheckable(boolean bl2) {
        int n2 = this.mFlags;
        int n3 = 0xFFFFFFFE & this.mFlags;
        int n4 = bl2 ? 1 : 0;
        this.mFlags = n4 | n3;
        if (n2 != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
        return this;
    }

    public MenuItem setChecked(boolean bl2) {
        if ((4 & this.mFlags) != 0) {
            this.mMenu.setExclusiveItemChecked(this);
            return this;
        }
        this.setCheckedInt(bl2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCheckedInt(boolean bl2) {
        int n2 = this.mFlags;
        int n3 = 0xFFFFFFFD & this.mFlags;
        int n4 = bl2 ? 2 : 0;
        this.mFlags = n4 | n3;
        if (n2 != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public MenuItem setEnabled(boolean bl2) {
        this.mFlags = bl2 ? 0x10 | this.mFlags : 0xFFFFFFEF & this.mFlags;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExclusiveCheckable(boolean bl2) {
        int n2 = 0xFFFFFFFB & this.mFlags;
        int n3 = bl2 ? 4 : 0;
        this.mFlags = n3 | n2;
    }

    public MenuItem setIcon(int n2) {
        this.mIconDrawable = null;
        this.mIconResId = n2;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setIcon(Drawable drawable2) {
        this.mIconResId = 0;
        this.mIconDrawable = drawable2;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    public void setIsActionButton(boolean bl2) {
        if (bl2) {
            this.mFlags = 0x20 | this.mFlags;
            return;
        }
        this.mFlags = 0xFFFFFFDF & this.mFlags;
    }

    void setMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mMenuInfo = contextMenuInfo;
    }

    public MenuItem setNumericShortcut(char c2) {
        if (this.mShortcutNumericChar == c2) {
            return this;
        }
        this.mShortcutNumericChar = c2;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        throw new UnsupportedOperationException("Implementation should use setSupportOnActionExpandListener!");
    }

    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        this.mClickListener = onMenuItemClickListener;
        return this;
    }

    public MenuItem setShortcut(char c2, char c3) {
        this.mShortcutNumericChar = c2;
        this.mShortcutAlphabeticChar = Character.toLowerCase(c3);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    @Override
    public void setShowAsAction(int n2) {
        switch (n2 & 3) {
            default: {
                throw new IllegalArgumentException("SHOW_AS_ACTION_ALWAYS, SHOW_AS_ACTION_IF_ROOM, and SHOW_AS_ACTION_NEVER are mutually exclusive.");
            }
            case 0: 
            case 1: 
            case 2: 
        }
        this.mShowAsAction = n2;
        this.mMenu.onItemActionRequestChanged(this);
    }

    @Override
    public SupportMenuItem setShowAsActionFlags(int n2) {
        this.setShowAsAction(n2);
        return this;
    }

    void setSubMenu(SubMenuBuilder subMenuBuilder) {
        this.mSubMenu = subMenuBuilder;
        subMenuBuilder.setHeaderTitle(this.getTitle());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public SupportMenuItem setSupportActionProvider(ActionProvider actionProvider) {
        block5: {
            block4: {
                if (this.mActionProvider == actionProvider) break block4;
                this.mActionView = null;
                if (this.mActionProvider != null) {
                    this.mActionProvider.setVisibilityListener(null);
                }
                this.mActionProvider = actionProvider;
                this.mMenu.onItemsChanged(true);
                if (actionProvider != null) break block5;
            }
            return this;
        }
        actionProvider.setVisibilityListener(new ActionProvider.VisibilityListener(){

            @Override
            public void onActionProviderVisibilityChanged(boolean bl2) {
                MenuItemImpl.this.mMenu.onItemVisibleChanged(MenuItemImpl.this);
            }
        });
        return this;
    }

    @Override
    public SupportMenuItem setSupportOnActionExpandListener(MenuItemCompat.OnActionExpandListener onActionExpandListener) {
        this.mOnActionExpandListener = onActionExpandListener;
        return this;
    }

    public MenuItem setTitle(int n2) {
        return this.setTitle(this.mMenu.getContext().getString(n2));
    }

    public MenuItem setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.mMenu.onItemsChanged(false);
        if (this.mSubMenu != null) {
            this.mSubMenu.setHeaderTitle(charSequence);
        }
        return this;
    }

    public MenuItem setTitleCondensed(CharSequence charSequence) {
        this.mTitleCondensed = charSequence;
        if (charSequence == null) {
        }
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setVisible(boolean bl2) {
        if (this.setVisibleInt(bl2)) {
            this.mMenu.onItemVisibleChanged(this);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean setVisibleInt(boolean bl2) {
        int n2 = this.mFlags;
        int n3 = 0xFFFFFFF7 & this.mFlags;
        int n4 = bl2 ? 0 : 8;
        int n5 = this.mFlags = n4 | n3;
        boolean bl3 = false;
        if (n2 == n5) return bl3;
        return true;
    }

    public boolean shouldShowIcon() {
        return this.mMenu.getOptionalIconsVisible();
    }

    boolean shouldShowShortcut() {
        return this.mMenu.isShortcutsVisible() && this.getShortcut() != '\u0000';
    }

    public boolean showsTextAsAction() {
        return (4 & this.mShowAsAction) == 4;
    }

    public String toString() {
        return ((Object)this.mTitle).toString();
    }
}

