/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.view.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.internal.view.SupportMenu;
import android.support.v4.view.ActionProvider;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.menu.MenuItemImpl;
import android.support.v7.internal.view.menu.MenuPresenter;
import android.support.v7.internal.view.menu.SubMenuBuilder;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MenuBuilder
implements SupportMenu {
    private static final String ACTION_VIEW_STATES_KEY = "android:menu:actionviewstates";
    private static final String EXPANDED_ACTION_VIEW_ID = "android:menu:expandedactionview";
    private static final String PRESENTER_KEY = "android:menu:presenters";
    private static final String TAG = "MenuBuilder";
    private static final int[] sCategoryToOrder = new int[]{1, 4, 5, 3, 2, 0};
    private ArrayList<MenuItemImpl> mActionItems;
    private Callback mCallback;
    private final Context mContext;
    private ContextMenu.ContextMenuInfo mCurrentMenuInfo;
    private int mDefaultShowAsAction = 0;
    private MenuItemImpl mExpandedItem;
    Drawable mHeaderIcon;
    CharSequence mHeaderTitle;
    View mHeaderView;
    private boolean mIsActionItemsStale;
    private boolean mIsClosing = false;
    private boolean mIsVisibleItemsStale;
    private ArrayList<MenuItemImpl> mItems;
    private boolean mItemsChangedWhileDispatchPrevented = false;
    private ArrayList<MenuItemImpl> mNonActionItems;
    private boolean mOptionalIconsVisible = false;
    private CopyOnWriteArrayList<WeakReference<MenuPresenter>> mPresenters;
    private boolean mPreventDispatchingItemsChanged = false;
    private boolean mQwertyMode;
    private final Resources mResources;
    private boolean mShortcutsVisible;
    private ArrayList<MenuItemImpl> mTempShortcutItemList = new ArrayList();
    private ArrayList<MenuItemImpl> mVisibleItems;

    public MenuBuilder(Context context) {
        this.mPresenters = new CopyOnWriteArrayList();
        this.mContext = context;
        this.mResources = context.getResources();
        this.mItems = new ArrayList();
        this.mVisibleItems = new ArrayList();
        this.mIsVisibleItemsStale = true;
        this.mActionItems = new ArrayList();
        this.mNonActionItems = new ArrayList();
        this.mIsActionItemsStale = true;
        this.setShortcutsVisibleInner(true);
    }

    private MenuItem addInternal(int n2, int n3, int n4, CharSequence charSequence) {
        int n5 = MenuBuilder.getOrdering(n4);
        MenuItemImpl menuItemImpl = new MenuItemImpl(this, n2, n3, n4, n5, charSequence, this.mDefaultShowAsAction);
        if (this.mCurrentMenuInfo != null) {
            menuItemImpl.setMenuInfo(this.mCurrentMenuInfo);
        }
        this.mItems.add(MenuBuilder.findInsertIndex(this.mItems, n5), menuItemImpl);
        this.onItemsChanged(true);
        return menuItemImpl;
    }

    private void dispatchPresenterUpdate(boolean bl2) {
        if (this.mPresenters.isEmpty()) {
            return;
        }
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            menuPresenter.updateMenuView(bl2);
        }
        this.startDispatchingItemsChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchRestoreInstanceState(Bundle bundle) {
        SparseArray sparseArray = bundle.getSparseParcelableArray(PRESENTER_KEY);
        if (sparseArray != null && !this.mPresenters.isEmpty()) {
            for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
                Parcelable parcelable;
                MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
                if (menuPresenter == null) {
                    this.mPresenters.remove(weakReference);
                    continue;
                }
                int n2 = menuPresenter.getId();
                if (n2 <= 0 || (parcelable = (Parcelable)sparseArray.get(n2)) == null) continue;
                menuPresenter.onRestoreInstanceState(parcelable);
            }
        }
    }

    private void dispatchSaveInstanceState(Bundle bundle) {
        if (this.mPresenters.isEmpty()) {
            return;
        }
        SparseArray sparseArray = new SparseArray();
        for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
            Parcelable parcelable;
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            int n2 = menuPresenter.getId();
            if (n2 <= 0 || (parcelable = menuPresenter.onSaveInstanceState()) == null) continue;
            sparseArray.put(n2, (Object)parcelable);
        }
        bundle.putSparseParcelableArray(PRESENTER_KEY, sparseArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean dispatchSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        if (this.mPresenters.isEmpty()) {
            return false;
        }
        boolean bl2 = false;
        Iterator<WeakReference<MenuPresenter>> iterator = this.mPresenters.iterator();
        while (iterator.hasNext()) {
            WeakReference<MenuPresenter> weakReference = iterator.next();
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            if (bl2) continue;
            bl2 = menuPresenter.onSubMenuSelected(subMenuBuilder);
        }
        return bl2;
    }

    private static int findInsertIndex(ArrayList<MenuItemImpl> arrayList, int n2) {
        for (int i2 = -1 + arrayList.size(); i2 >= 0; --i2) {
            if (arrayList.get(i2).getOrdering() > n2) continue;
            return i2 + 1;
        }
        return 0;
    }

    private static int getOrdering(int n2) {
        int n3 = (0xFFFF0000 & n2) >> 16;
        if (n3 < 0 || n3 >= sCategoryToOrder.length) {
            throw new IllegalArgumentException("order does not contain a valid category.");
        }
        return sCategoryToOrder[n3] << 16 | 0xFFFF & n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeItemAtInt(int n2, boolean bl2) {
        block3: {
            block2: {
                if (n2 < 0 || n2 >= this.mItems.size()) break block2;
                this.mItems.remove(n2);
                if (bl2) break block3;
            }
            return;
        }
        this.onItemsChanged(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setHeaderInternal(int n2, CharSequence charSequence, int n3, Drawable drawable2, View view) {
        Resources resources = this.getResources();
        if (view != null) {
            this.mHeaderView = view;
            this.mHeaderTitle = null;
            this.mHeaderIcon = null;
        } else {
            if (n2 > 0) {
                this.mHeaderTitle = resources.getText(n2);
            } else if (charSequence != null) {
                this.mHeaderTitle = charSequence;
            }
            if (n3 > 0) {
                this.mHeaderIcon = resources.getDrawable(n3);
            } else if (drawable2 != null) {
                this.mHeaderIcon = drawable2;
            }
            this.mHeaderView = null;
        }
        this.onItemsChanged(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setShortcutsVisibleInner(boolean bl2) {
        int n2 = 1;
        if (!bl2 || this.mResources.getConfiguration().keyboard == n2 || !this.mResources.getBoolean(R.bool.abc_config_showMenuShortcutsWhenKeyboardPresent)) {
            n2 = 0;
        }
        this.mShortcutsVisible = n2;
    }

    public MenuItem add(int n2) {
        return this.addInternal(0, 0, 0, this.mResources.getString(n2));
    }

    public MenuItem add(int n2, int n3, int n4, int n5) {
        return this.addInternal(n2, n3, n4, this.mResources.getString(n5));
    }

    public MenuItem add(int n2, int n3, int n4, CharSequence charSequence) {
        return this.addInternal(n2, n3, n4, charSequence);
    }

    public MenuItem add(CharSequence charSequence) {
        return this.addInternal(0, 0, 0, charSequence);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int addIntentOptions(int n2, int n3, int n4, ComponentName componentName, Intent[] intentArray, Intent intent, int n5, MenuItem[] menuItemArray) {
        PackageManager packageManager = this.mContext.getPackageManager();
        List list = packageManager.queryIntentActivityOptions(componentName, intentArray, intent, 0);
        int n6 = list != null ? list.size() : 0;
        if ((n5 & 1) == 0) {
            this.removeGroup(n2);
        }
        int n7 = 0;
        while (n7 < n6) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(n7);
            Intent intent2 = resolveInfo.specificIndex < 0 ? intent : intentArray[resolveInfo.specificIndex];
            Intent intent3 = new Intent(intent2);
            intent3.setComponent(new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name));
            MenuItem menuItem = this.add(n2, n3, n4, resolveInfo.loadLabel(packageManager)).setIcon(resolveInfo.loadIcon(packageManager)).setIntent(intent3);
            if (menuItemArray != null && resolveInfo.specificIndex >= 0) {
                menuItemArray[resolveInfo.specificIndex] = menuItem;
            }
            ++n7;
        }
        return n6;
    }

    public void addMenuPresenter(MenuPresenter menuPresenter) {
        this.mPresenters.add(new WeakReference<MenuPresenter>(menuPresenter));
        menuPresenter.initForMenu(this.mContext, this);
        this.mIsActionItemsStale = true;
    }

    public SubMenu addSubMenu(int n2) {
        return this.addSubMenu(0, 0, 0, this.mResources.getString(n2));
    }

    public SubMenu addSubMenu(int n2, int n3, int n4, int n5) {
        return this.addSubMenu(n2, n3, n4, this.mResources.getString(n5));
    }

    public SubMenu addSubMenu(int n2, int n3, int n4, CharSequence charSequence) {
        MenuItemImpl menuItemImpl = (MenuItemImpl)this.addInternal(n2, n3, n4, charSequence);
        SubMenuBuilder subMenuBuilder = new SubMenuBuilder(this.mContext, this, menuItemImpl);
        menuItemImpl.setSubMenu(subMenuBuilder);
        return subMenuBuilder;
    }

    public SubMenu addSubMenu(CharSequence charSequence) {
        return this.addSubMenu(0, 0, 0, charSequence);
    }

    public void changeMenuMode() {
        if (this.mCallback != null) {
            this.mCallback.onMenuModeChange(this);
        }
    }

    public void clear() {
        if (this.mExpandedItem != null) {
            this.collapseItemActionView(this.mExpandedItem);
        }
        this.mItems.clear();
        this.onItemsChanged(true);
    }

    public void clearAll() {
        this.mPreventDispatchingItemsChanged = true;
        this.clear();
        this.clearHeader();
        this.mPreventDispatchingItemsChanged = false;
        this.mItemsChangedWhileDispatchPrevented = false;
        this.onItemsChanged(true);
    }

    public void clearHeader() {
        this.mHeaderIcon = null;
        this.mHeaderTitle = null;
        this.mHeaderView = null;
        this.onItemsChanged(false);
    }

    public void close() {
        this.close(true);
    }

    final void close(boolean bl2) {
        if (this.mIsClosing) {
            return;
        }
        this.mIsClosing = true;
        for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            menuPresenter.onCloseMenu(this, bl2);
        }
        this.mIsClosing = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean collapseItemActionView(MenuItemImpl menuItemImpl) {
        if (this.mPresenters.isEmpty()) return false;
        if (this.mExpandedItem != menuItemImpl) {
            return false;
        }
        boolean bl2 = false;
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            bl2 = menuPresenter.collapseItemActionView(this, menuItemImpl);
            if (!bl2) continue;
        }
        this.startDispatchingItemsChanged();
        if (!bl2) return bl2;
        this.mExpandedItem = null;
        return bl2;
    }

    boolean dispatchMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
        return this.mCallback != null && this.mCallback.onMenuItemSelected(menuBuilder, menuItem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean expandItemActionView(MenuItemImpl menuItemImpl) {
        if (this.mPresenters.isEmpty()) {
            return false;
        }
        boolean bl2 = false;
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            bl2 = menuPresenter.expandItemActionView(this, menuItemImpl);
            if (!bl2) continue;
        }
        this.startDispatchingItemsChanged();
        if (!bl2) return bl2;
        this.mExpandedItem = menuItemImpl;
        return bl2;
    }

    public int findGroupIndex(int n2) {
        return this.findGroupIndex(n2, 0);
    }

    public int findGroupIndex(int n2, int n3) {
        int n4 = this.size();
        if (n3 < 0) {
            n3 = 0;
        }
        for (int i2 = n3; i2 < n4; ++i2) {
            if (this.mItems.get(i2).getGroupId() != n2) continue;
            return i2;
        }
        return -1;
    }

    public MenuItem findItem(int n2) {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            MenuItem menuItem;
            MenuItemImpl menuItemImpl = this.mItems.get(i2);
            if (menuItemImpl.getItemId() == n2) {
                return menuItemImpl;
            }
            if (!menuItemImpl.hasSubMenu() || (menuItem = menuItemImpl.getSubMenu().findItem(n2)) == null) continue;
            return menuItem;
        }
        return null;
    }

    public int findItemIndex(int n2) {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.mItems.get(i2).getItemId() != n2) continue;
            return i2;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    MenuItemImpl findItemWithShortcutForKey(int n2, KeyEvent keyEvent) {
        ArrayList<MenuItemImpl> arrayList = this.mTempShortcutItemList;
        arrayList.clear();
        this.findItemsWithShortcutForKey(arrayList, n2, keyEvent);
        if (!arrayList.isEmpty()) {
            int n3 = keyEvent.getMetaState();
            KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
            keyEvent.getKeyData(keyData);
            int n4 = arrayList.size();
            if (n4 == 1) {
                return arrayList.get(0);
            }
            boolean bl2 = this.isQwertyMode();
            for (int i2 = 0; i2 < n4; ++i2) {
                MenuItemImpl menuItemImpl = arrayList.get(i2);
                char c2 = bl2 ? menuItemImpl.getAlphabeticShortcut() : menuItemImpl.getNumericShortcut();
                if (!(c2 == keyData.meta[0] && (n3 & 2) == 0 || c2 == keyData.meta[2] && (n3 & 2) != 0) && (!bl2 || c2 != '\b' || n2 != 67)) continue;
                return menuItemImpl;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void findItemsWithShortcutForKey(List<MenuItemImpl> list, int n2, KeyEvent keyEvent) {
        boolean bl2 = this.isQwertyMode();
        int n3 = keyEvent.getMetaState();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        if (keyEvent.getKeyData(keyData) || n2 == 67) {
            int n4 = this.mItems.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                MenuItemImpl menuItemImpl = this.mItems.get(i2);
                if (menuItemImpl.hasSubMenu()) {
                    ((MenuBuilder)menuItemImpl.getSubMenu()).findItemsWithShortcutForKey(list, n2, keyEvent);
                }
                char c2 = bl2 ? menuItemImpl.getAlphabeticShortcut() : menuItemImpl.getNumericShortcut();
                if ((n3 & 5) != 0 || c2 == '\u0000' || c2 != keyData.meta[0] && c2 != keyData.meta[2] && (!bl2 || c2 != '\b' || n2 != 67) || !menuItemImpl.isEnabled()) continue;
                list.add(menuItemImpl);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void flagActionItems() {
        if (!this.mIsActionItemsStale) {
            return;
        }
        boolean bl2 = false;
        for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            bl2 |= menuPresenter.flagActionItems();
        }
        if (!bl2) {
            this.mActionItems.clear();
            this.mNonActionItems.clear();
            this.mNonActionItems.addAll(this.getVisibleItems());
        } else {
            this.mActionItems.clear();
            this.mNonActionItems.clear();
            ArrayList<MenuItemImpl> arrayList = this.getVisibleItems();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                MenuItemImpl menuItemImpl = arrayList.get(i2);
                if (menuItemImpl.isActionButton()) {
                    this.mActionItems.add(menuItemImpl);
                    continue;
                }
                this.mNonActionItems.add(menuItemImpl);
            }
        }
        this.mIsActionItemsStale = false;
    }

    ArrayList<MenuItemImpl> getActionItems() {
        this.flagActionItems();
        return this.mActionItems;
    }

    protected String getActionViewStatesKey() {
        return ACTION_VIEW_STATES_KEY;
    }

    public Context getContext() {
        return this.mContext;
    }

    public MenuItemImpl getExpandedItem() {
        return this.mExpandedItem;
    }

    public Drawable getHeaderIcon() {
        return this.mHeaderIcon;
    }

    public CharSequence getHeaderTitle() {
        return this.mHeaderTitle;
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    public MenuItem getItem(int n2) {
        return this.mItems.get(n2);
    }

    ArrayList<MenuItemImpl> getNonActionItems() {
        this.flagActionItems();
        return this.mNonActionItems;
    }

    boolean getOptionalIconsVisible() {
        return this.mOptionalIconsVisible;
    }

    Resources getResources() {
        return this.mResources;
    }

    public MenuBuilder getRootMenu() {
        return this;
    }

    ArrayList<MenuItemImpl> getVisibleItems() {
        if (!this.mIsVisibleItemsStale) {
            return this.mVisibleItems;
        }
        this.mVisibleItems.clear();
        int n2 = this.mItems.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MenuItemImpl menuItemImpl = this.mItems.get(i2);
            if (!menuItemImpl.isVisible()) continue;
            this.mVisibleItems.add(menuItemImpl);
        }
        this.mIsVisibleItemsStale = false;
        this.mIsActionItemsStale = true;
        return this.mVisibleItems;
    }

    public boolean hasVisibleItems() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.mItems.get(i2).isVisible()) continue;
            return true;
        }
        return false;
    }

    boolean isQwertyMode() {
        return this.mQwertyMode;
    }

    public boolean isShortcutKey(int n2, KeyEvent keyEvent) {
        return this.findItemWithShortcutForKey(n2, keyEvent) != null;
    }

    public boolean isShortcutsVisible() {
        return this.mShortcutsVisible;
    }

    void onItemActionRequestChanged(MenuItemImpl menuItemImpl) {
        this.mIsActionItemsStale = true;
        this.onItemsChanged(true);
    }

    void onItemVisibleChanged(MenuItemImpl menuItemImpl) {
        this.mIsVisibleItemsStale = true;
        this.onItemsChanged(true);
    }

    void onItemsChanged(boolean bl2) {
        if (!this.mPreventDispatchingItemsChanged) {
            if (bl2) {
                this.mIsVisibleItemsStale = true;
                this.mIsActionItemsStale = true;
            }
            this.dispatchPresenterUpdate(bl2);
            return;
        }
        this.mItemsChangedWhileDispatchPrevented = true;
    }

    public boolean performIdentifierAction(int n2, int n3) {
        return this.performItemAction(this.findItem(n2), n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean performItemAction(MenuItem menuItem, int n2) {
        MenuItemImpl menuItemImpl = (MenuItemImpl)menuItem;
        if (menuItemImpl == null) return false;
        if (!menuItemImpl.isEnabled()) {
            return false;
        }
        boolean bl2 = menuItemImpl.invoke();
        ActionProvider actionProvider = menuItemImpl.getSupportActionProvider();
        boolean bl3 = actionProvider != null && actionProvider.hasSubMenu();
        if (menuItemImpl.hasCollapsibleActionView()) {
            if (!(bl2 |= menuItemImpl.expandActionView())) return bl2;
            this.close(true);
            return bl2;
        }
        if (menuItemImpl.hasSubMenu() || bl3) {
            this.close(false);
            if (!menuItemImpl.hasSubMenu()) {
                menuItemImpl.setSubMenu(new SubMenuBuilder(this.getContext(), this, menuItemImpl));
            }
            SubMenuBuilder subMenuBuilder = (SubMenuBuilder)menuItemImpl.getSubMenu();
            if (bl3) {
                actionProvider.onPrepareSubMenu(subMenuBuilder);
            }
            if (bl2 |= this.dispatchSubMenuSelected(subMenuBuilder)) return bl2;
            this.close(true);
            return bl2;
        }
        if ((n2 & 1) != 0) return bl2;
        this.close(true);
        return bl2;
    }

    public boolean performShortcut(int n2, KeyEvent keyEvent, int n3) {
        MenuItemImpl menuItemImpl = this.findItemWithShortcutForKey(n2, keyEvent);
        boolean bl2 = false;
        if (menuItemImpl != null) {
            bl2 = this.performItemAction(menuItemImpl, n3);
        }
        if ((n3 & 2) != 0) {
            this.close(true);
        }
        return bl2;
    }

    public void removeGroup(int n2) {
        int n3 = this.findGroupIndex(n2);
        if (n3 >= 0) {
            int n4 = this.mItems.size() - n3;
            int n5 = 0;
            while (true) {
                int n6 = n5 + 1;
                if (n5 >= n4 || this.mItems.get(n3).getGroupId() != n2) break;
                this.removeItemAtInt(n3, false);
                n5 = n6;
            }
            this.onItemsChanged(true);
        }
    }

    public void removeItem(int n2) {
        this.removeItemAtInt(this.findItemIndex(n2), true);
    }

    public void removeItemAt(int n2) {
        this.removeItemAtInt(n2, true);
    }

    public void removeMenuPresenter(MenuPresenter menuPresenter) {
        for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
            MenuPresenter menuPresenter2 = (MenuPresenter)weakReference.get();
            if (menuPresenter2 != null && menuPresenter2 != menuPresenter) continue;
            this.mPresenters.remove(weakReference);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void restoreActionViewStates(Bundle bundle) {
        MenuItem menuItem;
        block6: {
            block5: {
                if (bundle == null) break block5;
                SparseArray sparseArray = bundle.getSparseParcelableArray(this.getActionViewStatesKey());
                int n2 = this.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    MenuItem menuItem2 = this.getItem(i2);
                    View view = MenuItemCompat.getActionView(menuItem2);
                    if (view != null && view.getId() != -1) {
                        view.restoreHierarchyState(sparseArray);
                    }
                    if (!menuItem2.hasSubMenu()) continue;
                    ((SubMenuBuilder)menuItem2.getSubMenu()).restoreActionViewStates(bundle);
                }
                int n3 = bundle.getInt(EXPANDED_ACTION_VIEW_ID);
                if (n3 > 0 && (menuItem = this.findItem(n3)) != null) break block6;
            }
            return;
        }
        MenuItemCompat.expandActionView(menuItem);
    }

    public void restorePresenterStates(Bundle bundle) {
        this.dispatchRestoreInstanceState(bundle);
    }

    public void saveActionViewStates(Bundle bundle) {
        SparseArray sparseArray = null;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MenuItem menuItem = this.getItem(i2);
            View view = MenuItemCompat.getActionView(menuItem);
            if (view != null && view.getId() != -1) {
                if (sparseArray == null) {
                    sparseArray = new SparseArray();
                }
                view.saveHierarchyState(sparseArray);
                if (MenuItemCompat.isActionViewExpanded(menuItem)) {
                    bundle.putInt(EXPANDED_ACTION_VIEW_ID, menuItem.getItemId());
                }
            }
            if (!menuItem.hasSubMenu()) continue;
            ((SubMenuBuilder)menuItem.getSubMenu()).saveActionViewStates(bundle);
        }
        if (sparseArray != null) {
            bundle.putSparseParcelableArray(this.getActionViewStatesKey(), sparseArray);
        }
    }

    public void savePresenterStates(Bundle bundle) {
        this.dispatchSaveInstanceState(bundle);
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setCurrentMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mCurrentMenuInfo = contextMenuInfo;
    }

    public MenuBuilder setDefaultShowAsAction(int n2) {
        this.mDefaultShowAsAction = n2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setExclusiveItemChecked(MenuItem menuItem) {
        int n2 = menuItem.getGroupId();
        int n3 = this.mItems.size();
        int n4 = 0;
        while (n4 < n3) {
            MenuItemImpl menuItemImpl = this.mItems.get(n4);
            if (menuItemImpl.getGroupId() == n2 && menuItemImpl.isExclusiveCheckable() && menuItemImpl.isCheckable()) {
                boolean bl2 = menuItemImpl == menuItem;
                menuItemImpl.setCheckedInt(bl2);
            }
            ++n4;
        }
        return;
    }

    public void setGroupCheckable(int n2, boolean bl2, boolean bl3) {
        int n3 = this.mItems.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            MenuItemImpl menuItemImpl = this.mItems.get(i2);
            if (menuItemImpl.getGroupId() != n2) continue;
            menuItemImpl.setExclusiveCheckable(bl3);
            menuItemImpl.setCheckable(bl2);
        }
    }

    public void setGroupEnabled(int n2, boolean bl2) {
        int n3 = this.mItems.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            MenuItemImpl menuItemImpl = this.mItems.get(i2);
            if (menuItemImpl.getGroupId() != n2) continue;
            menuItemImpl.setEnabled(bl2);
        }
    }

    public void setGroupVisible(int n2, boolean bl2) {
        int n3 = this.mItems.size();
        boolean bl3 = false;
        for (int i2 = 0; i2 < n3; ++i2) {
            MenuItemImpl menuItemImpl = this.mItems.get(i2);
            if (menuItemImpl.getGroupId() != n2 || !menuItemImpl.setVisibleInt(bl2)) continue;
            bl3 = true;
        }
        if (bl3) {
            this.onItemsChanged(true);
        }
    }

    protected MenuBuilder setHeaderIconInt(int n2) {
        this.setHeaderInternal(0, null, n2, null, null);
        return this;
    }

    protected MenuBuilder setHeaderIconInt(Drawable drawable2) {
        this.setHeaderInternal(0, null, 0, drawable2, null);
        return this;
    }

    protected MenuBuilder setHeaderTitleInt(int n2) {
        this.setHeaderInternal(n2, null, 0, null, null);
        return this;
    }

    protected MenuBuilder setHeaderTitleInt(CharSequence charSequence) {
        this.setHeaderInternal(0, charSequence, 0, null, null);
        return this;
    }

    protected MenuBuilder setHeaderViewInt(View view) {
        this.setHeaderInternal(0, null, 0, null, view);
        return this;
    }

    void setOptionalIconsVisible(boolean bl2) {
        this.mOptionalIconsVisible = bl2;
    }

    public void setQwertyMode(boolean bl2) {
        this.mQwertyMode = bl2;
        this.onItemsChanged(false);
    }

    public void setShortcutsVisible(boolean bl2) {
        if (this.mShortcutsVisible == bl2) {
            return;
        }
        this.setShortcutsVisibleInner(bl2);
        this.onItemsChanged(false);
    }

    public int size() {
        return this.mItems.size();
    }

    public void startDispatchingItemsChanged() {
        this.mPreventDispatchingItemsChanged = false;
        if (this.mItemsChangedWhileDispatchPrevented) {
            this.mItemsChangedWhileDispatchPrevented = false;
            this.onItemsChanged(true);
        }
    }

    public void stopDispatchingItemsChanged() {
        if (!this.mPreventDispatchingItemsChanged) {
            this.mPreventDispatchingItemsChanged = true;
            this.mItemsChangedWhileDispatchPrevented = false;
        }
    }

    public static interface Callback {
        public boolean onMenuItemSelected(MenuBuilder var1, MenuItem var2);

        public void onMenuModeChange(MenuBuilder var1);
    }

    public static interface ItemInvoker {
        public boolean invokeItem(MenuItemImpl var1);
    }
}

