/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.view.menu;

import android.support.v4.internal.view.SupportMenuItem;
import android.support.v7.internal.view.menu.BaseWrapper;
import android.support.v7.internal.view.menu.MenuWrapperFactory;
import android.view.MenuItem;
import android.view.SubMenu;
import java.util.HashMap;
import java.util.Iterator;

abstract class BaseMenuWrapper<T>
extends BaseWrapper<T> {
    private HashMap<MenuItem, SupportMenuItem> mMenuItems;
    private HashMap<SubMenu, SubMenu> mSubMenus;

    BaseMenuWrapper(T t2) {
        super(t2);
    }

    final SupportMenuItem getMenuItemWrapper(MenuItem menuItem) {
        if (menuItem != null) {
            SupportMenuItem supportMenuItem;
            if (this.mMenuItems == null) {
                this.mMenuItems = new HashMap();
            }
            if ((supportMenuItem = this.mMenuItems.get(menuItem)) == null) {
                supportMenuItem = MenuWrapperFactory.createSupportMenuItemWrapper(menuItem);
                this.mMenuItems.put(menuItem, supportMenuItem);
            }
            return supportMenuItem;
        }
        return null;
    }

    final SubMenu getSubMenuWrapper(SubMenu subMenu) {
        if (subMenu != null) {
            SubMenu subMenu2;
            if (this.mSubMenus == null) {
                this.mSubMenus = new HashMap();
            }
            if ((subMenu2 = this.mSubMenus.get(subMenu)) == null) {
                subMenu2 = MenuWrapperFactory.createSupportSubMenuWrapper(subMenu);
                this.mSubMenus.put(subMenu, subMenu2);
            }
            return subMenu2;
        }
        return null;
    }

    final void internalClear() {
        if (this.mMenuItems != null) {
            this.mMenuItems.clear();
        }
        if (this.mSubMenus != null) {
            this.mSubMenus.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void internalRemoveGroup(int n2) {
        if (this.mMenuItems != null) {
            Iterator<MenuItem> iterator = this.mMenuItems.keySet().iterator();
            while (iterator.hasNext()) {
                if (n2 != iterator.next().getGroupId()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    final void internalRemoveItem(int n2) {
        if (this.mMenuItems == null) {
            return;
        }
        Iterator<MenuItem> iterator = this.mMenuItems.keySet().iterator();
        do {
            if (!iterator.hasNext()) return;
        } while (n2 != iterator.next().getItemId());
        iterator.remove();
    }
}

