/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.menu.ActionMenuItemView;
import android.support.v7.internal.view.menu.ActionMenuPresenter;
import android.support.v7.internal.view.menu.MenuBuilder;
import android.support.v7.internal.view.menu.MenuItemImpl;
import android.support.v7.internal.view.menu.MenuView;
import android.support.v7.internal.widget.LinearLayoutICS;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.LinearLayout;

public class ActionMenuView
extends LinearLayoutICS
implements MenuBuilder.ItemInvoker,
MenuView {
    static final int GENERATED_ITEM_PADDING = 4;
    static final int MIN_CELL_SIZE = 56;
    private static final String TAG = "ActionMenuView";
    private boolean mFormatItems;
    private int mFormatItemsWidth;
    private int mGeneratedItemPadding;
    private int mMaxItemHeight;
    private int mMeasuredExtraWidth;
    private MenuBuilder mMenu;
    private int mMinCellSize;
    private ActionMenuPresenter mPresenter;
    private boolean mReserveOverflow;

    public ActionMenuView(Context context) {
        this(context, null);
    }

    public ActionMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setBaselineAligned(false);
        float f2 = context.getResources().getDisplayMetrics().density;
        this.mMinCellSize = (int)(56.0f * f2);
        this.mGeneratedItemPadding = (int)(4.0f * f2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ActionBar, R.attr.actionBarStyle, 0);
        this.mMaxItemHeight = typedArray.getDimensionPixelSize(0, 0);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    static int measureChildForCells(View view, int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl2;
        int n7;
        LayoutParams layoutParams;
        block5: {
            block6: {
                layoutParams = (LayoutParams)view.getLayoutParams();
                n7 = View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)n4) - n5), (int)View.MeasureSpec.getMode((int)n4));
                ActionMenuItemView actionMenuItemView = view instanceof ActionMenuItemView ? (ActionMenuItemView)view : null;
                bl2 = actionMenuItemView != null && actionMenuItemView.hasText();
                n6 = 0;
                if (n3 <= 0) break block5;
                if (!bl2) break block6;
                n6 = 0;
                if (n3 < 2) break block5;
            }
            view.measure(View.MeasureSpec.makeMeasureSpec((int)(n2 * n3), (int)Integer.MIN_VALUE), n7);
            int n8 = view.getMeasuredWidth();
            n6 = n8 / n2;
            if (n8 % n2 != 0) {
                ++n6;
            }
            if (bl2 && n6 < 2) {
                n6 = 2;
            }
        }
        boolean bl3 = !layoutParams.isOverflowButton && bl2;
        layoutParams.expandable = bl3;
        layoutParams.cellsUsed = n6;
        view.measure(View.MeasureSpec.makeMeasureSpec((int)(n6 * n2), (int)0x40000000), n7);
        return n6;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onMeasureExactFormat(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        block22: {
            n9 = View.MeasureSpec.getMode((int)n3);
            int n10 = View.MeasureSpec.getSize((int)n2);
            n8 = View.MeasureSpec.getSize((int)n3);
            int n11 = this.getPaddingLeft() + this.getPaddingRight();
            int n12 = this.getPaddingTop() + this.getPaddingBottom();
            int n13 = n9 == 0x40000000 ? View.MeasureSpec.makeMeasureSpec((int)(n8 - n12), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)Math.min(this.mMaxItemHeight, n8 - n12), (int)Integer.MIN_VALUE);
            n7 = n10 - n11;
            int n14 = n7 / this.mMinCellSize;
            int n15 = n7 % this.mMinCellSize;
            if (n14 == 0) {
                this.setMeasuredDimension(n7, 0);
                return;
            }
            n6 = this.mMinCellSize + n15 / n14;
            n5 = n14;
            n4 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            boolean bl2 = false;
            long l2 = 0L;
            int n19 = this.getChildCount();
            for (int i2 = 0; i2 < n19; ++i2) {
                View view = this.getChildAt(i2);
                if (view.getVisibility() == 8) continue;
                boolean bl3 = view instanceof ActionMenuItemView;
                ++n18;
                if (bl3) {
                    view.setPadding(this.mGeneratedItemPadding, 0, this.mGeneratedItemPadding, 0);
                }
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                layoutParams.expanded = false;
                layoutParams.extraPixels = 0;
                layoutParams.cellsUsed = 0;
                layoutParams.expandable = false;
                layoutParams.leftMargin = 0;
                layoutParams.rightMargin = 0;
                boolean bl4 = bl3 && ((ActionMenuItemView)view).hasText();
                layoutParams.preventEdgeOffset = bl4;
                int n20 = layoutParams.isOverflowButton ? 1 : n5;
                int n21 = ActionMenuView.measureChildForCells(view, n6, n20, n13, n12);
                n16 = Math.max(n16, n21);
                if (layoutParams.expandable) {
                    ++n17;
                }
                if (layoutParams.isOverflowButton) {
                    bl2 = true;
                }
                n5 -= n21;
                int n22 = view.getMeasuredHeight();
                n4 = Math.max(n4, n22);
                if (n21 != 1) continue;
                l2 |= (long)(1 << i2);
            }
            boolean bl5 = bl2 && n18 == 2;
            boolean bl6 = false;
            while (true) {
                int n23;
                long l3;
                block27: {
                    block25: {
                        int n24;
                        block26: {
                            int n25;
                            block24: {
                                block23: {
                                    if (n17 <= 0 || n5 <= 0) break block23;
                                    n25 = Integer.MAX_VALUE;
                                    l3 = 0L;
                                    int n26 = 0;
                                    for (int i3 = 0; i3 < n19; ++i3) {
                                        LayoutParams layoutParams = (LayoutParams)this.getChildAt(i3).getLayoutParams();
                                        if (!layoutParams.expandable) continue;
                                        if (layoutParams.cellsUsed < n25) {
                                            n25 = layoutParams.cellsUsed;
                                            l3 = 1 << i3;
                                            n26 = 1;
                                            continue;
                                        }
                                        if (layoutParams.cellsUsed != n25) continue;
                                        l3 |= (long)(1 << i3);
                                        ++n26;
                                    }
                                    l2 |= l3;
                                    if (n26 <= n5) break block24;
                                }
                                boolean bl7 = !bl2 && n18 == 1;
                                if (n5 <= 0 || l2 == 0L || n5 >= n18 - 1 && !bl7 && n16 <= true) break block25;
                                float f2 = Long.bitCount(l2);
                                if (!bl7) {
                                    if ((1L & l2) != 0L && !((LayoutParams)this.getChildAt((int)0).getLayoutParams()).preventEdgeOffset) {
                                        f2 -= 0.5f;
                                    }
                                    if ((l2 & (long)(1 << n19 - 1)) != 0L && !((LayoutParams)this.getChildAt((int)(n19 - 1)).getLayoutParams()).preventEdgeOffset) {
                                        f2 -= 0.5f;
                                    }
                                }
                                n24 = f2 > 0.0f ? (int)((float)(n5 * n6) / f2) : 0;
                                break block26;
                            }
                            n23 = n25 + 1;
                            break block27;
                        }
                        for (int i4 = 0; i4 < n19; ++i4) {
                            int n27;
                            if ((l2 & (long)(1 << i4)) == 0L) continue;
                            View view = this.getChildAt(i4);
                            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                            if (view instanceof ActionMenuItemView) {
                                layoutParams.extraPixels = n24;
                                layoutParams.expanded = true;
                                if (i4 == 0 && !layoutParams.preventEdgeOffset) {
                                    layoutParams.leftMargin = -n24 / 2;
                                }
                                bl6 = true;
                                continue;
                            }
                            if (layoutParams.isOverflowButton) {
                                layoutParams.extraPixels = n24;
                                layoutParams.expanded = true;
                                layoutParams.rightMargin = -n24 / 2;
                                bl6 = true;
                                continue;
                            }
                            if (i4 != 0) {
                                layoutParams.leftMargin = n24 / 2;
                            }
                            if (i4 == (n27 = n19 - 1)) continue;
                            layoutParams.rightMargin = n24 / 2;
                        }
                        n5 = 0;
                    }
                    if (bl6) {
                        break;
                    }
                    break block22;
                }
                for (int i5 = 0; i5 < n19; ++i5) {
                    View view = this.getChildAt(i5);
                    LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                    if ((l3 & (long)(1 << i5)) == 0L) {
                        if (layoutParams.cellsUsed != n23) continue;
                        l2 |= (long)(1 << i5);
                        continue;
                    }
                    if (bl5 && layoutParams.preventEdgeOffset && n5 == 1) {
                        view.setPadding(n6 + this.mGeneratedItemPadding, 0, this.mGeneratedItemPadding, 0);
                    }
                    layoutParams.cellsUsed = 1 + layoutParams.cellsUsed;
                    layoutParams.expanded = true;
                    --n5;
                }
                bl6 = true;
            }
            for (int i6 = 0; i6 < n19; ++i6) {
                View view = this.getChildAt(i6);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (!layoutParams.expanded) continue;
                view.measure(View.MeasureSpec.makeMeasureSpec((int)(n6 * layoutParams.cellsUsed + layoutParams.extraPixels), (int)0x40000000), n13);
            }
        }
        if (n9 != 0x40000000) {
            n8 = n4;
        }
        this.setMeasuredDimension(n7, n8);
        this.mMeasuredExtraWidth = n5 * n6;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams != null && layoutParams instanceof LayoutParams;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return false;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        LayoutParams layoutParams = new LayoutParams(-2, -2);
        layoutParams.gravity = 16;
        return layoutParams;
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LayoutParams) {
            LayoutParams layoutParams2 = new LayoutParams((LayoutParams)layoutParams);
            if (layoutParams2.gravity <= 0) {
                layoutParams2.gravity = 16;
            }
            return layoutParams2;
        }
        return this.generateDefaultLayoutParams();
    }

    public LayoutParams generateOverflowButtonLayoutParams() {
        LayoutParams layoutParams = this.generateDefaultLayoutParams();
        layoutParams.isOverflowButton = true;
        return layoutParams;
    }

    @Override
    public int getWindowAnimations() {
        return 0;
    }

    @Override
    protected boolean hasSupportDividerBeforeChildAt(int n2) {
        View view = this.getChildAt(n2 - 1);
        View view2 = this.getChildAt(n2);
        int n3 = this.getChildCount();
        boolean bl2 = false;
        if (n2 < n3) {
            boolean bl3 = view instanceof ActionMenuChildView;
            bl2 = false;
            if (bl3) {
                bl2 = false | ((ActionMenuChildView)view).needsDividerAfter();
            }
        }
        if (n2 > 0 && view2 instanceof ActionMenuChildView) {
            bl2 |= ((ActionMenuChildView)view2).needsDividerBefore();
        }
        return bl2;
    }

    @Override
    public void initialize(MenuBuilder menuBuilder) {
        this.mMenu = menuBuilder;
    }

    @Override
    public boolean invokeItem(MenuItemImpl menuItemImpl) {
        return this.mMenu.performItemAction(menuItemImpl, 0);
    }

    public boolean isExpandedFormat() {
        return this.mFormatItems;
    }

    public boolean isOverflowReserved() {
        return this.mReserveOverflow;
    }

    public void onConfigurationChanged(Configuration configuration) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onConfigurationChanged(configuration);
        }
        this.mPresenter.updateMenuView(false);
        if (this.mPresenter != null && this.mPresenter.isOverflowMenuShowing()) {
            this.mPresenter.hideOverflowMenu();
            this.mPresenter.showOverflowMenu();
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mPresenter.dismissPopupMenus();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        if (!this.mFormatItems) {
            super.onLayout(bl2, n2, n3, n4, n5);
            return;
        }
        int n6 = this.getChildCount();
        int n7 = (n3 + n5) / 2;
        int n8 = this.getSupportDividerWidth();
        int n9 = 0;
        int n10 = 0;
        int n11 = n4 - n2 - this.getPaddingRight() - this.getPaddingLeft();
        boolean bl3 = false;
        for (int i2 = 0; i2 < n6; ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.isOverflowButton) {
                int n12 = view.getMeasuredWidth();
                if (this.hasSupportDividerBeforeChildAt(i2)) {
                    n12 += n8;
                }
                int n13 = view.getMeasuredHeight();
                int n14 = this.getWidth() - this.getPaddingRight() - layoutParams.rightMargin;
                int n15 = n14 - n12;
                int n16 = n7 - n13 / 2;
                view.layout(n15, n16, n14, n16 + n13);
                n11 -= n12;
                bl3 = true;
                continue;
            }
            int n17 = view.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
            n9 += n17;
            n11 -= n17;
            if (this.hasSupportDividerBeforeChildAt(i2)) {
                n9 += n8;
            }
            ++n10;
        }
        if (n6 == 1 && !bl3) {
            View view = this.getChildAt(0);
            int n18 = view.getMeasuredWidth();
            int n19 = view.getMeasuredHeight();
            int n20 = (n4 - n2) / 2 - n18 / 2;
            int n21 = n7 - n19 / 2;
            view.layout(n20, n21, n20 + n18, n21 + n19);
            return;
        }
        int n22 = bl3 ? 0 : 1;
        int n23 = n10 - n22;
        int n24 = n23 > 0 ? n11 / n23 : 0;
        int n25 = Math.max(0, n24);
        int n26 = this.getPaddingLeft();
        int n27 = 0;
        while (n27 < n6) {
            View view = this.getChildAt(n27);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (view.getVisibility() != 8 && !layoutParams.isOverflowButton) {
                int n28 = n26 + layoutParams.leftMargin;
                int n29 = view.getMeasuredWidth();
                int n30 = view.getMeasuredHeight();
                int n31 = n7 - n30 / 2;
                view.layout(n28, n31, n28 + n29, n31 + n30);
                n26 = n28 + (n25 + (n29 + layoutParams.rightMargin));
            }
            ++n27;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        boolean bl2 = this.mFormatItems;
        boolean bl3 = View.MeasureSpec.getMode((int)n2) == 0x40000000;
        this.mFormatItems = bl3;
        if (bl2 != this.mFormatItems) {
            this.mFormatItemsWidth = 0;
        }
        int n4 = View.MeasureSpec.getMode((int)n2);
        if (this.mFormatItems && this.mMenu != null && n4 != this.mFormatItemsWidth) {
            this.mFormatItemsWidth = n4;
            this.mMenu.onItemsChanged(true);
        }
        if (this.mFormatItems) {
            this.onMeasureExactFormat(n2, n3);
            return;
        }
        int n5 = this.getChildCount();
        int n6 = 0;
        while (true) {
            if (n6 >= n5) {
                super.onMeasure(n2, n3);
                return;
            }
            LayoutParams layoutParams = (LayoutParams)this.getChildAt(n6).getLayoutParams();
            layoutParams.rightMargin = 0;
            layoutParams.leftMargin = 0;
            ++n6;
        }
    }

    public void setOverflowReserved(boolean bl2) {
        this.mReserveOverflow = bl2;
    }

    public void setPresenter(ActionMenuPresenter actionMenuPresenter) {
        this.mPresenter = actionMenuPresenter;
    }

    public static interface ActionMenuChildView {
        public boolean needsDividerAfter();

        public boolean needsDividerBefore();
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        @ViewDebug.ExportedProperty
        public int cellsUsed;
        @ViewDebug.ExportedProperty
        public boolean expandable;
        public boolean expanded;
        @ViewDebug.ExportedProperty
        public int extraPixels;
        @ViewDebug.ExportedProperty
        public boolean isOverflowButton;
        @ViewDebug.ExportedProperty
        public boolean preventEdgeOffset;

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
            this.isOverflowButton = false;
        }

        public LayoutParams(int n2, int n3, boolean bl2) {
            super(n2, n3);
            this.isOverflowButton = bl2;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((LinearLayout.LayoutParams)layoutParams);
            this.isOverflowButton = layoutParams.isOverflowButton;
        }
    }
}

