/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.view.menu;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ActionProvider;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.ActionBarPolicy;
import android.support.v7.internal.view.menu.ActionMenuItemView;
import android.support.v7.internal.view.menu.ActionMenuView;
import android.support.v7.internal.view.menu.BaseMenuPresenter;
import android.support.v7.internal.view.menu.MenuBuilder;
import android.support.v7.internal.view.menu.MenuDialogHelper;
import android.support.v7.internal.view.menu.MenuItemImpl;
import android.support.v7.internal.view.menu.MenuPopupHelper;
import android.support.v7.internal.view.menu.MenuPresenter;
import android.support.v7.internal.view.menu.MenuView;
import android.support.v7.internal.view.menu.SubMenuBuilder;
import android.util.SparseBooleanArray;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import java.util.ArrayList;

public class ActionMenuPresenter
extends BaseMenuPresenter
implements ActionProvider.SubUiVisibilityListener {
    private static final String TAG = "ActionMenuPresenter";
    private final SparseBooleanArray mActionButtonGroups = new SparseBooleanArray();
    private ActionButtonSubmenu mActionButtonPopup;
    private int mActionItemWidthLimit;
    private boolean mExpandedActionViewsExclusive;
    private int mMaxItems;
    private boolean mMaxItemsSet;
    private int mMinCellSize;
    int mOpenSubMenuId;
    private View mOverflowButton;
    private OverflowPopup mOverflowPopup;
    final PopupPresenterCallback mPopupPresenterCallback = new PopupPresenterCallback();
    private OpenOverflowRunnable mPostedOpenRunnable;
    private boolean mReserveOverflow;
    private boolean mReserveOverflowSet;
    private View mScrapActionButtonView;
    private boolean mStrictWidthLimit;
    private int mWidthLimit;
    private boolean mWidthLimitSet;

    public ActionMenuPresenter(Context context) {
        super(context, R.layout.abc_action_menu_layout, R.layout.abc_action_menu_item_layout);
    }

    static /* synthetic */ OverflowPopup access$102(ActionMenuPresenter actionMenuPresenter, OverflowPopup overflowPopup) {
        actionMenuPresenter.mOverflowPopup = overflowPopup;
        return overflowPopup;
    }

    static /* synthetic */ ActionButtonSubmenu access$202(ActionMenuPresenter actionMenuPresenter, ActionButtonSubmenu actionButtonSubmenu) {
        actionMenuPresenter.mActionButtonPopup = actionButtonSubmenu;
        return actionButtonSubmenu;
    }

    static /* synthetic */ OpenOverflowRunnable access$302(ActionMenuPresenter actionMenuPresenter, OpenOverflowRunnable openOverflowRunnable) {
        actionMenuPresenter.mPostedOpenRunnable = openOverflowRunnable;
        return openOverflowRunnable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View findViewForItem(MenuItem menuItem) {
        ViewGroup viewGroup = (ViewGroup)this.mMenuView;
        if (viewGroup == null) {
            return null;
        }
        int n2 = viewGroup.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = viewGroup.getChildAt(n3);
            if (view instanceof MenuView.ItemView) {
                if (((MenuView.ItemView)view).getItemData() == menuItem) return view;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public void bindItemView(MenuItemImpl menuItemImpl, MenuView.ItemView itemView) {
        itemView.initialize(menuItemImpl, 0);
        ActionMenuView actionMenuView = (ActionMenuView)this.mMenuView;
        ((ActionMenuItemView)itemView).setItemInvoker(actionMenuView);
    }

    public boolean dismissPopupMenus() {
        return this.hideOverflowMenu() | this.hideSubMenus();
    }

    @Override
    public boolean filterLeftoverView(ViewGroup viewGroup, int n2) {
        if (viewGroup.getChildAt(n2) == this.mOverflowButton) {
            return false;
        }
        return super.filterLeftoverView(viewGroup, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean flagActionItems() {
        ArrayList<MenuItemImpl> arrayList = this.mMenu.getVisibleItems();
        int n2 = arrayList.size();
        int n3 = this.mMaxItems;
        int n4 = this.mActionItemWidthLimit;
        int n5 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        ViewGroup viewGroup = (ViewGroup)this.mMenuView;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            MenuItemImpl menuItemImpl = arrayList.get(i2);
            if (menuItemImpl.requiresActionButton()) {
                ++n6;
            } else if (menuItemImpl.requestsActionButton()) {
                ++n7;
            } else {
                bl2 = true;
            }
            if (!this.mExpandedActionViewsExclusive || !menuItemImpl.isActionViewExpanded()) continue;
            n3 = 0;
        }
        if (this.mReserveOverflow && (bl2 || n6 + n7 > n3)) {
            --n3;
        }
        int n9 = n3 - n6;
        SparseBooleanArray sparseBooleanArray = this.mActionButtonGroups;
        sparseBooleanArray.clear();
        boolean bl3 = this.mStrictWidthLimit;
        int n10 = 0;
        int n11 = 0;
        if (bl3) {
            n11 = n4 / this.mMinCellSize;
            int n12 = n4 % this.mMinCellSize;
            n10 = this.mMinCellSize + n12 / n11;
        }
        int n13 = 0;
        while (n13 < n2) {
            MenuItemImpl menuItemImpl = arrayList.get(n13);
            if (menuItemImpl.requiresActionButton()) {
                int n14;
                View view = this.getItemView(menuItemImpl, this.mScrapActionButtonView, viewGroup);
                if (this.mScrapActionButtonView == null) {
                    this.mScrapActionButtonView = view;
                }
                if (this.mStrictWidthLimit) {
                    n11 -= ActionMenuView.measureChildForCells(view, n10, n11, n5, 0);
                } else {
                    view.measure(n5, n5);
                }
                int n15 = view.getMeasuredWidth();
                n4 -= n15;
                if (n8 == 0) {
                    n8 = n15;
                }
                if ((n14 = menuItemImpl.getGroupId()) != 0) {
                    sparseBooleanArray.put(n14, true);
                }
                menuItemImpl.setIsActionButton(true);
            } else if (menuItemImpl.requestsActionButton()) {
                int n16 = menuItemImpl.getGroupId();
                boolean bl4 = sparseBooleanArray.get(n16);
                boolean bl5 = !(n9 <= 0 && !bl4 || n4 <= 0 || this.mStrictWidthLimit && n11 <= 0);
                if (bl5) {
                    View view = this.getItemView(menuItemImpl, this.mScrapActionButtonView, viewGroup);
                    if (this.mScrapActionButtonView == null) {
                        this.mScrapActionButtonView = view;
                    }
                    if (this.mStrictWidthLimit) {
                        int n17 = ActionMenuView.measureChildForCells(view, n10, n11, n5, 0);
                        n11 -= n17;
                        if (n17 == 0) {
                            bl5 = false;
                        }
                    } else {
                        view.measure(n5, n5);
                    }
                    int n18 = view.getMeasuredWidth();
                    n4 -= n18;
                    if (n8 == 0) {
                        n8 = n18;
                    }
                    if (this.mStrictWidthLimit) {
                        boolean bl6 = n4 >= 0;
                        bl5 &= bl6;
                    } else {
                        boolean bl7 = n4 + n8 > 0;
                        bl5 &= bl7;
                    }
                }
                if (bl5 && n16 != 0) {
                    sparseBooleanArray.put(n16, true);
                } else if (bl4) {
                    sparseBooleanArray.put(n16, false);
                    for (int i3 = 0; i3 < n13; ++i3) {
                        MenuItemImpl menuItemImpl2 = arrayList.get(i3);
                        if (menuItemImpl2.getGroupId() != n16) continue;
                        if (menuItemImpl2.isActionButton()) {
                            ++n9;
                        }
                        menuItemImpl2.setIsActionButton(false);
                    }
                }
                if (bl5) {
                    --n9;
                }
                menuItemImpl.setIsActionButton(bl5);
            }
            ++n13;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getItemView(MenuItemImpl menuItemImpl, View view, ViewGroup viewGroup) {
        View view2 = menuItemImpl.getActionView();
        if (view2 == null || menuItemImpl.hasCollapsibleActionView()) {
            if (!(view instanceof ActionMenuItemView)) {
                view = null;
            }
            view2 = super.getItemView(menuItemImpl, view, viewGroup);
        }
        int n2 = menuItemImpl.isActionViewExpanded() ? 8 : 0;
        view2.setVisibility(n2);
        ActionMenuView actionMenuView = (ActionMenuView)viewGroup;
        ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
        if (!actionMenuView.checkLayoutParams(layoutParams)) {
            view2.setLayoutParams((ViewGroup.LayoutParams)actionMenuView.generateLayoutParams(layoutParams));
        }
        return view2;
    }

    @Override
    public MenuView getMenuView(ViewGroup viewGroup) {
        MenuView menuView = super.getMenuView(viewGroup);
        ((ActionMenuView)menuView).setPresenter(this);
        return menuView;
    }

    public boolean hideOverflowMenu() {
        if (this.mPostedOpenRunnable != null && this.mMenuView != null) {
            ((View)this.mMenuView).removeCallbacks((Runnable)this.mPostedOpenRunnable);
            this.mPostedOpenRunnable = null;
            return true;
        }
        OverflowPopup overflowPopup = this.mOverflowPopup;
        if (overflowPopup != null) {
            overflowPopup.dismiss();
            return true;
        }
        return false;
    }

    public boolean hideSubMenus() {
        if (this.mActionButtonPopup != null) {
            this.mActionButtonPopup.dismiss();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initForMenu(Context context, MenuBuilder menuBuilder) {
        super.initForMenu(context, menuBuilder);
        Resources resources = context.getResources();
        ActionBarPolicy actionBarPolicy = ActionBarPolicy.get(context);
        if (!this.mReserveOverflowSet) {
            this.mReserveOverflow = actionBarPolicy.showsOverflowMenuButton();
        }
        if (!this.mWidthLimitSet) {
            this.mWidthLimit = actionBarPolicy.getEmbeddedMenuWidthLimit();
        }
        if (!this.mMaxItemsSet) {
            this.mMaxItems = actionBarPolicy.getMaxActionButtons();
        }
        int n2 = this.mWidthLimit;
        if (this.mReserveOverflow) {
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this.mSystemContext);
                int n3 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                this.mOverflowButton.measure(n3, n3);
            }
            n2 -= this.mOverflowButton.getMeasuredWidth();
        } else {
            this.mOverflowButton = null;
        }
        this.mActionItemWidthLimit = n2;
        this.mMinCellSize = (int)(56.0f * resources.getDisplayMetrics().density);
        this.mScrapActionButtonView = null;
    }

    public boolean isOverflowMenuShowing() {
        return this.mOverflowPopup != null && this.mOverflowPopup.isShowing();
    }

    public boolean isOverflowReserved() {
        return this.mReserveOverflow;
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl2) {
        this.dismissPopupMenus();
        super.onCloseMenu(menuBuilder, bl2);
    }

    public void onConfigurationChanged(Configuration configuration) {
        if (!this.mMaxItemsSet) {
            this.mMaxItems = this.mContext.getResources().getInteger(R.integer.abc_max_action_buttons);
        }
        if (this.mMenu != null) {
            this.mMenu.onItemsChanged(true);
        }
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        MenuItem menuItem;
        SavedState savedState = (SavedState)parcelable;
        if (savedState.openSubMenuId > 0 && (menuItem = this.mMenu.findItem(savedState.openSubMenuId)) != null) {
            this.onSubMenuSelected((SubMenuBuilder)menuItem.getSubMenu());
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState();
        savedState.openSubMenuId = this.mOpenSubMenuId;
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        block4: {
            block3: {
                if (!subMenuBuilder.hasVisibleItems()) break block3;
                SubMenuBuilder subMenuBuilder2 = subMenuBuilder;
                while (subMenuBuilder2.getParentMenu() != this.mMenu) {
                    subMenuBuilder2 = (SubMenuBuilder)subMenuBuilder2.getParentMenu();
                }
                if (this.findViewForItem(subMenuBuilder2.getItem()) != null || this.mOverflowButton != null) break block4;
            }
            return false;
        }
        this.mOpenSubMenuId = subMenuBuilder.getItem().getItemId();
        this.mActionButtonPopup = new ActionButtonSubmenu(subMenuBuilder);
        this.mActionButtonPopup.show(null);
        super.onSubMenuSelected(subMenuBuilder);
        return true;
    }

    @Override
    public void onSubUiVisibilityChanged(boolean bl2) {
        if (bl2) {
            super.onSubMenuSelected(null);
            return;
        }
        this.mMenu.close(false);
    }

    public void setExpandedActionViewsExclusive(boolean bl2) {
        this.mExpandedActionViewsExclusive = bl2;
    }

    public void setItemLimit(int n2) {
        this.mMaxItems = n2;
        this.mMaxItemsSet = true;
    }

    public void setReserveOverflow(boolean bl2) {
        this.mReserveOverflow = bl2;
        this.mReserveOverflowSet = true;
    }

    public void setWidthLimit(int n2, boolean bl2) {
        this.mWidthLimit = n2;
        this.mStrictWidthLimit = bl2;
        this.mWidthLimitSet = true;
    }

    @Override
    public boolean shouldIncludeItem(int n2, MenuItemImpl menuItemImpl) {
        return menuItemImpl.isActionButton();
    }

    public boolean showOverflowMenu() {
        if (this.mReserveOverflow && !this.isOverflowMenuShowing() && this.mMenu != null && this.mMenuView != null && this.mPostedOpenRunnable == null) {
            this.mPostedOpenRunnable = new OpenOverflowRunnable(new OverflowPopup(this.mContext, this.mMenu, this.mOverflowButton, true));
            ((View)this.mMenuView).post((Runnable)this.mPostedOpenRunnable);
            super.onSubMenuSelected(null);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateMenuView(boolean bl2) {
        super.updateMenuView(bl2);
        if (this.mMenuView == null) {
            return;
        }
        if (this.mMenu != null) {
            ArrayList<MenuItemImpl> arrayList = this.mMenu.getActionItems();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ActionProvider actionProvider = arrayList.get(i2).getSupportActionProvider();
                if (actionProvider == null) continue;
                actionProvider.setSubUiVisibilityListener(this);
            }
        }
        ArrayList<MenuItemImpl> arrayList = this.mMenu != null ? this.mMenu.getNonActionItems() : null;
        boolean bl3 = this.mReserveOverflow;
        boolean bl4 = false;
        if (bl3) {
            bl4 = false;
            if (arrayList != null) {
                int n3 = arrayList.size();
                bl4 = n3 == 1 ? !arrayList.get(0).isActionViewExpanded() : n3 > 0;
            }
        }
        if (bl4) {
            ViewGroup viewGroup;
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this.mSystemContext);
            }
            if ((viewGroup = (ViewGroup)this.mOverflowButton.getParent()) != this.mMenuView) {
                if (viewGroup != null) {
                    viewGroup.removeView(this.mOverflowButton);
                }
                ActionMenuView actionMenuView = (ActionMenuView)this.mMenuView;
                actionMenuView.addView(this.mOverflowButton, (ViewGroup.LayoutParams)actionMenuView.generateOverflowButtonLayoutParams());
            }
        } else if (this.mOverflowButton != null && this.mOverflowButton.getParent() == this.mMenuView) {
            ((ViewGroup)this.mMenuView).removeView(this.mOverflowButton);
        }
        ((ActionMenuView)this.mMenuView).setOverflowReserved(this.mReserveOverflow);
    }

    private class ActionButtonSubmenu
    extends MenuDialogHelper {
        public ActionButtonSubmenu(SubMenuBuilder subMenuBuilder) {
            super(subMenuBuilder);
            ActionMenuPresenter.this.setCallback(ActionMenuPresenter.this.mPopupPresenterCallback);
        }

        @Override
        public void onDismiss(DialogInterface dialogInterface) {
            super.onDismiss(dialogInterface);
            ActionMenuPresenter.access$202(ActionMenuPresenter.this, null);
            ActionMenuPresenter.this.mOpenSubMenuId = 0;
        }
    }

    private class OpenOverflowRunnable
    implements Runnable {
        private OverflowPopup mPopup;

        public OpenOverflowRunnable(OverflowPopup overflowPopup) {
            this.mPopup = overflowPopup;
        }

        @Override
        public void run() {
            ActionMenuPresenter.this.mMenu.changeMenuMode();
            View view = (View)ActionMenuPresenter.this.mMenuView;
            if (view != null && view.getWindowToken() != null && this.mPopup.tryShow()) {
                ActionMenuPresenter.access$102(ActionMenuPresenter.this, this.mPopup);
            }
            ActionMenuPresenter.access$302(ActionMenuPresenter.this, null);
        }
    }

    private class OverflowMenuButton
    extends ImageButton
    implements ActionMenuView.ActionMenuChildView {
        public OverflowMenuButton(Context context) {
            super(context, null, R.attr.actionOverflowButtonStyle);
            this.setClickable(true);
            this.setFocusable(true);
            this.setVisibility(0);
            this.setEnabled(true);
        }

        @Override
        public boolean needsDividerAfter() {
            return false;
        }

        @Override
        public boolean needsDividerBefore() {
            return false;
        }

        public boolean performClick() {
            if (super.performClick()) {
                return true;
            }
            this.playSoundEffect(0);
            ActionMenuPresenter.this.showOverflowMenu();
            return true;
        }
    }

    private class OverflowPopup
    extends MenuPopupHelper {
        public OverflowPopup(Context context, MenuBuilder menuBuilder, View view, boolean bl2) {
            super(context, menuBuilder, view, bl2);
            this.setCallback(ActionMenuPresenter.this.mPopupPresenterCallback);
        }

        @Override
        public void onDismiss() {
            super.onDismiss();
            ActionMenuPresenter.this.mMenu.close();
            ActionMenuPresenter.access$102(ActionMenuPresenter.this, null);
        }
    }

    private class PopupPresenterCallback
    implements MenuPresenter.Callback {
        private PopupPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl2) {
            if (menuBuilder instanceof SubMenuBuilder) {
                ((SubMenuBuilder)menuBuilder).getRootMenu().close(false);
            }
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            if (menuBuilder == null) {
                return false;
            }
            ActionMenuPresenter.this.mOpenSubMenuId = ((SubMenuBuilder)menuBuilder).getItem().getItemId();
            return false;
        }
    }

    private static class SavedState
    implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        public int openSubMenuId;

        SavedState() {
        }

        SavedState(Parcel parcel) {
            this.openSubMenuId = parcel.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeInt(this.openSubMenuId);
        }
    }
}

