/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.menu.ActionMenuView;
import android.support.v7.internal.view.menu.MenuBuilder;
import android.support.v7.internal.view.menu.MenuItemImpl;
import android.support.v7.internal.view.menu.MenuView;
import android.support.v7.internal.widget.CompatTextView;
import android.text.TextUtils;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Toast;
import java.util.Locale;

public class ActionMenuItemView
extends CompatTextView
implements MenuView.ItemView,
View.OnClickListener,
View.OnLongClickListener,
ActionMenuView.ActionMenuChildView {
    private static final String TAG = "ActionMenuItemView";
    private boolean mAllowTextWithIcon;
    private boolean mExpandedFormat;
    private Drawable mIcon;
    private MenuItemImpl mItemData;
    private MenuBuilder.ItemInvoker mItemInvoker;
    private int mMinWidth;
    private int mSavedPaddingLeft;
    private CharSequence mTitle;

    public ActionMenuItemView(Context context) {
        this(context, null);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mAllowTextWithIcon = context.getResources().getBoolean(R.bool.abc_config_allowActionMenuItemTextWithIcon);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ActionMenuItemView, 0, 0);
        this.mMinWidth = typedArray.getDimensionPixelSize(0, 0);
        typedArray.recycle();
        this.setOnClickListener(this);
        this.setOnLongClickListener(this);
        this.setTransformationMethod(new AllCapsTransformationMethod());
        this.mSavedPaddingLeft = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTextButtonVisibility() {
        boolean bl2;
        boolean bl3;
        block3: {
            block2: {
                bl3 = !TextUtils.isEmpty((CharSequence)this.mTitle);
                if (this.mIcon == null) break block2;
                boolean bl4 = this.mItemData.showsTextAsAction();
                bl2 = false;
                if (!bl4) break block3;
                if (this.mAllowTextWithIcon) break block2;
                boolean bl5 = this.mExpandedFormat;
                bl2 = false;
                if (!bl5) break block3;
            }
            bl2 = true;
        }
        CharSequence charSequence = bl3 & bl2 ? this.mTitle : null;
        this.setText(charSequence);
    }

    @Override
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    public boolean hasText() {
        return !TextUtils.isEmpty((CharSequence)this.getText());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n2) {
        this.mItemData = menuItemImpl;
        this.setIcon(menuItemImpl.getIcon());
        this.setTitle(menuItemImpl.getTitleForItemView(this));
        this.setId(menuItemImpl.getItemId());
        int n3 = menuItemImpl.isVisible() ? 0 : 8;
        this.setVisibility(n3);
        this.setEnabled(menuItemImpl.isEnabled());
    }

    @Override
    public boolean needsDividerAfter() {
        return this.hasText();
    }

    @Override
    public boolean needsDividerBefore() {
        return this.hasText() && this.mItemData.getIcon() == null;
    }

    public void onClick(View view) {
        if (this.mItemInvoker != null) {
            this.mItemInvoker.invokeItem(this.mItemData);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onLongClick(View view) {
        if (this.hasText()) {
            return false;
        }
        int[] nArray = new int[2];
        Rect rect = new Rect();
        this.getLocationOnScreen(nArray);
        this.getWindowVisibleDisplayFrame(rect);
        Context context = this.getContext();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = nArray[1] + n3 / 2;
        int n5 = context.getResources().getDisplayMetrics().widthPixels;
        Toast toast = Toast.makeText((Context)context, (CharSequence)this.mItemData.getTitle(), (int)0);
        if (n4 < rect.height()) {
            toast.setGravity(53, n5 - nArray[0] - n2 / 2, n3);
        } else {
            toast.setGravity(81, 0, n3);
        }
        toast.show();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        boolean bl2 = this.hasText();
        if (bl2 && this.mSavedPaddingLeft >= 0) {
            super.setPadding(this.mSavedPaddingLeft, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
        super.onMeasure(n2, n3);
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n2);
        int n6 = this.getMeasuredWidth();
        int n7 = n4 == Integer.MIN_VALUE ? Math.min(n5, this.mMinWidth) : this.mMinWidth;
        if (n4 != 0x40000000 && this.mMinWidth > 0 && n6 < n7) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n7, (int)0x40000000), n3);
        }
        if (!bl2 && this.mIcon != null) {
            super.setPadding((this.getMeasuredWidth() - this.mIcon.getIntrinsicWidth()) / 2, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
    }

    @Override
    public boolean prefersCondensedTitle() {
        return true;
    }

    @Override
    public void setCheckable(boolean bl2) {
    }

    @Override
    public void setChecked(boolean bl2) {
    }

    public void setExpandedFormat(boolean bl2) {
        if (this.mExpandedFormat != bl2) {
            this.mExpandedFormat = bl2;
            if (this.mItemData != null) {
                this.mItemData.actionFormatChanged();
            }
        }
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        this.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        this.updateTextButtonVisibility();
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker itemInvoker) {
        this.mItemInvoker = itemInvoker;
    }

    public void setPadding(int n2, int n3, int n4, int n5) {
        this.mSavedPaddingLeft = n2;
        super.setPadding(n2, n3, n4, n5);
    }

    @Override
    public void setShortcut(boolean bl2, char c2) {
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.setContentDescription(this.mTitle);
        this.updateTextButtonVisibility();
    }

    @Override
    public boolean showsIcon() {
        return true;
    }

    private class AllCapsTransformationMethod
    implements TransformationMethod {
        private Locale mLocale;

        public AllCapsTransformationMethod() {
            this.mLocale = ActionMenuItemView.this.getContext().getResources().getConfiguration().locale;
        }

        public CharSequence getTransformation(CharSequence charSequence, View view) {
            if (charSequence != null) {
                return ((Object)charSequence).toString().toUpperCase(this.mLocale);
            }
            return null;
        }

        public void onFocusChanged(View view, CharSequence charSequence, boolean bl2, int n2, Rect rect) {
        }
    }
}

