/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.ActionBarPolicy;
import android.support.v7.internal.view.SupportMenuInflater;
import android.support.v7.internal.view.menu.MenuBuilder;
import android.support.v7.internal.view.menu.SubMenuBuilder;
import android.support.v7.internal.widget.ActionBarContainer;
import android.support.v7.internal.widget.ActionBarContextView;
import android.support.v7.internal.widget.ActionBarOverlayLayout;
import android.support.v7.internal.widget.ActionBarView;
import android.support.v7.internal.widget.ScrollingTabContainerView;
import android.support.v7.view.ActionMode;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.SpinnerAdapter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class ActionBarImplBase
extends ActionBar {
    private static final int CONTEXT_DISPLAY_NORMAL = 0;
    private static final int CONTEXT_DISPLAY_SPLIT = 1;
    private static final int INVALID_POSITION = -1;
    ActionModeImpl mActionMode;
    private ActionBarView mActionView;
    private ActionBarActivity mActivity;
    private ActionBar.Callback mCallback;
    private ActionBarContainer mContainerView;
    private View mContentView;
    private Context mContext;
    private int mContextDisplayMode;
    private ActionBarContextView mContextView;
    private int mCurWindowVisibility = 0;
    ActionMode mDeferredDestroyActionMode;
    ActionMode.Callback mDeferredModeDestroyCallback;
    private Dialog mDialog;
    private boolean mDisplayHomeAsUpSet;
    final Handler mHandler;
    private boolean mHasEmbeddedTabs;
    private boolean mHiddenByApp;
    private boolean mHiddenBySystem;
    private boolean mLastMenuVisibility;
    private ArrayList<ActionBar.OnMenuVisibilityListener> mMenuVisibilityListeners;
    private boolean mNowShowing = true;
    private ActionBarOverlayLayout mOverlayLayout;
    private int mSavedTabPosition = -1;
    private TabImpl mSelectedTab;
    private boolean mShowHideAnimationEnabled;
    private boolean mShowingForMode;
    private ActionBarContainer mSplitView;
    private ScrollingTabContainerView mTabScrollView;
    Runnable mTabSelector;
    private ArrayList<TabImpl> mTabs = new ArrayList();
    private Context mThemedContext;
    private ViewGroup mTopVisibilityView;

    public ActionBarImplBase(ActionBarActivity actionBarActivity, ActionBar.Callback callback) {
        this.mMenuVisibilityListeners = new ArrayList();
        this.mHandler = new Handler();
        this.mActivity = actionBarActivity;
        this.mContext = actionBarActivity;
        this.mCallback = callback;
        this.init(this.mActivity);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean checkShowingFlags(boolean bl2, boolean bl3, boolean bl4) {
        return bl4 || !bl2 && !bl3;
    }

    private void cleanupTabs() {
        if (this.mSelectedTab != null) {
            this.selectTab(null);
        }
        this.mTabs.clear();
        if (this.mTabScrollView != null) {
            this.mTabScrollView.removeAllTabs();
        }
        this.mSavedTabPosition = -1;
    }

    private void configureTab(ActionBar.Tab tab, int n2) {
        TabImpl tabImpl = (TabImpl)tab;
        if (tabImpl.getCallback() == null) {
            throw new IllegalStateException("Action Bar Tab must have a Callback");
        }
        tabImpl.setPosition(n2);
        this.mTabs.add(n2, tabImpl);
        int n3 = this.mTabs.size();
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            this.mTabs.get(i2).setPosition(i2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ensureTabsExist() {
        if (this.mTabScrollView != null) {
            return;
        }
        ScrollingTabContainerView scrollingTabContainerView = new ScrollingTabContainerView(this.mContext);
        if (this.mHasEmbeddedTabs) {
            scrollingTabContainerView.setVisibility(0);
            this.mActionView.setEmbeddedTabView(scrollingTabContainerView);
        } else {
            if (this.getNavigationMode() == 2) {
                scrollingTabContainerView.setVisibility(0);
            } else {
                scrollingTabContainerView.setVisibility(8);
            }
            this.mContainerView.setTabContainer(scrollingTabContainerView);
        }
        this.mTabScrollView = scrollingTabContainerView;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void init(ActionBarActivity actionBarActivity) {
        boolean bl2;
        ActionBarPolicy actionBarPolicy;
        block8: {
            block7: {
                this.mOverlayLayout = (ActionBarOverlayLayout)actionBarActivity.findViewById(R.id.action_bar_overlay_layout);
                if (this.mOverlayLayout != null) {
                    this.mOverlayLayout.setActionBar(this);
                }
                this.mActionView = (ActionBarView)actionBarActivity.findViewById(R.id.action_bar);
                this.mContextView = (ActionBarContextView)actionBarActivity.findViewById(R.id.action_context_bar);
                this.mContainerView = (ActionBarContainer)actionBarActivity.findViewById(R.id.action_bar_container);
                this.mTopVisibilityView = (ViewGroup)actionBarActivity.findViewById(R.id.top_action_bar);
                if (this.mTopVisibilityView == null) {
                    this.mTopVisibilityView = this.mContainerView;
                }
                this.mSplitView = (ActionBarContainer)actionBarActivity.findViewById(R.id.split_action_bar);
                if (this.mActionView == null || this.mContextView == null || this.mContainerView == null) {
                    throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with a compatible window decor layout");
                }
                this.mActionView.setContextView(this.mContextView);
                int n2 = this.mActionView.isSplitActionBar() ? 1 : 0;
                this.mContextDisplayMode = n2;
                boolean bl3 = (4 & this.mActionView.getDisplayOptions()) != 0;
                if (bl3) {
                    this.mDisplayHomeAsUpSet = true;
                }
                if ((actionBarPolicy = ActionBarPolicy.get(this.mContext)).enableHomeButtonByDefault()) break block7;
                bl2 = false;
                if (!bl3) break block8;
            }
            bl2 = true;
        }
        this.setHomeButtonEnabled(bl2);
        this.setHasEmbeddedTabs(actionBarPolicy.hasEmbeddedTabs());
        this.setTitle(this.mActivity.getTitle());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setHasEmbeddedTabs(boolean bl2) {
        boolean bl3 = true;
        this.mHasEmbeddedTabs = bl2;
        if (!this.mHasEmbeddedTabs) {
            this.mActionView.setEmbeddedTabView(null);
            this.mContainerView.setTabContainer(this.mTabScrollView);
        } else {
            this.mContainerView.setTabContainer(null);
            this.mActionView.setEmbeddedTabView(this.mTabScrollView);
        }
        boolean bl4 = this.getNavigationMode() == 2 ? bl3 : false;
        if (this.mTabScrollView != null) {
            if (bl4) {
                this.mTabScrollView.setVisibility(0);
            } else {
                this.mTabScrollView.setVisibility(8);
            }
        }
        ActionBarView actionBarView = this.mActionView;
        if (this.mHasEmbeddedTabs || !bl4) {
            bl3 = false;
        }
        actionBarView.setCollapsable(bl3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateVisibility(boolean bl2) {
        if (ActionBarImplBase.checkShowingFlags(this.mHiddenByApp, this.mHiddenBySystem, this.mShowingForMode)) {
            if (this.mNowShowing) return;
            this.mNowShowing = true;
            this.doShow(bl2);
            return;
        }
        if (!this.mNowShowing) return;
        this.mNowShowing = false;
        this.doHide(bl2);
    }

    @Override
    public void addOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener onMenuVisibilityListener) {
        this.mMenuVisibilityListeners.add(onMenuVisibilityListener);
    }

    @Override
    public void addTab(ActionBar.Tab tab) {
        this.addTab(tab, this.mTabs.isEmpty());
    }

    @Override
    public void addTab(ActionBar.Tab tab, int n2) {
        this.addTab(tab, n2, this.mTabs.isEmpty());
    }

    @Override
    public void addTab(ActionBar.Tab tab, int n2, boolean bl2) {
        this.ensureTabsExist();
        this.mTabScrollView.addTab(tab, n2, bl2);
        this.configureTab(tab, n2);
        if (bl2) {
            this.selectTab(tab);
        }
    }

    @Override
    public void addTab(ActionBar.Tab tab, boolean bl2) {
        this.ensureTabsExist();
        this.mTabScrollView.addTab(tab, bl2);
        this.configureTab(tab, this.mTabs.size());
        if (bl2) {
            this.selectTab(tab);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void animateToMode(boolean bl2) {
        int n2 = 8;
        if (bl2) {
            this.showForActionMode();
        } else {
            this.hideForActionMode();
        }
        ActionBarView actionBarView = this.mActionView;
        int n3 = bl2 ? 4 : 0;
        actionBarView.animateToVisibility(n3);
        ActionBarContextView actionBarContextView = this.mContextView;
        int n4 = bl2 ? 0 : n2;
        actionBarContextView.animateToVisibility(n4);
        if (this.mTabScrollView != null && !this.mActionView.hasEmbeddedTabs() && this.mActionView.isCollapsed()) {
            ScrollingTabContainerView scrollingTabContainerView = this.mTabScrollView;
            if (!bl2) {
                n2 = 0;
            }
            scrollingTabContainerView.setVisibility(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doHide(boolean bl2) {
        boolean bl3;
        block6: {
            block5: {
                this.mTopVisibilityView.clearAnimation();
                if (this.mTopVisibilityView.getVisibility() == 8) break block5;
                bl3 = this.isShowHideAnimationEnabled() || bl2;
                if (bl3) {
                    Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.abc_slide_out_top);
                    this.mTopVisibilityView.startAnimation(animation);
                }
                this.mTopVisibilityView.setVisibility(8);
                if (this.mSplitView != null && this.mSplitView.getVisibility() != 8) break block6;
            }
            return;
        }
        if (bl3) {
            Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.abc_slide_out_bottom);
            this.mSplitView.startAnimation(animation);
        }
        this.mSplitView.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doShow(boolean bl2) {
        boolean bl3;
        block6: {
            block5: {
                this.mTopVisibilityView.clearAnimation();
                if (this.mTopVisibilityView.getVisibility() == 0) break block5;
                bl3 = this.isShowHideAnimationEnabled() || bl2;
                if (bl3) {
                    Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.abc_slide_in_top);
                    this.mTopVisibilityView.startAnimation(animation);
                }
                this.mTopVisibilityView.setVisibility(0);
                if (this.mSplitView != null && this.mSplitView.getVisibility() != 0) break block6;
            }
            return;
        }
        if (bl3) {
            Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.abc_slide_in_bottom);
            this.mSplitView.startAnimation(animation);
        }
        this.mSplitView.setVisibility(0);
    }

    @Override
    public View getCustomView() {
        return this.mActionView.getCustomNavigationView();
    }

    @Override
    public int getDisplayOptions() {
        return this.mActionView.getDisplayOptions();
    }

    @Override
    public int getHeight() {
        return this.mContainerView.getHeight();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getNavigationItemCount() {
        switch (this.mActionView.getNavigationMode()) {
            default: {
                return 0;
            }
            case 2: {
                return this.mTabs.size();
            }
            case 1: {
                SpinnerAdapter spinnerAdapter = this.mActionView.getDropdownAdapter();
                if (spinnerAdapter == null) return 0;
                return spinnerAdapter.getCount();
            }
        }
    }

    @Override
    public int getNavigationMode() {
        return this.mActionView.getNavigationMode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getSelectedNavigationIndex() {
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                if (this.mSelectedTab != null) {
                    return this.mSelectedTab.getPosition();
                }
            }
            default: {
                return -1;
            }
            case 1: 
        }
        return this.mActionView.getDropdownSelectedPosition();
    }

    @Override
    public ActionBar.Tab getSelectedTab() {
        return this.mSelectedTab;
    }

    @Override
    public CharSequence getSubtitle() {
        return this.mActionView.getSubtitle();
    }

    @Override
    public ActionBar.Tab getTabAt(int n2) {
        return this.mTabs.get(n2);
    }

    @Override
    public int getTabCount() {
        return this.mTabs.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Context getThemedContext() {
        block4: {
            block3: {
                if (this.mThemedContext != null) break block3;
                TypedValue typedValue = new TypedValue();
                this.mContext.getTheme().resolveAttribute(R.attr.actionBarWidgetTheme, typedValue, true);
                int n2 = typedValue.resourceId;
                if (n2 == 0) break block4;
                this.mThemedContext = new ContextThemeWrapper(this.mContext, n2);
            }
            return this.mThemedContext;
        }
        this.mThemedContext = this.mContext;
        return this.mThemedContext;
    }

    @Override
    public CharSequence getTitle() {
        return this.mActionView.getTitle();
    }

    public boolean hasNonEmbeddedTabs() {
        return !this.mHasEmbeddedTabs && this.getNavigationMode() == 2;
    }

    @Override
    public void hide() {
        if (!this.mHiddenByApp) {
            this.mHiddenByApp = true;
            this.updateVisibility(false);
        }
    }

    void hideForActionMode() {
        if (this.mShowingForMode) {
            this.mShowingForMode = false;
            this.updateVisibility(false);
        }
    }

    boolean isShowHideAnimationEnabled() {
        return this.mShowHideAnimationEnabled;
    }

    @Override
    public boolean isShowing() {
        return this.mNowShowing;
    }

    @Override
    public ActionBar.Tab newTab() {
        return new TabImpl();
    }

    public void onConfigurationChanged(Configuration configuration) {
        this.setHasEmbeddedTabs(ActionBarPolicy.get(this.mContext).hasEmbeddedTabs());
    }

    @Override
    public void removeAllTabs() {
        this.cleanupTabs();
    }

    @Override
    public void removeOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener onMenuVisibilityListener) {
        this.mMenuVisibilityListeners.remove(onMenuVisibilityListener);
    }

    @Override
    public void removeTab(ActionBar.Tab tab) {
        this.removeTabAt(tab.getPosition());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void removeTabAt(int n2) {
        block6: {
            block5: {
                if (this.mTabScrollView == null) break block5;
                int n3 = this.mSelectedTab != null ? this.mSelectedTab.getPosition() : this.mSavedTabPosition;
                this.mTabScrollView.removeTabAt(n2);
                TabImpl tabImpl = this.mTabs.remove(n2);
                if (tabImpl != null) {
                    tabImpl.setPosition(-1);
                }
                int n4 = this.mTabs.size();
                for (int i2 = n2; i2 < n4; ++i2) {
                    this.mTabs.get(i2).setPosition(i2);
                }
                if (n3 == n2) break block6;
            }
            return;
        }
        TabImpl tabImpl = this.mTabs.isEmpty() ? null : this.mTabs.get(Math.max(0, n2 - 1));
        this.selectTab(tabImpl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void selectTab(ActionBar.Tab tab) {
        int n2 = -1;
        if (this.getNavigationMode() != 2) {
            if (tab != null) {
                n2 = tab.getPosition();
            }
            this.mSavedTabPosition = n2;
            return;
        }
        FragmentTransaction fragmentTransaction = this.mActivity.getSupportFragmentManager().beginTransaction().disallowAddToBackStack();
        if (this.mSelectedTab == tab) {
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabReselected(this.mSelectedTab, fragmentTransaction);
                this.mTabScrollView.animateToTab(tab.getPosition());
            }
        } else {
            ScrollingTabContainerView scrollingTabContainerView = this.mTabScrollView;
            if (tab != null) {
                n2 = tab.getPosition();
            }
            scrollingTabContainerView.setTabSelected(n2);
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabUnselected(this.mSelectedTab, fragmentTransaction);
            }
            this.mSelectedTab = (TabImpl)tab;
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabSelected(this.mSelectedTab, fragmentTransaction);
            }
        }
        if (fragmentTransaction.isEmpty()) return;
        fragmentTransaction.commit();
    }

    @Override
    public void setBackgroundDrawable(Drawable drawable2) {
        this.mContainerView.setPrimaryBackground(drawable2);
    }

    @Override
    public void setCustomView(int n2) {
        this.setCustomView(LayoutInflater.from((Context)this.getThemedContext()).inflate(n2, (ViewGroup)this.mActionView, false));
    }

    @Override
    public void setCustomView(View view) {
        this.mActionView.setCustomNavigationView(view);
    }

    @Override
    public void setCustomView(View view, ActionBar.LayoutParams layoutParams) {
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mActionView.setCustomNavigationView(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayHomeAsUpEnabled(boolean bl2) {
        int n2 = bl2 ? 4 : 0;
        this.setDisplayOptions(n2, 4);
    }

    @Override
    public void setDisplayOptions(int n2) {
        if ((n2 & 4) != 0) {
            this.mDisplayHomeAsUpSet = true;
        }
        this.mActionView.setDisplayOptions(n2);
    }

    @Override
    public void setDisplayOptions(int n2, int n3) {
        int n4 = this.mActionView.getDisplayOptions();
        if ((n3 & 4) != 0) {
            this.mDisplayHomeAsUpSet = true;
        }
        this.mActionView.setDisplayOptions(n2 & n3 | n4 & ~n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayShowCustomEnabled(boolean bl2) {
        int n2 = bl2 ? 16 : 0;
        this.setDisplayOptions(n2, 16);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayShowHomeEnabled(boolean bl2) {
        int n2 = bl2 ? 2 : 0;
        this.setDisplayOptions(n2, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayShowTitleEnabled(boolean bl2) {
        int n2 = bl2 ? 8 : 0;
        this.setDisplayOptions(n2, 8);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayUseLogoEnabled(boolean bl2) {
        int n2 = bl2 ? 1 : 0;
        this.setDisplayOptions(n2, 1);
    }

    @Override
    public void setHomeButtonEnabled(boolean bl2) {
        this.mActionView.setHomeButtonEnabled(bl2);
    }

    @Override
    public void setIcon(int n2) {
        this.mActionView.setIcon(n2);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.mActionView.setIcon(drawable2);
    }

    @Override
    public void setListNavigationCallbacks(SpinnerAdapter spinnerAdapter, ActionBar.OnNavigationListener onNavigationListener) {
        this.mActionView.setDropdownAdapter(spinnerAdapter);
        this.mActionView.setCallback(onNavigationListener);
    }

    @Override
    public void setLogo(int n2) {
        this.mActionView.setLogo(n2);
    }

    @Override
    public void setLogo(Drawable drawable2) {
        this.mActionView.setLogo(drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setNavigationMode(int n2) {
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                this.mSavedTabPosition = this.getSelectedNavigationIndex();
                this.selectTab(null);
                this.mTabScrollView.setVisibility(8);
                break;
            }
        }
        this.mActionView.setNavigationMode(n2);
        switch (n2) {
            case 2: {
                this.ensureTabsExist();
                this.mTabScrollView.setVisibility(0);
                if (this.mSavedTabPosition == -1) break;
                this.setSelectedNavigationItem(this.mSavedTabPosition);
                this.mSavedTabPosition = -1;
                break;
            }
        }
        ActionBarView actionBarView = this.mActionView;
        boolean bl2 = false;
        if (n2 == 2) {
            boolean bl3 = this.mHasEmbeddedTabs;
            bl2 = false;
            if (!bl3) {
                bl2 = true;
            }
        }
        actionBarView.setCollapsable(bl2);
    }

    @Override
    public void setSelectedNavigationItem(int n2) {
        switch (this.mActionView.getNavigationMode()) {
            default: {
                throw new IllegalStateException("setSelectedNavigationIndex not valid for current navigation mode");
            }
            case 2: {
                this.selectTab(this.mTabs.get(n2));
                return;
            }
            case 1: 
        }
        this.mActionView.setDropdownSelectedPosition(n2);
    }

    public void setShowHideAnimationEnabled(boolean bl2) {
        this.mShowHideAnimationEnabled = bl2;
        if (!bl2) {
            this.mTopVisibilityView.clearAnimation();
            if (this.mSplitView != null) {
                this.mSplitView.clearAnimation();
            }
        }
    }

    @Override
    public void setSubtitle(int n2) {
        this.setSubtitle(this.mContext.getString(n2));
    }

    @Override
    public void setSubtitle(CharSequence charSequence) {
        this.mActionView.setSubtitle(charSequence);
    }

    @Override
    public void setTitle(int n2) {
        this.setTitle(this.mContext.getString(n2));
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        this.mActionView.setTitle(charSequence);
    }

    @Override
    public void show() {
        if (this.mHiddenByApp) {
            this.mHiddenByApp = false;
            this.updateVisibility(false);
        }
    }

    void showForActionMode() {
        if (!this.mShowingForMode) {
            this.mShowingForMode = true;
            this.updateVisibility(false);
        }
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
        }
        this.mContextView.killMode();
        ActionModeImpl actionModeImpl = new ActionModeImpl(callback);
        if (actionModeImpl.dispatchOnCreate()) {
            actionModeImpl.invalidate();
            this.mContextView.initForMode(actionModeImpl);
            this.animateToMode(true);
            if (this.mSplitView != null && this.mContextDisplayMode == 1 && this.mSplitView.getVisibility() != 0) {
                this.mSplitView.setVisibility(0);
            }
            this.mContextView.sendAccessibilityEvent(32);
            this.mActionMode = actionModeImpl;
            return actionModeImpl;
        }
        return null;
    }

    class ActionModeImpl
    extends ActionMode
    implements MenuBuilder.Callback {
        private ActionMode.Callback mCallback;
        private WeakReference<View> mCustomView;
        private MenuBuilder mMenu;

        public ActionModeImpl(ActionMode.Callback callback) {
            this.mCallback = callback;
            this.mMenu = new MenuBuilder(ActionBarImplBase.this.getThemedContext()).setDefaultShowAsAction(1);
            this.mMenu.setCallback(this);
        }

        public boolean dispatchOnCreate() {
            this.mMenu.stopDispatchingItemsChanged();
            try {
                boolean bl2 = this.mCallback.onCreateActionMode(this, this.mMenu);
                return bl2;
            }
            finally {
                this.mMenu.startDispatchingItemsChanged();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void finish() {
            if (ActionBarImplBase.this.mActionMode != this) {
                return;
            }
            if (!ActionBarImplBase.checkShowingFlags(ActionBarImplBase.this.mHiddenByApp, ActionBarImplBase.this.mHiddenBySystem, false)) {
                ActionBarImplBase.this.mDeferredDestroyActionMode = this;
                ActionBarImplBase.this.mDeferredModeDestroyCallback = this.mCallback;
            } else {
                this.mCallback.onDestroyActionMode(this);
            }
            this.mCallback = null;
            ActionBarImplBase.this.animateToMode(false);
            ActionBarImplBase.this.mContextView.closeMode();
            ActionBarImplBase.this.mActionView.sendAccessibilityEvent(32);
            ActionBarImplBase.this.mActionMode = null;
        }

        @Override
        public View getCustomView() {
            if (this.mCustomView != null) {
                return (View)this.mCustomView.get();
            }
            return null;
        }

        @Override
        public Menu getMenu() {
            return this.mMenu;
        }

        @Override
        public MenuInflater getMenuInflater() {
            return new SupportMenuInflater(ActionBarImplBase.this.getThemedContext());
        }

        @Override
        public CharSequence getSubtitle() {
            return ActionBarImplBase.this.mContextView.getSubtitle();
        }

        @Override
        public CharSequence getTitle() {
            return ActionBarImplBase.this.mContextView.getTitle();
        }

        @Override
        public void invalidate() {
            this.mMenu.stopDispatchingItemsChanged();
            try {
                this.mCallback.onPrepareActionMode(this, this.mMenu);
                return;
            }
            finally {
                this.mMenu.startDispatchingItemsChanged();
            }
        }

        @Override
        public boolean isTitleOptional() {
            return ActionBarImplBase.this.mContextView.isTitleOptional();
        }

        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl2) {
        }

        public void onCloseSubMenu(SubMenuBuilder subMenuBuilder) {
        }

        @Override
        public boolean onMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
            if (this.mCallback != null) {
                return this.mCallback.onActionItemClicked(this, menuItem);
            }
            return false;
        }

        @Override
        public void onMenuModeChange(MenuBuilder menuBuilder) {
            if (this.mCallback == null) {
                return;
            }
            this.invalidate();
            ActionBarImplBase.this.mContextView.showOverflowMenu();
        }

        public void onMenuModeChange(Menu menu2) {
            if (this.mCallback == null) {
                return;
            }
            this.invalidate();
            ActionBarImplBase.this.mContextView.showOverflowMenu();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
            boolean bl2 = true;
            if (this.mCallback == null) {
                return false;
            }
            if (subMenuBuilder.hasVisibleItems()) return bl2;
            return bl2;
        }

        @Override
        public void setCustomView(View view) {
            ActionBarImplBase.this.mContextView.setCustomView(view);
            this.mCustomView = new WeakReference<View>(view);
        }

        @Override
        public void setSubtitle(int n2) {
            this.setSubtitle(ActionBarImplBase.this.mContext.getResources().getString(n2));
        }

        @Override
        public void setSubtitle(CharSequence charSequence) {
            ActionBarImplBase.this.mContextView.setSubtitle(charSequence);
        }

        @Override
        public void setTitle(int n2) {
            this.setTitle(ActionBarImplBase.this.mContext.getResources().getString(n2));
        }

        @Override
        public void setTitle(CharSequence charSequence) {
            ActionBarImplBase.this.mContextView.setTitle(charSequence);
        }

        @Override
        public void setTitleOptionalHint(boolean bl2) {
            super.setTitleOptionalHint(bl2);
            ActionBarImplBase.this.mContextView.setTitleOptional(bl2);
        }
    }

    public class TabImpl
    extends ActionBar.Tab {
        private ActionBar.TabListener mCallback;
        private CharSequence mContentDesc;
        private View mCustomView;
        private Drawable mIcon;
        private int mPosition = -1;
        private Object mTag;
        private CharSequence mText;

        public ActionBar.TabListener getCallback() {
            return this.mCallback;
        }

        @Override
        public CharSequence getContentDescription() {
            return this.mContentDesc;
        }

        @Override
        public View getCustomView() {
            return this.mCustomView;
        }

        @Override
        public Drawable getIcon() {
            return this.mIcon;
        }

        @Override
        public int getPosition() {
            return this.mPosition;
        }

        @Override
        public Object getTag() {
            return this.mTag;
        }

        @Override
        public CharSequence getText() {
            return this.mText;
        }

        @Override
        public void select() {
            ActionBarImplBase.this.selectTab(this);
        }

        @Override
        public ActionBar.Tab setContentDescription(int n2) {
            return this.setContentDescription(ActionBarImplBase.this.mContext.getResources().getText(n2));
        }

        @Override
        public ActionBar.Tab setContentDescription(CharSequence charSequence) {
            this.mContentDesc = charSequence;
            if (this.mPosition >= 0) {
                ActionBarImplBase.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }

        @Override
        public ActionBar.Tab setCustomView(int n2) {
            return this.setCustomView(LayoutInflater.from((Context)ActionBarImplBase.this.getThemedContext()).inflate(n2, null));
        }

        @Override
        public ActionBar.Tab setCustomView(View view) {
            this.mCustomView = view;
            if (this.mPosition >= 0) {
                ActionBarImplBase.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }

        @Override
        public ActionBar.Tab setIcon(int n2) {
            return this.setIcon(ActionBarImplBase.this.mContext.getResources().getDrawable(n2));
        }

        @Override
        public ActionBar.Tab setIcon(Drawable drawable2) {
            this.mIcon = drawable2;
            if (this.mPosition >= 0) {
                ActionBarImplBase.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }

        public void setPosition(int n2) {
            this.mPosition = n2;
        }

        @Override
        public ActionBar.Tab setTabListener(ActionBar.TabListener tabListener) {
            this.mCallback = tabListener;
            return this;
        }

        @Override
        public ActionBar.Tab setTag(Object object) {
            this.mTag = object;
            return this;
        }

        @Override
        public ActionBar.Tab setText(int n2) {
            return this.setText(ActionBarImplBase.this.mContext.getResources().getText(n2));
        }

        @Override
        public ActionBar.Tab setText(CharSequence charSequence) {
            this.mText = charSequence;
            if (this.mPosition >= 0) {
                ActionBarImplBase.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }
    }
}

