/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.ActionBarDrawerToggle;
import android.support.v4.app.NavUtils;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBarActivityDelegateBase;
import android.support.v7.app.ActionBarActivityDelegateHC;
import android.support.v7.app.ActionBarActivityDelegateICS;
import android.support.v7.app.ActionBarActivityDelegateJB;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.SupportMenuInflater;
import android.support.v7.view.ActionMode;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;

abstract class ActionBarActivityDelegate {
    static final String METADATA_UI_OPTIONS = "android.support.UI_OPTIONS";
    private static final String TAG = "ActionBarActivityDelegate";
    static final String UIOPTION_SPLIT_ACTION_BAR_WHEN_NARROW = "splitActionBarWhenNarrow";
    private ActionBar mActionBar;
    final ActionBarActivity mActivity;
    private boolean mEnableDefaultActionBarUp;
    boolean mHasActionBar;
    private MenuInflater mMenuInflater;
    boolean mOverlayActionBar;

    ActionBarActivityDelegate(ActionBarActivity actionBarActivity) {
        this.mActivity = actionBarActivity;
    }

    static ActionBarActivityDelegate createDelegate(ActionBarActivity actionBarActivity) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 16) {
            return new ActionBarActivityDelegateJB(actionBarActivity);
        }
        if (n2 >= 14) {
            return new ActionBarActivityDelegateICS(actionBarActivity);
        }
        if (n2 >= 11) {
            return new ActionBarActivityDelegateHC(actionBarActivity);
        }
        return new ActionBarActivityDelegateBase(actionBarActivity);
    }

    abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    abstract ActionBar createSupportActionBar();

    protected final Context getActionBarThemedContext() {
        ActionBarActivity actionBarActivity = this.mActivity;
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBarActivity = actionBar.getThemedContext();
        }
        return actionBarActivity;
    }

    abstract ActionBarDrawerToggle.Delegate getDrawerToggleDelegate();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MenuInflater getMenuInflater() {
        block4: {
            block3: {
                if (this.mMenuInflater != null) break block3;
                ActionBar actionBar = this.getSupportActionBar();
                if (actionBar == null) break block4;
                this.mMenuInflater = new SupportMenuInflater(actionBar.getThemedContext());
            }
            return this.mMenuInflater;
        }
        this.mMenuInflater = new SupportMenuInflater((Context)this.mActivity);
        return this.mMenuInflater;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final ActionBar getSupportActionBar() {
        if (this.mHasActionBar || this.mOverlayActionBar) {
            if (this.mActionBar == null) {
                this.mActionBar = this.createSupportActionBar();
                if (this.mEnableDefaultActionBarUp) {
                    this.mActionBar.setDisplayHomeAsUpEnabled(true);
                }
            }
            return this.mActionBar;
        }
        this.mActionBar = null;
        return this.mActionBar;
    }

    protected final String getUiOptionsFromMetadata() {
        String string2;
        block3: {
            String string3;
            ActivityInfo activityInfo;
            try {
                activityInfo = this.mActivity.getPackageManager().getActivityInfo(this.mActivity.getComponentName(), 128);
                Bundle bundle = activityInfo.metaData;
                string2 = null;
                if (bundle == null) break block3;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)TAG, (String)("getUiOptionsFromMetadata: Activity '" + this.mActivity.getClass().getSimpleName() + "' not in manifest"));
                return null;
            }
            string2 = string3 = activityInfo.metaData.getString(METADATA_UI_OPTIONS);
        }
        return string2;
    }

    abstract boolean onBackPressed();

    abstract void onConfigurationChanged(Configuration var1);

    abstract void onContentChanged();

    void onCreate(Bundle bundle) {
        block5: {
            block4: {
                TypedArray typedArray = this.mActivity.obtainStyledAttributes(R.styleable.ActionBarWindow);
                if (!typedArray.hasValue(0)) {
                    typedArray.recycle();
                    throw new IllegalStateException("You need to use a Theme.AppCompat theme (or descendant) with this activity.");
                }
                this.mHasActionBar = typedArray.getBoolean(0, false);
                this.mOverlayActionBar = typedArray.getBoolean(1, false);
                typedArray.recycle();
                if (NavUtils.getParentActivityName(this.mActivity) == null) break block4;
                if (this.mActionBar != null) break block5;
                this.mEnableDefaultActionBarUp = true;
            }
            return;
        }
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
    }

    abstract boolean onCreatePanelMenu(int var1, Menu var2);

    abstract View onCreatePanelView(int var1);

    abstract boolean onMenuItemSelected(int var1, MenuItem var2);

    abstract void onPostResume();

    boolean onPrepareOptionsPanel(View view, Menu menu2) {
        if (Build.VERSION.SDK_INT < 16) {
            return this.mActivity.onPrepareOptionsMenu(menu2);
        }
        return this.mActivity.superOnPrepareOptionsPanel(view, menu2);
    }

    abstract boolean onPreparePanel(int var1, View var2, Menu var3);

    abstract void onStop();

    abstract void onTitleChanged(CharSequence var1);

    abstract void setContentView(int var1);

    abstract void setContentView(View var1);

    abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    abstract void setSupportProgress(int var1);

    abstract void setSupportProgressBarIndeterminate(boolean var1);

    abstract void setSupportProgressBarIndeterminateVisibility(boolean var1);

    abstract void setSupportProgressBarVisibility(boolean var1);

    abstract ActionMode startSupportActionMode(ActionMode.Callback var1);

    abstract void supportInvalidateOptionsMenu();

    abstract boolean supportRequestWindowFeature(int var1);
}

