/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ScrollerCompat;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import java.util.Arrays;

public class ViewDragHelper {
    private static final int BASE_SETTLE_DURATION = 256;
    public static final int DIRECTION_ALL = 3;
    public static final int DIRECTION_HORIZONTAL = 1;
    public static final int DIRECTION_VERTICAL = 2;
    public static final int EDGE_ALL = 15;
    public static final int EDGE_BOTTOM = 8;
    public static final int EDGE_LEFT = 1;
    public static final int EDGE_RIGHT = 2;
    private static final int EDGE_SIZE = 20;
    public static final int EDGE_TOP = 4;
    public static final int INVALID_POINTER = -1;
    private static final int MAX_SETTLE_DURATION = 600;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_SETTLING = 2;
    private static final String TAG = "ViewDragHelper";
    private static final Interpolator sInterpolator = new Interpolator(){

        public float getInterpolation(float f2) {
            float f3 = f2 - 1.0f;
            return 1.0f + f3 * (f3 * (f3 * (f3 * f3)));
        }
    };
    private int mActivePointerId = -1;
    private final Callback mCallback;
    private View mCapturedView;
    private int mDragState;
    private int[] mEdgeDragsInProgress;
    private int[] mEdgeDragsLocked;
    private int mEdgeSize;
    private int[] mInitialEdgesTouched;
    private float[] mInitialMotionX;
    private float[] mInitialMotionY;
    private float[] mLastMotionX;
    private float[] mLastMotionY;
    private float mMaxVelocity;
    private float mMinVelocity;
    private final ViewGroup mParentView;
    private int mPointersDown;
    private boolean mReleaseInProgress;
    private ScrollerCompat mScroller;
    private final Runnable mSetIdleRunnable = new Runnable(){

        @Override
        public void run() {
            ViewDragHelper.this.setDragState(0);
        }
    };
    private int mTouchSlop;
    private int mTrackingEdges;
    private VelocityTracker mVelocityTracker;

    private ViewDragHelper(Context context, ViewGroup viewGroup, Callback callback) {
        if (viewGroup == null) {
            throw new IllegalArgumentException("Parent view may not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback may not be null");
        }
        this.mParentView = viewGroup;
        this.mCallback = callback;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mEdgeSize = (int)(0.5f + 20.0f * context.getResources().getDisplayMetrics().density);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMaxVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mMinVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mScroller = ScrollerCompat.create(context, sInterpolator);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkNewEdgeDrag(float f2, float f3, int n2, int n3) {
        block5: {
            block4: {
                float f4 = Math.abs(f2);
                float f5 = Math.abs(f3);
                if ((n3 & this.mInitialEdgesTouched[n2]) != n3 || (n3 & this.mTrackingEdges) == 0 || (n3 & this.mEdgeDragsLocked[n2]) == n3 || (n3 & this.mEdgeDragsInProgress[n2]) == n3 || f4 <= (float)this.mTouchSlop && f5 <= (float)this.mTouchSlop) break block4;
                if (f4 < 0.5f * f5 && this.mCallback.onEdgeLock(n3)) {
                    int[] nArray = this.mEdgeDragsLocked;
                    nArray[n2] = n3 | nArray[n2];
                    return false;
                }
                if ((n3 & this.mEdgeDragsInProgress[n2]) == 0 && f4 > (float)this.mTouchSlop) break block5;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkTouchSlop(View view, float f2, float f3) {
        boolean bl2 = true;
        if (view == null) {
            return false;
        }
        boolean bl3 = this.mCallback.getViewHorizontalDragRange(view) > 0 ? bl2 : false;
        boolean bl4 = this.mCallback.getViewVerticalDragRange(view) > 0 ? bl2 : false;
        if (bl3 && bl4) {
            if (f2 * f2 + f3 * f3 > (float)(this.mTouchSlop * this.mTouchSlop)) return bl2;
            return false;
        }
        if (bl3) {
            if (Math.abs(f2) > (float)this.mTouchSlop) return bl2;
            return false;
        }
        if (!bl4) {
            return false;
        }
        if (Math.abs(f3) > (float)this.mTouchSlop) return bl2;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float clampMag(float f2, float f3, float f4) {
        float f5 = Math.abs(f2);
        if (f5 < f3) {
            return 0.0f;
        }
        if (!(f5 > f4)) return f2;
        if (f2 > 0.0f) return f4;
        return -f4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int clampMag(int n2, int n3, int n4) {
        int n5 = Math.abs(n2);
        if (n5 < n3) {
            return 0;
        }
        if (n5 <= n4) return n2;
        if (n2 > 0) return n4;
        return -n4;
    }

    private void clearMotionHistory() {
        if (this.mInitialMotionX == null) {
            return;
        }
        Arrays.fill(this.mInitialMotionX, 0.0f);
        Arrays.fill(this.mInitialMotionY, 0.0f);
        Arrays.fill(this.mLastMotionX, 0.0f);
        Arrays.fill(this.mLastMotionY, 0.0f);
        Arrays.fill(this.mInitialEdgesTouched, 0);
        Arrays.fill(this.mEdgeDragsInProgress, 0);
        Arrays.fill(this.mEdgeDragsLocked, 0);
        this.mPointersDown = 0;
    }

    private void clearMotionHistory(int n2) {
        if (this.mInitialMotionX == null) {
            return;
        }
        this.mInitialMotionX[n2] = 0.0f;
        this.mInitialMotionY[n2] = 0.0f;
        this.mLastMotionX[n2] = 0.0f;
        this.mLastMotionY[n2] = 0.0f;
        this.mInitialEdgesTouched[n2] = 0;
        this.mEdgeDragsInProgress[n2] = 0;
        this.mEdgeDragsLocked[n2] = 0;
        this.mPointersDown &= 0xFFFFFFFF ^ 1 << n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int computeAxisDuration(int n2, int n3, int n4) {
        int n5;
        if (n2 == 0) {
            return 0;
        }
        int n6 = this.mParentView.getWidth();
        int n7 = n6 / 2;
        float f2 = Math.min(1.0f, (float)Math.abs(n2) / (float)n6);
        float f3 = (float)n7 + (float)n7 * this.distanceInfluenceForSnapDuration(f2);
        int n8 = Math.abs(n3);
        if (n8 > 0) {
            n5 = 4 * Math.round(1000.0f * Math.abs(f3 / (float)n8));
            return Math.min(n5, 600);
        }
        n5 = (int)(256.0f * (1.0f + (float)Math.abs(n2) / (float)n4));
        return Math.min(n5, 600);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int computeSettleDuration(View view, int n2, int n3, int n4, int n5) {
        int n6 = this.clampMag(n4, (int)this.mMinVelocity, (int)this.mMaxVelocity);
        int n7 = this.clampMag(n5, (int)this.mMinVelocity, (int)this.mMaxVelocity);
        int n8 = Math.abs(n2);
        int n9 = Math.abs(n3);
        int n10 = Math.abs(n6);
        int n11 = Math.abs(n7);
        int n12 = n10 + n11;
        int n13 = n8 + n9;
        float f2 = n6 != 0 ? (float)n10 / (float)n12 : (float)n8 / (float)n13;
        float f3 = n7 != 0 ? (float)n11 / (float)n12 : (float)n9 / (float)n13;
        int n14 = this.computeAxisDuration(n2, n6, this.mCallback.getViewHorizontalDragRange(view));
        int n15 = this.computeAxisDuration(n3, n7, this.mCallback.getViewVerticalDragRange(view));
        return (int)(f2 * (float)n14 + f3 * (float)n15);
    }

    public static ViewDragHelper create(ViewGroup viewGroup, float f2, Callback callback) {
        ViewDragHelper viewDragHelper = ViewDragHelper.create(viewGroup, callback);
        viewDragHelper.mTouchSlop = (int)((float)viewDragHelper.mTouchSlop * (1.0f / f2));
        return viewDragHelper;
    }

    public static ViewDragHelper create(ViewGroup viewGroup, Callback callback) {
        return new ViewDragHelper(viewGroup.getContext(), viewGroup, callback);
    }

    private void dispatchViewReleased(float f2, float f3) {
        this.mReleaseInProgress = true;
        this.mCallback.onViewReleased(this.mCapturedView, f2, f3);
        this.mReleaseInProgress = false;
        if (this.mDragState == 1) {
            this.setDragState(0);
        }
    }

    private float distanceInfluenceForSnapDuration(float f2) {
        return (float)Math.sin((float)(0.4712389167638204 * (double)(f2 - 0.5f)));
    }

    private void dragTo(int n2, int n3, int n4, int n5) {
        int n6 = n2;
        int n7 = n3;
        int n8 = this.mCapturedView.getLeft();
        int n9 = this.mCapturedView.getTop();
        if (n4 != 0) {
            n6 = this.mCallback.clampViewPositionHorizontal(this.mCapturedView, n2, n4);
            this.mCapturedView.offsetLeftAndRight(n6 - n8);
        }
        if (n5 != 0) {
            n7 = this.mCallback.clampViewPositionVertical(this.mCapturedView, n3, n5);
            this.mCapturedView.offsetTopAndBottom(n7 - n9);
        }
        if (n4 != 0 || n5 != 0) {
            int n10 = n6 - n8;
            int n11 = n7 - n9;
            this.mCallback.onViewPositionChanged(this.mCapturedView, n6, n7, n10, n11);
        }
    }

    private void ensureMotionHistorySizeForId(int n2) {
        if (this.mInitialMotionX == null || this.mInitialMotionX.length <= n2) {
            float[] fArray = new float[n2 + 1];
            float[] fArray2 = new float[n2 + 1];
            float[] fArray3 = new float[n2 + 1];
            float[] fArray4 = new float[n2 + 1];
            int[] nArray = new int[n2 + 1];
            int[] nArray2 = new int[n2 + 1];
            int[] nArray3 = new int[n2 + 1];
            if (this.mInitialMotionX != null) {
                System.arraycopy(this.mInitialMotionX, 0, fArray, 0, this.mInitialMotionX.length);
                System.arraycopy(this.mInitialMotionY, 0, fArray2, 0, this.mInitialMotionY.length);
                System.arraycopy(this.mLastMotionX, 0, fArray3, 0, this.mLastMotionX.length);
                System.arraycopy(this.mLastMotionY, 0, fArray4, 0, this.mLastMotionY.length);
                System.arraycopy(this.mInitialEdgesTouched, 0, nArray, 0, this.mInitialEdgesTouched.length);
                System.arraycopy(this.mEdgeDragsInProgress, 0, nArray2, 0, this.mEdgeDragsInProgress.length);
                System.arraycopy(this.mEdgeDragsLocked, 0, nArray3, 0, this.mEdgeDragsLocked.length);
            }
            this.mInitialMotionX = fArray;
            this.mInitialMotionY = fArray2;
            this.mLastMotionX = fArray3;
            this.mLastMotionY = fArray4;
            this.mInitialEdgesTouched = nArray;
            this.mEdgeDragsInProgress = nArray2;
            this.mEdgeDragsLocked = nArray3;
        }
    }

    private boolean forceSettleCapturedViewAt(int n2, int n3, int n4, int n5) {
        int n6 = this.mCapturedView.getLeft();
        int n7 = this.mCapturedView.getTop();
        int n8 = n2 - n6;
        int n9 = n3 - n7;
        if (n8 == 0 && n9 == 0) {
            this.mScroller.abortAnimation();
            this.setDragState(0);
            return false;
        }
        int n10 = this.computeSettleDuration(this.mCapturedView, n8, n9, n4, n5);
        this.mScroller.startScroll(n6, n7, n8, n9, n10);
        this.setDragState(2);
        return true;
    }

    private int getEdgesTouched(int n2, int n3) {
        int n4 = this.mParentView.getLeft() + this.mEdgeSize;
        int n5 = 0;
        if (n2 < n4) {
            n5 = 0 | 1;
        }
        if (n3 < this.mParentView.getTop() + this.mEdgeSize) {
            n5 |= 4;
        }
        if (n2 > this.mParentView.getRight() - this.mEdgeSize) {
            n5 |= 2;
        }
        if (n3 > this.mParentView.getBottom() - this.mEdgeSize) {
            n5 |= 8;
        }
        return n5;
    }

    private void releaseViewForPointerUp() {
        this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaxVelocity);
        this.dispatchViewReleased(this.clampMag(VelocityTrackerCompat.getXVelocity(this.mVelocityTracker, this.mActivePointerId), this.mMinVelocity, this.mMaxVelocity), this.clampMag(VelocityTrackerCompat.getYVelocity(this.mVelocityTracker, this.mActivePointerId), this.mMinVelocity, this.mMaxVelocity));
    }

    private void reportNewEdgeDrags(float f2, float f3, int n2) {
        boolean bl2 = this.checkNewEdgeDrag(f2, f3, n2, 1);
        int n3 = 0;
        if (bl2) {
            n3 = 0 | 1;
        }
        if (this.checkNewEdgeDrag(f3, f2, n2, 4)) {
            n3 |= 4;
        }
        if (this.checkNewEdgeDrag(f2, f3, n2, 2)) {
            n3 |= 2;
        }
        if (this.checkNewEdgeDrag(f3, f2, n2, 8)) {
            n3 |= 8;
        }
        if (n3 != 0) {
            int[] nArray = this.mEdgeDragsInProgress;
            nArray[n2] = n3 | nArray[n2];
            this.mCallback.onEdgeDragStarted(n3, n2);
        }
    }

    private void saveInitialMotion(float f2, float f3, int n2) {
        this.ensureMotionHistorySizeForId(n2);
        float[] fArray = this.mInitialMotionX;
        this.mLastMotionX[n2] = f2;
        fArray[n2] = f2;
        float[] fArray2 = this.mInitialMotionY;
        this.mLastMotionY[n2] = f3;
        fArray2[n2] = f3;
        this.mInitialEdgesTouched[n2] = this.getEdgesTouched((int)f2, (int)f3);
        this.mPointersDown |= 1 << n2;
    }

    private void saveLastMotion(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getPointerCount(motionEvent);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = MotionEventCompat.getPointerId(motionEvent, i2);
            float f2 = MotionEventCompat.getX(motionEvent, i2);
            float f3 = MotionEventCompat.getY(motionEvent, i2);
            this.mLastMotionX[n3] = f2;
            this.mLastMotionY[n3] = f3;
        }
    }

    public void abort() {
        this.cancel();
        if (this.mDragState == 2) {
            int n2 = this.mScroller.getCurrX();
            int n3 = this.mScroller.getCurrY();
            this.mScroller.abortAnimation();
            int n4 = this.mScroller.getCurrX();
            int n5 = this.mScroller.getCurrY();
            this.mCallback.onViewPositionChanged(this.mCapturedView, n4, n5, n4 - n2, n5 - n3);
        }
        this.setDragState(0);
    }

    protected boolean canScroll(View view, boolean bl2, int n2, int n3, int n4, int n5) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n6 = view.getScrollX();
            int n7 = view.getScrollY();
            for (int i2 = -1 + viewGroup.getChildCount(); i2 >= 0; --i2) {
                View view2 = viewGroup.getChildAt(i2);
                if (n4 + n6 < view2.getLeft() || n4 + n6 >= view2.getRight() || n5 + n7 < view2.getTop() || n5 + n7 >= view2.getBottom() || !this.canScroll(view2, true, n2, n3, n4 + n6 - view2.getLeft(), n5 + n7 - view2.getTop())) continue;
                return true;
            }
        }
        return bl2 && (ViewCompat.canScrollHorizontally(view, -n2) || ViewCompat.canScrollVertically(view, -n3));
    }

    public void cancel() {
        this.mActivePointerId = -1;
        this.clearMotionHistory();
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public void captureChildView(View view, int n2) {
        if (view.getParent() != this.mParentView) {
            throw new IllegalArgumentException("captureChildView: parameter must be a descendant of the ViewDragHelper's tracked parent view (" + this.mParentView + ")");
        }
        this.mCapturedView = view;
        this.mActivePointerId = n2;
        this.mCallback.onViewCaptured(view, n2);
        this.setDragState(1);
    }

    public boolean checkTouchSlop(int n2) {
        int n3 = this.mInitialMotionX.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!this.checkTouchSlop(n2, i2)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkTouchSlop(int n2, int n3) {
        int n4 = 1;
        if (!this.isPointerDown(n3)) {
            return 0 != 0;
        }
        int n5 = (n2 & 1) == n4 ? n4 : 0;
        int n6 = (n2 & 2) == 2 ? n4 : 0;
        float f2 = this.mLastMotionX[n3] - this.mInitialMotionX[n3];
        float f3 = this.mLastMotionY[n3] - this.mInitialMotionY[n3];
        if (n5 != 0 && n6 != 0) {
            if (f2 * f2 + f3 * f3 > (float)(this.mTouchSlop * this.mTouchSlop)) return n4 != 0;
            return false;
        }
        if (n5 != 0) {
            if (Math.abs(f2) > (float)this.mTouchSlop) return n4 != 0;
            return false;
        }
        if (n6 == 0) {
            return false;
        }
        if (Math.abs(f3) > (float)this.mTouchSlop) return n4 != 0;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean continueSettling(boolean bl2) {
        block9: {
            block8: {
                if (this.mDragState != 2) break block8;
                boolean bl3 = this.mScroller.computeScrollOffset();
                int n2 = this.mScroller.getCurrX();
                int n3 = this.mScroller.getCurrY();
                int n4 = n2 - this.mCapturedView.getLeft();
                int n5 = n3 - this.mCapturedView.getTop();
                if (n4 != 0) {
                    this.mCapturedView.offsetLeftAndRight(n4);
                }
                if (n5 != 0) {
                    this.mCapturedView.offsetTopAndBottom(n5);
                }
                if (n4 != 0 || n5 != 0) {
                    this.mCallback.onViewPositionChanged(this.mCapturedView, n2, n3, n4, n5);
                }
                if (bl3 && n2 == this.mScroller.getFinalX() && n3 == this.mScroller.getFinalY()) {
                    this.mScroller.abortAnimation();
                    bl3 = this.mScroller.isFinished();
                }
                if (bl3) break block8;
                if (!bl2) break block9;
                this.mParentView.post(this.mSetIdleRunnable);
            }
            return this.mDragState == 2;
        }
        this.setDragState(0);
        return this.mDragState == 2;
    }

    public View findTopChildUnder(int n2, int n3) {
        for (int i2 = -1 + this.mParentView.getChildCount(); i2 >= 0; --i2) {
            View view = this.mParentView.getChildAt(this.mCallback.getOrderedChildIndex(i2));
            if (n2 < view.getLeft() || n2 >= view.getRight() || n3 < view.getTop() || n3 >= view.getBottom()) continue;
            return view;
        }
        return null;
    }

    public void flingCapturedView(int n2, int n3, int n4, int n5) {
        if (!this.mReleaseInProgress) {
            throw new IllegalStateException("Cannot flingCapturedView outside of a call to Callback#onViewReleased");
        }
        this.mScroller.fling(this.mCapturedView.getLeft(), this.mCapturedView.getTop(), (int)VelocityTrackerCompat.getXVelocity(this.mVelocityTracker, this.mActivePointerId), (int)VelocityTrackerCompat.getYVelocity(this.mVelocityTracker, this.mActivePointerId), n2, n4, n3, n5);
        this.setDragState(2);
    }

    public int getActivePointerId() {
        return this.mActivePointerId;
    }

    public View getCapturedView() {
        return this.mCapturedView;
    }

    public int getEdgeSize() {
        return this.mEdgeSize;
    }

    public float getMinVelocity() {
        return this.mMinVelocity;
    }

    public int getTouchSlop() {
        return this.mTouchSlop;
    }

    public int getViewDragState() {
        return this.mDragState;
    }

    public boolean isCapturedViewUnder(int n2, int n3) {
        return this.isViewUnder(this.mCapturedView, n2, n3);
    }

    public boolean isEdgeTouched(int n2) {
        int n3 = this.mInitialEdgesTouched.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!this.isEdgeTouched(n2, i2)) continue;
            return true;
        }
        return false;
    }

    public boolean isEdgeTouched(int n2, int n3) {
        return this.isPointerDown(n3) && (n2 & this.mInitialEdgesTouched[n3]) != 0;
    }

    public boolean isPointerDown(int n2) {
        return (this.mPointersDown & 1 << n2) != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isViewUnder(View view, int n2, int n3) {
        return view != null && n2 >= view.getLeft() && n2 < view.getRight() && n3 >= view.getTop() && n3 < view.getBottom();
    }

    /*
     * Unable to fully structure code
     */
    public void processTouchEvent(MotionEvent var1_1) {
        var2_2 = MotionEventCompat.getActionMasked(var1_1);
        var3_3 = MotionEventCompat.getActionIndex(var1_1);
        if (var2_2 == 0) {
            this.cancel();
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(var1_1);
        switch (var2_2) lbl-1000:
        // 4 sources

        {
            default: {
                return;
            }
            case 0: {
                var30_4 = var1_1.getX();
                var31_5 = var1_1.getY();
                var32_6 = MotionEventCompat.getPointerId(var1_1, 0);
                var33_7 = this.findTopChildUnder((int)var30_4, (int)var31_5);
                this.saveInitialMotion(var30_4, var31_5, var32_6);
                this.tryCaptureViewForDrag(var33_7, var32_6);
                var35_8 = this.mInitialEdgesTouched[var32_6];
                if ((var35_8 & this.mTrackingEdges) == 0) ** GOTO lbl-1000
                this.mCallback.onEdgeTouched(var35_8 & this.mTrackingEdges, var32_6);
                return;
            }
            case 5: {
                var24_9 = MotionEventCompat.getPointerId(var1_1, var3_3);
                var25_10 = MotionEventCompat.getX(var1_1, var3_3);
                var26_11 = MotionEventCompat.getY(var1_1, var3_3);
                this.saveInitialMotion(var25_10, var26_11, var24_9);
                if (this.mDragState != 0) ** GOTO lbl35
                this.tryCaptureViewForDrag(this.findTopChildUnder((int)var25_10, (int)var26_11), var24_9);
                var29_12 = this.mInitialEdgesTouched[var24_9];
                if ((var29_12 & this.mTrackingEdges) == 0) ** GOTO lbl-1000
                this.mCallback.onEdgeTouched(var29_12 & this.mTrackingEdges, var24_9);
                return;
lbl35:
                // 1 sources

                if (!this.isCapturedViewUnder((int)var25_10, (int)var26_11)) ** GOTO lbl-1000
                this.tryCaptureViewForDrag(this.mCapturedView, var24_9);
                return;
            }
            case 2: {
                if (this.mDragState == 1) {
                    var19_13 = MotionEventCompat.findPointerIndex(var1_1, this.mActivePointerId);
                    var20_14 = MotionEventCompat.getX(var1_1, var19_13);
                    var21_15 = MotionEventCompat.getY(var1_1, var19_13);
                    var22_16 = (int)(var20_14 - this.mLastMotionX[this.mActivePointerId]);
                    var23_17 = (int)(var21_15 - this.mLastMotionY[this.mActivePointerId]);
                    this.dragTo(var22_16 + this.mCapturedView.getLeft(), var23_17 + this.mCapturedView.getTop(), var22_16, var23_17);
                    this.saveLastMotion(var1_1);
                    return;
                }
                var11_18 = MotionEventCompat.getPointerCount(var1_1);
                var12_19 = 0;
                while (true) {
                    if (var12_19 >= var11_18) ** GOTO lbl60
                    var13_23 = MotionEventCompat.getPointerId(var1_1, var12_19);
                    var14_24 = MotionEventCompat.getX(var1_1, var12_19);
                    var15_25 = MotionEventCompat.getY(var1_1, var12_19);
                    var16_20 = var14_24 - this.mInitialMotionX[var13_23];
                    var17_21 = var15_25 - this.mInitialMotionY[var13_23];
                    this.reportNewEdgeDrags(var16_20, var17_21, var13_23);
                    if (this.mDragState != 1) ** GOTO lbl63
lbl60:
                    // 3 sources

                    while (true) {
                        this.saveLastMotion(var1_1);
                        return;
                    }
lbl63:
                    // 1 sources

                    if (this.checkTouchSlop(var18_22 = this.findTopChildUnder((int)var14_24, (int)var15_25), var16_20, var17_21) && this.tryCaptureViewForDrag(var18_22, var13_23)) ** continue;
                    ++var12_19;
                }
            }
            case 6: {
                var4_26 = MotionEventCompat.getPointerId(var1_1, var3_3);
                if (this.mDragState == 1 && var4_26 == this.mActivePointerId) {
                    var5_27 = -1;
                    var6_28 = MotionEventCompat.getPointerCount(var1_1);
                    block11: for (var7_29 = 0; var7_29 < var6_28; ++var7_29) {
                        var8_30 = MotionEventCompat.getPointerId(var1_1, var7_29);
                        if (var8_30 == this.mActivePointerId) {
                            continue block11;
                        }
                        if (this.findTopChildUnder((int)(var9_31 = MotionEventCompat.getX(var1_1, var7_29)), (int)(var10_32 = MotionEventCompat.getY(var1_1, var7_29))) != this.mCapturedView || !this.tryCaptureViewForDrag(this.mCapturedView, var8_30)) ** continue;
                        var5_27 = this.mActivePointerId;
                        break;
                    }
                    if (var5_27 == -1) {
                        this.releaseViewForPointerUp();
                    }
                }
                this.clearMotionHistory(var4_26);
                return;
            }
            case 1: {
                if (this.mDragState == 1) {
                    this.releaseViewForPointerUp();
                }
                this.cancel();
                return;
            }
            case 3: 
        }
        if (this.mDragState == 1) {
            this.dispatchViewReleased(0.0f, 0.0f);
        }
        this.cancel();
    }

    void setDragState(int n2) {
        if (this.mDragState != n2) {
            this.mDragState = n2;
            this.mCallback.onViewDragStateChanged(n2);
            if (n2 == 0) {
                this.mCapturedView = null;
            }
        }
    }

    public void setEdgeTrackingEnabled(int n2) {
        this.mTrackingEdges = n2;
    }

    public void setMinVelocity(float f2) {
        this.mMinVelocity = f2;
    }

    public boolean settleCapturedViewAt(int n2, int n3) {
        if (!this.mReleaseInProgress) {
            throw new IllegalStateException("Cannot settleCapturedViewAt outside of a call to Callback#onViewReleased");
        }
        return this.forceSettleCapturedViewAt(n2, n3, (int)VelocityTrackerCompat.getXVelocity(this.mVelocityTracker, this.mActivePointerId), (int)VelocityTrackerCompat.getYVelocity(this.mVelocityTracker, this.mActivePointerId));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean shouldInterceptTouchEvent(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getActionMasked(motionEvent);
        int n3 = MotionEventCompat.getActionIndex(motionEvent);
        if (n2 == 0) {
            this.cancel();
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        switch (n2) {
            case 0: {
                int n4;
                float f2 = motionEvent.getX();
                float f3 = motionEvent.getY();
                int n5 = MotionEventCompat.getPointerId(motionEvent, 0);
                this.saveInitialMotion(f2, f3, n5);
                View view = this.findTopChildUnder((int)f2, (int)f3);
                if (view == this.mCapturedView && this.mDragState == 2) {
                    this.tryCaptureViewForDrag(view, n5);
                }
                if (((n4 = this.mInitialEdgesTouched[n5]) & this.mTrackingEdges) == 0) break;
                this.mCallback.onEdgeTouched(n4 & this.mTrackingEdges, n5);
                break;
            }
            case 5: {
                View view;
                int n6 = MotionEventCompat.getPointerId(motionEvent, n3);
                float f4 = MotionEventCompat.getX(motionEvent, n3);
                float f5 = MotionEventCompat.getY(motionEvent, n3);
                this.saveInitialMotion(f4, f5, n6);
                if (this.mDragState == 0) {
                    int n7 = this.mInitialEdgesTouched[n6];
                    if ((n7 & this.mTrackingEdges) == 0) break;
                    this.mCallback.onEdgeTouched(n7 & this.mTrackingEdges, n6);
                    break;
                }
                if (this.mDragState != 2 || (view = this.findTopChildUnder((int)f4, (int)f5)) != this.mCapturedView) break;
                this.tryCaptureViewForDrag(view, n6);
                break;
            }
            case 2: {
                int n8 = MotionEventCompat.getPointerCount(motionEvent);
                for (int i2 = 0; i2 < n8; ++i2) {
                    View view;
                    int n9 = MotionEventCompat.getPointerId(motionEvent, i2);
                    float f6 = MotionEventCompat.getX(motionEvent, i2);
                    float f7 = MotionEventCompat.getY(motionEvent, i2);
                    float f8 = f6 - this.mInitialMotionX[n9];
                    float f9 = f7 - this.mInitialMotionY[n9];
                    this.reportNewEdgeDrags(f8, f9, n9);
                    if (this.mDragState == 1 || (view = this.findTopChildUnder((int)f6, (int)f7)) != null && this.checkTouchSlop(view, f8, f9) && this.tryCaptureViewForDrag(view, n9)) break;
                }
                this.saveLastMotion(motionEvent);
                break;
            }
            case 6: {
                this.clearMotionHistory(MotionEventCompat.getPointerId(motionEvent, n3));
                break;
            }
            case 1: 
            case 3: {
                this.cancel();
            }
        }
        return this.mDragState == 1;
    }

    public boolean smoothSlideViewTo(View view, int n2, int n3) {
        this.mCapturedView = view;
        this.mActivePointerId = -1;
        return this.forceSettleCapturedViewAt(n2, n3, 0, 0);
    }

    boolean tryCaptureViewForDrag(View view, int n2) {
        if (view == this.mCapturedView && this.mActivePointerId == n2) {
            return true;
        }
        if (view != null && this.mCallback.tryCaptureView(view, n2)) {
            this.mActivePointerId = n2;
            this.captureChildView(view, n2);
            return true;
        }
        return false;
    }

    public static abstract class Callback {
        public int clampViewPositionHorizontal(View view, int n2, int n3) {
            return 0;
        }

        public int clampViewPositionVertical(View view, int n2, int n3) {
            return 0;
        }

        public int getOrderedChildIndex(int n2) {
            return n2;
        }

        public int getViewHorizontalDragRange(View view) {
            return 0;
        }

        public int getViewVerticalDragRange(View view) {
            return 0;
        }

        public void onEdgeDragStarted(int n2, int n3) {
        }

        public boolean onEdgeLock(int n2) {
            return false;
        }

        public void onEdgeTouched(int n2, int n3) {
        }

        public void onViewCaptured(View view, int n2) {
        }

        public void onViewDragStateChanged(int n2) {
        }

        public void onViewPositionChanged(View view, int n2, int n3, int n4, int n5) {
        }

        public void onViewReleased(View view, float f2, float f3) {
        }

        public abstract boolean tryCaptureView(View var1, int var2);
    }
}

