/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SlidingPaneLayout
extends ViewGroup {
    private static final int DEFAULT_FADE_COLOR = -858993460;
    private static final int DEFAULT_OVERHANG_SIZE = 32;
    static final SlidingPanelLayoutImpl IMPL;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final String TAG = "SlidingPaneLayout";
    private boolean mCanSlide;
    private int mCoveredFadeColor;
    private final ViewDragHelper mDragHelper;
    private boolean mFirstLayout = true;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private boolean mIsUnableToDrag;
    private final int mOverhangSize;
    private PanelSlideListener mPanelSlideListener;
    private int mParallaxBy;
    private float mParallaxOffset;
    private final ArrayList<DisableLayerRunnable> mPostedRunnables;
    private boolean mPreservedOpenState;
    private Drawable mShadowDrawable;
    private float mSlideOffset;
    private int mSlideRange;
    private View mSlideableView;
    private int mSliderFadeColor = -858993460;
    private final Rect mTmpRect = new Rect();

    static {
        int n2 = Build.VERSION.SDK_INT;
        IMPL = n2 >= 17 ? new SlidingPanelLayoutImplJBMR1() : (n2 >= 16 ? new SlidingPanelLayoutImplJB() : new SlidingPanelLayoutImplBase());
    }

    public SlidingPaneLayout(Context context) {
        this(context, null);
    }

    public SlidingPaneLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SlidingPaneLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mPostedRunnables = new ArrayList();
        float f2 = context.getResources().getDisplayMetrics().density;
        this.mOverhangSize = (int)(0.5f + 32.0f * f2);
        ViewConfiguration.get((Context)context);
        this.setWillNotDraw(false);
        ViewCompat.setAccessibilityDelegate((View)this, new AccessibilityDelegate());
        ViewCompat.setImportantForAccessibility((View)this, 1);
        this.mDragHelper = ViewDragHelper.create(this, 0.5f, new DragHelperCallback());
        this.mDragHelper.setEdgeTrackingEnabled(1);
        this.mDragHelper.setMinVelocity(400.0f * f2);
    }

    static /* synthetic */ boolean access$502(SlidingPaneLayout slidingPaneLayout, boolean bl2) {
        slidingPaneLayout.mPreservedOpenState = bl2;
        return bl2;
    }

    private boolean closePane(View view, int n2) {
        boolean bl2;
        block3: {
            block2: {
                if (this.mFirstLayout) break block2;
                boolean bl3 = this.smoothSlideTo(0.0f, n2);
                bl2 = false;
                if (!bl3) break block3;
            }
            this.mPreservedOpenState = false;
            bl2 = true;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dimChildView(View view, float f2, int n2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (f2 > 0.0f && n2 != 0) {
            int n3 = (int)(f2 * (float)((0xFF000000 & n2) >>> 24)) << 24 | 0xFFFFFF & n2;
            if (layoutParams.dimPaint == null) {
                layoutParams.dimPaint = new Paint();
            }
            layoutParams.dimPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(n3, PorterDuff.Mode.SRC_OVER));
            if (ViewCompat.getLayerType(view) != 2) {
                ViewCompat.setLayerType(view, 2, layoutParams.dimPaint);
            }
            this.invalidateChildRegion(view);
            return;
        } else {
            if (ViewCompat.getLayerType(view) == 0) return;
            if (layoutParams.dimPaint != null) {
                layoutParams.dimPaint.setColorFilter(null);
            }
            DisableLayerRunnable disableLayerRunnable = new DisableLayerRunnable(view);
            this.mPostedRunnables.add(disableLayerRunnable);
            ViewCompat.postOnAnimation((View)this, disableLayerRunnable);
            return;
        }
    }

    private void invalidateChildRegion(View view) {
        IMPL.invalidateChildRegion(this, view);
    }

    private void onPanelDragged(int n2) {
        LayoutParams layoutParams = (LayoutParams)this.mSlideableView.getLayoutParams();
        this.mSlideOffset = (float)(n2 - (this.getPaddingLeft() + layoutParams.leftMargin)) / (float)this.mSlideRange;
        if (this.mParallaxBy != 0) {
            this.parallaxOtherViews(this.mSlideOffset);
        }
        if (layoutParams.dimWhenOffset) {
            this.dimChildView(this.mSlideableView, this.mSlideOffset, this.mSliderFadeColor);
        }
        this.dispatchOnPanelSlide(this.mSlideableView);
    }

    private boolean openPane(View view, int n2) {
        if (this.mFirstLayout || this.smoothSlideTo(1.0f, n2)) {
            this.mPreservedOpenState = true;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parallaxOtherViews(float f2) {
        LayoutParams layoutParams = (LayoutParams)this.mSlideableView.getLayoutParams();
        boolean bl2 = layoutParams.dimWhenOffset && layoutParams.leftMargin <= 0;
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getChildAt(n3);
            if (view != this.mSlideableView) {
                int n4 = (int)((1.0f - this.mParallaxOffset) * (float)this.mParallaxBy);
                this.mParallaxOffset = f2;
                view.offsetLeftAndRight(n4 - (int)((1.0f - f2) * (float)this.mParallaxBy));
                if (bl2) {
                    this.dimChildView(view, 1.0f - this.mParallaxOffset, this.mCoveredFadeColor);
                }
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean viewIsOpaque(View view) {
        block6: {
            block5: {
                if (ViewCompat.isOpaque(view)) break block5;
                if (Build.VERSION.SDK_INT >= 18) {
                    return false;
                }
                Drawable drawable2 = view.getBackground();
                if (drawable2 == null) {
                    return false;
                }
                if (drawable2.getOpacity() != -1) break block6;
            }
            return true;
        }
        return false;
    }

    protected boolean canScroll(View view, boolean bl2, int n2, int n3, int n4) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n5 = view.getScrollX();
            int n6 = view.getScrollY();
            for (int i2 = -1 + viewGroup.getChildCount(); i2 >= 0; --i2) {
                View view2 = viewGroup.getChildAt(i2);
                if (n3 + n5 < view2.getLeft() || n3 + n5 >= view2.getRight() || n4 + n6 < view2.getTop() || n4 + n6 >= view2.getBottom() || !this.canScroll(view2, true, n2, n3 + n5 - view2.getLeft(), n4 + n6 - view2.getTop())) continue;
                return true;
            }
        }
        return bl2 && ViewCompat.canScrollHorizontally(view, -n2);
    }

    @Deprecated
    public boolean canSlide() {
        return this.mCanSlide;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams && super.checkLayoutParams(layoutParams);
    }

    public boolean closePane() {
        return this.closePane(this.mSlideableView, 0);
    }

    public void computeScroll() {
        block3: {
            block2: {
                if (!this.mDragHelper.continueSettling(true)) break block2;
                if (this.mCanSlide) break block3;
                this.mDragHelper.abort();
            }
            return;
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    void dispatchOnPanelClosed(View view) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelClosed(view);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelOpened(View view) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelOpened(view);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelSlide(View view) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelSlide(view, this.mSlideOffset);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.getChildCount() <= 1) return;
        View view = this.getChildAt(1);
        if (view == null) return;
        if (this.mShadowDrawable == null) {
            return;
        }
        int n2 = this.mShadowDrawable.getIntrinsicWidth();
        int n3 = view.getLeft();
        int n4 = view.getTop();
        int n5 = view.getBottom();
        int n6 = n3 - n2;
        this.mShadowDrawable.setBounds(n6, n4, n3, n5);
        this.mShadowDrawable.draw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean drawChild(Canvas canvas, View view, long l2) {
        boolean bl2;
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n2 = canvas.save(2);
        if (this.mCanSlide && !layoutParams.slideable && this.mSlideableView != null) {
            canvas.getClipBounds(this.mTmpRect);
            this.mTmpRect.right = Math.min(this.mTmpRect.right, this.mSlideableView.getLeft());
            canvas.clipRect(this.mTmpRect);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            bl2 = super.drawChild(canvas, view, l2);
        } else if (layoutParams.dimWhenOffset && this.mSlideOffset > 0.0f) {
            Bitmap bitmap;
            if (!view.isDrawingCacheEnabled()) {
                view.setDrawingCacheEnabled(true);
            }
            if ((bitmap = view.getDrawingCache()) != null) {
                canvas.drawBitmap(bitmap, (float)view.getLeft(), (float)view.getTop(), layoutParams.dimPaint);
                bl2 = false;
            } else {
                Log.e((String)TAG, (String)("drawChild: child view " + view + " returned null drawing cache"));
                bl2 = super.drawChild(canvas, view, l2);
            }
        } else {
            if (view.isDrawingCacheEnabled()) {
                view.setDrawingCacheEnabled(false);
            }
            bl2 = super.drawChild(canvas, view, l2);
        }
        canvas.restoreToCount(n2);
        return bl2;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    public int getCoveredFadeColor() {
        return this.mCoveredFadeColor;
    }

    public int getParallaxDistance() {
        return this.mParallaxBy;
    }

    public int getSliderFadeColor() {
        return this.mSliderFadeColor;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean isDimmed(View view) {
        block3: {
            block2: {
                if (view == null) break block2;
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (this.mCanSlide && layoutParams.dimWhenOffset && this.mSlideOffset > 0.0f) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean isOpen() {
        return !this.mCanSlide || this.mSlideOffset == 1.0f;
    }

    public boolean isSlideable() {
        return this.mCanSlide;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
        int n2 = this.mPostedRunnables.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mPostedRunnables.get(i2).run();
        }
        this.mPostedRunnables.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        View view;
        int n2 = MotionEventCompat.getActionMasked(motionEvent);
        if (!this.mCanSlide && n2 == 0 && this.getChildCount() > 1 && (view = this.getChildAt(1)) != null) {
            boolean bl2 = !this.mDragHelper.isViewUnder(view, (int)motionEvent.getX(), (int)motionEvent.getY());
            this.mPreservedOpenState = bl2;
        }
        if (!this.mCanSlide || this.mIsUnableToDrag && n2 != 0) {
            this.mDragHelper.cancel();
            return super.onInterceptTouchEvent(motionEvent);
        }
        if (n2 == 3 || n2 == 1) {
            this.mDragHelper.cancel();
            return false;
        }
        boolean bl3 = false;
        switch (n2) {
            case 0: {
                this.mIsUnableToDrag = false;
                float f2 = motionEvent.getX();
                float f3 = motionEvent.getY();
                this.mInitialMotionX = f2;
                this.mInitialMotionY = f3;
                boolean bl4 = this.mDragHelper.isViewUnder(this.mSlideableView, (int)f2, (int)f3);
                bl3 = false;
                if (!bl4) break;
                boolean bl5 = this.isDimmed(this.mSlideableView);
                bl3 = false;
                if (!bl5) break;
                bl3 = true;
                break;
            }
            case 2: {
                float f4 = motionEvent.getX();
                float f5 = motionEvent.getY();
                float f6 = Math.abs(f4 - this.mInitialMotionX);
                float f7 = Math.abs(f5 - this.mInitialMotionY);
                float f8 = f6 - (float)this.mDragHelper.getTouchSlop();
                float f9 = f8 == 0.0f ? 0 : (f8 > 0.0f ? 1 : -1);
                bl3 = false;
                if (f9 <= 0) break;
                float f10 = f7 == f6 ? 0 : (f7 > f6 ? 1 : -1);
                bl3 = false;
                if (f10 <= 0) break;
                this.mDragHelper.cancel();
                this.mIsUnableToDrag = true;
                return false;
            }
        }
        return this.mDragHelper.shouldInterceptTouchEvent(motionEvent) || bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n4 - n2;
        int n8 = this.getPaddingLeft();
        int n9 = this.getPaddingRight();
        int n10 = this.getPaddingTop();
        int n11 = this.getChildCount();
        int n12 = n6 = n8;
        if (this.mFirstLayout) {
            float f2 = this.mCanSlide && this.mPreservedOpenState ? 1.0f : 0.0f;
            this.mSlideOffset = f2;
        }
        for (int i2 = 0; i2 < n11; ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n13 = view.getMeasuredWidth();
            int n14 = 0;
            if (layoutParams.slideable) {
                int n15;
                int n16 = layoutParams.leftMargin + layoutParams.rightMargin;
                this.mSlideRange = n15 = Math.min(n12, n7 - n9 - this.mOverhangSize) - n6 - n16;
                boolean bl3 = n15 + (n6 + layoutParams.leftMargin) + n13 / 2 > n7 - n9;
                layoutParams.dimWhenOffset = bl3;
                n6 += (int)((float)n15 * this.mSlideOffset) + layoutParams.leftMargin;
            } else if (this.mCanSlide && this.mParallaxBy != 0) {
                n14 = (int)((1.0f - this.mSlideOffset) * (float)this.mParallaxBy);
                n6 = n12;
            } else {
                n6 = n12;
                n14 = 0;
            }
            int n17 = n6 - n14;
            view.layout(n17, n10, n17 + n13, n10 + view.getMeasuredHeight());
            n12 += view.getWidth();
        }
        if (this.mFirstLayout) {
            if (this.mCanSlide) {
                if (this.mParallaxBy != 0) {
                    this.parallaxOtherViews(this.mSlideOffset);
                }
                if (((LayoutParams)this.mSlideableView.getLayoutParams()).dimWhenOffset) {
                    this.dimChildView(this.mSlideableView, this.mSlideOffset, this.mSliderFadeColor);
                }
            } else {
                for (int i3 = 0; i3 < n11; ++i3) {
                    this.dimChildView(this.getChildAt(i3), 0.0f, this.mSliderFadeColor);
                }
            }
            this.updateObscuredViewsVisibility(this.mSlideableView);
        }
        this.mFirstLayout = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        block21: {
            block20: {
                int n7 = View.MeasureSpec.getMode((int)n2);
                n6 = View.MeasureSpec.getSize((int)n2);
                n5 = View.MeasureSpec.getMode((int)n3);
                n4 = View.MeasureSpec.getSize((int)n3);
                if (n7 == 0x40000000) break block20;
                if (this.isInEditMode()) {
                    if (n7 != Integer.MIN_VALUE && n7 == 0) {
                        n6 = 300;
                    }
                    break block21;
                } else {
                    throw new IllegalStateException("Width must have an exact value or MATCH_PARENT");
                }
            }
            if (n5 == 0) {
                if (!this.isInEditMode()) {
                    throw new IllegalStateException("Height must not be UNSPECIFIED");
                }
                if (n5 == 0) {
                    n5 = Integer.MIN_VALUE;
                    n4 = 300;
                }
            }
        }
        int n8 = -1;
        int n9 = 0;
        switch (n5) {
            case 0x40000000: {
                n9 = n8 = n4 - this.getPaddingTop() - this.getPaddingBottom();
                break;
            }
            case -2147483648: {
                n8 = n4 - this.getPaddingTop() - this.getPaddingBottom();
                n9 = 0;
            }
        }
        float f2 = 0.0f;
        boolean bl2 = false;
        int n10 = n6 - this.getPaddingLeft() - this.getPaddingRight();
        int n11 = this.getChildCount();
        if (n11 > 2) {
            Log.e((String)TAG, (String)"onMeasure: More than two child views are not supported.");
        }
        this.mSlideableView = null;
        for (int i2 = 0; i2 < n11; ++i2) {
            View view = this.getChildAt(i2);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (view.getVisibility() == 8) {
                layoutParams.dimWhenOffset = false;
                continue;
            }
            if (layoutParams.weight > 0.0f) {
                f2 += layoutParams.weight;
                if (layoutParams.width == 0) continue;
            }
            int n12 = layoutParams.leftMargin + layoutParams.rightMargin;
            int n13 = layoutParams.width == -2 ? View.MeasureSpec.makeMeasureSpec((int)(n6 - n12), (int)Integer.MIN_VALUE) : (layoutParams.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)(n6 - n12), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)layoutParams.width, (int)0x40000000));
            int n14 = layoutParams.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)n8, (int)Integer.MIN_VALUE) : (layoutParams.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)n8, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000));
            view.measure(n13, n14);
            int n15 = view.getMeasuredWidth();
            int n16 = view.getMeasuredHeight();
            if (n5 == Integer.MIN_VALUE && n16 > n9) {
                n9 = Math.min(n16, n8);
            }
            boolean bl3 = (n10 -= n15) < 0;
            layoutParams.slideable = bl3;
            bl2 |= bl3;
            if (!layoutParams.slideable) continue;
            this.mSlideableView = view;
        }
        if (bl2 || f2 > 0.0f) {
            int n17 = n6 - this.mOverhangSize;
            for (int i3 = 0; i3 < n11; ++i3) {
                View view = this.getChildAt(i3);
                if (view.getVisibility() == 8) continue;
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (view.getVisibility() == 8) continue;
                boolean bl4 = layoutParams.width == 0 && layoutParams.weight > 0.0f;
                int n18 = bl4 ? 0 : view.getMeasuredWidth();
                if (bl2 && view != this.mSlideableView) {
                    if (layoutParams.width >= 0 || n18 <= n17 && !(layoutParams.weight > 0.0f)) continue;
                    int n19 = bl4 ? (layoutParams.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)n8, (int)Integer.MIN_VALUE) : (layoutParams.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)n8, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000))) : View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredHeight(), (int)0x40000000);
                    view.measure(View.MeasureSpec.makeMeasureSpec((int)n17, (int)0x40000000), n19);
                    continue;
                }
                if (!(layoutParams.weight > 0.0f)) continue;
                int n20 = layoutParams.width == 0 ? (layoutParams.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)n8, (int)Integer.MIN_VALUE) : (layoutParams.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)n8, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000))) : View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredHeight(), (int)0x40000000);
                if (bl2) {
                    int n21 = n6 - (layoutParams.leftMargin + layoutParams.rightMargin);
                    int n22 = View.MeasureSpec.makeMeasureSpec((int)n21, (int)0x40000000);
                    if (n18 == n21) continue;
                    view.measure(n22, n20);
                    continue;
                }
                int n23 = Math.max(0, n10);
                view.measure(View.MeasureSpec.makeMeasureSpec((int)(n18 + (int)(layoutParams.weight * (float)n23 / f2)), (int)0x40000000), n20);
            }
        }
        this.setMeasuredDimension(n6, n9);
        this.mCanSlide = bl2;
        if (this.mDragHelper.getViewDragState() != 0 && !bl2) {
            this.mDragHelper.abort();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.isOpen) {
            this.openPane();
        } else {
            this.closePane();
        }
        this.mPreservedOpenState = savedState.isOpen;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        boolean bl2 = this.isSlideable() ? this.isOpen() : this.mPreservedOpenState;
        savedState.isOpen = bl2;
        return savedState;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n2 != n4) {
            this.mFirstLayout = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2;
        float f2;
        float f3;
        if (!this.mCanSlide) {
            return super.onTouchEvent(motionEvent);
        }
        this.mDragHelper.processTouchEvent(motionEvent);
        int n3 = motionEvent.getAction();
        boolean bl2 = true;
        switch (n3 & 0xFF) {
            default: {
                return bl2;
            }
            case 0: {
                float f4 = motionEvent.getX();
                float f5 = motionEvent.getY();
                this.mInitialMotionX = f4;
                this.mInitialMotionY = f5;
                return bl2;
            }
            case 1: 
        }
        if (!this.isDimmed(this.mSlideableView)) return bl2;
        float f6 = motionEvent.getX();
        float f7 = f6 - this.mInitialMotionX;
        if (!(f7 * f7 + (f3 = (f2 = motionEvent.getY()) - this.mInitialMotionY) * f3 < (float)((n2 = this.mDragHelper.getTouchSlop()) * n2))) return bl2;
        if (!this.mDragHelper.isViewUnder(this.mSlideableView, (int)f6, (int)f2)) return bl2;
        this.closePane(this.mSlideableView, 0);
        return bl2;
    }

    public boolean openPane() {
        return this.openPane(this.mSlideableView, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void requestChildFocus(View view, View view2) {
        super.requestChildFocus(view, view2);
        if (!this.isInTouchMode() && !this.mCanSlide) {
            boolean bl2 = view == this.mSlideableView;
            this.mPreservedOpenState = bl2;
        }
    }

    void setAllChildrenVisible() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 4) continue;
            view.setVisibility(0);
        }
    }

    public void setCoveredFadeColor(int n2) {
        this.mCoveredFadeColor = n2;
    }

    public void setPanelSlideListener(PanelSlideListener panelSlideListener) {
        this.mPanelSlideListener = panelSlideListener;
    }

    public void setParallaxDistance(int n2) {
        this.mParallaxBy = n2;
        this.requestLayout();
    }

    public void setShadowDrawable(Drawable drawable2) {
        this.mShadowDrawable = drawable2;
    }

    public void setShadowResource(int n2) {
        this.setShadowDrawable(this.getResources().getDrawable(n2));
    }

    public void setSliderFadeColor(int n2) {
        this.mSliderFadeColor = n2;
    }

    @Deprecated
    public void smoothSlideClosed() {
        this.closePane();
    }

    @Deprecated
    public void smoothSlideOpen() {
        this.openPane();
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean smoothSlideTo(float f2, int n2) {
        block3: {
            block2: {
                if (!this.mCanSlide) break block2;
                LayoutParams layoutParams = (LayoutParams)this.mSlideableView.getLayoutParams();
                int n3 = (int)((float)(this.getPaddingLeft() + layoutParams.leftMargin) + f2 * (float)this.mSlideRange);
                if (this.mDragHelper.smoothSlideViewTo(this.mSlideableView, n3, this.mSlideableView.getTop())) break block3;
            }
            return false;
        }
        this.setAllChildrenVisible();
        ViewCompat.postInvalidateOnAnimation((View)this);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateObscuredViewsVisibility(View view) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getPaddingLeft();
        int n7 = this.getWidth() - this.getPaddingRight();
        int n8 = this.getPaddingTop();
        int n9 = this.getHeight() - this.getPaddingBottom();
        if (view != null && SlidingPaneLayout.viewIsOpaque(view)) {
            n5 = view.getLeft();
            n4 = view.getRight();
            n3 = view.getTop();
            n2 = view.getBottom();
        } else {
            n2 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
        }
        int n10 = 0;
        int n11 = this.getChildCount();
        View view2;
        while (n10 < n11 && (view2 = this.getChildAt(n10)) != view) {
            int n12 = Math.max(n6, view2.getLeft());
            int n13 = Math.max(n8, view2.getTop());
            int n14 = Math.min(n7, view2.getRight());
            int n15 = Math.min(n9, view2.getBottom());
            int n16 = n12 >= n5 && n13 >= n3 && n14 <= n4 && n15 <= n2 ? 4 : 0;
            view2.setVisibility(n16);
            ++n10;
        }
        return;
    }

    class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private final Rect mTmpRect = new Rect();

        AccessibilityDelegate() {
        }

        private void copyNodeInfoNoChildren(AccessibilityNodeInfoCompat accessibilityNodeInfoCompat, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2) {
            Rect rect = this.mTmpRect;
            accessibilityNodeInfoCompat2.getBoundsInParent(rect);
            accessibilityNodeInfoCompat.setBoundsInParent(rect);
            accessibilityNodeInfoCompat2.getBoundsInScreen(rect);
            accessibilityNodeInfoCompat.setBoundsInScreen(rect);
            accessibilityNodeInfoCompat.setVisibleToUser(accessibilityNodeInfoCompat2.isVisibleToUser());
            accessibilityNodeInfoCompat.setPackageName(accessibilityNodeInfoCompat2.getPackageName());
            accessibilityNodeInfoCompat.setClassName(accessibilityNodeInfoCompat2.getClassName());
            accessibilityNodeInfoCompat.setContentDescription(accessibilityNodeInfoCompat2.getContentDescription());
            accessibilityNodeInfoCompat.setEnabled(accessibilityNodeInfoCompat2.isEnabled());
            accessibilityNodeInfoCompat.setClickable(accessibilityNodeInfoCompat2.isClickable());
            accessibilityNodeInfoCompat.setFocusable(accessibilityNodeInfoCompat2.isFocusable());
            accessibilityNodeInfoCompat.setFocused(accessibilityNodeInfoCompat2.isFocused());
            accessibilityNodeInfoCompat.setAccessibilityFocused(accessibilityNodeInfoCompat2.isAccessibilityFocused());
            accessibilityNodeInfoCompat.setSelected(accessibilityNodeInfoCompat2.isSelected());
            accessibilityNodeInfoCompat.setLongClickable(accessibilityNodeInfoCompat2.isLongClickable());
            accessibilityNodeInfoCompat.addAction(accessibilityNodeInfoCompat2.getActions());
            accessibilityNodeInfoCompat.setMovementGranularities(accessibilityNodeInfoCompat2.getMovementGranularities());
        }

        public boolean filter(View view) {
            return SlidingPaneLayout.this.isDimmed(view);
        }

        @Override
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName((CharSequence)SlidingPaneLayout.class.getName());
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = AccessibilityNodeInfoCompat.obtain(accessibilityNodeInfoCompat);
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat2);
            this.copyNodeInfoNoChildren(accessibilityNodeInfoCompat, accessibilityNodeInfoCompat2);
            accessibilityNodeInfoCompat2.recycle();
            accessibilityNodeInfoCompat.setClassName(SlidingPaneLayout.class.getName());
            accessibilityNodeInfoCompat.setSource(view);
            ViewParent viewParent = ViewCompat.getParentForAccessibility(view);
            if (viewParent instanceof View) {
                accessibilityNodeInfoCompat.setParent((View)viewParent);
            }
            int n2 = SlidingPaneLayout.this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view2 = SlidingPaneLayout.this.getChildAt(i2);
                if (this.filter(view2) || view2.getVisibility() != 0) continue;
                ViewCompat.setImportantForAccessibility(view2, 1);
                accessibilityNodeInfoCompat.addChild(view2);
            }
        }

        @Override
        public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
            if (!this.filter(view)) {
                return super.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
            }
            return false;
        }
    }

    private class DisableLayerRunnable
    implements Runnable {
        final View mChildView;

        DisableLayerRunnable(View view) {
            this.mChildView = view;
        }

        @Override
        public void run() {
            if (this.mChildView.getParent() == SlidingPaneLayout.this) {
                ViewCompat.setLayerType(this.mChildView, 0, null);
                SlidingPaneLayout.this.invalidateChildRegion(this.mChildView);
            }
            SlidingPaneLayout.this.mPostedRunnables.remove(this);
        }
    }

    private class DragHelperCallback
    extends ViewDragHelper.Callback {
        private DragHelperCallback() {
        }

        @Override
        public int clampViewPositionHorizontal(View view, int n2, int n3) {
            LayoutParams layoutParams = (LayoutParams)SlidingPaneLayout.this.mSlideableView.getLayoutParams();
            int n4 = SlidingPaneLayout.this.getPaddingLeft() + layoutParams.leftMargin;
            int n5 = n4 + SlidingPaneLayout.this.mSlideRange;
            return Math.min(Math.max(n2, n4), n5);
        }

        @Override
        public int getViewHorizontalDragRange(View view) {
            return SlidingPaneLayout.this.mSlideRange;
        }

        @Override
        public void onEdgeDragStarted(int n2, int n3) {
            SlidingPaneLayout.this.mDragHelper.captureChildView(SlidingPaneLayout.this.mSlideableView, n3);
        }

        @Override
        public void onViewCaptured(View view, int n2) {
            SlidingPaneLayout.this.setAllChildrenVisible();
        }

        @Override
        public void onViewDragStateChanged(int n2) {
            block3: {
                block2: {
                    if (SlidingPaneLayout.this.mDragHelper.getViewDragState() != 0) break block2;
                    if (SlidingPaneLayout.this.mSlideOffset != 0.0f) break block3;
                    SlidingPaneLayout.this.updateObscuredViewsVisibility(SlidingPaneLayout.this.mSlideableView);
                    SlidingPaneLayout.this.dispatchOnPanelClosed(SlidingPaneLayout.this.mSlideableView);
                    SlidingPaneLayout.access$502(SlidingPaneLayout.this, false);
                }
                return;
            }
            SlidingPaneLayout.this.dispatchOnPanelOpened(SlidingPaneLayout.this.mSlideableView);
            SlidingPaneLayout.access$502(SlidingPaneLayout.this, true);
        }

        @Override
        public void onViewPositionChanged(View view, int n2, int n3, int n4, int n5) {
            SlidingPaneLayout.this.onPanelDragged(n2);
            SlidingPaneLayout.this.invalidate();
        }

        @Override
        public void onViewReleased(View view, float f2, float f3) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n2 = SlidingPaneLayout.this.getPaddingLeft() + layoutParams.leftMargin;
            if (f2 > 0.0f || f2 == 0.0f && SlidingPaneLayout.this.mSlideOffset > 0.5f) {
                n2 += SlidingPaneLayout.this.mSlideRange;
            }
            SlidingPaneLayout.this.mDragHelper.settleCapturedViewAt(n2, view.getTop());
            SlidingPaneLayout.this.invalidate();
        }

        @Override
        public boolean tryCaptureView(View view, int n2) {
            if (SlidingPaneLayout.this.mIsUnableToDrag) {
                return false;
            }
            return ((LayoutParams)view.getLayoutParams()).slideable;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int[] ATTRS = new int[]{0x1010181};
        Paint dimPaint;
        boolean dimWhenOffset;
        boolean slideable;
        public float weight = 0.0f;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, ATTRS);
            this.weight = typedArray.getFloat(0, 0.0f);
            typedArray.recycle();
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
            this.weight = layoutParams.weight;
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }
    }

    public static interface PanelSlideListener {
        public void onPanelClosed(View var1);

        public void onPanelOpened(View var1);

        public void onPanelSlide(View var1, float var2);
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        boolean isOpen;

        /*
         * Enabled aggressive block sorting
         */
        private SavedState(Parcel parcel) {
            super(parcel);
            boolean bl2 = parcel.readInt() != 0;
            this.isOpen = bl2;
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            int n3 = this.isOpen ? 1 : 0;
            parcel.writeInt(n3);
        }
    }

    public static class SimplePanelSlideListener
    implements PanelSlideListener {
        @Override
        public void onPanelClosed(View view) {
        }

        @Override
        public void onPanelOpened(View view) {
        }

        @Override
        public void onPanelSlide(View view, float f2) {
        }
    }

    static interface SlidingPanelLayoutImpl {
        public void invalidateChildRegion(SlidingPaneLayout var1, View var2);
    }

    static class SlidingPanelLayoutImplBase
    implements SlidingPanelLayoutImpl {
        SlidingPanelLayoutImplBase() {
        }

        @Override
        public void invalidateChildRegion(SlidingPaneLayout slidingPaneLayout, View view) {
            ViewCompat.postInvalidateOnAnimation((View)slidingPaneLayout, view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    static class SlidingPanelLayoutImplJB
    extends SlidingPanelLayoutImplBase {
        private Method mGetDisplayList;
        private Field mRecreateDisplayList;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        SlidingPanelLayoutImplJB() {
            try {
                this.mGetDisplayList = View.class.getDeclaredMethod("getDisplayList", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)SlidingPaneLayout.TAG, (String)"Couldn't fetch getDisplayList method; dimming won't work right.", (Throwable)noSuchMethodException);
            }
            try {
                this.mRecreateDisplayList = View.class.getDeclaredField("mRecreateDisplayList");
                this.mRecreateDisplayList.setAccessible(true);
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Log.e((String)SlidingPaneLayout.TAG, (String)"Couldn't fetch mRecreateDisplayList field; dimming will be slow.", (Throwable)noSuchFieldException);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void invalidateChildRegion(SlidingPaneLayout slidingPaneLayout, View view) {
            if (this.mGetDisplayList != null && this.mRecreateDisplayList != null) {
                try {
                    this.mRecreateDisplayList.setBoolean(view, true);
                    this.mGetDisplayList.invoke((Object)view, (Object[])null);
                }
                catch (Exception exception) {
                    Log.e((String)SlidingPaneLayout.TAG, (String)"Error refreshing display list state", (Throwable)exception);
                }
                super.invalidateChildRegion(slidingPaneLayout, view);
                return;
            }
            view.invalidate();
        }
    }

    static class SlidingPanelLayoutImplJBMR1
    extends SlidingPanelLayoutImplBase {
        SlidingPanelLayoutImplJBMR1() {
        }

        @Override
        public void invalidateChildRegion(SlidingPaneLayout slidingPaneLayout, View view) {
            ViewCompat.setLayerPaint(view, ((LayoutParams)view.getLayoutParams()).dimPaint);
        }
    }
}

