/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ViewPager
extends ViewGroup {
    private static final int CLOSE_ENOUGH = 2;
    private static final Comparator<ItemInfo> COMPARATOR;
    private static final boolean DEBUG = false;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int DRAW_ORDER_DEFAULT = 0;
    private static final int DRAW_ORDER_FORWARD = 1;
    private static final int DRAW_ORDER_REVERSE = 2;
    private static final int INVALID_POINTER = -1;
    private static final int[] LAYOUT_ATTRS;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int MIN_FLING_VELOCITY = 400;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_SETTLING = 2;
    private static final String TAG = "ViewPager";
    private static final boolean USE_CACHE;
    private static final Interpolator sInterpolator;
    private static final ViewPositionComparator sPositionComparator;
    private int mActivePointerId = -1;
    private PagerAdapter mAdapter;
    private OnAdapterChangeListener mAdapterChangeListener;
    private int mBottomPageBounds;
    private boolean mCalledSuper;
    private int mChildHeightMeasureSpec;
    private int mChildWidthMeasureSpec;
    private int mCloseEnough;
    private int mCurItem;
    private int mDecorChildCount;
    private int mDefaultGutterSize;
    private int mDrawingOrder;
    private ArrayList<View> mDrawingOrderedChildren;
    private final Runnable mEndScrollRunnable;
    private int mExpectedAdapterCount;
    private long mFakeDragBeginTime;
    private boolean mFakeDragging;
    private boolean mFirstLayout = true;
    private float mFirstOffset = -3.4028235E38f;
    private int mFlingDistance;
    private int mGutterSize;
    private boolean mIgnoreGutter;
    private boolean mInLayout;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private OnPageChangeListener mInternalPageChangeListener;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private final ArrayList<ItemInfo> mItems = new ArrayList();
    private float mLastMotionX;
    private float mLastMotionY;
    private float mLastOffset;
    private EdgeEffectCompat mLeftEdge;
    private Drawable mMarginDrawable;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private boolean mNeedCalculatePageOffsets = false;
    private PagerObserver mObserver;
    private int mOffscreenPageLimit = 1;
    private OnPageChangeListener mOnPageChangeListener;
    private int mPageMargin;
    private PageTransformer mPageTransformer;
    private boolean mPopulatePending;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private int mRestoredCurItem = -1;
    private EdgeEffectCompat mRightEdge;
    private int mScrollState = 0;
    private Scroller mScroller;
    private boolean mScrollingCacheEnabled;
    private Method mSetChildrenDrawingOrderEnabled;
    private final ItemInfo mTempItem = new ItemInfo();
    private final Rect mTempRect = new Rect();
    private int mTopPageBounds;
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;

    static {
        LAYOUT_ATTRS = new int[]{16842931};
        COMPARATOR = new Comparator<ItemInfo>(){

            @Override
            public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
                return itemInfo.position - itemInfo2.position;
            }
        };
        sInterpolator = new Interpolator(){

            public float getInterpolation(float f2) {
                float f3 = f2 - 1.0f;
                return 1.0f + f3 * (f3 * (f3 * (f3 * f3)));
            }
        };
        sPositionComparator = new ViewPositionComparator();
    }

    public ViewPager(Context context) {
        super(context);
        this.mLastOffset = Float.MAX_VALUE;
        this.mEndScrollRunnable = new Runnable(){

            @Override
            public void run() {
                ViewPager.this.setScrollState(0);
                ViewPager.this.populate();
            }
        };
        this.initViewPager();
    }

    public ViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mLastOffset = Float.MAX_VALUE;
        this.mEndScrollRunnable = new /* invalid duplicate definition of identical inner class */;
        this.initViewPager();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculatePageOffsets(ItemInfo itemInfo, int n2, ItemInfo itemInfo2) {
        float f2;
        int n3;
        block12: {
            int n4;
            block15: {
                ItemInfo itemInfo3;
                float f3;
                int n5;
                block14: {
                    int n6;
                    block13: {
                        n3 = this.mAdapter.getCount();
                        int n7 = this.getClientWidth();
                        f2 = n7 > 0 ? (float)this.mPageMargin / (float)n7 : 0.0f;
                        if (itemInfo2 == null) break block12;
                        n6 = itemInfo2.position;
                        if (n6 >= itemInfo.position) break block13;
                        n5 = 0;
                        f3 = f2 + (itemInfo2.offset + itemInfo2.widthFactor);
                        break block14;
                    }
                    if (n6 <= itemInfo.position) break block12;
                    n4 = -1 + this.mItems.size();
                    float f4 = itemInfo2.offset;
                    break block15;
                }
                for (int i2 = n6 + 1; i2 <= itemInfo.position && n5 < this.mItems.size(); f3 += f2 + itemInfo3.widthFactor, ++i2) {
                    itemInfo3 = this.mItems.get(n5);
                    while (i2 > itemInfo3.position && n5 < -1 + this.mItems.size()) {
                        itemInfo3 = this.mItems.get(++n5);
                    }
                    while (i2 < itemInfo3.position) {
                        f3 += f2 + this.mAdapter.getPageWidth(i2);
                        ++i2;
                    }
                    itemInfo3.offset = f3;
                }
                break block12;
            }
            for (int i3 = n6 - 1; i3 >= itemInfo.position && n4 >= 0; --i3) {
                ItemInfo itemInfo4 = this.mItems.get(n4);
                while (i3 < itemInfo4.position && n4 > 0) {
                    itemInfo4 = this.mItems.get(--n4);
                }
                while (i3 > itemInfo4.position) {
                    f4 -= f2 + this.mAdapter.getPageWidth(i3);
                    --i3;
                }
                itemInfo4.offset = f4 -= f2 + itemInfo4.widthFactor;
            }
        }
        int n8 = this.mItems.size();
        float f5 = itemInfo.offset;
        int n9 = -1 + itemInfo.position;
        float f6 = itemInfo.position == 0 ? itemInfo.offset : -3.4028235E38f;
        this.mFirstOffset = f6;
        float f7 = itemInfo.position == n3 - 1 ? itemInfo.offset + itemInfo.widthFactor - 1.0f : Float.MAX_VALUE;
        this.mLastOffset = f7;
        for (int i4 = n2 - 1; i4 >= 0; --i4, --n9) {
            ItemInfo itemInfo5 = this.mItems.get(i4);
            while (n9 > itemInfo5.position) {
                PagerAdapter pagerAdapter = this.mAdapter;
                int n10 = n9 - 1;
                f5 -= f2 + pagerAdapter.getPageWidth(n9);
                n9 = n10;
            }
            itemInfo5.offset = f5 -= f2 + itemInfo5.widthFactor;
            if (itemInfo5.position != 0) continue;
            this.mFirstOffset = f5;
        }
        float f8 = f2 + (itemInfo.offset + itemInfo.widthFactor);
        int n11 = 1 + itemInfo.position;
        int n12 = n2 + 1;
        while (true) {
            if (n12 >= n8) {
                this.mNeedCalculatePageOffsets = false;
                return;
            }
            ItemInfo itemInfo6 = this.mItems.get(n12);
            while (n11 < itemInfo6.position) {
                PagerAdapter pagerAdapter = this.mAdapter;
                int n13 = n11 + 1;
                f8 += f2 + pagerAdapter.getPageWidth(n11);
                n11 = n13;
            }
            if (itemInfo6.position == n3 - 1) {
                this.mLastOffset = f8 + itemInfo6.widthFactor - 1.0f;
            }
            itemInfo6.offset = f8;
            f8 += f2 + itemInfo6.widthFactor;
            ++n12;
            ++n11;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void completeScroll(boolean bl2) {
        boolean bl3 = this.mScrollState == 2;
        if (bl3) {
            this.setScrollingCacheEnabled(false);
            this.mScroller.abortAnimation();
            int n2 = this.getScrollX();
            int n3 = this.getScrollY();
            int n4 = this.mScroller.getCurrX();
            int n5 = this.mScroller.getCurrY();
            if (n2 != n4 || n3 != n5) {
                this.scrollTo(n4, n5);
            }
        }
        this.mPopulatePending = false;
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ItemInfo itemInfo = this.mItems.get(i2);
            if (!itemInfo.scrolling) continue;
            bl3 = true;
            itemInfo.scrolling = false;
        }
        if (bl3) {
            if (!bl2) {
                this.mEndScrollRunnable.run();
                return;
            }
            ViewCompat.postOnAnimation((View)this, this.mEndScrollRunnable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int determineTargetPage(int n2, float f2, int n3, int n4) {
        int n5;
        if (Math.abs(n4) > this.mFlingDistance && Math.abs(n3) > this.mMinimumVelocity) {
            n5 = n3 > 0 ? n2 : n2 + 1;
        } else {
            float f3 = n2 >= this.mCurItem ? 0.4f : 0.6f;
            n5 = (int)(f3 + (f2 + (float)n2));
        }
        if (this.mItems.size() <= 0) return n5;
        ItemInfo itemInfo = this.mItems.get(0);
        ItemInfo itemInfo2 = this.mItems.get(-1 + this.mItems.size());
        return Math.max(itemInfo.position, Math.min(n5, itemInfo2.position));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enableLayers(boolean bl2) {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = bl2 ? 2 : 0;
            ViewCompat.setLayerType(this.getChildAt(n3), n4, null);
            ++n3;
        }
        return;
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Rect getChildRectInPagerCoordinates(Rect rect, View view) {
        if (rect == null) {
            rect = new Rect();
        }
        if (view == null) {
            rect.set(0, 0, 0, 0);
            return rect;
        } else {
            rect.left = view.getLeft();
            rect.right = view.getRight();
            rect.top = view.getTop();
            rect.bottom = view.getBottom();
            ViewParent viewParent = view.getParent();
            while (viewParent instanceof ViewGroup && viewParent != this) {
                ViewGroup viewGroup = (ViewGroup)viewParent;
                rect.left += viewGroup.getLeft();
                rect.right += viewGroup.getRight();
                rect.top += viewGroup.getTop();
                rect.bottom += viewGroup.getBottom();
                viewParent = viewGroup.getParent();
            }
        }
        return rect;
    }

    private int getClientWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    /*
     * Enabled aggressive block sorting
     */
    private ItemInfo infoForCurrentScrollPosition() {
        int n2 = this.getClientWidth();
        float f2 = n2 > 0 ? (float)this.getScrollX() / (float)n2 : 0.0f;
        float f3 = 0.0f;
        if (n2 > 0) {
            f3 = (float)this.mPageMargin / (float)n2;
        }
        int n3 = -1;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl2 = true;
        ItemInfo itemInfo = null;
        int n4 = 0;
        while (n4 < this.mItems.size()) {
            ItemInfo itemInfo2 = this.mItems.get(n4);
            if (!bl2 && itemInfo2.position != n3 + 1) {
                itemInfo2 = this.mTempItem;
                itemInfo2.offset = f3 + (f4 + f5);
                itemInfo2.position = n3 + 1;
                itemInfo2.widthFactor = this.mAdapter.getPageWidth(itemInfo2.position);
                --n4;
            }
            float f6 = itemInfo2.offset;
            float f7 = f3 + (f6 + itemInfo2.widthFactor);
            if (!bl2) {
                if (!(f2 >= f6)) return itemInfo;
            }
            if (f2 < f7) return itemInfo2;
            if (n4 == -1 + this.mItems.size()) {
                return itemInfo2;
            }
            n3 = itemInfo2.position;
            f4 = f6;
            f5 = itemInfo2.widthFactor;
            itemInfo = itemInfo2;
            ++n4;
            bl2 = false;
        }
        return itemInfo;
    }

    private boolean isGutterDrag(float f2, float f3) {
        return f2 < (float)this.mGutterSize && f3 > 0.0f || f2 > (float)(this.getWidth() - this.mGutterSize) && f3 < 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getActionIndex(motionEvent);
        if (MotionEventCompat.getPointerId(motionEvent, n2) == this.mActivePointerId) {
            int n3 = n2 == 0 ? 1 : 0;
            this.mLastMotionX = MotionEventCompat.getX(motionEvent, n3);
            this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, n3);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private boolean pageScrolled(int n2) {
        boolean bl2;
        if (this.mItems.size() == 0) {
            this.mCalledSuper = false;
            this.onPageScrolled(0, 0.0f, 0);
            boolean bl3 = this.mCalledSuper;
            bl2 = false;
            if (!bl3) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
        } else {
            ItemInfo itemInfo = this.infoForCurrentScrollPosition();
            int n3 = this.getClientWidth();
            int n4 = n3 + this.mPageMargin;
            float f2 = (float)this.mPageMargin / (float)n3;
            int n5 = itemInfo.position;
            float f3 = ((float)n2 / (float)n3 - itemInfo.offset) / (f2 + itemInfo.widthFactor);
            int n6 = (int)(f3 * (float)n4);
            this.mCalledSuper = false;
            this.onPageScrolled(n5, f3, n6);
            if (!this.mCalledSuper) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
            bl2 = true;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean performDrag(float f2) {
        boolean bl2;
        float f3 = this.mLastMotionX - f2;
        this.mLastMotionX = f2;
        float f4 = f3 + (float)this.getScrollX();
        int n2 = this.getClientWidth();
        float f5 = (float)n2 * this.mFirstOffset;
        float f6 = (float)n2 * this.mLastOffset;
        boolean bl3 = true;
        boolean bl4 = true;
        ItemInfo itemInfo = this.mItems.get(0);
        ItemInfo itemInfo2 = this.mItems.get(-1 + this.mItems.size());
        if (itemInfo.position != 0) {
            bl3 = false;
            f5 = itemInfo.offset * (float)n2;
        }
        if (itemInfo2.position != -1 + this.mAdapter.getCount()) {
            bl4 = false;
            f6 = itemInfo2.offset * (float)n2;
        }
        if (f4 < f5) {
            bl2 = false;
            if (bl3) {
                float f7 = f5 - f4;
                bl2 = this.mLeftEdge.onPull(Math.abs(f7) / (float)n2);
            }
            f4 = f5;
        } else {
            float f8 = f4 == f6 ? 0 : (f4 > f6 ? 1 : -1);
            bl2 = false;
            if (f8 > 0) {
                bl2 = false;
                if (bl4) {
                    float f9 = f4 - f6;
                    bl2 = this.mRightEdge.onPull(Math.abs(f9) / (float)n2);
                }
                f4 = f6;
            }
        }
        this.mLastMotionX += f4 - (float)((int)f4);
        this.scrollTo((int)f4, this.getScrollY());
        this.pageScrolled((int)f4);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void recomputeScrollPosition(int n2, int n3, int n4, int n5) {
        if (n3 > 0 && !this.mItems.isEmpty()) {
            int n6 = n4 + (n2 - this.getPaddingLeft() - this.getPaddingRight());
            int n7 = n5 + (n3 - this.getPaddingLeft() - this.getPaddingRight());
            int n8 = (int)((float)this.getScrollX() / (float)n7 * (float)n6);
            this.scrollTo(n8, this.getScrollY());
            if (this.mScroller.isFinished()) return;
            int n9 = this.mScroller.getDuration() - this.mScroller.timePassed();
            ItemInfo itemInfo = this.infoForPosition(this.mCurItem);
            this.mScroller.startScroll(n8, 0, (int)(itemInfo.offset * (float)n2), 0, n9);
            return;
        }
        ItemInfo itemInfo = this.infoForPosition(this.mCurItem);
        float f2 = itemInfo != null ? Math.min(itemInfo.offset, this.mLastOffset) : 0.0f;
        int n10 = (int)(f2 * (float)(n2 - this.getPaddingLeft() - this.getPaddingRight()));
        if (n10 == this.getScrollX()) return;
        this.completeScroll(false);
        this.scrollTo(n10, this.getScrollY());
    }

    private void removeNonDecorViews() {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            if (((LayoutParams)this.getChildAt((int)i2).getLayoutParams()).isDecor) continue;
            this.removeViewAt(i2);
            --i2;
        }
    }

    private void requestParentDisallowInterceptTouchEvent(boolean bl2) {
        ViewParent viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(bl2);
        }
    }

    private void scrollToItem(int n2, boolean bl2, int n3, boolean bl3) {
        ItemInfo itemInfo = this.infoForPosition(n2);
        int n4 = 0;
        if (itemInfo != null) {
            n4 = (int)((float)this.getClientWidth() * Math.max(this.mFirstOffset, Math.min(itemInfo.offset, this.mLastOffset)));
        }
        if (bl2) {
            this.smoothScrollTo(n4, 0, n3);
            if (bl3 && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(n2);
            }
            if (bl3 && this.mInternalPageChangeListener != null) {
                this.mInternalPageChangeListener.onPageSelected(n2);
            }
            return;
        }
        if (bl3 && this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(n2);
        }
        if (bl3 && this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageSelected(n2);
        }
        this.completeScroll(false);
        this.scrollTo(n4, 0);
        this.pageScrolled(n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setScrollState(int n2) {
        block5: {
            block4: {
                if (this.mScrollState == n2) break block4;
                this.mScrollState = n2;
                if (this.mPageTransformer != null) {
                    boolean bl2 = n2 != 0;
                    this.enableLayers(bl2);
                }
                if (this.mOnPageChangeListener != null) break block5;
            }
            return;
        }
        this.mOnPageChangeListener.onPageScrollStateChanged(n2);
    }

    private void setScrollingCacheEnabled(boolean bl2) {
        if (this.mScrollingCacheEnabled != bl2) {
            this.mScrollingCacheEnabled = bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sortChildDrawingOrder() {
        if (this.mDrawingOrder != 0) {
            if (this.mDrawingOrderedChildren == null) {
                this.mDrawingOrderedChildren = new ArrayList();
            } else {
                this.mDrawingOrderedChildren.clear();
            }
            int n2 = this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view = this.getChildAt(i2);
                this.mDrawingOrderedChildren.add(view);
            }
            Collections.sort(this.mDrawingOrderedChildren, sPositionComparator);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addFocusables(ArrayList<View> arrayList, int n2, int n3) {
        int n4 = arrayList.size();
        int n5 = this.getDescendantFocusability();
        if (n5 != 393216) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                ItemInfo itemInfo;
                View view = this.getChildAt(i2);
                if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
                view.addFocusables(arrayList, n2, n3);
            }
        }
        if (n5 == 262144 && n4 != arrayList.size() || !this.isFocusable() || (n3 & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode() || arrayList == null) {
            return;
        }
        arrayList.add((View)this);
    }

    ItemInfo addNewItem(int n2, int n3) {
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.position = n2;
        itemInfo.object = this.mAdapter.instantiateItem(this, n2);
        itemInfo.widthFactor = this.mAdapter.getPageWidth(n2);
        if (n3 < 0 || n3 >= this.mItems.size()) {
            this.mItems.add(itemInfo);
            return itemInfo;
        }
        this.mItems.add(n3, itemInfo);
        return itemInfo;
    }

    public void addTouchables(ArrayList<View> arrayList) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
            view.addTouchables(arrayList);
        }
    }

    public void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        if (!this.checkLayoutParams(layoutParams)) {
            layoutParams = this.generateLayoutParams(layoutParams);
        }
        LayoutParams layoutParams2 = (LayoutParams)layoutParams;
        layoutParams2.isDecor |= view instanceof Decor;
        if (this.mInLayout) {
            if (layoutParams2 != null && layoutParams2.isDecor) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            layoutParams2.needsMeasure = true;
            this.addViewInLayout(view, n2, layoutParams);
            return;
        }
        super.addView(view, n2, layoutParams);
    }

    /*
     * Unable to fully structure code
     */
    public boolean arrowScroll(int var1_1) {
        block14: {
            block13: {
                block9: {
                    block12: {
                        block6: {
                            block7: {
                                block8: {
                                    var2_2 = this.findFocus();
                                    if (var2_2 != this) break block8;
                                    var2_2 = null;
lbl4:
                                    // 4 sources

                                    while ((var10_3 = FocusFinder.getInstance().findNextFocus((ViewGroup)this, var2_2, var1_1)) != null && var10_3 != var2_2) {
                                        if (var1_1 != 17) break block6;
                                        var14_4 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var10_3).left;
                                        var15_5 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var2_2).left;
                                        if (var2_2 != null && var14_4 >= var15_5) {
                                            var11_6 = this.pageLeft();
lbl10:
                                            // 8 sources

                                            while (true) {
                                                if (var11_6) {
                                                    this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)var1_1));
                                                }
                                                return var11_6;
                                            }
                                        }
                                        break block7;
                                    }
                                    break block9;
                                }
                                if (var2_2 == null) ** GOTO lbl4
                                var3_7 = var2_2.getParent();
                                while (true) {
                                    block11: {
                                        block10: {
                                            var4_8 = var3_7 instanceof ViewGroup;
                                            var5_9 = false;
                                            if (!var4_8) break block10;
                                            if (var3_7 != this) break block11;
                                            var5_9 = true;
                                        }
                                        if (var5_9) ** GOTO lbl4
                                        var6_10 = new StringBuilder();
                                        var6_10.append(var2_2.getClass().getSimpleName());
                                        var8_11 = var2_2.getParent();
                                        while (var8_11 instanceof ViewGroup) {
                                            var6_10.append(" => ").append(var8_11.getClass().getSimpleName());
                                            var8_11 = var8_11.getParent();
                                        }
                                        break;
                                    }
                                    var3_7 = var3_7.getParent();
                                }
                                Log.e((String)"ViewPager", (String)("arrowScroll tried to find focus based on non-child current focused view " + var6_10.toString()));
                                var2_2 = null;
                                ** GOTO lbl4
                            }
                            var11_6 = var10_3.requestFocus();
                            ** GOTO lbl10
                        }
                        var11_6 = false;
                        if (var1_1 != 66) ** GOTO lbl10
                        var12_12 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var10_3).left;
                        var13_13 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var2_2).left;
                        if (var2_2 == null || var12_12 > var13_13) break block12;
                        var11_6 = this.pageRight();
                        ** GOTO lbl10
                    }
                    var11_6 = var10_3.requestFocus();
                    ** GOTO lbl10
                }
                if (var1_1 != 17 && var1_1 != 1) break block13;
                var11_6 = this.pageLeft();
                ** GOTO lbl10
            }
            if (var1_1 == 66) break block14;
            var11_6 = false;
            if (var1_1 != 2) ** GOTO lbl10
        }
        var11_6 = this.pageRight();
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean beginFakeDrag() {
        if (this.mIsBeingDragged) {
            return false;
        }
        this.mFakeDragging = true;
        this.setScrollState(1);
        this.mLastMotionX = 0.0f;
        this.mInitialMotionX = 0.0f;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
        long l2 = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain((long)l2, (long)l2, (int)0, (float)0.0f, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(motionEvent);
        motionEvent.recycle();
        this.mFakeDragBeginTime = l2;
        return true;
    }

    protected boolean canScroll(View view, boolean bl2, int n2, int n3, int n4) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n5 = view.getScrollX();
            int n6 = view.getScrollY();
            for (int i2 = -1 + viewGroup.getChildCount(); i2 >= 0; --i2) {
                View view2 = viewGroup.getChildAt(i2);
                if (n3 + n5 < view2.getLeft() || n3 + n5 >= view2.getRight() || n4 + n6 < view2.getTop() || n4 + n6 >= view2.getBottom() || !this.canScroll(view2, true, n2, n3 + n5 - view2.getLeft(), n4 + n6 - view2.getTop())) continue;
                return true;
            }
        }
        return bl2 && ViewCompat.canScrollHorizontally(view, -n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canScrollHorizontally(int n2) {
        boolean bl2 = true;
        if (this.mAdapter == null) {
            return false;
        }
        int n3 = this.getClientWidth();
        int n4 = this.getScrollX();
        if (n2 < 0) {
            if (n4 <= (int)((float)n3 * this.mFirstOffset)) return false;
            return bl2;
        }
        if (n2 <= 0) return false;
        if (n4 >= (int)((float)n3 * this.mLastOffset)) return false;
        return bl2;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams && super.checkLayoutParams(layoutParams);
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int n2 = this.getScrollX();
            int n3 = this.getScrollY();
            int n4 = this.mScroller.getCurrX();
            int n5 = this.mScroller.getCurrY();
            if (n2 != n4 || n3 != n5) {
                this.scrollTo(n4, n5);
                if (!this.pageScrolled(n4)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, n5);
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    void dataSetChanged() {
        int n2;
        this.mExpectedAdapterCount = n2 = this.mAdapter.getCount();
        boolean bl2 = this.mItems.size() < 1 + 2 * this.mOffscreenPageLimit && this.mItems.size() < n2;
        int n3 = this.mCurItem;
        boolean bl3 = false;
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ItemInfo itemInfo = this.mItems.get(i2);
            int n4 = this.mAdapter.getItemPosition(itemInfo.object);
            if (n4 == -1) continue;
            if (n4 == -2) {
                this.mItems.remove(i2);
                --i2;
                if (!bl3) {
                    this.mAdapter.startUpdate(this);
                    bl3 = true;
                }
                this.mAdapter.destroyItem(this, itemInfo.position, itemInfo.object);
                bl2 = true;
                if (this.mCurItem != itemInfo.position) continue;
                n3 = Math.max(0, Math.min(this.mCurItem, n2 - 1));
                bl2 = true;
                continue;
            }
            if (itemInfo.position == n4) continue;
            if (itemInfo.position == this.mCurItem) {
                n3 = n4;
            }
            itemInfo.position = n4;
            bl2 = true;
        }
        if (bl3) {
            this.mAdapter.finishUpdate(this);
        }
        Collections.sort(this.mItems, COMPARATOR);
        if (bl2) {
            int n5 = this.getChildCount();
            for (int i3 = 0; i3 < n5; ++i3) {
                LayoutParams layoutParams = (LayoutParams)this.getChildAt(i3).getLayoutParams();
                if (layoutParams.isDecor) continue;
                layoutParams.widthFactor = 0.0f;
            }
            this.setCurrentItemInternal(n3, false, true);
            this.requestLayout();
        }
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || this.executeKeyEvent(keyEvent);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 4096) {
            return super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem || !view.dispatchPopulateAccessibilityEvent(accessibilityEvent)) continue;
            return true;
        }
        return false;
    }

    float distanceInfluenceForSnapDuration(float f2) {
        return (float)Math.sin((float)(0.4712389167638204 * (double)(f2 - 0.5f)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void draw(Canvas canvas) {
        super.draw(canvas);
        int n2 = ViewCompat.getOverScrollMode((View)this);
        if (n2 == 0 || n2 == 1 && this.mAdapter != null && this.mAdapter.getCount() > 1) {
            boolean bl2 = this.mLeftEdge.isFinished();
            boolean bl3 = false;
            if (!bl2) {
                int n3 = canvas.save();
                int n4 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                int n5 = this.getWidth();
                canvas.rotate(270.0f);
                canvas.translate((float)(-n4 + this.getPaddingTop()), this.mFirstOffset * (float)n5);
                this.mLeftEdge.setSize(n4, n5);
                bl3 = false | this.mLeftEdge.draw(canvas);
                canvas.restoreToCount(n3);
            }
            if (!this.mRightEdge.isFinished()) {
                int n6 = canvas.save();
                int n7 = this.getWidth();
                int n8 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate((float)(-this.getPaddingTop()), -(1.0f + this.mLastOffset) * (float)n7);
                this.mRightEdge.setSize(n8, n7);
                bl3 |= this.mRightEdge.draw(canvas);
                canvas.restoreToCount(n6);
            }
            if (!bl3) return;
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.mLeftEdge.finish();
        this.mRightEdge.finish();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.mMarginDrawable;
        if (drawable2 != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    public void endFakeDrag() {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        VelocityTracker velocityTracker = this.mVelocityTracker;
        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
        int n2 = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
        this.mPopulatePending = true;
        int n3 = this.getClientWidth();
        int n4 = this.getScrollX();
        ItemInfo itemInfo = this.infoForCurrentScrollPosition();
        this.setCurrentItemInternal(this.determineTargetPage(itemInfo.position, ((float)n4 / (float)n3 - itemInfo.offset) / itemInfo.widthFactor, n2, (int)(this.mLastMotionX - this.mInitialMotionX)), true, true, n2);
        this.endDrag();
        this.mFakeDragging = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean executeKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getAction() != 0) return false;
        switch (keyEvent.getKeyCode()) {
            default: {
                return false;
            }
            case 21: {
                return this.arrowScroll(17);
            }
            case 22: {
                return this.arrowScroll(66);
            }
            case 61: {
                if (Build.VERSION.SDK_INT < 11) return false;
                if (KeyEventCompat.hasNoModifiers(keyEvent)) {
                    return this.arrowScroll(2);
                }
                if (!KeyEventCompat.hasModifiers(keyEvent, 1)) return false;
                return this.arrowScroll(1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fakeDragBy(float f2) {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        this.mLastMotionX = f2 + this.mLastMotionX;
        float f3 = (float)this.getScrollX() - f2;
        int n2 = this.getClientWidth();
        float f4 = (float)n2 * this.mFirstOffset;
        float f5 = (float)n2 * this.mLastOffset;
        ItemInfo itemInfo = this.mItems.get(0);
        ItemInfo itemInfo2 = this.mItems.get(-1 + this.mItems.size());
        if (itemInfo.position != 0) {
            f4 = itemInfo.offset * (float)n2;
        }
        if (itemInfo2.position != -1 + this.mAdapter.getCount()) {
            f5 = itemInfo2.offset * (float)n2;
        }
        if (f3 < f4) {
            f3 = f4;
        } else if (f3 > f5) {
            f3 = f5;
        }
        this.mLastMotionX += f3 - (float)((int)f3);
        this.scrollTo((int)f3, this.getScrollY());
        this.pageScrolled((int)f3);
        long l2 = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain((long)this.mFakeDragBeginTime, (long)l2, (int)2, (float)this.mLastMotionX, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(motionEvent);
        motionEvent.recycle();
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return this.generateDefaultLayoutParams();
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getChildDrawingOrder(int n2, int n3) {
        int n4;
        if (this.mDrawingOrder == 2) {
            n4 = n2 - 1 - n3;
            return ((LayoutParams)this.mDrawingOrderedChildren.get((int)n4).getLayoutParams()).childIndex;
        }
        n4 = n3;
        return ((LayoutParams)this.mDrawingOrderedChildren.get((int)n4).getLayoutParams()).childIndex;
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    ItemInfo infoForAnyChild(View view) {
        ViewParent viewParent;
        while ((viewParent = view.getParent()) != this) {
            if (viewParent == null || !(viewParent instanceof View)) {
                return null;
            }
            view = (View)viewParent;
        }
        return this.infoForChild(view);
    }

    ItemInfo infoForChild(View view) {
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ItemInfo itemInfo = this.mItems.get(i2);
            if (!this.mAdapter.isViewFromObject(view, itemInfo.object)) continue;
            return itemInfo;
        }
        return null;
    }

    ItemInfo infoForPosition(int n2) {
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ItemInfo itemInfo = this.mItems.get(i2);
            if (itemInfo.position != n2) continue;
            return itemInfo;
        }
        return null;
    }

    void initViewPager() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        float f2 = context.getResources().getDisplayMetrics().density;
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop(viewConfiguration);
        this.mMinimumVelocity = (int)(400.0f * f2);
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mLeftEdge = new EdgeEffectCompat(context);
        this.mRightEdge = new EdgeEffectCompat(context);
        this.mFlingDistance = (int)(25.0f * f2);
        this.mCloseEnough = (int)(2.0f * f2);
        this.mDefaultGutterSize = (int)(16.0f * f2);
        ViewCompat.setAccessibilityDelegate((View)this, new MyAccessibilityDelegate());
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mEndScrollRunnable);
        super.onDetachedFromWindow();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && this.mItems.size() > 0 && this.mAdapter != null) {
            int n2 = this.getScrollX();
            int n3 = this.getWidth();
            float f2 = (float)this.mPageMargin / (float)n3;
            int n4 = 0;
            ItemInfo itemInfo = this.mItems.get(0);
            float f3 = itemInfo.offset;
            int n5 = this.mItems.size();
            int n6 = itemInfo.position;
            int n7 = this.mItems.get((int)(n5 - 1)).position;
            for (int i2 = n6; i2 < n7; ++i2) {
                float f4;
                while (i2 > itemInfo.position && n4 < n5) {
                    ArrayList<ItemInfo> arrayList = this.mItems;
                    itemInfo = arrayList.get(++n4);
                }
                if (i2 == itemInfo.position) {
                    f4 = (itemInfo.offset + itemInfo.widthFactor) * (float)n3;
                    f3 = f2 + (itemInfo.offset + itemInfo.widthFactor);
                } else {
                    float f5 = this.mAdapter.getPageWidth(i2);
                    f4 = (f3 + f5) * (float)n3;
                    f3 += f5 + f2;
                }
                if (f4 + (float)this.mPageMargin > (float)n2) {
                    this.mMarginDrawable.setBounds((int)f4, this.mTopPageBounds, (int)(0.5f + (f4 + (float)this.mPageMargin)), this.mBottomPageBounds);
                    this.mMarginDrawable.draw(canvas);
                }
                if (f4 > (float)(n2 + n3)) break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n2 = 0xFF & motionEvent.getAction();
        if (n2 == 3 || n2 == 1) {
            this.mIsBeingDragged = false;
            this.mIsUnableToDrag = false;
            this.mActivePointerId = -1;
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            return false;
        }
        if (n2 != 0) {
            if (this.mIsBeingDragged) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (n2) {
            case 2: {
                int n3 = this.mActivePointerId;
                if (n3 == -1) break;
                int n4 = MotionEventCompat.findPointerIndex(motionEvent, n3);
                float f2 = MotionEventCompat.getX(motionEvent, n4);
                float f3 = f2 - this.mLastMotionX;
                float f4 = Math.abs(f3);
                float f5 = MotionEventCompat.getY(motionEvent, n4);
                float f6 = Math.abs(f5 - this.mInitialMotionY);
                if (f3 != 0.0f && !this.isGutterDrag(this.mLastMotionX, f3) && this.canScroll((View)this, false, (int)f3, (int)f2, (int)f5)) {
                    this.mLastMotionX = f2;
                    this.mLastMotionY = f5;
                    this.mIsUnableToDrag = true;
                    return false;
                }
                if (f4 > (float)this.mTouchSlop && 0.5f * f4 > f6) {
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    float f7 = f3 > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                    this.mLastMotionX = f7;
                    this.mLastMotionY = f5;
                    this.setScrollingCacheEnabled(true);
                } else if (f6 > (float)this.mTouchSlop) {
                    this.mIsUnableToDrag = true;
                }
                if (!this.mIsBeingDragged || !this.performDrag(f2)) break;
                ViewCompat.postInvalidateOnAnimation((View)this);
                break;
            }
            case 0: {
                float f8;
                float f9;
                this.mInitialMotionX = f9 = motionEvent.getX();
                this.mLastMotionX = f9;
                this.mInitialMotionY = f8 = motionEvent.getY();
                this.mLastMotionY = f8;
                this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, 0);
                this.mIsUnableToDrag = false;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState == 2 && Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) > this.mCloseEnough) {
                    this.mScroller.abortAnimation();
                    this.mPopulatePending = false;
                    this.populate();
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    break;
                }
                this.completeScroll(false);
                this.mIsBeingDragged = false;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                break;
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        return this.mIsBeingDragged;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        int n6 = this.getChildCount();
        int n7 = n4 - n2;
        int n8 = n5 - n3;
        int n9 = this.getPaddingLeft();
        int n10 = this.getPaddingTop();
        int n11 = this.getPaddingRight();
        int n12 = this.getPaddingBottom();
        int n13 = this.getScrollX();
        int n14 = 0;
        for (int i2 = 0; i2 < n6; ++i2) {
            int n15;
            int n16;
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (!layoutParams.isDecor) continue;
            int n17 = 7 & layoutParams.gravity;
            int n18 = 0x70 & layoutParams.gravity;
            switch (n17) {
                default: {
                    n16 = n9;
                    break;
                }
                case 3: {
                    n16 = n9;
                    n9 += view.getMeasuredWidth();
                    break;
                }
                case 1: {
                    n16 = Math.max((n7 - view.getMeasuredWidth()) / 2, n9);
                    break;
                }
                case 5: {
                    n16 = n7 - n11 - view.getMeasuredWidth();
                    n11 += view.getMeasuredWidth();
                }
            }
            switch (n18) {
                default: {
                    n15 = n10;
                    break;
                }
                case 48: {
                    n15 = n10;
                    n10 += view.getMeasuredHeight();
                    break;
                }
                case 16: {
                    n15 = Math.max((n8 - view.getMeasuredHeight()) / 2, n10);
                    break;
                }
                case 80: {
                    n15 = n8 - n12 - view.getMeasuredHeight();
                    n12 += view.getMeasuredHeight();
                }
            }
            int n19 = n16 + n13;
            view.layout(n19, n15, n19 + view.getMeasuredWidth(), n15 + view.getMeasuredHeight());
            ++n14;
        }
        int n20 = n7 - n9 - n11;
        for (int i3 = 0; i3 < n6; ++i3) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i3);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.isDecor || (itemInfo = this.infoForChild(view)) == null) continue;
            int n21 = n9 + (int)((float)n20 * itemInfo.offset);
            int n22 = n10;
            if (layoutParams.needsMeasure) {
                layoutParams.needsMeasure = false;
                view.measure(View.MeasureSpec.makeMeasureSpec((int)((int)((float)n20 * layoutParams.widthFactor)), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(n8 - n10 - n12), (int)0x40000000));
            }
            view.layout(n21, n22, n21 + view.getMeasuredWidth(), n22 + view.getMeasuredHeight());
        }
        this.mTopPageBounds = n10;
        this.mBottomPageBounds = n8 - n12;
        this.mDecorChildCount = n14;
        if (this.mFirstLayout) {
            this.scrollToItem(this.mCurItem, false, 0, false);
        }
        this.mFirstLayout = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        this.setMeasuredDimension(ViewPager.getDefaultSize((int)0, (int)n2), ViewPager.getDefaultSize((int)0, (int)n3));
        int n4 = this.getMeasuredWidth();
        this.mGutterSize = Math.min(n4 / 10, this.mDefaultGutterSize);
        int n5 = n4 - this.getPaddingLeft() - this.getPaddingRight();
        int n6 = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int n7 = this.getChildCount();
        for (int i2 = 0; i2 < n7; ++i2) {
            LayoutParams layoutParams;
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8 || (layoutParams = (LayoutParams)view.getLayoutParams()) == null || !layoutParams.isDecor) continue;
            int n8 = 7 & layoutParams.gravity;
            int n9 = 0x70 & layoutParams.gravity;
            int n10 = Integer.MIN_VALUE;
            int n11 = Integer.MIN_VALUE;
            boolean bl2 = n9 == 48 || n9 == 80;
            boolean bl3 = n8 == 3 || n8 == 5;
            if (bl2) {
                n10 = 0x40000000;
            } else if (bl3) {
                n11 = 0x40000000;
            }
            int n12 = n5;
            int n13 = n6;
            if (layoutParams.width != -2) {
                n10 = 0x40000000;
                if (layoutParams.width != -1) {
                    n12 = layoutParams.width;
                }
            }
            if (layoutParams.height != -2) {
                n11 = 0x40000000;
                if (layoutParams.height != -1) {
                    n13 = layoutParams.height;
                }
            }
            view.measure(View.MeasureSpec.makeMeasureSpec((int)n12, (int)n10), View.MeasureSpec.makeMeasureSpec((int)n13, (int)n11));
            if (bl2) {
                n6 -= view.getMeasuredHeight();
                continue;
            }
            if (!bl3) continue;
            n5 -= view.getMeasuredWidth();
        }
        this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n5, (int)0x40000000);
        this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n6, (int)0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int n14 = this.getChildCount();
        int n15 = 0;
        while (n15 < n14) {
            LayoutParams layoutParams;
            View view = this.getChildAt(n15);
            if (!(view.getVisibility() == 8 || (layoutParams = (LayoutParams)view.getLayoutParams()) != null && layoutParams.isDecor)) {
                view.measure(View.MeasureSpec.makeMeasureSpec((int)((int)((float)n5 * layoutParams.widthFactor)), (int)0x40000000), this.mChildHeightMeasureSpec);
            }
            ++n15;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onPageScrolled(int n2, float f2, int n3) {
        if (this.mDecorChildCount > 0) {
            int n4 = this.getScrollX();
            int n5 = this.getPaddingLeft();
            int n6 = this.getPaddingRight();
            int n7 = this.getWidth();
            int n8 = this.getChildCount();
            for (int i2 = 0; i2 < n8; ++i2) {
                int n9;
                int n10;
                View view = this.getChildAt(i2);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (!layoutParams.isDecor) continue;
                switch (7 & layoutParams.gravity) {
                    default: {
                        n10 = n5;
                        break;
                    }
                    case 3: {
                        n10 = n5;
                        n5 += view.getWidth();
                        break;
                    }
                    case 1: {
                        n10 = Math.max((n7 - view.getMeasuredWidth()) / 2, n5);
                        break;
                    }
                    case 5: {
                        n10 = n7 - n6 - view.getMeasuredWidth();
                        n6 += view.getMeasuredWidth();
                    }
                }
                if ((n9 = n10 + n4 - view.getLeft()) == 0) continue;
                view.offsetLeftAndRight(n9);
            }
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(n2, f2, n3);
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageScrolled(n2, f2, n3);
        }
        if (this.mPageTransformer != null) {
            int n11 = this.getScrollX();
            int n12 = this.getChildCount();
            for (int i3 = 0; i3 < n12; ++i3) {
                View view = this.getChildAt(i3);
                if (((LayoutParams)view.getLayoutParams()).isDecor) continue;
                float f3 = (float)(view.getLeft() - n11) / (float)this.getClientWidth();
                this.mPageTransformer.transformPage(view, f3);
            }
        }
        this.mCalledSuper = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean onRequestFocusInDescendants(int n2, Rect rect) {
        int n3;
        int n4;
        int n5;
        int n6 = this.getChildCount();
        if ((n2 & 2) != 0) {
            n5 = 0;
            n4 = 1;
            n3 = n6;
        } else {
            n5 = n6 - 1;
            n4 = -1;
            n3 = -1;
        }
        int n7 = n5;
        while (n7 != n3) {
            ItemInfo itemInfo;
            View view = this.getChildAt(n7);
            if (view.getVisibility() == 0 && (itemInfo = this.infoForChild(view)) != null && itemInfo.position == this.mCurItem && view.requestFocus(n2, rect)) {
                return true;
            }
            n7 += n4;
        }
        return false;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (this.mAdapter != null) {
            this.mAdapter.restoreState(savedState.adapterState, savedState.loader);
            this.setCurrentItemInternal(savedState.position, false, true);
            return;
        }
        this.mRestoredCurItem = savedState.position;
        this.mRestoredAdapterState = savedState.adapterState;
        this.mRestoredClassLoader = savedState.loader;
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.position = this.mCurItem;
        if (this.mAdapter != null) {
            savedState.adapterState = this.mAdapter.saveState();
        }
        return savedState;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n2 != n4) {
            this.recomputeScrollPosition(n2, n4, this.mPageMargin, this.mPageMargin);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mFakeDragging) {
            return true;
        }
        if (motionEvent.getAction() == 0 && motionEvent.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null) return false;
        if (this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int n2 = 0xFF & motionEvent.getAction();
        boolean bl2 = false;
        switch (n2) {
            case 0: {
                float f2;
                float f3;
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mInitialMotionX = f3 = motionEvent.getX();
                this.mLastMotionX = f3;
                this.mInitialMotionY = f2 = motionEvent.getY();
                this.mLastMotionY = f2;
                this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, 0);
                return true;
            }
            case 2: {
                if (!this.mIsBeingDragged) {
                    int n3 = MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId);
                    float f4 = MotionEventCompat.getX(motionEvent, n3);
                    float f5 = Math.abs(f4 - this.mLastMotionX);
                    float f6 = MotionEventCompat.getY(motionEvent, n3);
                    float f7 = Math.abs(f6 - this.mLastMotionY);
                    if (f5 > (float)this.mTouchSlop && f5 > f7) {
                        this.mIsBeingDragged = true;
                        this.requestParentDisallowInterceptTouchEvent(true);
                        float f8 = f4 - this.mInitialMotionX > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                        this.mLastMotionX = f8;
                        this.mLastMotionY = f6;
                        this.setScrollState(1);
                        this.setScrollingCacheEnabled(true);
                        ViewParent viewParent = this.getParent();
                        if (viewParent != null) {
                            viewParent.requestDisallowInterceptTouchEvent(true);
                        }
                    }
                }
                boolean bl3 = this.mIsBeingDragged;
                bl2 = false;
                if (!bl3) break;
                bl2 = false | this.performDrag(MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId)));
                break;
            }
            case 1: {
                boolean bl4 = this.mIsBeingDragged;
                bl2 = false;
                if (!bl4) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int n4 = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
                this.mPopulatePending = true;
                int n5 = this.getClientWidth();
                int n6 = this.getScrollX();
                ItemInfo itemInfo = this.infoForCurrentScrollPosition();
                this.setCurrentItemInternal(this.determineTargetPage(itemInfo.position, ((float)n6 / (float)n5 - itemInfo.offset) / itemInfo.widthFactor, n4, (int)(MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId)) - this.mInitialMotionX)), true, true, n4);
                this.mActivePointerId = -1;
                this.endDrag();
                bl2 = this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                break;
            }
            case 3: {
                boolean bl5 = this.mIsBeingDragged;
                bl2 = false;
                if (!bl5) break;
                this.scrollToItem(this.mCurItem, true, 0, false);
                this.mActivePointerId = -1;
                this.endDrag();
                bl2 = this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                break;
            }
            case 5: {
                int n7 = MotionEventCompat.getActionIndex(motionEvent);
                this.mLastMotionX = MotionEventCompat.getX(motionEvent, n7);
                this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, n7);
                return true;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                this.mLastMotionX = MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId));
                return true;
            }
        }
        if (!bl2) return true;
        ViewCompat.postInvalidateOnAnimation((View)this);
        return true;
    }

    boolean pageLeft() {
        if (this.mCurItem > 0) {
            this.setCurrentItem(-1 + this.mCurItem, true);
            return true;
        }
        return false;
    }

    boolean pageRight() {
        if (this.mAdapter != null && this.mCurItem < -1 + this.mAdapter.getCount()) {
            this.setCurrentItem(1 + this.mCurItem, true);
            return true;
        }
        return false;
    }

    void populate() {
        this.populate(this.mCurItem);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void populate(int n2) {
        int n3;
        ItemInfo itemInfo;
        int n4;
        block26: {
            int n5;
            ItemInfo itemInfo2;
            block27: {
                float f2;
                ItemInfo itemInfo3;
                int n6;
                float f3;
                n4 = 2;
                int n7 = this.mCurItem;
                itemInfo2 = null;
                if (n7 != n2) {
                    n4 = this.mCurItem < n2 ? 66 : 17;
                    itemInfo2 = this.infoForPosition(this.mCurItem);
                    this.mCurItem = n2;
                }
                if (this.mAdapter == null) {
                    this.sortChildDrawingOrder();
                    return;
                }
                if (this.mPopulatePending) {
                    this.sortChildDrawingOrder();
                    return;
                }
                if (this.getWindowToken() == null) return;
                this.mAdapter.startUpdate(this);
                int n8 = this.mOffscreenPageLimit;
                int n9 = Math.max(0, this.mCurItem - n8);
                int n10 = this.mAdapter.getCount();
                int n11 = Math.min(n10 - 1, n8 + this.mCurItem);
                if (n10 != this.mExpectedAdapterCount) {
                    String string2;
                    try {
                        String string3;
                        string2 = string3 = this.getResources().getResourceName(this.getId());
                        throw new IllegalStateException("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + n10 + " Pager id: " + string2 + " Pager class: " + ((Object)((Object)this)).getClass() + " Problematic adapter: " + this.mAdapter.getClass());
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        string2 = Integer.toHexString(this.getId());
                        throw new IllegalStateException("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + n10 + " Pager id: " + string2 + " Pager class: " + ((Object)((Object)this)).getClass() + " Problematic adapter: " + this.mAdapter.getClass());
                    }
                }
                n5 = 0;
                while (true) {
                    block29: {
                        block28: {
                            int n12 = this.mItems.size();
                            itemInfo = null;
                            if (n5 >= n12) break block28;
                            ItemInfo itemInfo4 = this.mItems.get(n5);
                            if (itemInfo4.position < this.mCurItem) break block29;
                            int n13 = itemInfo4.position;
                            int n14 = this.mCurItem;
                            itemInfo = null;
                            if (n13 == n14) {
                                itemInfo = itemInfo4;
                            }
                        }
                        if (itemInfo == null && n10 > 0) {
                            itemInfo = this.addNewItem(this.mCurItem, n5);
                        }
                        if (itemInfo != null) {
                            break;
                        }
                        break block26;
                    }
                    ++n5;
                }
                float f4 = 0.0f;
                int n15 = n5 - 1;
                ItemInfo itemInfo5 = n15 >= 0 ? this.mItems.get(n15) : null;
                int n16 = this.getClientWidth();
                float f5 = n16 <= 0 ? 0.0f : 2.0f - itemInfo.widthFactor + (float)this.getPaddingLeft() / (float)n16;
                int n17 = -1 + this.mCurItem;
                while (true) {
                    block33: {
                        int n18;
                        block31: {
                            block32: {
                                block30: {
                                    if (n17 < 0) break block30;
                                    if (!(f4 >= f5) || n17 >= n9) break block31;
                                    if (itemInfo5 != null) break block32;
                                }
                                f3 = itemInfo.widthFactor;
                                n6 = n5 + 1;
                                if (f3 < 2.0f) {
                                    int n19 = this.mItems.size();
                                    itemInfo3 = n6 < n19 ? this.mItems.get(n6) : null;
                                    f2 = n16 <= 0 ? 0.0f : 2.0f + (float)this.getPaddingRight() / (float)n16;
                                    break;
                                }
                                break block27;
                            }
                            int n20 = itemInfo5.position;
                            if (n17 == n20 && !itemInfo5.scrolling) {
                                this.mItems.remove(n15);
                                PagerAdapter pagerAdapter = this.mAdapter;
                                Object object = itemInfo5.object;
                                pagerAdapter.destroyItem(this, n17, object);
                                --n5;
                                itemInfo5 = --n15 >= 0 ? this.mItems.get(n15) : null;
                            }
                            break block33;
                        }
                        if (itemInfo5 != null && n17 == (n18 = itemInfo5.position)) {
                            f4 += itemInfo5.widthFactor;
                            itemInfo5 = --n15 >= 0 ? this.mItems.get(n15) : null;
                        } else {
                            int n21 = n15 + 1;
                            f4 += this.addNewItem((int)n17, (int)n21).widthFactor;
                            ++n5;
                            itemInfo5 = n15 >= 0 ? this.mItems.get(n15) : null;
                        }
                    }
                    --n17;
                }
                for (int i2 = 1 + this.mCurItem; i2 < n10; ++i2) {
                    int n22;
                    if (f3 >= f2 && i2 > n11) {
                        if (itemInfo3 == null) break;
                        int n23 = itemInfo3.position;
                        if (i2 != n23 || itemInfo3.scrolling) continue;
                        this.mItems.remove(n6);
                        PagerAdapter pagerAdapter = this.mAdapter;
                        Object object = itemInfo3.object;
                        pagerAdapter.destroyItem(this, i2, object);
                        int n24 = this.mItems.size();
                        if (n6 < n24) {
                            itemInfo3 = this.mItems.get(n6);
                            continue;
                        }
                        itemInfo3 = null;
                        continue;
                    }
                    if (itemInfo3 != null && i2 == (n22 = itemInfo3.position)) {
                        f3 += itemInfo3.widthFactor;
                        int n25 = this.mItems.size();
                        if (++n6 < n25) {
                            itemInfo3 = this.mItems.get(n6);
                            continue;
                        }
                        itemInfo3 = null;
                        continue;
                    }
                    ItemInfo itemInfo6 = this.addNewItem(i2, n6);
                    f3 += itemInfo6.widthFactor;
                    int n26 = this.mItems.size();
                    itemInfo3 = ++n6 < n26 ? this.mItems.get(n6) : null;
                }
            }
            this.calculatePageOffsets(itemInfo, n5, itemInfo2);
        }
        PagerAdapter pagerAdapter = this.mAdapter;
        int n27 = this.mCurItem;
        Object object = itemInfo != null ? itemInfo.object : null;
        pagerAdapter.setPrimaryItem(this, n27, object);
        this.mAdapter.finishUpdate(this);
        int n28 = this.getChildCount();
        for (int i3 = 0; i3 < n28; ++i3) {
            ItemInfo itemInfo7;
            View view = this.getChildAt(i3);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            layoutParams.childIndex = i3;
            if (layoutParams.isDecor || layoutParams.widthFactor != 0.0f || (itemInfo7 = this.infoForChild(view)) == null) continue;
            layoutParams.widthFactor = itemInfo7.widthFactor;
            layoutParams.position = itemInfo7.position;
        }
        this.sortChildDrawingOrder();
        if (!this.hasFocus()) return;
        View view = this.findFocus();
        ItemInfo itemInfo8 = view != null ? this.infoForAnyChild(view) : null;
        if (itemInfo8 != null) {
            if (itemInfo8.position == this.mCurItem) return;
        }
        int n29 = 0;
        while (n29 < (n3 = this.getChildCount())) {
            View view2 = this.getChildAt(n29);
            ItemInfo itemInfo9 = this.infoForChild(view2);
            if (itemInfo9 != null && itemInfo9.position == this.mCurItem) {
                if (view2.requestFocus(n4)) return;
            }
            ++n29;
        }
    }

    public void removeView(View view) {
        if (this.mInLayout) {
            this.removeViewInLayout(view);
            return;
        }
        super.removeView(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAdapter(PagerAdapter pagerAdapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
            this.mAdapter.startUpdate(this);
            for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
                ItemInfo itemInfo = this.mItems.get(i2);
                this.mAdapter.destroyItem(this, itemInfo.position, itemInfo.object);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeNonDecorViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        PagerAdapter pagerAdapter2 = this.mAdapter;
        this.mAdapter = pagerAdapter;
        this.mExpectedAdapterCount = 0;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.registerDataSetObserver(this.mObserver);
            this.mPopulatePending = false;
            boolean bl2 = this.mFirstLayout;
            this.mFirstLayout = true;
            this.mExpectedAdapterCount = this.mAdapter.getCount();
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else if (!bl2) {
                this.populate();
            } else {
                this.requestLayout();
            }
        }
        if (this.mAdapterChangeListener != null && pagerAdapter2 != pagerAdapter) {
            this.mAdapterChangeListener.onAdapterChanged(pagerAdapter2, pagerAdapter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    void setChildrenDrawingOrderEnabledCompat(boolean bl2) {
        if (Build.VERSION.SDK_INT < 7) return;
        if (this.mSetChildrenDrawingOrderEnabled == null) {
            try {
                Class[] classArray = new Class[]{Boolean.TYPE};
                this.mSetChildrenDrawingOrderEnabled = ViewGroup.class.getDeclaredMethod("setChildrenDrawingOrderEnabled", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)TAG, (String)"Can't find setChildrenDrawingOrderEnabled", (Throwable)noSuchMethodException);
            }
        }
        try {
            Method method = this.mSetChildrenDrawingOrderEnabled;
            Object[] objectArray = new Object[]{bl2};
            method.invoke((Object)this, objectArray);
            return;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error changing children drawing order", (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCurrentItem(int n2) {
        this.mPopulatePending = false;
        boolean bl2 = !this.mFirstLayout;
        this.setCurrentItemInternal(n2, bl2, false);
    }

    public void setCurrentItem(int n2, boolean bl2) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n2, bl2, false);
    }

    void setCurrentItemInternal(int n2, boolean bl2, boolean bl3) {
        this.setCurrentItemInternal(n2, bl2, bl3, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCurrentItemInternal(int n2, boolean bl2, boolean bl3, int n3) {
        int n4;
        boolean bl4 = true;
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (!bl3 && this.mCurItem == n2 && this.mItems.size() != 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.mAdapter.getCount()) {
            n2 = -1 + this.mAdapter.getCount();
        }
        if (n2 > (n4 = this.mOffscreenPageLimit) + this.mCurItem || n2 < this.mCurItem - n4) {
            for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
                this.mItems.get((int)i2).scrolling = bl4;
            }
        }
        if (this.mCurItem == n2) {
            bl4 = false;
        }
        if (!this.mFirstLayout) {
            this.populate(n2);
            this.scrollToItem(n2, bl2, n3, bl4);
            return;
        }
        this.mCurItem = n2;
        if (bl4 && this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(n2);
        }
        if (bl4 && this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageSelected(n2);
        }
        this.requestLayout();
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener onPageChangeListener) {
        OnPageChangeListener onPageChangeListener2 = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = onPageChangeListener;
        return onPageChangeListener2;
    }

    public void setOffscreenPageLimit(int n2) {
        if (n2 < 1) {
            Log.w((String)TAG, (String)("Requested offscreen page limit " + n2 + " too small; defaulting to " + 1));
            n2 = 1;
        }
        if (n2 != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = n2;
            this.populate();
        }
    }

    void setOnAdapterChangeListener(OnAdapterChangeListener onAdapterChangeListener) {
        this.mAdapterChangeListener = onAdapterChangeListener;
    }

    public void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public void setPageMargin(int n2) {
        int n3 = this.mPageMargin;
        this.mPageMargin = n2;
        int n4 = this.getWidth();
        this.recomputeScrollPosition(n4, n4, n2, n3);
        this.requestLayout();
    }

    public void setPageMarginDrawable(int n2) {
        this.setPageMarginDrawable(this.getContext().getResources().getDrawable(n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPageMarginDrawable(Drawable drawable2) {
        this.mMarginDrawable = drawable2;
        if (drawable2 != null) {
            this.refreshDrawableState();
        }
        boolean bl2 = drawable2 == null;
        this.setWillNotDraw(bl2);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPageTransformer(boolean bl2, PageTransformer pageTransformer) {
        int n2 = 1;
        if (Build.VERSION.SDK_INT < 11) return;
        int n3 = pageTransformer != null ? n2 : 0;
        int n4 = this.mPageTransformer != null ? n2 : 0;
        int n5 = n3 != n4 ? n2 : 0;
        this.mPageTransformer = pageTransformer;
        this.setChildrenDrawingOrderEnabledCompat(n3 != 0);
        if (n3 != 0) {
            if (bl2) {
                n2 = 2;
            }
            this.mDrawingOrder = n2;
        } else {
            this.mDrawingOrder = 0;
        }
        if (n5 != 0) {
            this.populate();
        }
    }

    void smoothScrollTo(int n2, int n3) {
        this.smoothScrollTo(n2, n3, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void smoothScrollTo(int n2, int n3, int n4) {
        int n5;
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int n6 = this.getScrollX();
        int n7 = this.getScrollY();
        int n8 = n2 - n6;
        int n9 = n3 - n7;
        if (n8 == 0 && n9 == 0) {
            this.completeScroll(false);
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.setScrollState(2);
        int n10 = this.getClientWidth();
        int n11 = n10 / 2;
        float f2 = Math.min(1.0f, 1.0f * (float)Math.abs(n8) / (float)n10);
        float f3 = (float)n11 + (float)n11 * this.distanceInfluenceForSnapDuration(f2);
        int n12 = Math.abs(n4);
        if (n12 > 0) {
            n5 = 4 * Math.round(1000.0f * Math.abs(f3 / (float)n12));
        } else {
            float f4 = (float)n10 * this.mAdapter.getPageWidth(this.mCurItem);
            n5 = (int)(100.0f * (1.0f + (float)Math.abs(n8) / (f4 + (float)this.mPageMargin)));
        }
        int n13 = Math.min(n5, 600);
        this.mScroller.startScroll(n6, n7, n8, n9, n13);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        return super.verifyDrawable(drawable2) || drawable2 == this.mMarginDrawable;
    }

    static interface Decor {
    }

    static class ItemInfo {
        Object object;
        float offset;
        int position;
        boolean scrolling;
        float widthFactor;

        ItemInfo() {
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        int childIndex;
        public int gravity;
        public boolean isDecor;
        boolean needsMeasure;
        int position;
        float widthFactor = 0.0f;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
            this.gravity = typedArray.getInteger(0, 48);
            typedArray.recycle();
        }
    }

    class MyAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        MyAccessibilityDelegate() {
        }

        private boolean canScroll() {
            return ViewPager.this.mAdapter != null && ViewPager.this.mAdapter.getCount() > 1;
        }

        @Override
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName((CharSequence)ViewPager.class.getName());
            AccessibilityRecordCompat accessibilityRecordCompat = AccessibilityRecordCompat.obtain();
            accessibilityRecordCompat.setScrollable(this.canScroll());
            if (accessibilityEvent.getEventType() == 4096 && ViewPager.this.mAdapter != null) {
                accessibilityRecordCompat.setItemCount(ViewPager.this.mAdapter.getCount());
                accessibilityRecordCompat.setFromIndex(ViewPager.this.mCurItem);
                accessibilityRecordCompat.setToIndex(ViewPager.this.mCurItem);
            }
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
            accessibilityNodeInfoCompat.setClassName(ViewPager.class.getName());
            accessibilityNodeInfoCompat.setScrollable(this.canScroll());
            if (ViewPager.this.canScrollHorizontally(1)) {
                accessibilityNodeInfoCompat.addAction(4096);
            }
            if (ViewPager.this.canScrollHorizontally(-1)) {
                accessibilityNodeInfoCompat.addAction(8192);
            }
        }

        @Override
        public boolean performAccessibilityAction(View view, int n2, Bundle bundle) {
            if (super.performAccessibilityAction(view, n2, bundle)) {
                return true;
            }
            switch (n2) {
                default: {
                    return false;
                }
                case 4096: {
                    if (ViewPager.this.canScrollHorizontally(1)) {
                        ViewPager.this.setCurrentItem(1 + ViewPager.this.mCurItem);
                        return true;
                    }
                    return false;
                }
                case 8192: 
            }
            if (ViewPager.this.canScrollHorizontally(-1)) {
                ViewPager.this.setCurrentItem(-1 + ViewPager.this.mCurItem);
                return true;
            }
            return false;
        }
    }

    static interface OnAdapterChangeListener {
        public void onAdapterChanged(PagerAdapter var1, PagerAdapter var2);
    }

    public static interface OnPageChangeListener {
        public void onPageScrollStateChanged(int var1);

        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);
    }

    public static interface PageTransformer {
        public void transformPage(View var1, float var2);
    }

    private class PagerObserver
    extends DataSetObserver {
        private PagerObserver() {
        }

        public void onChanged() {
            ViewPager.this.dataSetChanged();
        }

        public void onInvalidated() {
            ViewPager.this.dataSetChanged();
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator(new ParcelableCompatCreatorCallbacks<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        });
        Parcelable adapterState;
        ClassLoader loader;
        int position;

        SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel);
            if (classLoader == null) {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.position = parcel.readInt();
            this.adapterState = parcel.readParcelable(classLoader);
            this.loader = classLoader;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "FragmentPager.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " position=" + this.position + "}";
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeInt(this.position);
            parcel.writeParcelable(this.adapterState, n2);
        }
    }

    public static class SimpleOnPageChangeListener
    implements OnPageChangeListener {
        @Override
        public void onPageScrollStateChanged(int n2) {
        }

        @Override
        public void onPageScrolled(int n2, float f2, int n3) {
        }

        @Override
        public void onPageSelected(int n2) {
        }
    }

    static class ViewPositionComparator
    implements Comparator<View> {
        ViewPositionComparator() {
        }

        @Override
        public int compare(View view, View view2) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            LayoutParams layoutParams2 = (LayoutParams)view2.getLayoutParams();
            if (layoutParams.isDecor != layoutParams2.isDecor) {
                if (layoutParams.isDecor) {
                    return 1;
                }
                return -1;
            }
            return layoutParams.position - layoutParams2.position;
        }
    }
}

