/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.PagerTitleStripIcs;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;
import java.lang.ref.WeakReference;

public class PagerTitleStrip
extends ViewGroup
implements ViewPager.Decor {
    private static final int[] ATTRS = new int[]{16842804, 16842901, 16842904, 16842927};
    private static final PagerTitleStripImpl IMPL;
    private static final float SIDE_ALPHA = 0.6f;
    private static final String TAG = "PagerTitleStrip";
    private static final int[] TEXT_ATTRS;
    private static final int TEXT_SPACING = 16;
    TextView mCurrText;
    private int mGravity;
    private int mLastKnownCurrentPage = -1;
    private float mLastKnownPositionOffset = -1.0f;
    TextView mNextText;
    private int mNonPrimaryAlpha;
    private final PageListener mPageListener = new PageListener();
    ViewPager mPager;
    TextView mPrevText;
    private int mScaledTextSpacing;
    int mTextColor;
    private boolean mUpdatingPositions;
    private boolean mUpdatingText;
    private WeakReference<PagerAdapter> mWatchingAdapter;

    static {
        TEXT_ATTRS = new int[]{16843660};
        IMPL = Build.VERSION.SDK_INT >= 14 ? new PagerTitleStripImplIcs() : new PagerTitleStripImplBase();
    }

    public PagerTitleStrip(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public PagerTitleStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n2;
        TextView textView;
        TextView textView2;
        TextView textView3;
        this.mPrevText = textView3 = new TextView(context);
        this.addView((View)textView3);
        this.mCurrText = textView2 = new TextView(context);
        this.addView((View)textView2);
        this.mNextText = textView = new TextView(context);
        this.addView((View)textView);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, ATTRS);
        int n3 = typedArray.getResourceId(0, 0);
        if (n3 != 0) {
            this.mPrevText.setTextAppearance(context, n3);
            this.mCurrText.setTextAppearance(context, n3);
            this.mNextText.setTextAppearance(context, n3);
        }
        if ((n2 = typedArray.getDimensionPixelSize(1, 0)) != 0) {
            this.setTextSize(0, n2);
        }
        if (typedArray.hasValue(2)) {
            int n4 = typedArray.getColor(2, 0);
            this.mPrevText.setTextColor(n4);
            this.mCurrText.setTextColor(n4);
            this.mNextText.setTextColor(n4);
        }
        this.mGravity = typedArray.getInteger(3, 80);
        typedArray.recycle();
        this.mTextColor = this.mCurrText.getTextColors().getDefaultColor();
        this.setNonPrimaryAlpha(0.6f);
        this.mPrevText.setEllipsize(TextUtils.TruncateAt.END);
        this.mCurrText.setEllipsize(TextUtils.TruncateAt.END);
        this.mNextText.setEllipsize(TextUtils.TruncateAt.END);
        boolean bl2 = false;
        if (n3 != 0) {
            TypedArray typedArray2 = context.obtainStyledAttributes(n3, TEXT_ATTRS);
            bl2 = typedArray2.getBoolean(0, false);
            typedArray2.recycle();
        }
        if (bl2) {
            PagerTitleStrip.setSingleLineAllCaps(this.mPrevText);
            PagerTitleStrip.setSingleLineAllCaps(this.mCurrText);
            PagerTitleStrip.setSingleLineAllCaps(this.mNextText);
        } else {
            this.mPrevText.setSingleLine();
            this.mCurrText.setSingleLine();
            this.mNextText.setSingleLine();
        }
        this.mScaledTextSpacing = (int)(16.0f * context.getResources().getDisplayMetrics().density);
    }

    private static void setSingleLineAllCaps(TextView textView) {
        IMPL.setSingleLineAllCaps(textView);
    }

    int getMinHeight() {
        Drawable drawable2 = this.getBackground();
        int n2 = 0;
        if (drawable2 != null) {
            n2 = drawable2.getIntrinsicHeight();
        }
        return n2;
    }

    public int getTextSpacing() {
        return this.mScaledTextSpacing;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent viewParent = this.getParent();
        if (!(viewParent instanceof ViewPager)) {
            throw new IllegalStateException("PagerTitleStrip must be a direct child of a ViewPager.");
        }
        ViewPager viewPager = (ViewPager)viewParent;
        PagerAdapter pagerAdapter = viewPager.getAdapter();
        viewPager.setInternalPageChangeListener(this.mPageListener);
        viewPager.setOnAdapterChangeListener(this.mPageListener);
        this.mPager = viewPager;
        PagerAdapter pagerAdapter2 = this.mWatchingAdapter != null ? (PagerAdapter)this.mWatchingAdapter.get() : null;
        this.updateAdapter(pagerAdapter2, pagerAdapter);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPager != null) {
            this.updateAdapter(this.mPager.getAdapter(), null);
            this.mPager.setInternalPageChangeListener(null);
            this.mPager.setOnAdapterChangeListener(null);
            this.mPager = null;
        }
    }

    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        if (this.mPager != null) {
            float f2 = this.mLastKnownPositionOffset - 0.0f;
            float f3 = f2 == 0.0f ? 0 : (f2 > 0.0f ? 1 : -1);
            float f4 = 0.0f;
            if (f3 >= 0) {
                f4 = this.mLastKnownPositionOffset;
            }
            this.updateTextPositions(this.mLastKnownCurrentPage, f4, true);
        }
    }

    protected void onMeasure(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getMode((int)n3);
        int n6 = View.MeasureSpec.getSize((int)n2);
        int n7 = View.MeasureSpec.getSize((int)n3);
        if (n4 != 0x40000000) {
            throw new IllegalStateException("Must measure with an exact width");
        }
        int n8 = this.getMinHeight();
        int n9 = this.getPaddingTop() + this.getPaddingBottom();
        int n10 = n7 - n9;
        int n11 = View.MeasureSpec.makeMeasureSpec((int)((int)(0.8f * (float)n6)), (int)Integer.MIN_VALUE);
        int n12 = View.MeasureSpec.makeMeasureSpec((int)n10, (int)Integer.MIN_VALUE);
        this.mPrevText.measure(n11, n12);
        this.mCurrText.measure(n11, n12);
        this.mNextText.measure(n11, n12);
        if (n5 == 0x40000000) {
            this.setMeasuredDimension(n6, n7);
            return;
        }
        this.setMeasuredDimension(n6, Math.max(n8, n9 + this.mCurrText.getMeasuredHeight()));
    }

    public void requestLayout() {
        if (!this.mUpdatingText) {
            super.requestLayout();
        }
    }

    public void setGravity(int n2) {
        this.mGravity = n2;
        this.requestLayout();
    }

    public void setNonPrimaryAlpha(float f2) {
        this.mNonPrimaryAlpha = 0xFF & (int)(255.0f * f2);
        int n2 = this.mNonPrimaryAlpha << 24 | 0xFFFFFF & this.mTextColor;
        this.mPrevText.setTextColor(n2);
        this.mNextText.setTextColor(n2);
    }

    public void setTextColor(int n2) {
        this.mTextColor = n2;
        this.mCurrText.setTextColor(n2);
        int n3 = this.mNonPrimaryAlpha << 24 | 0xFFFFFF & this.mTextColor;
        this.mPrevText.setTextColor(n3);
        this.mNextText.setTextColor(n3);
    }

    public void setTextSize(int n2, float f2) {
        this.mPrevText.setTextSize(n2, f2);
        this.mCurrText.setTextSize(n2, f2);
        this.mNextText.setTextSize(n2, f2);
    }

    public void setTextSpacing(int n2) {
        this.mScaledTextSpacing = n2;
        this.requestLayout();
    }

    void updateAdapter(PagerAdapter pagerAdapter, PagerAdapter pagerAdapter2) {
        if (pagerAdapter != null) {
            pagerAdapter.unregisterDataSetObserver(this.mPageListener);
            this.mWatchingAdapter = null;
        }
        if (pagerAdapter2 != null) {
            pagerAdapter2.registerDataSetObserver(this.mPageListener);
            this.mWatchingAdapter = new WeakReference<PagerAdapter>(pagerAdapter2);
        }
        if (this.mPager != null) {
            this.mLastKnownCurrentPage = -1;
            this.mLastKnownPositionOffset = -1.0f;
            this.updateText(this.mPager.getCurrentItem(), pagerAdapter2);
            this.requestLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateText(int n2, PagerAdapter pagerAdapter) {
        int n3 = pagerAdapter != null ? pagerAdapter.getCount() : 0;
        this.mUpdatingText = true;
        CharSequence charSequence = null;
        if (n2 >= 1) {
            charSequence = null;
            if (pagerAdapter != null) {
                charSequence = pagerAdapter.getPageTitle(n2 - 1);
            }
        }
        this.mPrevText.setText(charSequence);
        TextView textView = this.mCurrText;
        CharSequence charSequence2 = pagerAdapter != null && n2 < n3 ? pagerAdapter.getPageTitle(n2) : null;
        textView.setText(charSequence2);
        int n4 = n2 + 1;
        CharSequence charSequence3 = null;
        if (n4 < n3) {
            charSequence3 = null;
            if (pagerAdapter != null) {
                charSequence3 = pagerAdapter.getPageTitle(n2 + 1);
            }
        }
        this.mNextText.setText(charSequence3);
        int n5 = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int n6 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int n7 = View.MeasureSpec.makeMeasureSpec((int)((int)(0.8f * (float)n5)), (int)Integer.MIN_VALUE);
        int n8 = View.MeasureSpec.makeMeasureSpec((int)n6, (int)Integer.MIN_VALUE);
        this.mPrevText.measure(n7, n8);
        this.mCurrText.measure(n7, n8);
        this.mNextText.measure(n7, n8);
        this.mLastKnownCurrentPage = n2;
        if (!this.mUpdatingPositions) {
            this.updateTextPositions(n2, this.mLastKnownPositionOffset, false);
        }
        this.mUpdatingText = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateTextPositions(int n2, float f2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        if (n2 != this.mLastKnownCurrentPage) {
            this.updateText(n2, this.mPager.getAdapter());
        } else if (!bl2 && f2 == this.mLastKnownPositionOffset) {
            return;
        }
        this.mUpdatingPositions = true;
        int n6 = this.mPrevText.getMeasuredWidth();
        int n7 = this.mCurrText.getMeasuredWidth();
        int n8 = this.mNextText.getMeasuredWidth();
        int n9 = n7 / 2;
        int n10 = this.getWidth();
        int n11 = this.getHeight();
        int n12 = this.getPaddingLeft();
        int n13 = this.getPaddingRight();
        int n14 = this.getPaddingTop();
        int n15 = this.getPaddingBottom();
        int n16 = n12 + n9;
        int n17 = n13 + n9;
        int n18 = n10 - n16 - n17;
        float f3 = f2 + 0.5f;
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        int n19 = n10 - n17 - (int)(f3 * (float)n18) - n7 / 2;
        int n20 = n19 + n7;
        int n21 = this.mPrevText.getBaseline();
        int n22 = this.mCurrText.getBaseline();
        int n23 = this.mNextText.getBaseline();
        int n24 = Math.max(Math.max(n21, n22), n23);
        int n25 = n24 - n21;
        int n26 = n24 - n22;
        int n27 = n24 - n23;
        int n28 = n25 + this.mPrevText.getMeasuredHeight();
        int n29 = n26 + this.mCurrText.getMeasuredHeight();
        int n30 = n27 + this.mNextText.getMeasuredHeight();
        int n31 = Math.max(Math.max(n28, n29), n30);
        switch (0x70 & this.mGravity) {
            default: {
                n5 = n14 + n25;
                n4 = n14 + n26;
                n3 = n14 + n27;
                break;
            }
            case 16: {
                int n32 = (n11 - n14 - n15 - n31) / 2;
                n5 = n32 + n25;
                n4 = n32 + n26;
                n3 = n32 + n27;
                break;
            }
            case 80: {
                int n33 = n11 - n15 - n31;
                n5 = n33 + n25;
                n4 = n33 + n26;
                n3 = n33 + n27;
            }
        }
        TextView textView = this.mCurrText;
        int n34 = n4 + this.mCurrText.getMeasuredHeight();
        textView.layout(n19, n4, n20, n34);
        int n35 = Math.min(n12, n19 - this.mScaledTextSpacing - n6);
        TextView textView2 = this.mPrevText;
        int n36 = n35 + n6;
        int n37 = n5 + this.mPrevText.getMeasuredHeight();
        textView2.layout(n35, n5, n36, n37);
        int n38 = Math.max(n10 - n13 - n8, n20 + this.mScaledTextSpacing);
        TextView textView3 = this.mNextText;
        int n39 = n38 + n8;
        int n40 = n3 + this.mNextText.getMeasuredHeight();
        textView3.layout(n38, n3, n39, n40);
        this.mLastKnownPositionOffset = f2;
        this.mUpdatingPositions = false;
    }

    private class PageListener
    extends DataSetObserver
    implements ViewPager.OnPageChangeListener,
    ViewPager.OnAdapterChangeListener {
        private int mScrollState;

        private PageListener() {
        }

        @Override
        public void onAdapterChanged(PagerAdapter pagerAdapter, PagerAdapter pagerAdapter2) {
            PagerTitleStrip.this.updateAdapter(pagerAdapter, pagerAdapter2);
        }

        public void onChanged() {
            PagerTitleStrip.this.updateText(PagerTitleStrip.this.mPager.getCurrentItem(), PagerTitleStrip.this.mPager.getAdapter());
            float f2 = PagerTitleStrip.this.mLastKnownPositionOffset - 0.0f;
            float f3 = f2 == 0.0f ? 0 : (f2 > 0.0f ? 1 : -1);
            float f4 = 0.0f;
            if (f3 >= 0) {
                f4 = PagerTitleStrip.this.mLastKnownPositionOffset;
            }
            PagerTitleStrip.this.updateTextPositions(PagerTitleStrip.this.mPager.getCurrentItem(), f4, true);
        }

        @Override
        public void onPageScrollStateChanged(int n2) {
            this.mScrollState = n2;
        }

        @Override
        public void onPageScrolled(int n2, float f2, int n3) {
            if (f2 > 0.5f) {
                ++n2;
            }
            PagerTitleStrip.this.updateTextPositions(n2, f2, false);
        }

        @Override
        public void onPageSelected(int n2) {
            if (this.mScrollState == 0) {
                PagerTitleStrip.this.updateText(PagerTitleStrip.this.mPager.getCurrentItem(), PagerTitleStrip.this.mPager.getAdapter());
                float f2 = PagerTitleStrip.this.mLastKnownPositionOffset - 0.0f;
                float f3 = f2 == 0.0f ? 0 : (f2 > 0.0f ? 1 : -1);
                float f4 = 0.0f;
                if (f3 >= 0) {
                    f4 = PagerTitleStrip.this.mLastKnownPositionOffset;
                }
                PagerTitleStrip.this.updateTextPositions(PagerTitleStrip.this.mPager.getCurrentItem(), f4, true);
            }
        }
    }

    static interface PagerTitleStripImpl {
        public void setSingleLineAllCaps(TextView var1);
    }

    static class PagerTitleStripImplBase
    implements PagerTitleStripImpl {
        PagerTitleStripImplBase() {
        }

        @Override
        public void setSingleLineAllCaps(TextView textView) {
            textView.setSingleLine();
        }
    }

    static class PagerTitleStripImplIcs
    implements PagerTitleStripImpl {
        PagerTitleStripImplIcs() {
        }

        @Override
        public void setSingleLineAllCaps(TextView textView) {
            PagerTitleStripIcs.setSingleLineAllCaps(textView);
        }
    }
}

