/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;

public class GestureDetectorCompat {
    private final GestureDetectorCompatImpl mImpl;

    public GestureDetectorCompat(Context context, GestureDetector.OnGestureListener onGestureListener) {
        this(context, onGestureListener, null);
    }

    public GestureDetectorCompat(Context context, GestureDetector.OnGestureListener onGestureListener, Handler handler) {
        if (Build.VERSION.SDK_INT > 17) {
            this.mImpl = new GestureDetectorCompatImplJellybeanMr2(context, onGestureListener, handler);
            return;
        }
        this.mImpl = new GestureDetectorCompatImplBase(context, onGestureListener, handler);
    }

    public boolean isLongpressEnabled() {
        return this.mImpl.isLongpressEnabled();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.mImpl.onTouchEvent(motionEvent);
    }

    public void setIsLongpressEnabled(boolean bl2) {
        this.mImpl.setIsLongpressEnabled(bl2);
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        this.mImpl.setOnDoubleTapListener(onDoubleTapListener);
    }

    static interface GestureDetectorCompatImpl {
        public boolean isLongpressEnabled();

        public boolean onTouchEvent(MotionEvent var1);

        public void setIsLongpressEnabled(boolean var1);

        public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener var1);
    }

    static class GestureDetectorCompatImplBase
    implements GestureDetectorCompatImpl {
        private static final int DOUBLE_TAP_TIMEOUT = 0;
        private static final int LONGPRESS_TIMEOUT = 0;
        private static final int LONG_PRESS = 2;
        private static final int SHOW_PRESS = 1;
        private static final int TAP = 3;
        private static final int TAP_TIMEOUT;
        private boolean mAlwaysInBiggerTapRegion;
        private boolean mAlwaysInTapRegion;
        private MotionEvent mCurrentDownEvent;
        private boolean mDeferConfirmSingleTap;
        private GestureDetector.OnDoubleTapListener mDoubleTapListener;
        private int mDoubleTapSlopSquare;
        private float mDownFocusX;
        private float mDownFocusY;
        private final Handler mHandler;
        private boolean mInLongPress;
        private boolean mIsDoubleTapping;
        private boolean mIsLongpressEnabled;
        private float mLastFocusX;
        private float mLastFocusY;
        private final GestureDetector.OnGestureListener mListener;
        private int mMaximumFlingVelocity;
        private int mMinimumFlingVelocity;
        private MotionEvent mPreviousUpEvent;
        private boolean mStillDown;
        private int mTouchSlopSquare;
        private VelocityTracker mVelocityTracker;

        static {
            LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
            TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
            DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
        }

        /*
         * Enabled aggressive block sorting
         */
        public GestureDetectorCompatImplBase(Context context, GestureDetector.OnGestureListener onGestureListener, Handler handler) {
            this.mHandler = handler != null ? new GestureHandler(handler) : new GestureHandler();
            this.mListener = onGestureListener;
            if (onGestureListener instanceof GestureDetector.OnDoubleTapListener) {
                this.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)onGestureListener);
            }
            this.init(context);
        }

        static /* synthetic */ boolean access$502(GestureDetectorCompatImplBase gestureDetectorCompatImplBase, boolean bl2) {
            gestureDetectorCompatImplBase.mDeferConfirmSingleTap = bl2;
            return bl2;
        }

        private void cancel() {
            this.mHandler.removeMessages(1);
            this.mHandler.removeMessages(2);
            this.mHandler.removeMessages(3);
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
            this.mIsDoubleTapping = false;
            this.mStillDown = false;
            this.mAlwaysInTapRegion = false;
            this.mAlwaysInBiggerTapRegion = false;
            this.mDeferConfirmSingleTap = false;
            if (this.mInLongPress) {
                this.mInLongPress = false;
            }
        }

        private void cancelTaps() {
            this.mHandler.removeMessages(1);
            this.mHandler.removeMessages(2);
            this.mHandler.removeMessages(3);
            this.mIsDoubleTapping = false;
            this.mAlwaysInTapRegion = false;
            this.mAlwaysInBiggerTapRegion = false;
            this.mDeferConfirmSingleTap = false;
            if (this.mInLongPress) {
                this.mInLongPress = false;
            }
        }

        private void dispatchLongPress() {
            this.mHandler.removeMessages(3);
            this.mDeferConfirmSingleTap = false;
            this.mInLongPress = true;
            this.mListener.onLongPress(this.mCurrentDownEvent);
        }

        private void init(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null");
            }
            if (this.mListener == null) {
                throw new IllegalArgumentException("OnGestureListener must not be null");
            }
            this.mIsLongpressEnabled = true;
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
            int n2 = viewConfiguration.getScaledTouchSlop();
            int n3 = viewConfiguration.getScaledDoubleTapSlop();
            this.mMinimumFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
            this.mMaximumFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
            this.mTouchSlopSquare = n2 * n2;
            this.mDoubleTapSlopSquare = n3 * n3;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean isConsideredDoubleTap(MotionEvent motionEvent, MotionEvent motionEvent2, MotionEvent motionEvent3) {
            int n2;
            int n3;
            return this.mAlwaysInBiggerTapRegion && motionEvent3.getEventTime() - motionEvent2.getEventTime() <= (long)DOUBLE_TAP_TIMEOUT && (n3 = (int)motionEvent.getX() - (int)motionEvent3.getX()) * n3 + (n2 = (int)motionEvent.getY() - (int)motionEvent3.getY()) * n2 < this.mDoubleTapSlopSquare;
        }

        @Override
        public boolean isLongpressEnabled() {
            return this.mIsLongpressEnabled;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean onTouchEvent(MotionEvent var1_1) {
            block34: {
                block33: {
                    block36: {
                        block35: {
                            var2_2 = var1_1.getAction();
                            if (this.mVelocityTracker == null) {
                                this.mVelocityTracker = VelocityTracker.obtain();
                            }
                            this.mVelocityTracker.addMovement(var1_1);
                            if ((var2_2 & 255) != 6) break block35;
                            var3_3 = true;
lbl7:
                            // 2 sources

                            while (var3_3) {
                                var4_4 = MotionEventCompat.getActionIndex(var1_1);
lbl9:
                                // 2 sources

                                while (true) {
                                    var5_5 = 0.0f;
                                    var6_6 = 0.0f;
                                    var7_7 = MotionEventCompat.getPointerCount(var1_1);
                                    block10: for (var8_8 = 0; var8_8 < var7_7; ++var8_8) {
                                        if (var4_4 == var8_8) lbl-1000:
                                        // 2 sources

                                        {
                                            continue block10;
                                        }
                                        break block33;
                                    }
                                    break block34;
                                    break;
                                }
                            }
                            break block36;
                        }
                        var3_3 = false;
                        ** GOTO lbl7
                    }
                    var4_4 = -1;
                    ** while (true)
                }
                var5_5 += MotionEventCompat.getX(var1_1, var8_8);
                var6_6 += MotionEventCompat.getY(var1_1, var8_8);
                ** while (true)
            }
            if (!var3_3) ** GOTO lbl41
            var9_9 = var7_7 - 1;
            block12: while (true) {
                var10_10 = var5_5 / (float)var9_9;
                var11_11 = var6_6 / (float)var9_9;
                var12_12 = var2_2 & 255;
                var13_13 = false;
                switch (var12_12) lbl-1000:
                // 5 sources

                {
                    default: {
                        return var13_13;
                    }
lbl41:
                    // 1 sources

                    var9_9 = var7_7;
                    continue block12;
                    case 5: {
                        this.mLastFocusX = var10_10;
                        this.mDownFocusX = var10_10;
                        this.mLastFocusY = var11_11;
                        this.mDownFocusY = var11_11;
                        this.cancelTaps();
                        return false;
                    }
                    case 6: {
                        this.mLastFocusX = var10_10;
                        this.mDownFocusX = var10_10;
                        this.mLastFocusY = var11_11;
                        this.mDownFocusY = var11_11;
                        this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                        var37_14 = MotionEventCompat.getActionIndex(var1_1);
                        var38_15 = MotionEventCompat.getPointerId(var1_1, var37_14);
                        var39_16 = VelocityTrackerCompat.getXVelocity(this.mVelocityTracker, var38_15);
                        var40_17 = VelocityTrackerCompat.getYVelocity(this.mVelocityTracker, var38_15);
                        var41_18 = 0;
                        block14: while (true) {
                            var42_19 = ++var41_18;
                            var13_13 = false;
                            if (var42_19 >= var7_7) ** GOTO lbl-1000
                            if (var41_18 != var37_14) break;
                            continue block14;
                            break;
                        }
                        if (!(var39_16 * VelocityTrackerCompat.getXVelocity(this.mVelocityTracker, var43_20 = MotionEventCompat.getPointerId(var1_1, var41_18)) + var40_17 * VelocityTrackerCompat.getYVelocity(this.mVelocityTracker, var43_20) < 0.0f)) ** continue;
                        this.mVelocityTracker.clear();
                        return false;
                    }
                    case 0: {
                        var31_21 = this.mDoubleTapListener;
                        var32_22 = false;
                        if (var31_21 == null) ** GOTO lbl81
                        var35_23 = this.mHandler.hasMessages(3);
                        if (var35_23) {
                            this.mHandler.removeMessages(3);
                        }
                        if (this.mCurrentDownEvent == null || this.mPreviousUpEvent == null || !var35_23 || !this.isConsideredDoubleTap(this.mCurrentDownEvent, this.mPreviousUpEvent, var1_1)) ** GOTO lbl101
                        this.mIsDoubleTapping = true;
                        var32_22 = false | this.mDoubleTapListener.onDoubleTap(this.mCurrentDownEvent) | this.mDoubleTapListener.onDoubleTapEvent(var1_1);
lbl81:
                        // 3 sources

                        while (true) {
                            this.mLastFocusX = var10_10;
                            this.mDownFocusX = var10_10;
                            this.mLastFocusY = var11_11;
                            this.mDownFocusY = var11_11;
                            if (this.mCurrentDownEvent != null) {
                                this.mCurrentDownEvent.recycle();
                            }
                            this.mCurrentDownEvent = MotionEvent.obtain((MotionEvent)var1_1);
                            this.mAlwaysInTapRegion = true;
                            this.mAlwaysInBiggerTapRegion = true;
                            this.mStillDown = true;
                            this.mInLongPress = false;
                            this.mDeferConfirmSingleTap = false;
                            if (this.mIsLongpressEnabled) {
                                this.mHandler.removeMessages(2);
                                this.mHandler.sendEmptyMessageAtTime(2, this.mCurrentDownEvent.getDownTime() + (long)GestureDetectorCompatImplBase.TAP_TIMEOUT + (long)GestureDetectorCompatImplBase.LONGPRESS_TIMEOUT);
                            }
                            this.mHandler.sendEmptyMessageAtTime(1, this.mCurrentDownEvent.getDownTime() + (long)GestureDetectorCompatImplBase.TAP_TIMEOUT);
                            return var32_22 | this.mListener.onDown(var1_1);
                        }
lbl101:
                        // 1 sources

                        this.mHandler.sendEmptyMessageDelayed(3, (long)GestureDetectorCompatImplBase.DOUBLE_TAP_TIMEOUT);
                        var32_22 = false;
                        ** continue;
                    }
                    case 2: {
                        var22_24 = this.mInLongPress;
                        var13_13 = false;
                        if (var22_24) ** GOTO lbl-1000
                        var23_25 = this.mLastFocusX - var10_10;
                        var24_26 = this.mLastFocusY - var11_11;
                        if (this.mIsDoubleTapping) {
                            return false | this.mDoubleTapListener.onDoubleTapEvent(var1_1);
                        }
                        if (!this.mAlwaysInTapRegion) ** GOTO lbl130
                        var27_27 = (int)(var10_10 - this.mDownFocusX);
                        var28_28 = (int)(var11_11 - this.mDownFocusY);
                        var29_29 = var27_27 * var27_27 + var28_28 * var28_28;
                        var30_30 = this.mTouchSlopSquare;
                        var13_13 = false;
                        if (var29_29 > var30_30) {
                            var13_13 = this.mListener.onScroll(this.mCurrentDownEvent, var1_1, var23_25, var24_26);
                            this.mLastFocusX = var10_10;
                            this.mLastFocusY = var11_11;
                            this.mAlwaysInTapRegion = false;
                            this.mHandler.removeMessages(3);
                            this.mHandler.removeMessages(1);
                            this.mHandler.removeMessages(2);
                        }
                        if (var29_29 <= this.mTouchSlopSquare) ** GOTO lbl-1000
                        this.mAlwaysInBiggerTapRegion = false;
                        return var13_13;
lbl130:
                        // 1 sources

                        if (Math.abs(var23_25) >= 1.0f) ** GOTO lbl135
                        cfr_temp_0 = Math.abs(var24_26) - 1.0f;
                        var26_31 = cfr_temp_0 == 0.0f ? 0 : (cfr_temp_0 > 0.0f ? 1 : -1);
                        var13_13 = false;
                        if (var26_31 < 0) ** GOTO lbl-1000
lbl135:
                        // 2 sources

                        var25_32 = this.mListener.onScroll(this.mCurrentDownEvent, var1_1, var23_25, var24_26);
                        this.mLastFocusX = var10_10;
                        this.mLastFocusY = var11_11;
                        return var25_32;
                    }
                    case 1: {
                        this.mStillDown = false;
                        var14_33 = MotionEvent.obtain((MotionEvent)var1_1);
                        if (this.mIsDoubleTapping) {
                            var19_34 = false | this.mDoubleTapListener.onDoubleTapEvent(var1_1);
lbl144:
                            // 5 sources

                            while (true) {
                                if (this.mPreviousUpEvent != null) {
                                    this.mPreviousUpEvent.recycle();
                                }
                                this.mPreviousUpEvent = var14_33;
                                if (this.mVelocityTracker != null) {
                                    this.mVelocityTracker.recycle();
                                    this.mVelocityTracker = null;
                                }
                                this.mIsDoubleTapping = false;
                                this.mDeferConfirmSingleTap = false;
                                this.mHandler.removeMessages(1);
                                this.mHandler.removeMessages(2);
                                return var19_34;
                            }
                        }
                        if (!this.mInLongPress) ** GOTO lbl161
                        this.mHandler.removeMessages(3);
                        this.mInLongPress = false;
                        var19_34 = false;
                        ** GOTO lbl144
lbl161:
                        // 1 sources

                        if (!this.mAlwaysInTapRegion) ** GOTO lbl167
                        var19_34 = this.mListener.onSingleTapUp(var1_1);
                        if (this.mDeferConfirmSingleTap && this.mDoubleTapListener != null) {
                            this.mDoubleTapListener.onSingleTapConfirmed(var1_1);
                        }
                        ** GOTO lbl144
lbl167:
                        // 1 sources

                        var15_35 = this.mVelocityTracker;
                        var16_36 = MotionEventCompat.getPointerId(var1_1, 0);
                        var15_35.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                        var17_37 = VelocityTrackerCompat.getYVelocity(var15_35, var16_36);
                        var18_38 = VelocityTrackerCompat.getXVelocity(var15_35, var16_36);
                        if (Math.abs(var17_37) > (float)this.mMinimumFlingVelocity) ** GOTO lbl177
                        cfr_temp_1 = Math.abs(var18_38) - (float)this.mMinimumFlingVelocity;
                        var20_39 = cfr_temp_1 == 0.0f ? 0 : (cfr_temp_1 > 0.0f ? 1 : -1);
                        var19_34 = false;
                        if (var20_39 <= 0) ** GOTO lbl144
lbl177:
                        // 2 sources

                        var19_34 = this.mListener.onFling(this.mCurrentDownEvent, var1_1, var18_38, var17_37);
                        ** continue;
                    }
                    case 3: 
                }
                break;
            }
            this.cancel();
            return false;
        }

        @Override
        public void setIsLongpressEnabled(boolean bl2) {
            this.mIsLongpressEnabled = bl2;
        }

        @Override
        public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
            this.mDoubleTapListener = onDoubleTapListener;
        }

        private class GestureHandler
        extends Handler {
            GestureHandler() {
            }

            GestureHandler(Handler handler) {
                super(handler.getLooper());
            }

            /*
             * Enabled aggressive block sorting
             */
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        throw new RuntimeException("Unknown message " + message);
                    }
                    case 1: {
                        GestureDetectorCompatImplBase.this.mListener.onShowPress(GestureDetectorCompatImplBase.this.mCurrentDownEvent);
                        return;
                    }
                    case 2: {
                        GestureDetectorCompatImplBase.this.dispatchLongPress();
                        return;
                    }
                    case 3: {
                        if (GestureDetectorCompatImplBase.this.mDoubleTapListener == null) return;
                        if (!GestureDetectorCompatImplBase.this.mStillDown) {
                            GestureDetectorCompatImplBase.this.mDoubleTapListener.onSingleTapConfirmed(GestureDetectorCompatImplBase.this.mCurrentDownEvent);
                            return;
                        } else {
                            break;
                        }
                    }
                }
                GestureDetectorCompatImplBase.access$502(GestureDetectorCompatImplBase.this, true);
            }
        }
    }

    static class GestureDetectorCompatImplJellybeanMr2
    implements GestureDetectorCompatImpl {
        private final GestureDetector mDetector;

        public GestureDetectorCompatImplJellybeanMr2(Context context, GestureDetector.OnGestureListener onGestureListener, Handler handler) {
            this.mDetector = new GestureDetector(context, onGestureListener, handler);
        }

        @Override
        public boolean isLongpressEnabled() {
            return this.mDetector.isLongpressEnabled();
        }

        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            return this.mDetector.onTouchEvent(motionEvent);
        }

        @Override
        public void setIsLongpressEnabled(boolean bl2) {
            this.mDetector.setIsLongpressEnabled(bl2);
        }

        @Override
        public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
            this.mDetector.setOnDoubleTapListener(onDoubleTapListener);
        }
    }
}

