/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ICUCompatIcs {
    private static final String TAG = "ICUCompatIcs";
    private static Method sAddLikelySubtagsMethod;
    private static Method sGetScriptMethod;

    static {
        block3: {
            Class<?> clazz = Class.forName("libcore.icu.ICU");
            if (clazz == null) break block3;
            try {
                sGetScriptMethod = clazz.getMethod("getScript", String.class);
                sAddLikelySubtagsMethod = clazz.getMethod("addLikelySubtags", String.class);
            }
            catch (Exception exception) {
                Log.w((String)TAG, (Throwable)exception);
            }
        }
    }

    ICUCompatIcs() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String addLikelySubtags(String string2) {
        try {
            if (sAddLikelySubtagsMethod == null) return string2;
            Object[] objectArray = new Object[]{string2};
            return (String)sAddLikelySubtagsMethod.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.w((String)TAG, (Throwable)illegalAccessException);
            return string2;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.w((String)TAG, (Throwable)invocationTargetException);
            return string2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getScript(String string2) {
        try {
            if (sGetScriptMethod == null) return null;
            Object[] objectArray = new Object[]{string2};
            return (String)sGetScriptMethod.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.w((String)TAG, (Throwable)illegalAccessException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.w((String)TAG, (Throwable)invocationTargetException);
            return null;
        }
    }
}

