/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.pdf.PdfDocument;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.print.PrintManager;
import android.print.pdf.PrintedPdfDocument;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PrintHelperKitkat {
    public static final int COLOR_MODE_COLOR = 2;
    public static final int COLOR_MODE_MONOCHROME = 1;
    private static final String LOG_TAG = "PrintHelperKitkat";
    private static final int MAX_PRINT_SIZE = 3500;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int ORIENTATION_PORTRAIT = 2;
    public static final int SCALE_MODE_FILL = 2;
    public static final int SCALE_MODE_FIT = 1;
    int mColorMode = 2;
    final Context mContext;
    BitmapFactory.Options mDecodeOptions = null;
    private final Object mLock = new Object();
    int mOrientation = 1;
    int mScaleMode = 2;

    PrintHelperKitkat(Context context) {
        this.mContext = context;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Matrix getMatrix(int n2, int n3, RectF rectF, int n4) {
        Matrix matrix = new Matrix();
        float f2 = rectF.width() / (float)n2;
        float f3 = n4 == 2 ? Math.max(f2, rectF.height() / (float)n3) : Math.min(f2, rectF.height() / (float)n3);
        matrix.postScale(f3, f3);
        matrix.postTranslate((rectF.width() - f3 * (float)n2) / 2.0f, (rectF.height() - f3 * (float)n3) / 2.0f);
        return matrix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap loadBitmap(Uri uri, BitmapFactory.Options options) throws FileNotFoundException {
        Bitmap bitmap;
        if (uri == null) throw new IllegalArgumentException("bad argument to loadBitmap");
        if (this.mContext == null) {
            throw new IllegalArgumentException("bad argument to loadBitmap");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getContentResolver().openInputStream(uri);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            if (inputStream == null) return bitmap;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Log.w((String)LOG_TAG, (String)"close fail ", (Throwable)iOException);
                throw throwable;
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return bitmap;
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)"close fail ", (Throwable)iOException);
            return bitmap;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap loadConstrainedBitmap(Uri uri, int n2) throws FileNotFoundException {
        BitmapFactory.Options options;
        if (n2 <= 0) throw new IllegalArgumentException("bad argument to getScaledBitmap");
        if (uri == null) throw new IllegalArgumentException("bad argument to getScaledBitmap");
        if (this.mContext == null) {
            throw new IllegalArgumentException("bad argument to getScaledBitmap");
        }
        BitmapFactory.Options options2 = new BitmapFactory.Options();
        options2.inJustDecodeBounds = true;
        this.loadBitmap(uri, options2);
        int n3 = options2.outWidth;
        int n4 = options2.outHeight;
        if (n3 <= 0) return null;
        if (n4 <= 0) {
            return null;
        }
        int n5 = 1;
        for (int i2 = Math.max(n3, n4); i2 > n2; i2 >>>= 1, n5 <<= 1) {
        }
        if (n5 <= 0) return null;
        if (Math.min(n3, n4) / n5 <= 0) return null;
        Object object = this.mLock;
        synchronized (object) {
            this.mDecodeOptions = new BitmapFactory.Options();
            this.mDecodeOptions.inMutable = true;
            this.mDecodeOptions.inSampleSize = n5;
            options = this.mDecodeOptions;
        }
        try {
            Bitmap bitmap = this.loadBitmap(uri, options);
            return bitmap;
        }
        finally {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.mDecodeOptions = null;
            }
        }
    }

    public int getColorMode() {
        return this.mColorMode;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getScaleMode() {
        return this.mScaleMode;
    }

    public void printBitmap(final String string2, final Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        final int n2 = this.mScaleMode;
        PrintManager printManager = (PrintManager)this.mContext.getSystemService("print");
        PrintAttributes.MediaSize mediaSize = PrintAttributes.MediaSize.UNKNOWN_PORTRAIT;
        if (bitmap.getWidth() > bitmap.getHeight()) {
            mediaSize = PrintAttributes.MediaSize.UNKNOWN_LANDSCAPE;
        }
        PrintAttributes printAttributes = new PrintAttributes.Builder().setMediaSize(mediaSize).setColorMode(this.mColorMode).build();
        printManager.print(string2, new PrintDocumentAdapter(){
            private PrintAttributes mAttributes;

            /*
             * Enabled aggressive block sorting
             */
            public void onLayout(PrintAttributes printAttributes, PrintAttributes printAttributes2, CancellationSignal cancellationSignal, PrintDocumentAdapter.LayoutResultCallback layoutResultCallback, Bundle bundle) {
                boolean bl2 = true;
                this.mAttributes = printAttributes2;
                PrintDocumentInfo printDocumentInfo = new PrintDocumentInfo.Builder(string2).setContentType(bl2 ? 1 : 0).setPageCount(bl2 ? 1 : 0).build();
                if (printAttributes2.equals((Object)printAttributes)) {
                    bl2 = false;
                }
                layoutResultCallback.onLayoutFinished(printDocumentInfo, bl2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onWrite(PageRange[] pageRangeArray, ParcelFileDescriptor parcelFileDescriptor, CancellationSignal cancellationSignal, PrintDocumentAdapter.WriteResultCallback writeResultCallback) {
                PrintedPdfDocument printedPdfDocument = new PrintedPdfDocument(PrintHelperKitkat.this.mContext, this.mAttributes);
                try {
                    PdfDocument.Page page = printedPdfDocument.startPage(1);
                    RectF rectF = new RectF(page.getInfo().getContentRect());
                    Matrix matrix = PrintHelperKitkat.this.getMatrix(bitmap.getWidth(), bitmap.getHeight(), rectF, n2);
                    page.getCanvas().drawBitmap(bitmap, matrix, null);
                    printedPdfDocument.finishPage(page);
                    try {
                        printedPdfDocument.writeTo((OutputStream)new FileOutputStream(parcelFileDescriptor.getFileDescriptor()));
                        PageRange[] pageRangeArray2 = new PageRange[]{PageRange.ALL_PAGES};
                        writeResultCallback.onWriteFinished(pageRangeArray2);
                        return;
                    }
                    catch (IOException iOException) {
                        Log.e((String)PrintHelperKitkat.LOG_TAG, (String)"Error writing printed content", (Throwable)iOException);
                        writeResultCallback.onWriteFailed(null);
                        return;
                    }
                }
                finally {
                    if (printedPdfDocument != null) {
                        printedPdfDocument.close();
                    }
                    if (parcelFileDescriptor != null) {
                        parcelFileDescriptor.close();
                    }
                }
            }
        }, printAttributes);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void printBitmap(final String string2, final Uri uri) throws FileNotFoundException {
        PrintDocumentAdapter printDocumentAdapter = new PrintDocumentAdapter(){
            AsyncTask<Uri, Boolean, Bitmap> loadBitmap;
            private PrintAttributes mAttributes;
            Bitmap mBitmap = null;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void cancelLoad() {
                Object object = PrintHelperKitkat.this.mLock;
                synchronized (object) {
                    if (PrintHelperKitkat.this.mDecodeOptions != null) {
                        PrintHelperKitkat.this.mDecodeOptions.requestCancelDecode();
                        PrintHelperKitkat.this.mDecodeOptions = null;
                    }
                    return;
                }
            }

            public void onFinish() {
                super.onFinish();
                this.cancelLoad();
                this.loadBitmap.cancel(true);
            }

            /*
             * Enabled aggressive block sorting
             */
            public void onLayout(final PrintAttributes printAttributes, final PrintAttributes printAttributes2, final CancellationSignal cancellationSignal, final PrintDocumentAdapter.LayoutResultCallback layoutResultCallback, Bundle bundle) {
                boolean bl2 = true;
                if (cancellationSignal.isCanceled()) {
                    layoutResultCallback.onLayoutCancelled();
                    this.mAttributes = printAttributes2;
                    return;
                }
                if (this.mBitmap == null) {
                    this.loadBitmap = new AsyncTask<Uri, Boolean, Bitmap>(){

                        protected Bitmap doInBackground(Uri ... uriArray) {
                            try {
                                Bitmap bitmap = PrintHelperKitkat.this.loadConstrainedBitmap(uri, 3500);
                                return bitmap;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                return null;
                            }
                        }

                        protected void onCancelled(Bitmap bitmap) {
                            layoutResultCallback.onLayoutCancelled();
                        }

                        /*
                         * Enabled aggressive block sorting
                         */
                        protected void onPostExecute(Bitmap bitmap) {
                            boolean bl2 = true;
                            super.onPostExecute((Object)bitmap);
                            mBitmap = bitmap;
                            if (bitmap == null) {
                                layoutResultCallback.onLayoutFailed(null);
                                return;
                            }
                            PrintDocumentInfo printDocumentInfo = new PrintDocumentInfo.Builder(string2).setContentType(bl2 ? 1 : 0).setPageCount(bl2 ? 1 : 0).build();
                            if (printAttributes2.equals((Object)printAttributes)) {
                                bl2 = false;
                            }
                            layoutResultCallback.onLayoutFinished(printDocumentInfo, bl2);
                        }

                        protected void onPreExecute() {
                            cancellationSignal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

                                public void onCancel() {
                                    this.cancelLoad();
                                    this.cancel(false);
                                }
                            });
                        }
                    };
                    this.loadBitmap.execute((Object[])new Uri[0]);
                    this.mAttributes = printAttributes2;
                    return;
                }
                PrintDocumentInfo printDocumentInfo = new PrintDocumentInfo.Builder(string2).setContentType(bl2 ? 1 : 0).setPageCount(bl2 ? 1 : 0).build();
                if (printAttributes2.equals((Object)printAttributes)) {
                    bl2 = false;
                }
                layoutResultCallback.onLayoutFinished(printDocumentInfo, bl2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onWrite(PageRange[] pageRangeArray, ParcelFileDescriptor parcelFileDescriptor, CancellationSignal cancellationSignal, PrintDocumentAdapter.WriteResultCallback writeResultCallback) {
                PrintedPdfDocument printedPdfDocument = new PrintedPdfDocument(PrintHelperKitkat.this.mContext, this.mAttributes);
                try {
                    PdfDocument.Page page = printedPdfDocument.startPage(1);
                    RectF rectF = new RectF(page.getInfo().getContentRect());
                    Matrix matrix = PrintHelperKitkat.this.getMatrix(this.mBitmap.getWidth(), this.mBitmap.getHeight(), rectF, mScaleMode);
                    page.getCanvas().drawBitmap(this.mBitmap, matrix, null);
                    printedPdfDocument.finishPage(page);
                    try {
                        printedPdfDocument.writeTo((OutputStream)new FileOutputStream(parcelFileDescriptor.getFileDescriptor()));
                        PageRange[] pageRangeArray2 = new PageRange[]{PageRange.ALL_PAGES};
                        writeResultCallback.onWriteFinished(pageRangeArray2);
                        return;
                    }
                    catch (IOException iOException) {
                        Log.e((String)PrintHelperKitkat.LOG_TAG, (String)"Error writing printed content", (Throwable)iOException);
                        writeResultCallback.onWriteFailed(null);
                        return;
                    }
                }
                finally {
                    if (printedPdfDocument != null) {
                        printedPdfDocument.close();
                    }
                    if (parcelFileDescriptor != null) {
                        parcelFileDescriptor.close();
                    }
                }
            }
        };
        PrintManager printManager = (PrintManager)this.mContext.getSystemService("print");
        PrintAttributes.Builder builder = new PrintAttributes.Builder();
        builder.setColorMode(this.mColorMode);
        if (this.mOrientation == 1) {
            builder.setMediaSize(PrintAttributes.MediaSize.UNKNOWN_LANDSCAPE);
        } else if (this.mOrientation == 2) {
            builder.setMediaSize(PrintAttributes.MediaSize.UNKNOWN_PORTRAIT);
        }
        printManager.print(string2, printDocumentAdapter, builder.build());
    }

    public void setColorMode(int n2) {
        this.mColorMode = n2;
    }

    public void setOrientation(int n2) {
        this.mOrientation = n2;
    }

    public void setScaleMode(int n2) {
        this.mScaleMode = n2;
    }
}

