/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.util.Log;
import android.util.SparseArray;

public abstract class WakefulBroadcastReceiver
extends BroadcastReceiver {
    private static final String EXTRA_WAKE_LOCK_ID = "android.support.content.wakelockid";
    private static final SparseArray<PowerManager.WakeLock> mActiveWakeLocks = new SparseArray();
    private static int mNextId = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean completeWakefulIntent(Intent intent) {
        int n2 = intent.getIntExtra(EXTRA_WAKE_LOCK_ID, 0);
        if (n2 == 0) {
            return false;
        }
        SparseArray<PowerManager.WakeLock> sparseArray = mActiveWakeLocks;
        synchronized (sparseArray) {
            PowerManager.WakeLock wakeLock = (PowerManager.WakeLock)mActiveWakeLocks.get(n2);
            if (wakeLock != null) {
                wakeLock.release();
                mActiveWakeLocks.remove(n2);
                return true;
            }
            Log.w((String)"WakefulBroadcastReceiver", (String)("No active wake lock id #" + n2));
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ComponentName startWakefulService(Context context, Intent intent) {
        SparseArray<PowerManager.WakeLock> sparseArray = mActiveWakeLocks;
        synchronized (sparseArray) {
            int n2 = mNextId;
            mNextId = 1 + mNextId;
            if (mNextId <= 0) {
                mNextId = 1;
            }
            intent.putExtra(EXTRA_WAKE_LOCK_ID, n2);
            ComponentName componentName = context.startService(intent);
            if (componentName == null) {
                return null;
            }
            PowerManager.WakeLock wakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, "wake:" + componentName.flattenToShortString());
            wakeLock.setReferenceCounted(false);
            wakeLock.acquire(60000L);
            mActiveWakeLocks.put(n2, (Object)wakeLock);
            return componentName;
        }
    }
}

