/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class LocalBroadcastManager {
    private static final boolean DEBUG = false;
    static final int MSG_EXEC_PENDING_BROADCASTS = 1;
    private static final String TAG = "LocalBroadcastManager";
    private static LocalBroadcastManager mInstance;
    private static final Object mLock;
    private final HashMap<String, ArrayList<ReceiverRecord>> mActions;
    private final Context mAppContext;
    private final Handler mHandler;
    private final ArrayList<BroadcastRecord> mPendingBroadcasts;
    private final HashMap<BroadcastReceiver, ArrayList<IntentFilter>> mReceivers = new HashMap();

    static {
        mLock = new Object();
    }

    private LocalBroadcastManager(Context context) {
        this.mActions = new HashMap();
        this.mPendingBroadcasts = new ArrayList();
        this.mAppContext = context;
        this.mHandler = new Handler(context.getMainLooper()){

            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        super.handleMessage(message);
                        return;
                    }
                    case 1: 
                }
                LocalBroadcastManager.this.executePendingBroadcasts();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executePendingBroadcasts() {
        block3: while (true) {
            BroadcastRecord[] broadcastRecordArray;
            HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
            synchronized (hashMap) {
                int n2 = this.mPendingBroadcasts.size();
                if (n2 <= 0) {
                    return;
                }
                broadcastRecordArray = new BroadcastRecord[n2];
                this.mPendingBroadcasts.toArray(broadcastRecordArray);
                this.mPendingBroadcasts.clear();
            }
            int n3 = 0;
            while (true) {
                if (n3 >= broadcastRecordArray.length) continue block3;
                BroadcastRecord broadcastRecord = broadcastRecordArray[n3];
                for (int i2 = 0; i2 < broadcastRecord.receivers.size(); ++i2) {
                    broadcastRecord.receivers.get((int)i2).receiver.onReceive(this.mAppContext, broadcastRecord.intent);
                }
                ++n3;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalBroadcastManager getInstance(Context context) {
        Object object = mLock;
        synchronized (object) {
            if (mInstance != null) return mInstance;
            mInstance = new LocalBroadcastManager(context.getApplicationContext());
            return mInstance;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ReceiverRecord receiverRecord = new ReceiverRecord(intentFilter, broadcastReceiver);
            ArrayList<Object> arrayList = this.mReceivers.get(broadcastReceiver);
            if (arrayList == null) {
                arrayList = new ArrayList(1);
                this.mReceivers.put(broadcastReceiver, arrayList);
            }
            arrayList.add(intentFilter);
            int n2 = 0;
            while (n2 < intentFilter.countActions()) {
                String string2 = intentFilter.getAction(n2);
                ArrayList<ReceiverRecord> arrayList2 = this.mActions.get(string2);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList(1);
                    this.mActions.put(string2, arrayList2);
                }
                arrayList2.add(receiverRecord);
                ++n2;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendBroadcast(Intent intent) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ArrayList<ReceiverRecord> arrayList;
            block24: {
                block23: {
                    ArrayList<ReceiverRecord> arrayList2;
                    String string2 = intent.getAction();
                    String string3 = intent.resolveTypeIfNeeded(this.mAppContext.getContentResolver());
                    Uri uri = intent.getData();
                    String string4 = intent.getScheme();
                    Set set = intent.getCategories();
                    boolean bl2 = (8 & intent.getFlags()) != 0;
                    if (bl2) {
                        Log.v((String)TAG, (String)("Resolving type " + string3 + " scheme " + string4 + " of intent " + intent));
                    }
                    if ((arrayList2 = this.mActions.get(intent.getAction())) == null) break block23;
                    if (bl2) {
                        Log.v((String)TAG, (String)("Action list: " + arrayList2));
                    }
                    arrayList = null;
                    for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                        String string5;
                        ReceiverRecord receiverRecord = arrayList2.get(i2);
                        if (bl2) {
                            Log.v((String)TAG, (String)("Matching against filter " + receiverRecord.filter));
                        }
                        if (receiverRecord.broadcasting) {
                            if (!bl2) continue;
                            Log.v((String)TAG, (String)"  Filter's target already added");
                            continue;
                        }
                        int n2 = receiverRecord.filter.match(string2, string3, string4, uri, set, TAG);
                        if (n2 >= 0) {
                            if (bl2) {
                                Log.v((String)TAG, (String)("  Filter matched!  match=0x" + Integer.toHexString(n2)));
                            }
                            if (arrayList == null) {
                                arrayList = new ArrayList<ReceiverRecord>();
                            }
                            arrayList.add(receiverRecord);
                            receiverRecord.broadcasting = true;
                            continue;
                        }
                        if (!bl2) continue;
                        switch (n2) {
                            default: {
                                string5 = "unknown reason";
                                break;
                            }
                            case -3: {
                                string5 = "action";
                                break;
                            }
                            case -4: {
                                string5 = "category";
                                break;
                            }
                            case -2: {
                                string5 = "data";
                                break;
                            }
                            case -1: {
                                string5 = "type";
                            }
                        }
                        Log.v((String)TAG, (String)("  Filter did not match: " + string5));
                    }
                    if (arrayList != null) break block24;
                }
                return false;
            }
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                ((ReceiverRecord)arrayList.get((int)i3)).broadcasting = false;
            }
            this.mPendingBroadcasts.add(new BroadcastRecord(intent, arrayList));
            if (!this.mHandler.hasMessages(1)) {
                this.mHandler.sendEmptyMessage(1);
            }
            return true;
        }
    }

    public void sendBroadcastSync(Intent intent) {
        if (this.sendBroadcast(intent)) {
            this.executePendingBroadcasts();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ArrayList<IntentFilter> arrayList = this.mReceivers.remove(broadcastReceiver);
            if (arrayList == null) {
                return;
            }
            int n2 = 0;
            block3: while (n2 < arrayList.size()) {
                IntentFilter intentFilter = arrayList.get(n2);
                int n3 = 0;
                while (true) {
                    block12: {
                        ArrayList<ReceiverRecord> arrayList2;
                        String string2;
                        block13: {
                            block11: {
                                if (n3 >= intentFilter.countActions()) break block11;
                                string2 = intentFilter.getAction(n3);
                                arrayList2 = this.mActions.get(string2);
                                if (arrayList2 == null) break block12;
                                break block13;
                            }
                            ++n2;
                            continue block3;
                        }
                        int n4 = 0;
                        while (true) {
                            if (n4 < arrayList2.size()) {
                                if (arrayList2.get((int)n4).receiver == broadcastReceiver) {
                                    arrayList2.remove(n4);
                                    --n4;
                                }
                            } else {
                                if (arrayList2.size() > 0) break;
                                this.mActions.remove(string2);
                                break;
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
                break;
            }
            return;
        }
    }

    private static class BroadcastRecord {
        final Intent intent;
        final ArrayList<ReceiverRecord> receivers;

        BroadcastRecord(Intent intent, ArrayList<ReceiverRecord> arrayList) {
            this.intent = intent;
            this.receivers = arrayList;
        }
    }

    private static class ReceiverRecord {
        boolean broadcasting;
        final IntentFilter filter;
        final BroadcastReceiver receiver;

        ReceiverRecord(IntentFilter intentFilter, BroadcastReceiver broadcastReceiver) {
            this.filter = intentFilter;
            this.receiver = broadcastReceiver;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Receiver{");
            stringBuilder.append(this.receiver);
            stringBuilder.append(" filter=");
            stringBuilder.append(this.filter);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }
}

