/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class FileProvider
extends ContentProvider {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String[] COLUMNS = new String[]{"_display_name", "_size"};
    private static final File DEVICE_ROOT = new File("/");
    private static final String META_DATA_FILE_PROVIDER_PATHS = "android.support.FILE_PROVIDER_PATHS";
    private static final String TAG_CACHE_PATH = "cache-path";
    private static final String TAG_EXTERNAL = "external-path";
    private static final String TAG_FILES_PATH = "files-path";
    private static final String TAG_ROOT_PATH = "root-path";
    private static HashMap<String, PathStrategy> sCache = new HashMap();
    private PathStrategy mStrategy;

    /*
     * Enabled aggressive block sorting
     */
    private static File buildPath(File file, String ... stringArray) {
        int n2 = stringArray.length;
        int n3 = 0;
        File file2 = file;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            File file3 = string2 != null ? new File(file2, string2) : file2;
            ++n3;
            file2 = file3;
        }
        return file2;
    }

    private static Object[] copyOf(Object[] objectArray, int n2) {
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    private static String[] copyOf(String[] stringArray, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PathStrategy getPathStrategy(Context context, String string2) {
        HashMap<String, PathStrategy> hashMap = sCache;
        synchronized (hashMap) {
            PathStrategy pathStrategy = sCache.get(string2);
            if (pathStrategy == null) {
                try {
                    PathStrategy pathStrategy2;
                    pathStrategy = pathStrategy2 = FileProvider.parsePathStrategy(context, string2);
                    sCache.put(string2, pathStrategy);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", iOException);
                }
                catch (XmlPullParserException xmlPullParserException) {
                    throw new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", xmlPullParserException);
                }
            }
            return pathStrategy;
        }
    }

    public static Uri getUriForFile(Context context, String string2, File file) {
        return FileProvider.getPathStrategy(context, string2).getUriForFile(file);
    }

    private static int modeToMode(String string2) {
        if ("r".equals(string2)) {
            return 0x10000000;
        }
        if ("w".equals(string2) || "wt".equals(string2)) {
            return 0x2C000000;
        }
        if ("wa".equals(string2)) {
            return 0x2A000000;
        }
        if ("rw".equals(string2)) {
            return 0x38000000;
        }
        if ("rwt".equals(string2)) {
            return 0x3C000000;
        }
        throw new IllegalArgumentException("Invalid mode: " + string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static PathStrategy parsePathStrategy(Context context, String string2) throws IOException, XmlPullParserException {
        SimplePathStrategy simplePathStrategy = new SimplePathStrategy(string2);
        XmlResourceParser xmlResourceParser = context.getPackageManager().resolveContentProvider(string2, 128).loadXmlMetaData(context.getPackageManager(), META_DATA_FILE_PROVIDER_PATHS);
        if (xmlResourceParser == null) {
            throw new IllegalArgumentException("Missing android.support.FILE_PROVIDER_PATHS meta-data");
        }
        int n2;
        while ((n2 = xmlResourceParser.next()) != 1) {
            File file;
            if (n2 != 2) continue;
            String string3 = xmlResourceParser.getName();
            String string4 = xmlResourceParser.getAttributeValue(null, ATTR_NAME);
            String string5 = xmlResourceParser.getAttributeValue(null, ATTR_PATH);
            if (TAG_ROOT_PATH.equals(string3)) {
                file = FileProvider.buildPath(DEVICE_ROOT, string5);
            } else if (TAG_FILES_PATH.equals(string3)) {
                file = FileProvider.buildPath(context.getFilesDir(), string5);
            } else if (TAG_CACHE_PATH.equals(string3)) {
                file = FileProvider.buildPath(context.getCacheDir(), string5);
            } else {
                boolean bl2 = TAG_EXTERNAL.equals(string3);
                file = null;
                if (bl2) {
                    file = FileProvider.buildPath(Environment.getExternalStorageDirectory(), string5);
                }
            }
            if (file == null) continue;
            simplePathStrategy.addRoot(string4, file);
        }
        return simplePathStrategy;
    }

    public void attachInfo(Context context, ProviderInfo providerInfo) {
        super.attachInfo(context, providerInfo);
        if (providerInfo.exported) {
            throw new SecurityException("Provider must not be exported");
        }
        if (!providerInfo.grantUriPermissions) {
            throw new SecurityException("Provider must grant uri permissions");
        }
        this.mStrategy = FileProvider.getPathStrategy(context, providerInfo.authority);
    }

    public int delete(Uri uri, String string2, String[] stringArray) {
        if (this.mStrategy.getFileForUri(uri).delete()) {
            return 1;
        }
        return 0;
    }

    public String getType(Uri uri) {
        File file = this.mStrategy.getFileForUri(uri);
        int n2 = file.getName().lastIndexOf(46);
        if (n2 >= 0) {
            String string2 = file.getName().substring(n2 + 1);
            String string3 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2);
            if (string3 != null) {
                return string3;
            }
        }
        return "application/octet-stream";
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        throw new UnsupportedOperationException("No external inserts");
    }

    public boolean onCreate() {
        return true;
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
        return ParcelFileDescriptor.open((File)this.mStrategy.getFileForUri(uri), (int)FileProvider.modeToMode(string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        File file = this.mStrategy.getFileForUri(uri);
        if (stringArray == null) {
            stringArray = COLUMNS;
        }
        String[] stringArray3 = new String[stringArray.length];
        Object[] objectArray = new Object[stringArray.length];
        String[] stringArray4 = stringArray;
        int n2 = stringArray4.length;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            if (n3 >= n2) {
                String[] stringArray5 = FileProvider.copyOf(stringArray3, n4);
                Object[] objectArray2 = FileProvider.copyOf(objectArray, n4);
                MatrixCursor matrixCursor = new MatrixCursor(stringArray5, 1);
                matrixCursor.addRow(objectArray2);
                return matrixCursor;
            }
            String string4 = stringArray4[n3];
            if ("_display_name".equals(string4)) {
                stringArray3[n4] = "_display_name";
                n5 = n4 + 1;
                objectArray[n4] = file.getName();
            } else if ("_size".equals(string4)) {
                stringArray3[n4] = "_size";
                n5 = n4 + 1;
                objectArray[n4] = file.length();
            } else {
                n5 = n4;
            }
            ++n3;
            n4 = n5;
        }
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        throw new UnsupportedOperationException("No external updates");
    }

    static interface PathStrategy {
        public File getFileForUri(Uri var1);

        public Uri getUriForFile(File var1);
    }

    static class SimplePathStrategy
    implements PathStrategy {
        private final String mAuthority;
        private final HashMap<String, File> mRoots = new HashMap();

        public SimplePathStrategy(String string2) {
            this.mAuthority = string2;
        }

        public void addRoot(String string2, File file) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("Name must not be empty");
            }
            try {
                File file2 = file.getCanonicalFile();
                this.mRoots.put(string2, file2);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file, iOException);
            }
        }

        @Override
        public File getFileForUri(Uri uri) {
            File file;
            String string2 = uri.getEncodedPath();
            int n2 = string2.indexOf(47, 1);
            String string3 = Uri.decode((String)string2.substring(1, n2));
            String string4 = Uri.decode((String)string2.substring(n2 + 1));
            File file2 = this.mRoots.get(string3);
            if (file2 == null) {
                throw new IllegalArgumentException("Unable to find configured root for " + uri);
            }
            File file3 = new File(file2, string4);
            try {
                file = file3.getCanonicalFile();
                if (!file.getPath().startsWith(file2.getPath())) {
                    throw new SecurityException("Resolved path jumped beyond configured root");
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file3);
            }
            return file;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Uri getUriForFile(File file) {
            Iterator<Map.Entry<String, File>> iterator;
            Map.Entry<String, File> entry;
            String string2;
            try {
                string2 = file.getCanonicalPath();
                entry = null;
                iterator = this.mRoots.entrySet().iterator();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file);
            }
            while (iterator.hasNext()) {
                Map.Entry<String, File> entry2 = iterator.next();
                String string3 = entry2.getValue().getPath();
                if (!string2.startsWith(string3) || entry != null && string3.length() <= entry.getValue().getPath().length()) continue;
                entry = entry2;
            }
            if (entry == null) {
                throw new IllegalArgumentException("Failed to find configured root that contains " + string2);
            }
            String string4 = ((File)entry.getValue()).getPath();
            String string5 = string4.endsWith("/") ? string2.substring(string4.length()) : string2.substring(1 + string4.length());
            String string6 = Uri.encode((String)entry.getKey()) + '/' + Uri.encode((String)string5, (String)"/");
            return new Uri.Builder().scheme("content").authority(this.mAuthority).encodedPath(string6).build();
        }
    }
}

