/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.content.ContextCompatFroyo;
import android.support.v4.content.ContextCompatHoneycomb;
import android.support.v4.content.ContextCompatJellybean;
import android.support.v4.content.ContextCompatKitKat;
import java.io.File;

public class ContextCompat {
    private static final String DIR_ANDROID = "Android";
    private static final String DIR_CACHE = "cache";
    private static final String DIR_DATA = "data";
    private static final String DIR_FILES = "files";
    private static final String DIR_OBB = "obb";

    /*
     * Enabled aggressive block sorting
     */
    private static File buildPath(File file, String ... stringArray) {
        int n2 = stringArray.length;
        int n3 = 0;
        File file2 = file;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            File file3 = file2 == null ? new File(string2) : (string2 != null ? new File(file2, string2) : file2);
            ++n3;
            file2 = file3;
        }
        return file2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File[] getExternalCacheDirs(Context context) {
        File file;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 19) {
            return ContextCompatKitKat.getExternalCacheDirs(context);
        }
        if (n2 >= 8) {
            file = ContextCompatFroyo.getExternalCacheDir(context);
            return new File[]{file};
        }
        File file2 = Environment.getExternalStorageDirectory();
        String[] stringArray = new String[]{DIR_ANDROID, DIR_DATA, context.getPackageName(), DIR_CACHE};
        file = ContextCompat.buildPath(file2, stringArray);
        return new File[]{file};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File[] getExternalFilesDirs(Context context, String string2) {
        File file;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 19) {
            return ContextCompatKitKat.getExternalFilesDirs(context, string2);
        }
        if (n2 >= 8) {
            file = ContextCompatFroyo.getExternalFilesDir(context, string2);
            return new File[]{file};
        }
        File file2 = Environment.getExternalStorageDirectory();
        String[] stringArray = new String[]{DIR_ANDROID, DIR_DATA, context.getPackageName(), DIR_FILES, string2};
        file = ContextCompat.buildPath(file2, stringArray);
        return new File[]{file};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File[] getObbDirs(Context context) {
        File file;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 19) {
            return ContextCompatKitKat.getObbDirs(context);
        }
        if (n2 >= 11) {
            file = ContextCompatHoneycomb.getObbDir(context);
            return new File[]{file};
        }
        File file2 = Environment.getExternalStorageDirectory();
        String[] stringArray = new String[]{DIR_ANDROID, DIR_OBB, context.getPackageName()};
        file = ContextCompat.buildPath(file2, stringArray);
        return new File[]{file};
    }

    public static boolean startActivities(Context context, Intent[] intentArray) {
        return ContextCompat.startActivities(context, intentArray, null);
    }

    public static boolean startActivities(Context context, Intent[] intentArray, Bundle bundle) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 16) {
            ContextCompatJellybean.startActivities(context, intentArray, bundle);
            return true;
        }
        if (n2 >= 11) {
            ContextCompatHoneycomb.startActivities(context, intentArray);
            return true;
        }
        return false;
    }
}

