/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.content.Context;
import android.support.v4.app.BackStackRecord;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentManagerImpl;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.jakewharton.hanselandgretel.R;

public class FragmentBreadCrumbs
extends ViewGroup
implements FragmentManager.OnBackStackChangedListener {
    private static final int MEASURED_HEIGHT_STATE_SHIFT = 16;
    private static final int MEASURED_STATE_MASK = -16777216;
    private static final int MEASURED_STATE_TOO_SMALL = 0x1000000;
    FragmentActivity mActivity;
    LinearLayout mContainer;
    LayoutInflater mInflater;
    int mMaxVisible = -1;
    private OnBreadCrumbClickListener mOnBreadCrumbClickListener;
    private View.OnClickListener mOnClickListener = new View.OnClickListener(){

        /*
         * Enabled aggressive block sorting
         */
        public void onClick(View view) {
            FragmentManager.BackStackEntry backStackEntry;
            OnBreadCrumbClickListener onBreadCrumbClickListener;
            if (!(view.getTag() instanceof FragmentManager.BackStackEntry)) return;
            FragmentManager.BackStackEntry backStackEntry2 = (FragmentManager.BackStackEntry)view.getTag();
            if (backStackEntry2 == FragmentBreadCrumbs.this.mParentEntry) {
                if (FragmentBreadCrumbs.this.mParentClickListener == null) return;
                FragmentBreadCrumbs.this.mParentClickListener.onClick(view);
                return;
            }
            if (FragmentBreadCrumbs.this.mOnBreadCrumbClickListener != null && (onBreadCrumbClickListener = FragmentBreadCrumbs.this.mOnBreadCrumbClickListener).onBreadCrumbClick(backStackEntry = backStackEntry2 == FragmentBreadCrumbs.this.mTopEntry ? null : backStackEntry2, 0)) {
                return;
            }
            if (backStackEntry2 == FragmentBreadCrumbs.this.mTopEntry) {
                FragmentBreadCrumbs.this.mActivity.getSupportFragmentManager().popBackStack();
                return;
            }
            FragmentBreadCrumbs.this.mActivity.getSupportFragmentManager().popBackStack(backStackEntry2.getId(), 0);
        }
    };
    private View.OnClickListener mParentClickListener;
    BackStackRecord mParentEntry;
    BackStackRecord mTopEntry;

    public FragmentBreadCrumbs(Context context) {
        this(context, null);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.style.Widget_HanselAndGretel_FragmentBreadCrumb);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    public static int combineMeasuredStates(int n2, int n3) {
        return n2 | n3;
    }

    private BackStackRecord createBackStackEntry(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null) {
            return null;
        }
        BackStackRecord backStackRecord = new BackStackRecord((FragmentManagerImpl)this.mActivity.getSupportFragmentManager());
        backStackRecord.setBreadCrumbTitle(charSequence);
        backStackRecord.setBreadCrumbShortTitle(charSequence2);
        return backStackRecord;
    }

    private static final int getMeasuredState(View view) {
        return 0xFF000000 & view.getMeasuredWidth() | 0xFFFFFF00 & view.getMeasuredHeight() >> 16;
    }

    private FragmentManager.BackStackEntry getPreEntry(int n2) {
        if (this.mParentEntry != null) {
            if (n2 == 0) {
                return this.mParentEntry;
            }
            return this.mTopEntry;
        }
        return this.mTopEntry;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getPreEntryCount() {
        int n2 = 1;
        int n3 = this.mTopEntry != null ? n2 : 0;
        if (this.mParentEntry != null) {
            return n3 + n2;
        }
        n2 = 0;
        return n3 + n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int resolveSizeAndState(int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = View.MeasureSpec.getMode((int)n3);
        int n7 = View.MeasureSpec.getSize((int)n3);
        switch (n6) {
            case 0: {
                n5 = n2;
                return n5 | 0xFF000000 & n4;
            }
            case -2147483648: {
                if (n7 < n2) {
                    n5 = n7 | 0x1000000;
                    return n5 | 0xFF000000 & n4;
                }
                n5 = n2;
                return n5 | 0xFF000000 & n4;
            }
            case 0x40000000: {
                n5 = n7;
                return n5 | 0xFF000000 & n4;
            }
        }
        return n5 | 0xFF000000 & n4;
    }

    @Override
    public void onBackStackChanged() {
        this.updateCrumbs();
    }

    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        int n6 = this.getPaddingLeft();
        int n7 = this.getPaddingRight();
        int n8 = this.getPaddingTop();
        int n9 = this.getPaddingBottom();
        int n10 = this.getChildCount();
        for (int i2 = 0; i2 < n10; ++i2) {
            View view = this.getChildAt(i2);
            view.layout(n6, n8, n6 + view.getMeasuredWidth() - n7, n8 + view.getMeasuredHeight() - n9);
        }
    }

    protected void onMeasure(int n2, int n3) {
        int n4 = this.getChildCount();
        int n5 = this.getPaddingLeft();
        int n6 = this.getPaddingRight();
        int n7 = this.getPaddingTop();
        int n8 = this.getPaddingBottom();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            this.measureChild(view, n2, n3);
            n10 = Math.max(n10, view.getMeasuredWidth());
            n9 = Math.max(n9, view.getMeasuredHeight());
            n11 = FragmentBreadCrumbs.combineMeasuredStates(n11, FragmentBreadCrumbs.getMeasuredState(view));
        }
        int n12 = n10 + (n5 + n6);
        int n13 = Math.max(n9 + (n7 + n8), this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(FragmentBreadCrumbs.resolveSizeAndState(Math.max(n12, this.getSuggestedMinimumWidth()), n2, n11), FragmentBreadCrumbs.resolveSizeAndState(n13, n3, n11 << 16));
    }

    public void setActivity(FragmentActivity fragmentActivity) {
        this.mActivity = fragmentActivity;
        this.mInflater = (LayoutInflater)fragmentActivity.getSystemService("layout_inflater");
        this.mContainer = (LinearLayout)this.mInflater.inflate(R.layout.hag__fragment_bread_crumbs, (ViewGroup)this, false);
        this.addView((View)this.mContainer);
        fragmentActivity.getSupportFragmentManager().addOnBackStackChangedListener(this);
        this.updateCrumbs();
    }

    public void setMaxVisible(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("visibleCrumbs must be greater than zero");
        }
        this.mMaxVisible = n2;
    }

    public void setOnBreadCrumbClickListener(OnBreadCrumbClickListener onBreadCrumbClickListener) {
        this.mOnBreadCrumbClickListener = onBreadCrumbClickListener;
    }

    public void setParentTitle(CharSequence charSequence, CharSequence charSequence2, View.OnClickListener onClickListener) {
        this.mParentEntry = this.createBackStackEntry(charSequence, charSequence2);
        this.mParentClickListener = onClickListener;
        this.updateCrumbs();
    }

    public void setTitle(CharSequence charSequence, CharSequence charSequence2) {
        this.mTopEntry = this.createBackStackEntry(charSequence, charSequence2);
        this.updateCrumbs();
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateCrumbs() {
        int n2;
        FragmentManager fragmentManager = this.mActivity.getSupportFragmentManager();
        int n3 = fragmentManager.getBackStackEntryCount();
        int n4 = this.getPreEntryCount();
        int n5 = this.mContainer.getChildCount();
        for (int i2 = 0; i2 < n3 + n4; ++i2) {
            FragmentManager.BackStackEntry backStackEntry = i2 < n4 ? this.getPreEntry(i2) : fragmentManager.getBackStackEntryAt(i2 - n4);
            if (i2 < n5 && this.mContainer.getChildAt(i2).getTag() != backStackEntry) {
                for (int i3 = i2; i3 < n5; ++i3) {
                    this.mContainer.removeViewAt(i2);
                }
                n5 = i2;
            }
            if (i2 < n5) continue;
            View view = this.mInflater.inflate(R.layout.hag__fragment_bread_crumb_item, (ViewGroup)this, false);
            TextView textView = (TextView)view.findViewById(16908310);
            textView.setText(backStackEntry.getBreadCrumbTitle());
            textView.setTag((Object)backStackEntry);
            if (i2 == 0) {
                view.findViewById(16908294).setVisibility(8);
            }
            this.mContainer.addView(view);
            textView.setOnClickListener(this.mOnClickListener);
        }
        int n6 = n3 + n4;
        for (n2 = this.mContainer.getChildCount(); n2 > n6; --n2) {
            this.mContainer.removeViewAt(n2 - 1);
        }
        int n7 = 0;
        while (n7 < n2) {
            View view = this.mContainer.getChildAt(n7);
            View view2 = view.findViewById(16908310);
            boolean bl2 = n7 < n2 - 1;
            view2.setEnabled(bl2);
            if (this.mMaxVisible > 0) {
                int n8 = n7 < n2 - this.mMaxVisible ? 8 : 0;
                view.setVisibility(n8);
                View view3 = view.findViewById(16908294);
                int n9 = n7 > n2 - this.mMaxVisible && n7 != 0 ? 0 : 8;
                view3.setVisibility(n9);
            }
            ++n7;
        }
        return;
    }

    public static interface OnBreadCrumbClickListener {
        public boolean onBreadCrumbClick(FragmentManager.BackStackEntry var1, int var2);
    }
}

