/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.BackStackRecord;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManagerImpl;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;

final class BackStackState
implements Parcelable {
    public static final Parcelable.Creator<BackStackState> CREATOR = new Parcelable.Creator<BackStackState>(){

        public BackStackState createFromParcel(Parcel parcel) {
            return new BackStackState(parcel);
        }

        public BackStackState[] newArray(int n2) {
            return new BackStackState[n2];
        }
    };
    final int mBreadCrumbShortTitleRes;
    final CharSequence mBreadCrumbShortTitleText;
    final int mBreadCrumbTitleRes;
    final CharSequence mBreadCrumbTitleText;
    final int mIndex;
    final String mName;
    final int[] mOps;
    final int mTransition;
    final int mTransitionStyle;

    public BackStackState(Parcel parcel) {
        this.mOps = parcel.createIntArray();
        this.mTransition = parcel.readInt();
        this.mTransitionStyle = parcel.readInt();
        this.mName = parcel.readString();
        this.mIndex = parcel.readInt();
        this.mBreadCrumbTitleRes = parcel.readInt();
        this.mBreadCrumbTitleText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mBreadCrumbShortTitleRes = parcel.readInt();
        this.mBreadCrumbShortTitleText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    public BackStackState(FragmentManagerImpl fragmentManagerImpl, BackStackRecord backStackRecord) {
        int n2 = 0;
        BackStackRecord.Op op = backStackRecord.mHead;
        while (op != null) {
            if (op.removed != null) {
                n2 += op.removed.size();
            }
            op = op.next;
        }
        this.mOps = new int[n2 + 7 * backStackRecord.mNumOp];
        if (!backStackRecord.mAddToBackStack) {
            throw new IllegalStateException("Not on back stack");
        }
        BackStackRecord.Op op2 = backStackRecord.mHead;
        int n3 = 0;
        while (true) {
            int n4;
            if (op2 == null) {
                this.mTransition = backStackRecord.mTransition;
                this.mTransitionStyle = backStackRecord.mTransitionStyle;
                this.mName = backStackRecord.mName;
                this.mIndex = backStackRecord.mIndex;
                this.mBreadCrumbTitleRes = backStackRecord.mBreadCrumbTitleRes;
                this.mBreadCrumbTitleText = backStackRecord.mBreadCrumbTitleText;
                this.mBreadCrumbShortTitleRes = backStackRecord.mBreadCrumbShortTitleRes;
                this.mBreadCrumbShortTitleText = backStackRecord.mBreadCrumbShortTitleText;
                return;
            }
            int[] nArray = this.mOps;
            int n5 = n3 + 1;
            nArray[n3] = op2.cmd;
            int[] nArray2 = this.mOps;
            int n6 = n5 + 1;
            int n7 = op2.fragment != null ? op2.fragment.mIndex : -1;
            nArray2[n5] = n7;
            int[] nArray3 = this.mOps;
            int n8 = n6 + 1;
            nArray3[n6] = op2.enterAnim;
            int[] nArray4 = this.mOps;
            int n9 = n8 + 1;
            nArray4[n8] = op2.exitAnim;
            int[] nArray5 = this.mOps;
            int n10 = n9 + 1;
            nArray5[n9] = op2.popEnterAnim;
            int[] nArray6 = this.mOps;
            int n11 = n10 + 1;
            nArray6[n10] = op2.popExitAnim;
            if (op2.removed != null) {
                int n12 = op2.removed.size();
                int[] nArray7 = this.mOps;
                int n13 = n11 + 1;
                nArray7[n11] = n12;
                int n14 = n13;
                for (int i2 = 0; i2 < n12; ++i2) {
                    int[] nArray8 = this.mOps;
                    int n15 = n14 + 1;
                    nArray8[n14] = op2.removed.get((int)i2).mIndex;
                    n14 = n15;
                }
                n4 = n14;
            } else {
                int[] nArray9 = this.mOps;
                n4 = n11 + 1;
                nArray9[n11] = 0;
            }
            op2 = op2.next;
            n3 = n4;
        }
    }

    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public BackStackRecord instantiate(FragmentManagerImpl fragmentManagerImpl) {
        BackStackRecord backStackRecord = new BackStackRecord(fragmentManagerImpl);
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n2 >= this.mOps.length) {
                backStackRecord.mTransition = this.mTransition;
                backStackRecord.mTransitionStyle = this.mTransitionStyle;
                backStackRecord.mName = this.mName;
                backStackRecord.mIndex = this.mIndex;
                backStackRecord.mAddToBackStack = true;
                backStackRecord.mBreadCrumbTitleRes = this.mBreadCrumbTitleRes;
                backStackRecord.mBreadCrumbTitleText = this.mBreadCrumbTitleText;
                backStackRecord.mBreadCrumbShortTitleRes = this.mBreadCrumbShortTitleRes;
                backStackRecord.mBreadCrumbShortTitleText = this.mBreadCrumbShortTitleText;
                backStackRecord.bumpBackStackNesting(1);
                return backStackRecord;
            }
            BackStackRecord.Op op = new BackStackRecord.Op();
            int[] nArray = this.mOps;
            int n4 = n2 + 1;
            op.cmd = nArray[n2];
            if (FragmentManagerImpl.DEBUG) {
                Log.v((String)"FragmentManager", (String)("Instantiate " + backStackRecord + " op #" + n3 + " base fragment #" + this.mOps[n4]));
            }
            int[] nArray2 = this.mOps;
            int n5 = n4 + 1;
            int n6 = nArray2[n4];
            op.fragment = n6 >= 0 ? fragmentManagerImpl.mActive.get(n6) : null;
            int[] nArray3 = this.mOps;
            int n7 = n5 + 1;
            op.enterAnim = nArray3[n5];
            int[] nArray4 = this.mOps;
            int n8 = n7 + 1;
            op.exitAnim = nArray4[n7];
            int[] nArray5 = this.mOps;
            int n9 = n8 + 1;
            op.popEnterAnim = nArray5[n8];
            int[] nArray6 = this.mOps;
            int n10 = n9 + 1;
            op.popExitAnim = nArray6[n9];
            int[] nArray7 = this.mOps;
            int n11 = n10 + 1;
            int n12 = nArray7[n10];
            if (n12 > 0) {
                op.removed = new ArrayList(n12);
                for (int i2 = 0; i2 < n12; ++i2) {
                    if (FragmentManagerImpl.DEBUG) {
                        Log.v((String)"FragmentManager", (String)("Instantiate " + backStackRecord + " set remove fragment #" + this.mOps[n11]));
                    }
                    ArrayList<Fragment> arrayList = fragmentManagerImpl.mActive;
                    int[] nArray8 = this.mOps;
                    int n13 = n11 + 1;
                    Fragment fragment = arrayList.get(nArray8[n11]);
                    op.removed.add(fragment);
                    n11 = n13;
                }
            }
            n2 = n11;
            backStackRecord.addOp(op);
            ++n3;
        }
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeIntArray(this.mOps);
        parcel.writeInt(this.mTransition);
        parcel.writeInt(this.mTransitionStyle);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mIndex);
        parcel.writeInt(this.mBreadCrumbTitleRes);
        TextUtils.writeToParcel((CharSequence)this.mBreadCrumbTitleText, (Parcel)parcel, (int)0);
        parcel.writeInt(this.mBreadCrumbShortTitleRes);
        TextUtils.writeToParcel((CharSequence)this.mBreadCrumbShortTitleText, (Parcel)parcel, (int)0);
    }
}

