/*
 * Decompiled with CFR 0.152.
 */
package rmi;

import java.awt.Dimension;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javax.media.Codec;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoProcessorException;
import javax.media.Owned;
import javax.media.Player;
import javax.media.Processor;
import javax.media.control.QualityControl;
import javax.media.control.TrackControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.RTPManager;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;

public class Transmitter {
    private static final long serialVersionUID = 1L;
    private MediaLocator locator;
    private String ipAddress;
    private int portBase;
    private Processor processor = null;
    private RTPManager[] rtpMgrs;
    private DataSource dataOutput = null;
    private DatagramSocket recvSoc;
    private Integer stateLock = new Integer(0);
    private boolean failed = false;

    public Transmitter(MediaLocator locator, String ipAddress, String pb, Format format) {
        this.locator = locator;
        this.ipAddress = ipAddress;
        Integer integer = Integer.valueOf(pb);
        if (integer != null) {
            this.portBase = integer;
        }
    }

    public synchronized String start(Format format) {
        String result = this.createProcessor(format);
        if (result != null) {
            return result;
        }
        result = this.createTransmitter();
        if (result != null) {
            this.processor.close();
            this.processor = null;
            return result;
        }
        this.processor.start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Transmitter transmitter = this;
        synchronized (transmitter) {
            if (this.processor != null) {
                this.processor.stop();
                this.processor.close();
                this.processor = null;
                int i2 = 0;
                while (i2 < this.rtpMgrs.length) {
                    this.rtpMgrs[i2].removeTargets("Session ended.");
                    this.rtpMgrs[i2].dispose();
                    ++i2;
                }
            }
        }
    }

    private String createProcessor(Format chosen) {
        DataSource ds;
        if (this.locator == null) {
            return "Locator is null";
        }
        try {
            ds = Manager.createDataSource(this.locator);
        }
        catch (Exception e2) {
            return "Couldn't create DataSource";
        }
        try {
            this.processor = Manager.createProcessor(ds);
        }
        catch (NoProcessorException npe) {
            return "Couldn't create processor";
        }
        catch (IOException ioe) {
            return "IOException creating processor";
        }
        boolean result = this.waitForState(this.processor, 180);
        if (!result) {
            return "Couldn't configure processor";
        }
        TrackControl[] tracks = this.processor.getTrackControls();
        if (tracks == null || tracks.length < 1) {
            return "Couldn't find tracks in processor";
        }
        ContentDescriptor cd = new ContentDescriptor("raw.rtp");
        this.processor.setContentDescriptor(cd);
        boolean atLeastOneTrack = false;
        int i2 = 0;
        while (i2 < tracks.length) {
            Format f2 = tracks[i2].getFormat();
            if (tracks[i2].isEnabled()) {
                Format[] supported = tracks[i2].getSupportedFormats();
                if (supported.length > 0) {
                    if (chosen == null) {
                        chosen = supported[0];
                    }
                    tracks[i2].setFormat(chosen);
                    System.err.println("Track " + i2 + " is set to transmit as:");
                    System.err.println("  " + chosen);
                    atLeastOneTrack = true;
                } else {
                    tracks[i2].setEnabled(false);
                }
            } else {
                tracks[i2].setEnabled(false);
            }
            ++i2;
        }
        if (!atLeastOneTrack) {
            return "Couldn't set any of the tracks to a valid RTP format";
        }
        result = this.waitForState(this.processor, 300);
        if (!result) {
            return "Couldn't realize processor";
        }
        this.setJPEGQuality(this.processor, 0.5f);
        this.dataOutput = this.processor.getDataOutput();
        return null;
    }

    private String createTransmitter() {
        PushBufferDataSource pbds = (PushBufferDataSource)this.dataOutput;
        PushBufferStream[] pbss = pbds.getStreams();
        this.rtpMgrs = new RTPManager[pbss.length];
        int i2 = 0;
        while (i2 < pbss.length) {
            try {
                this.rtpMgrs[i2] = RTPManager.newInstance();
                int port = this.portBase + 2 * i2;
                InetAddress ipAddr = InetAddress.getByName(this.ipAddress);
                SessionAddress localAddr = new SessionAddress(InetAddress.getLocalHost(), port);
                SessionAddress destAddr = new SessionAddress(ipAddr, port);
                this.rtpMgrs[i2].initialize(localAddr);
                this.rtpMgrs[i2].addTarget(destAddr);
                System.err.println("Created RTP session: " + this.ipAddress + " " + port);
                SendStream sendStream = this.rtpMgrs[i2].createSendStream(this.dataOutput, i2);
                sendStream.start();
            }
            catch (Exception e2) {
                return e2.getMessage();
            }
            ++i2;
        }
        return null;
    }

    Format checkForVideoSizes(Format original, Format supported) {
        int height;
        int width;
        Dimension size = ((VideoFormat)original).getSize();
        Format jpegFmt = new Format("jpeg/rtp");
        Format h263Fmt = new Format("h263/rtp");
        if (supported.matches(jpegFmt)) {
            width = size.width % 8 == 0 ? size.width : size.width / 8 * 8;
            height = size.height % 8 == 0 ? size.height : size.height / 8 * 8;
        } else if (supported.matches(h263Fmt)) {
            if (size.width < 128) {
                width = 128;
                height = 96;
            } else if (size.width < 176) {
                width = 176;
                height = 144;
            } else {
                width = 352;
                height = 288;
            }
        } else {
            return supported;
        }
        return new VideoFormat(null, new Dimension(width, height), -1, null, -1.0f).intersects(supported);
    }

    void setJPEGQuality(Player p, float val) {
        Control[] cs = p.getControls();
        QualityControl qc = null;
        VideoFormat jpegFmt = new VideoFormat("jpeg");
        int i2 = 0;
        while (i2 < cs.length) {
            if (cs[i2] instanceof QualityControl && cs[i2] instanceof Owned) {
                Object owner = ((Owned)((Object)cs[i2])).getOwner();
                if (owner instanceof Codec) {
                    Format[] fmts = ((Codec)owner).getSupportedOutputFormats(null);
                    int j2 = 0;
                    while (j2 < fmts.length) {
                        if (fmts[j2].matches(jpegFmt)) {
                            qc = (QualityControl)cs[i2];
                            qc.setQuality(val);
                            System.err.println("- Setting quality to " + val + " on " + qc);
                            break;
                        }
                        ++j2;
                    }
                }
                if (qc != null) break;
            }
            ++i2;
        }
    }

    Integer getStateLock() {
        return this.stateLock;
    }

    void setFailed() {
        this.failed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean waitForState(Processor p, int state) {
        p.addControllerListener(new StateListener());
        this.failed = false;
        if (state == 180) {
            p.configure();
        } else if (state == 300) {
            p.realize();
        }
        while (p.getState() < state && !this.failed) {
            Integer n2 = this.getStateLock();
            synchronized (n2) {
                try {
                    this.getStateLock().wait();
                }
                catch (InterruptedException ie) {
                    return false;
                }
            }
        }
        return !this.failed;
    }

    static void prUsage() {
        System.err.println("Usage: AVTransmit2 <sourceURL> <destIP> <destPortBase>");
        System.err.println("     <sourceURL>: input URL or file name");
        System.err.println("     <destIP>: multicast, broadcast or unicast IP address for the transmission");
        System.err.println("     <destPortBase>: network port numbers for the transmission.");
        System.err.println("                     The first track will use the destPortBase.");
        System.err.println("                     The next track will use destPortBase + 2 and so on.\n");
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            Transmitter.prUsage();
        }
        Format fmt = null;
        int i2 = 0;
        Transmitter at = new Transmitter(new MediaLocator(args[i2]), args[i2 + 1], args[i2 + 2], fmt);
        String result = at.start(null);
        at.getFormats();
        if (result != null) {
            System.err.println("Error : " + result);
            System.exit(0);
        }
        System.err.println("Start transmission...");
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.portBase;
    }

    public Format[] getFormats() {
        Format[] supported = null;
        String s = "";
        TrackControl[] tracks = this.processor.getTrackControls();
        int i2 = 0;
        while (i2 < tracks.length) {
            Format format = tracks[i2].getFormat();
            System.out.println("tracks[i].getFormat" + format.toString());
            System.out.println("--------------------");
            if (tracks[i2].isEnabled()) {
                supported = tracks[i2].getSupportedFormats();
                System.out.println("Supported formats: ");
                int j2 = 0;
                while (j2 < supported.length) {
                    System.out.println(supported[j2].toString());
                    ++j2;
                }
                System.out.println();
            }
            ++i2;
        }
        return supported;
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent) {
                Transmitter.this.setFailed();
            }
            if (ce instanceof ControllerEvent) {
                Integer n2 = Transmitter.this.getStateLock();
                synchronized (n2) {
                    Transmitter.this.getStateLock().notifyAll();
                }
            }
        }
    }
}

