/*
 * Decompiled with CFR 0.152.
 */
package rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.LinkedList;
import javax.media.Format;
import javax.media.MediaLocator;
import rmi.RMIServerI;
import rmi.SMRMISocket;
import rmi.Transmitter;

public class RMIServer
extends UnicastRemoteObject
implements RMIServerI {
    LinkedList<Transmitter> transmitters = new LinkedList();

    @Override
    public void startTransmission(int port, Format format) throws RemoteException {
        try {
            String clienthost = RemoteServer.getClientHost();
            InetAddress address = InetAddress.getByName(clienthost);
            Transmitter at = this.findTransmitter(address.getHostAddress());
            if (at != null) {
                at.stop();
                this.transmitters.remove(at);
                System.out.println("Removed the previous stream with IP Address " + at.getIPAddress() + " Port " + at.getPort());
            }
            System.out.println("The JMF port is " + port);
            System.out.println("Client IP address is " + address.getHostAddress());
            System.out.println("Transmit javasound://44100 to IP Address: " + address.getHostAddress() + " port: " + port);
            at = new Transmitter(new MediaLocator("javasound://44100"), address.getHostAddress(), "" + port, null);
            String result = at.start(format);
            if (result != null) {
                System.err.println("Error : " + result);
            }
            this.transmitters.add(at);
            System.err.println("Start transmission...");
        }
        catch (ServerNotActiveException e2) {
            e2.printStackTrace();
        }
        catch (UnknownHostException e3) {
            e3.printStackTrace();
        }
    }

    @Override
    public void stopTransmission() {
        try {
            String clienthost = RemoteServer.getClientHost();
            InetAddress address = InetAddress.getByName(clienthost);
            Transmitter at = this.findTransmitter(address.getHostAddress());
            at.stop();
            this.transmitters.remove(at);
            System.out.println("Removed " + at.getIPAddress() + " " + at.getPort());
        }
        catch (ServerNotActiveException e2) {
            e2.printStackTrace();
        }
        catch (UnknownHostException e3) {
            e3.printStackTrace();
        }
    }

    @Override
    public Format[] getFormats() {
        Object s = null;
        Format[] supported = null;
        try {
            String clienthost = RemoteServer.getClientHost();
            InetAddress address = InetAddress.getByName(clienthost);
            Transmitter at = this.findTransmitter(address.getHostAddress());
            supported = at.getFormats();
        }
        catch (ServerNotActiveException e2) {
            e2.printStackTrace();
        }
        catch (UnknownHostException e3) {
            e3.printStackTrace();
        }
        return supported;
    }

    public Transmitter findTransmitter(String address) {
        for (Transmitter at : this.transmitters) {
            if (!at.getIPAddress().equals(address)) continue;
            return at;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        RMIServer rmis = null;
        System.setProperty("java.rmi.server.hostname", "146.169.35.2");
        RMISocketFactory.setSocketFactory(new SMRMISocket());
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            rmis = new RMIServer();
            RMIServer.rebindServer("RMIServer", rmis);
        }
        catch (RemoteException e2) {
            e2.printStackTrace();
        }
        catch (MalformedURLException e3) {
            e3.printStackTrace();
        }
        System.out.println("Server Started.");
    }

    protected static void rebindServer(String serverURL, RMIServer server) throws RemoteException, MalformedURLException {
        Registry reg = null;
        try {
            reg = LocateRegistry.createRegistry(1099);
        }
        catch (RemoteException e2) {
            try {
                reg = LocateRegistry.getRegistry();
            }
            catch (IOException ex) {
                e2.printStackTrace();
            }
        }
        reg.rebind(serverURL, server);
    }
}

