/*
 * Decompiled with CFR 0.152.
 */
package rmi;

import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import rmi.RMIServerI;
import rmi.SMRMISocket;

public class RMIClient {
    public static void main(String[] args) throws IOException {
        RMIServerI iRMIServer = null;
        RMISocketFactory.setSocketFactory(new SMRMISocket());
        if (args.length < 1) {
            System.out.println("Needs 2 arguments: ServerHostName/IPAddress, port");
            System.exit(-1);
        }
        String urlServer = new String("rmi://" + args[0] + ":" + args[1] + "/RMIServer");
        System.out.println(urlServer);
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            Registry reg = null;
            reg = LocateRegistry.getRegistry("146.169.35.2", 55059);
            System.out.println("Begin Lookup");
            iRMIServer = (RMIServerI)reg.lookup("RMIServer");
            System.out.println("Finish Lookup");
            System.out.println("Bound to Server");
            iRMIServer.startTransmission(22223, null);
            try {
                System.out.println(iRMIServer.getFormats().toString());
                System.out.println("Changing format.....");
                iRMIServer.startTransmission(22222, iRMIServer.getFormats()[3]);
                Thread.sleep(5000L);
                iRMIServer.stopTransmission();
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            System.out.println("Done.");
        }
        catch (RemoteException e3) {
            e3.printStackTrace();
        }
        catch (NotBoundException e4) {
            e4.printStackTrace();
        }
    }
}

