/*
 * Decompiled with CFR 0.152.
 */
package legacy;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UDPClient {
    private DatagramSocket sendSoc;

    public static void main(String[] args) {
        InetAddress serverAddr = null;
        if (args.length < 3) {
            System.err.println("Arguments required: server name/IP, recv port, message count");
            System.exit(-1);
        }
        try {
            serverAddr = InetAddress.getByName(args[0]);
        }
        catch (UnknownHostException e2) {
            System.out.println("Bad server address in UDPClient, " + args[0] + " caused an unknown host exception " + e2);
            System.exit(-1);
        }
        int recvPort = Integer.parseInt(args[1]);
        int countTo = Integer.parseInt(args[2]);
        UDPClient client = new UDPClient();
        try {
            client.send(InetAddress.getLocalHost(), serverAddr, recvPort);
        }
        catch (UnknownHostException e3) {
            e3.printStackTrace();
        }
    }

    public UDPClient() {
        try {
            this.sendSoc = new DatagramSocket();
        }
        catch (SocketException e2) {
            System.out.println("Socket Exception:");
            e2.printStackTrace();
        }
    }

    private void send(InetAddress address, InetAddress destAddr, int destPort) {
        byte[] pktData = new byte[30];
        int payloadSize = pktData.length;
        DatagramPacket pkt = new DatagramPacket(pktData, payloadSize, destAddr, destPort);
        pkt.setData(address.toString().getBytes());
        try {
            this.sendSoc.send(pkt);
        }
        catch (IOException e2) {
            System.out.println("IO Exception:");
            e2.printStackTrace();
        }
    }
}

