<?php

  /**
   * Init tracking module
   *
   * @package activeCollab.modules.tracking
   */
  
  define('TRACKING_MODULE', 'tracking');
  define('TRACKING_MODULE_PATH', APPLICATION_PATH . '/modules/tracking');
  
  define('BILLABLE_STATUS_NOT_BILLABLE', 0);
  define('BILLABLE_STATUS_BILLABLE', 1);
  define('BILLABLE_STATUS_PENDING_PAYMENT', 2);
  define('BILLABLE_STATUS_PAID', 3);
  
  AngieApplication::useModel(array(
    'job_types', 
    'expense_categories', 
    'time_records', 
    'expenses', 
    'estimates', 
    'tracking_reports', 
  ), TRACKING_MODULE);
  
  AngieApplication::setForAutoload(array(
    'TrackingObject' => TRACKING_MODULE_PATH . '/models/tracking_objects/TrackingObject.class.php', 
    'TrackingObjects' => TRACKING_MODULE_PATH . '/models/tracking_objects/TrackingObjects.class.php',
   
    'ITrackingObjectActivityLogsImplementation' => TRACKING_MODULE_PATH . '/models/ITrackingObjectActivityLogsImplementation.class.php', 
    
    'ProjectTimesheet' => TRACKING_MODULE_PATH . '/models/ProjectTimesheet.class.php',
    
    'ITrackingImplementation' => TRACKING_MODULE_PATH . '/models/ITrackingImplementation.class.php',

    'TimeRecordCreatedActivityLogCallback' => TRACKING_MODULE_PATH . '/models/javascript_callbacks/TimeRecordCreatedActivityLogCallback.class.php',
    'ExpenseCreatedActivityLogCallback' => TRACKING_MODULE_PATH . '/models/javascript_callbacks/ExpenseCreatedActivityLogCallback.class.php',
  
  	'TrackingExporter' => TRACKING_MODULE_PATH . '/models/TrackingExporter.class.php', 
   
  	// Inspector
  	'ITrackingInspectorImplementation' => TRACKING_MODULE_PATH . '/models/ITrackingInspectorImplementation.class.php',
  	'TrackingInspectorWidget' => TRACKING_MODULE_PATH . '/models/TrackingInspectorWidget.class.php', 
  	'EstimateInspectorProperty' => TRACKING_MODULE_PATH . '/models/EstimateInspectorProperty.class.php', 
  	
  	// Homescreen widgets
  	'TrackingReportHomescreenWidget' => TRACKING_MODULE_PATH . '/models/homescreen_widgets/TrackingReportHomescreenWidget.class.php', 
  	'TrackedTimeHomescreenWidget' => TRACKING_MODULE_PATH . '/models/homescreen_widgets/TrackedTimeHomescreenWidget.class.php', 
  	'TrackedExpensesHomescreenWidget' => TRACKING_MODULE_PATH . '/models/homescreen_widgets/TrackedExpensesHomescreenWidget.class.php', 
  
    'IInvoiceBasedOnTrackingReportImplementation' => TRACKING_MODULE_PATH . '/models/IInvoiceBasedOnTrackingReportImplementation.class.php',
  ));
  
  DataObjectPool::registerTypeLoader('TimeRecord', function($ids) {
    return TimeRecords::findByIds($ids, STATE_TRASHED);
  });
  
  DataObjectPool::registerTypeLoader('Expense', function($ids) {
    return Expenses::findByIds($ids, STATE_TRASHED);
  });