/* Minified: jquery.objectEstimate.js, jquery.objectTime.js, jquery.objectTimeExpensesFlyout.js, jquery.selectEstimate.js, jquery.timeExpensesLog.js, jquery.timesheet.js, jquery.trackingReportResults.js, widgets.TrackingReports.js */
jQuery.fn.objectEstimate=function(s){var settings=jQuery.extend({value:0,comment:"",job_type_id:null,job_type_name:null,short_format:true,can_change:false,estimates_url:false,set_estimate_url:false},s);return this.each(function(){var wrapper=$(this).addClass("object_estimate");if(settings.estimates_url){var caption=settings.value>0?App.lang(":estimate of :job_type",{estimate:App.Wireframe.Utils.formatEstimate(settings.value),job_type:settings.job_type_name}):"0h";var value=$('<a href="'+App.extendUrl(settings.estimates_url,{async:1})+'" title="'+App.lang("Estimates Time")+'" estimated_time="'+settings.value+'">'+caption+"</a>").flyout({width:800}).appendTo(wrapper);if(settings.can_change){wrapper.append(" ");var change=$('<a href="'+App.extendUrl(settings.set_estimate_url,{async:1})+'" title="'+App.lang("Change Estimate")+'"><img src="'+App.Wireframe.Utils.imageUrl("icons/12x12/edit.png","environment")+'" alt="'+App.lang("Change")+'"></a>').appendTo(wrapper);change.flyoutForm({width:400,success:function(estimate){var parent=estimate.parent;if(parent){App.Wireframe.Events.trigger(parent.event_names.updated,parent)}if(typeof(estimate)=="object"&&estimate){var caption=estimate.value>0?App.lang(":estimate of :job_type",{estimate:App.Wireframe.Utils.formatEstimate(estimate.value),job_type:estimate.job_type["name"]}):"0h";value.text(caption).attr("estimated_time",estimate.value)}}})}}else{wrapper.append(App.Wireframe.Utils.formatEstimate(settings.value))}})};
(function($){var public_methods={init:function(options){return this.each(function(){var wrapper=$(this);var wrapper_dom=this;var item=options.object;var default_billable_status=typeof(options.default_billable_status)!="undefined"&&options.default_billable_status?1:0;var label_text=generate_label_string(item);if(options["interface"]=="printer"){wrapper.append('<span class="object_tracking_text">'+label_text+"</span> ");return true}if(options.show_label===undefined||options.show_label){wrapper.append('<span class="object_tracking_text">'+label_text+"</span> ")}var anchor=$('<a href="'+item.urls["tracking"]+'" title="'+label_text+'"><img src="'+get_icon_url(item)+'" alt="" /></a>').appendTo(wrapper);anchor.objectTimeExpensesFlyout(updated_callback_function,default_billable_status)})}};var updated_callback_function=function(time,expenses,formatted){var wrapper=$(this).parent();wrapper.find("a").attr("title",formatted);if(wrapper.find("span.object_tracking_text").length){wrapper.find("span.object_tracking_text").html(formatted)}if(time||expenses){wrapper.find("img").attr("src",App.Wireframe.Utils.imageUrl("icons/12x12/object-time-active.png","tracking"))}else{wrapper.find("img").attr("src",App.Wireframe.Utils.imageUrl("icons/12x12/object-time-inactive.png","tracking"))}};var generate_label_string=function(item){var time_string=false;if(item.object_time){time_string=App.lang("Time: :totalh",{totalh:item.object_time})}var expenses_string=false;if(item.object_expenses){expenses_string=App.lang("Expenses: :total",{total:item.object_expenses})}if(time_string&&expenses_string){return time_string+". "+expenses_string}else{if(time_string){return time_string}else{if(expenses_string){return expenses_string}}}return App.lang("No Time")};var get_icon_url=function(item){var estimated_time=0;if(typeof(item.estimate)=="object"&&item.estimate&&item.estimate["value"]){estimated_time=item.estimate["value"]}if(estimated_time>0&&item.object_time>estimated_time){return App.Wireframe.Utils.imageUrl("icons/12x12/object-time-alert.png","tracking")}else{if(item.object_time||item.object_expenses){return App.Wireframe.Utils.imageUrl("icons/12x12/object-time-active.png","tracking")}else{return App.Wireframe.Utils.imageUrl("icons/12x12/object-time-inactive.png","tracking")}}};var plugin_name="objectTime";$.fn[plugin_name]=function(method){if(public_methods[method]){return public_methods[method].apply(this,Array.prototype.slice.call(arguments,1))}else{if(typeof method==="object"||!method){return public_methods.init.apply(this,arguments)}else{$.error("Method "+method+" does not exist in jQuery."+plugin_name)}}}})(jQuery);
jQuery.fn.objectTimeExpensesFlyout=function(on_change,default_billable_status){return this.each(function(){$(this).click(function(){var link=$(this);var dialog=App.widgets.FlyoutDialog.show({title:App.lang("Time & Expenses"),data:link.attr("href"),data_type:"url",width:1000,success:function(){var wrapper=$(this);var billable_toggler=wrapper.find("tr.add_time_or_expense .billable_toggler");var billable_toggler_image=$("<img />").appendTo(billable_toggler);var billable_toggler_input=$('<input type="hidden" />').appendTo(billable_toggler);var billable_active_image=App.Wireframe.Utils.imageUrl("icons/16x16/billable-active.png","tracking");var billable_inactive_image=App.Wireframe.Utils.imageUrl("icons/16x16/billable-inactive.png","tracking");if(default_billable_status){billable_toggler_input.attr("value",1);billable_toggler_image.attr("src",billable_active_image)}else{billable_toggler_input.attr("value",0);billable_toggler_image.attr("src",billable_inactive_image)}billable_toggler_image.click(function(){if(billable_toggler_input.val()==1){billable_toggler_input.attr("value",0);billable_toggler_image.attr("src",billable_inactive_image)}else{billable_toggler_input.attr("value",1);billable_toggler_image.attr("src",billable_active_image)}});var tracking_type_toggler=wrapper.find("tr.add_time_or_expense .tracking_type_toggler");var tracking_type_timerecord=$("<img />").appendTo(tracking_type_toggler);var tracking_type_expense=$("<img />").appendTo(tracking_type_toggler);var tracking_type_input=$('<input type="hidden" />').appendTo(tracking_type_toggler);var tracking_timerecord_active_image=App.Wireframe.Utils.imageUrl("icons/16x16/time-record.png","tracking");var tracking_timerecord_inactive_image=App.Wireframe.Utils.imageUrl("icons/16x16/time-record-inactive.png","tracking");var tracking_expense_active_image=App.Wireframe.Utils.imageUrl("icons/16x16/expense.png","tracking");var tracking_expense_inactive_image=App.Wireframe.Utils.imageUrl("icons/16x16/expense-inactive.png","tracking");var tracking_timerecord_control=wrapper.find("tr.add_time_or_expense td.job_type .timerecord_control");var tracking_expense_control=wrapper.find("tr.add_time_or_expense td.job_type .expense_control");tracking_type_input.attr("value","time_record");tracking_type_timerecord.attr("src",tracking_timerecord_active_image);tracking_type_expense.attr("src",tracking_expense_inactive_image);tracking_timerecord_control.show();tracking_expense_control.hide();tracking_type_timerecord.click(function(){tracking_type_input.attr("value","time_record");tracking_type_timerecord.attr("src",tracking_timerecord_active_image);tracking_type_expense.attr("src",tracking_expense_inactive_image);tracking_timerecord_control.show();tracking_expense_control.hide()});tracking_type_expense.click(function(){tracking_type_input.attr("value","expense");tracking_type_timerecord.attr("src",tracking_timerecord_inactive_image);tracking_type_expense.attr("src",tracking_expense_active_image);tracking_timerecord_control.hide();tracking_expense_control.show()});var estimate_wrapper=wrapper.find("ul.object_tracking_totals li.object_tracking_totals_estimated_time span.value");var total_time_wrapper=wrapper.find("ul.object_tracking_totals li.object_tracking_totals_tracked_time span.value");var total_expenses_wrapper=wrapper.find("ul.object_tracking_totals li.object_tracking_totals_tracked_expenses span.value");var log_table=wrapper.find("table");var value_field=log_table.find("tr.add_time_or_expense td.value input").focus();var summary_field=log_table.find("tr.add_time_or_expense td.summary input");summary_field.width(summary_field.parent().width()-7);var dialog_update=function(trigger_change){var items=log_table.find("tbody tr.item");var total_time=0;var total_expenses=0;if(items.length>0){log_table.find("tbody tr.empty").hide();items.each(function(){var item=$(this);if(item.is("tr.time_record")){total_time+=App.parseNumeric(item.find("td.value").text())}else{total_expenses+=App.parseNumeric(item.find("td.value").text())}})}else{log_table.find("tbody tr.empty").show()}total_time_wrapper.text(App.numberFormat(total_time,2)+"h");total_expenses_wrapper.text(App.numberFormat(total_expenses,2));if(total_time){var time_string=App.lang("Time: :totalh",{total:total_time})}else{var time_string=false}if(total_expenses){var expenses_string=App.lang("Expenses: :total",{total:total_expenses})}else{var expenses_string=false}if(time_string&&expenses_string){var formatted=time_string+". "+expenses_string}else{if(time_string){var formatted=time_string}else{if(expenses_string){var formatted=expenses_string}else{var formatted=App.lang("No time")}}}if(trigger_change&&$.isFunction(on_change)){on_change.apply(link[0],[total_time,total_expenses,formatted])}};var init_row=function(row){row.find("td.options a.trash").asyncLink({confirmation:App.lang("Are you sure that you want to move this time record to the Trash?"),indicator_url:App.Wireframe.Utils.indicatorUrl(),success:function(response){App.Wireframe.Events.trigger(response.event_names.deleted,response);var message=row.is("tr.time_record")?App.lang("Time record has been successfully moved to Trash"):App.lang("Expense has been successfully moved to Trash");row.remove();dialog_update(true);App.Wireframe.Flash.success(message)},error:function(){App.Wireframe.Flash.error("Failed to move selected time record to the Trash. Please try again later")}})};log_table.find("tbody tr.item").each(function(){init_row($(this))});wrapper.find("form").submit(function(){var form=$(this);var user_select=log_table.find("tr.add_time_or_expense td.user select");if(user_select.length){var user_id=user_select.val()}else{var user_id=log_table.find("tr.add_time_or_expense td.user input[type=hidden]").attr("value")}var record_date=jQuery.trim(log_table.find("tr.add_time_or_expense td.record_date input").val());var value=jQuery.trim(value_field.val());if(value.indexOf(":")==-1){if(value){value=App.parseNumeric(value)}if(isNaN(value)||value<=0){App.Wireframe.Flash.error("Please insert a valid record value");value_field.val("").focus()}}if(user_id&&record_date&&value){form.find("input, select").attr("disabled","disabled");log_table.find("tr.add_time_or_expense td.options").find("button").hide();log_table.find("tr.add_time_or_expense td.options").append('<img src="'+App.Wireframe.Utils.indicatorUrl()+'" />');if(log_table.find("tr.add_time_or_expense td.type input").val()=="expense"){var type="expense";var add_url=wrapper.attr("add_expense_url");var icon_url=wrapper.attr("expense_icon_url");var verbose_name=App.lang("Expense")}else{var type="time_record";var add_url=wrapper.attr("add_time_url");var icon_url=wrapper.attr("time_icon_url");var verbose_name=App.lang("Time Record")}var data={submitted:"submitted"};data[type+"[value]"]=value;data[type+"[user_id]"]=user_id;if(type=="expense"){data[type+"[category_id]"]=log_table.find("tr.add_time_or_expense td.job_type select.expense_control").val()}else{data[type+"[job_type_id]"]=log_table.find("tr.add_time_or_expense td.job_type select.timerecord_control").val()}data[type+"[record_date]"]=record_date;data[type+"[summary]"]=summary_field.val();data[type+"[billable_status]"]=log_table.find("tr.add_time_or_expense td.status input").val();$.ajax({url:App.extendUrl(add_url,{async:1}),type:"post",data:data,success:function(response){App.Wireframe.Events.trigger(response.event_names.created,response);form.find("input, select").removeAttr("disabled");log_table.find("tr.add_time_or_expense td.options").find("img").remove();log_table.find("tr.add_time_or_expense td.options").find("button").show();if($.isPlainObject(response)){var new_row=$('<tr class="item '+type+'"><td class="type"><img src="'+icon_url+'" title="'+verbose_name+'" /></td><td class="user"></td><td class="job_type"> '+(response["class"].toLowerCase()=="timerecord"?response.job_type["name"].clean():response.category["name"].clean())+'</td><td class="record_date">'+response.record_date["formatted_date_gmt"]+'</td><td class="value right">'+response.value+(type=="time_record"?App.lang("h"):"")+'</td><td class="summary">'+response.summary.clean()+'</td><td class="status">'+(response.billable_status?App.lang("Billable"):App.lang("Not Billable"))+'</td><td class="options"><a href="'+response.urls["trash"]+'" title="'+App.lang("Move to Trash")+'" class="trash"><img src="'+App.Wireframe.Utils.imageUrl("/icons/12x12/move-to-trash.png","system")+'" alt="" /></a></td></tr>');App.Wireframe.Utils.userLink(response.user,true).appendTo(new_row.find("td.user"));log_table.find("tr.add_time_or_expense").after(new_row);init_row(new_row);new_row.find("td").highlightFade();form.find("td.value input, td.summary input").val("");value_field.focus();dialog_update(true)}else{if(type=="expense"){App.Wireframe.Flash.error(App.lang("Failed to log expense. Please try again later"))}else{App.Wireframe.Flash.error(App.lang("Failed to log time. Please try again later"))}value_field.focus()}},error:function(response){form.find("input, select").removeAttr("disabled");log_table.find("tr.add_time_or_expense td.options").find("img").remove();log_table.find("tr.add_time_or_expense td.options").find("button").show();if(type=="expense"){App.Wireframe.Flash.error(App.lang("Failed to log expense. Please try again later"))}else{App.Wireframe.Flash.error(App.lang("Failed to log time. Please try again later"))}value_field.focus()}})}else{if(user_id){if(record_date){value_field.focus()}else{log_table.find("tr.add_time_or_expense td.record_date input").focus()}}else{log_table.find("tr.add_time_or_expense td.user select").focus()}}return false});dialog_update(false)}});return false})})};
jQuery.fn.selectEstimate=function(s){var settings=jQuery.extend({name:"object[estimate]",value:0,optional:false,"short":false},s);return this.each(function(){var wrapper=$(this);var possibilities={"0.25":App.Wireframe.Utils.formatEstimate(0.25,settings["short"]),"0.5":App.Wireframe.Utils.formatEstimate(0.5,settings["short"]),"0.75":App.Wireframe.Utils.formatEstimate(0.75,settings["short"]),"1":App.Wireframe.Utils.formatEstimate(1,settings["short"]),"2":App.Wireframe.Utils.formatEstimate(2,settings["short"]),"3":App.Wireframe.Utils.formatEstimate(3,settings["short"]),"4":App.Wireframe.Utils.formatEstimate(4,settings["short"]),"5":App.Wireframe.Utils.formatEstimate(5,settings["short"]),"6":App.Wireframe.Utils.formatEstimate(6,settings["short"]),"7":App.Wireframe.Utils.formatEstimate(7,settings["short"]),"8":App.Wireframe.Utils.formatEstimate(8,settings["short"]),"16":App.Wireframe.Utils.formatEstimate(16,settings["short"]),"24":App.Wireframe.Utils.formatEstimate(24,settings["short"]),"32":App.Wireframe.Utils.formatEstimate(32,settings["short"]),"40":App.Wireframe.Utils.formatEstimate(40,settings["short"])};if(settings.optional){var options='<option value="">'+App.lang("None")+'</option><option value=""></option>'}else{var options=""}for(var i in possibilities){options+='<option value="'+i+'" class="estimate_value">'+possibilities[i].clean()+"</option>"}var value=settings.value;if(settings.value&&!possibilities[value]){options+='<option value=""></option><option value="'+value+'">'+App.lang(":hours hours",{hours:value})+"</option>"}options+='<option value=""></option><option value="other">'+App.lang("Other")+"</option>";var select=$('<select name="'+settings.name+'" class="select_estimate">'+options+"</select>").val(settings.value).appendTo(wrapper);if(settings["short"]){select.addClass("short")}select.change(function(){if(select.val()=="other"){var input=prompt(App.lang("Please insert estimate, in hours. Example: 0.25, 1, 8 etc"),"");if(input){var value=App.Wireframe.Utils.parseEstimate(input);if(value>=0){if(select.find('option[value="'+value+'"]').length==0){select.find("option.estimate_value:last").after('<option value="'+value+'" class="estimate_value">'+App.Wireframe.Utils.formatEstimate(value,settings["short"])+"</option>")}select.val(value)}else{select.val("")}}}})})};
(function($){var public_methods={init:function(options){return this.each(function(){var wrapper=$(this);var wrapper_dom=this;this.tel_data={settings:jQuery.extend({},options)};render_initial_wireframe.apply(this);handle_interaction.apply(this);handle_events.apply(this);batch_import.apply(this,[this.tel_data.settings.initial_data,this.tel_data.settings.parent_tasks])})}};var render_initial_wireframe=function(){var wrapper=$(this);var wrapper_dom=this;this.tel_data.table=$("<table></table>").appendTo(wrapper)};var batch_import=function(items,parent_tasks){var wrapper=$(this);var wrapper_dom=this;if(!items||!items.length){return false}$.each(items,function(index,item){var parent_task=typeof(parent_tasks)=="object"&&parent_tasks&&item.parent_type=="Task"&&typeof(parent_tasks[item.parent_id])=="object"?parent_tasks[item.parent_id]:null;add_item.apply(wrapper_dom,[item,parent_task])})};var add_item=function(item,parent_task){var item_type=item["class"].toLowerCase();var row=$('<tr class="item time_record" record_date="'+item.record_date["formatted_date_gmt"]+'" record_date_timestamp="'+item.record_date["timestamp"]+'" record_type="'+item["class"]+'" record_id="'+item.id+'"><td class="value"></td><td class="icon"><img src="" alt="" /></td><td class="user"></td><td class="description"></td><td class="status"></td><td class="options"></td></tr>');if(item_type=="timerecord"){row.find("td.icon img:first").attr({src:App.Wireframe.Utils.imageUrl("icons/16x16/time-record.png","tracking"),alt:App.lang("Time Record")});row.find("td.value").append(App.hoursFormat(item.value))}else{if(item_type=="expense"){row.find("td.icon img:first").attr({src:App.Wireframe.Utils.imageUrl("icons/16x16/expense.png","tracking"),alt:App.lang("Expense")});row.find("td.value").append(App.moneyFormat(item.value,this.tel_data.settings.currency_code))}}App.Wireframe.Utils.userLink(item.user,true).appendTo(row.find("td.user"));var parent_task_text=parent_task?'<a href="'+parent_task.url.clean()+'" class="quick_view_item">#'+parent_task.task_id+": "+parent_task.name.clean()+"</a>":"";var summary_text=item.summary?item.summary.clean():"";if(parent_task&&parent_task.is_completed){row.find("td.description").addClass("completed")}if(parent_task_text&&summary_text){row.find("td.description").append(parent_task_text+" &mdash; "+summary_text)}else{if(parent_task_text){row.find("td.description").append(parent_task_text)}else{if(summary_text){row.find("td.description").append(summary_text)}}}switch(item.billable_status){case 1:var verbose_billable_status=App.lang("Billable");break;case 2:var verbose_billable_status=App.lang("Pending Payment");break;case 3:var verbose_billable_status=App.lang("Paid");break;default:var verbose_billable_status=App.lang("Not Billable");break}row.find("td.status").text(verbose_billable_status);if(item.permissions["can_edit"]){$('<a><img src="'+App.Wireframe.Utils.imageUrl("/icons/12x12/edit.png","environment")+'" /></a>').attr("href",item.urls["edit"]).addClass("edit").appendTo(row.find("td.options"))}if(item.permissions["can_trash"]){row.find("td.options").append(" ");$('<a><img src="'+App.Wireframe.Utils.imageUrl("/icons/12x12/move-to-trash.png","system")+'" /></a>').attr("href",item.urls["trash"]).addClass("trash").appendTo(row.find("td.options"))}find_day_table.apply(this,[item.record_date]).find("tbody").prepend(row)};var find_day_table=function(date){var wrapper=$(this);var wrapper_dom=this;var day_table=wrapper.find("table[date_timestamp="+date.timestamp+"]");if(day_table.length){return day_table}var day_table=$('<table class="common date_wrapper" cellspacing="0" date_timestamp="'+date.timestamp+'"><thead><tr><td colspan="6" class="date">'+date.formatted_date_gmt+"</td></tr></thead><tbody></tbody>");var date_table_added=false;wrapper.find("table.date_wrapper").each(function(){if(parseInt($(this).attr("date_timestamp"))<date.timestamp){wrapper.prepend(day_table);date_table_added=true;return false}});if(!date_table_added){wrapper.append(day_table)}return day_table};var create_working_row=function(){return $('<tr class="working_row"><td colspan="5"><img src="'+App.Wireframe.Utils.indicatorUrl("small")+'" alt="" /> '+App.lang("Working")+"</td></tr>")};var init_item_form_row=function(row,on_valid,on_success,on_error,on_cancel){var form=row.find("form");var summary_field=form.find("div.subtask_summary input[type=text]");form.find("input").keydown(function(e){if(e.keyCode==27){on_cancel.apply(form[0])}});form.find("a.item_form_cancel").click(function(){on_cancel.apply(form[0]);return false});form.submit(function(){if(row.is("tr.time_record_form")){var data={"time_record[user_id]":form.find("div.time_record_user select").val(),"time_record[value]":jQuery.trim(form.find("div.time_record_value input").val()),"time_record[job_type_id]":form.find("div.time_record_value select").val(),"time_record[record_date]":jQuery.trim(form.find("div.time_record_date input").val()),"time_record[summary]":jQuery.trim(form.find("div.time_record_summary input").val()),"time_record[billable_status]":form.find("div.time_record_billable select").val(),submitted:"submitted"};if(data["time_record[value]"]==""){form.find("div.time_record_value input").focus();return false}if(data["time_record[record_date]"]==""){form.find("div.time_record_date input").focus();return false}}else{var data={"expense[user_id]":form.find("div.expense_user select").val(),"expense[value]":jQuery.trim(form.find("div.expense_value input").val()),"expense[category_id]":jQuery.trim(form.find("div.expense_value select").val()),"expense[record_date]":jQuery.trim(form.find("div.expense_date input").val()),"expense[summary]":jQuery.trim(form.find("div.expense_summary input").val()),"expense[billable_status]":form.find("div.expense_billable select").val(),submitted:"submitted"};if(data["expense[value]"]==""){form.find("div.expense_value input").focus();return false}if(data["expense[record_date]"]==""){form.find("div.expense_date input").focus();return false}}on_valid();$.ajax({url:App.extendUrl(form.attr("action"),{async:1}),type:"post",data:data,success:function(response){on_success(response)},error:function(response){on_error(response)}});return false})};var show_item_form=function(form){form.show("fast",function(){var attributes_width=0;form.find("div.item_attribute").each(function(){if(!$(this).is("div.item_summary_wrapper")){attributes_width+=$(this).width()}});form.find("div.item_summary_wrapper input").width(form.width()-attributes_width-56);form.find("div.item_value_wrapper input").focus()})};var update_tables=function(){var wrapper=$(this);var wrapper_dom=this;wrapper.find("table.date_wrapper").each(function(){var date_wrapper=$(this);if(date_wrapper.find("tr.item").length<1){date_wrapper.remove()}})};var handle_interaction=function(){var wrapper=$(this);var wrapper_dom=this;wrapper.delegate("td.options a.edit","click",function(event){var link=$(this);var row=link.parents("tr:first");var working_row=create_working_row();row.hide().after(working_row);$.ajax({url:App.extendUrl(link.attr("href"),{async:1}),type:"get",success:function(response){var edit_row=$(response);working_row.after(edit_row).remove();init_item_form_row(edit_row,function(){edit_row.remove();working_row=create_working_row();row.after(working_row)},function(record){working_row.remove();var date_timestamp=parseInt(row.attr("record_date_timestamp"));var current_date_wrapper=row.parent().parent();row.attr({record_date:record.record_date["formatted_date_gmt"],record_date_timestamp:record.record_date["timestamp"]});App.Wireframe.Utils.userLink(record.user,true).appendTo(row.find("td.user").empty());if(record["class"]=="Expense"){row.find("td.value").empty().text(App.moneyFormat(record.value,record.currency["code"]))}else{row.find("td.value").empty().text(App.hoursFormat(record.value))}if(typeof(record.parent)=="object"&&record.parent&&record.parent["class"]=="Task"){var parent_task_text='<a href="'+record.parent["urls"]["view"].clean()+'">#'+record.parent["task_id"]+": "+record.parent["name"].clean()+"</a>"}else{var parent_task_text=""}var summary_text=record.summary?record.summary.clean():"";if(parent_task_text&&summary_text){row.find("td.description").empty().append(parent_task_text+" &mdash; "+summary_text)}else{if(parent_task_text){row.find("td.description").empty().append(parent_task_text)}else{if(summary_text){row.find("td.description").empty().append(summary_text)}}}row.find("td.status").empty().text(record.billable_status_verbose);var new_date_timestamp=parseInt(row.attr("record_date_timestamp"));if(date_timestamp!=current_date_wrapper.attr("date_timestamp")){var new_date_wrapper=wrapper.find("table[date_timestamp="+new_date_timestamp+"]");if(new_date_wrapper.length==0){new_date_wrapper=create_date_table(row.attr("record_date"),new_date_timestamp)}new_date_wrapper.find("tbody").prepend(row);update_tables.apply(wrapper_dom)}row.show().find("td").highlightFade();if(record["class"]=="Expense"){App.Wireframe.Content.trigger("project_expense_updated",[record])}else{App.Wireframe.Content.trigger("project_time_updated",[record])}},function(response){working_row.remove();row.show();App.Wireframe.Flash.error("Failed to submit changes. Please try again later")},function(){edit_row.remove();row.show()})},error:function(response){working_row.remove();row.show();App.Wireframe.Flash.error("Failed to load edit form. Please try again later")}});return false});wrapper.delegate("td.options a.trash","click",function(event){if(!confirm(App.lang("Are you sure that you want to move selected item to Trash?"))){return false}var anchor=$(this);var image=anchor.find("img:first");var original_image=image.attr("src");image.attr("src",App.Wireframe.Utils.indicatorUrl("small"));$.ajax({type:"post",url:App.extendUrl(anchor.attr("href"),{async:1}),success:function(){image.attr("src",original_image);anchor.parents("tr:first").remove();update_tables.apply(wrapper_dom);App.Wireframe.Flash.success("Item has been successfully moved to Trash")},error:function(){image.attr("src",original_image);App.Wireframe.Flash.error("Failed to move item to Trash. Please try again later")}});return false})};var handle_events=function(){var wrapper=$(this);var wrapper_dom=this;App.Wireframe.Content.bind("time_record_created.content",function(event,time_record){if(wrapper_dom.tel_data.settings.project_id!=time_record.project.id){return false}add_item.apply(wrapper_dom,[time_record]);if(time_record.value==1){App.Wireframe.Flash.success("One hour added")}else{App.Wireframe.Flash.success(":num hours added",{num:time_record.value})}});App.Wireframe.Content.bind("time_record_updated.content",function(event,time_record){if(wrapper_dom.tel_data.settings.project_id!=time_record.project.id){return false}if(wrapper.find('tr[record_id="'+time_record.id+'"][record_type="'+time_record["class"]+'"]').length){return false}add_item.apply(wrapper_dom,[time_record])});App.Wireframe.Content.bind("expense_created.content",function(event,expense){if(wrapper_dom.tel_data.settings.project_id!=expense.project.id){return false}add_item.apply(wrapper_dom,[expense]);App.Wireframe.Flash.success("Expense has been successfully logged")});App.Wireframe.Content.bind("expense_updated.content",function(event,expense){if(wrapper_dom.tel_data.settings.project_id!=expense.project.id){return false}if(wrapper.find('tr[record_id="'+expense.id+'"][record_type="'+expense["class"]+'"]').length){return false}add_item.apply(wrapper_dom,[expense])})};var plugin_name="timeExpensesLog";$.fn[plugin_name]=function(method){if(public_methods[method]){return public_methods[method].apply(this,Array.prototype.slice.call(arguments,1))}else{if(typeof method==="object"||!method){return public_methods.init.apply(this,arguments)}else{$.error("Method "+method+" does not exist in jQuery."+plugin_name)}}}})(jQuery);
(function($){var public_methods={init:function(options){return this.each(function(){var wrapper=$(this);var wrapper_dom=this;this.tim_data={settings:jQuery.extend({},options)};initialize.apply(this);handle_interaction.apply(this)})}};var initialize=function(){var wrapper=$(this);var wrapper_dom=this;this.tim_data.timesheet=wrapper.find("div.timesheet");this.tim_data.timesheet_wrapper=wrapper.find("div.timesheet_records_wrapper");this.tim_data.table=wrapper.find(".timesheet_records_wrapper table:first");this.tim_data.users_table=wrapper.find(".timesheet_users table:first");this.tim_data.day_details_url=this.tim_data.timesheet.attr("day_details_url");this.tim_data.table.css("width",26*this.tim_data.table.find("tr.timerecords:first td").length);this.tim_data.timesheet_wrapper.scrollTo(this.tim_data.table.find('thead td[day="'+Date.today().toString("yyyy-MM-dd")+'"]'),500,{axis:"x"})};var handle_interaction=function(){var wrapper=$(this);var wrapper_dom=this;this.tim_data.table.delegate("td.day","click",function(event){var cell=$(this);var link=cell.find("span");var row=cell.parents("tr:first");var dialog=App.widgets.FlyoutDialog.show({title:App.lang("Time Log"),data:App.extendUrl(wrapper_dom.tim_data.day_details_url,{user_id:row.attr("user_id"),day:cell.attr("day")}),data_type:"url",width:1000,success:function(){var dialog_content=$(this);var dialog_table=dialog_content.find("table");var value_field=dialog_content.find("#time_day_log_add td.value input");var dialog_init_row=function(row){row.find("td.options a.trash").asyncLink({confirmation:App.lang("Are you sure that you want to move this time record to the Trash?"),indicator_url:App.Wireframe.Utils.indicatorUrl(),success:function(){row.remove();if(dialog_table.find("tr.timesheet_day_log_entry").length==0){dialog_table.find("#timesheet_day_log_empty").show()}dialog_update();App.Wireframe.Flash.success("Time record has been successfully moved to Trash")},error:function(){App.Wireframe.Flash.error("Failed to move selected time record to the Trash. Please try again later")}})};var dialog_update=function(){var counter=1;var total_time=0;dialog_table.find("tr.timesheet_day_log_entry").each(function(){var row=$(this);row.removeClass("odd").removeClass("even").addClass((counter%2?"odd":"even"));total_time+=App.parseNumeric(row.find("td.value").text());counter++});if(total_time){cell.removeClass("no_time");link.text(total_time)}else{cell.addClass("no_time");link.text("")}if(total_time==1){dialog_table.find("tfoot td.value").text(App.lang("Total: 1 hour"))}else{dialog_table.find("tfoot td.value").text(App.lang("Total: :num hours",{num:total_time}))}};if(value_field.length>0){value_field.focus()}dialog_content.find("#timesheet_day_log #time_day_log_add td.summary input").each(function(){var input=$(this);input.width(input.parent().width()-7)});dialog_table.find("tr.timesheet_day_log_entry").each(function(){dialog_init_row($(this))});dialog_update();dialog_content.find("#time_day_log_add_form").submit(function(){var form=$(this);var value=jQuery.trim(value_field.val());if(value==""||value==0||!value){value_field.focus()}else{var data={"time_record[value]":value,"time_record[job_type_id]":dialog_content.find("#time_day_log_add td.value select").val(),"time_record[user_id]":dialog_content.attr("user_id"),"time_record[record_date]":dialog_content.attr("day"),"time_record[summary]":dialog_content.find("#time_day_log_add td.summary input").val(),"time_record[billable_status]":dialog_content.find("#time_day_log_add td.status select").val(),submitted:"submitted"};form.find("input, select").attr("disabled","disabled");dialog_content.find("#time_day_log_add td.options").find("button").hide();dialog_content.find("#time_day_log_add td.options").append('<img src="'+App.Wireframe.Utils.indicatorUrl()+'" />');$.ajax({url:App.extendUrl(form.attr("action"),{async:1}),type:"post",data:data,success:function(response){form.find("input, select").removeAttr("disabled");dialog_content.find("#time_day_log_add td.options").find("img").remove();dialog_content.find("#time_day_log_add td.options").find("button").show();if($.isPlainObject(response)){var new_row=$('<tr class="timesheet_day_log_entry"><td class="created_on">'+App.lang("Today")+'</td><td class="value right">'+response.value+'</td><td class="summary">'+response.summary.clean()+'</td><td class="status">'+(response.billable_status?App.lang("Billable"):App.lang("Not Billable"))+'</td><td class="options"><a href="'+response.urls["trash"]+'" title="'+App.lang("Move to Trash")+'" class="trash"><img src="'+App.Wireframe.Utils.imageUrl("/icons/12x12/move-to-trash.png","system")+'" alt="" /></a></td></tr>');dialog_table.find("#time_day_log_add").after(new_row);dialog_table.find("#timesheet_day_log_empty").hide();new_row.find("td").highlightFade();form.find("input").val("");value_field.focus();dialog_update()}else{App.Wireframe.Flash.error(App.lang("Failed to log time. Please try again later"));value_field.focus()}},error:function(response){form.find("input, select").removeAttr("disabled");dialog_content.find("#time_day_log_add td.options").find("img").remove();dialog_content.find("#time_day_log_add td.options").find("button").show();App.Wireframe.Flash.error(App.lang("Failed to log time. Please try again later"));value_field.focus()}})}return false})}})})};var plugin_name="timesheet";$.fn[plugin_name]=function(method){if(public_methods[method]){return public_methods[method].apply(this,Array.prototype.slice.call(arguments,1))}else{if(typeof method==="object"||!method){return public_methods.init.apply(this,arguments)}else{$.error("Method "+method+" does not exist in jQuery."+plugin_name)}}}})(jQuery);
jQuery.fn.trackingReportResults=function(s){var settings=jQuery.extend({records:null,currencies:null,show_user_column:true,sum_by_user:false,group_by:"dont",show_time:true,show_expenses:true,show_no_records_message:false,no_records_message:App.lang("No tracked records to show")},s);return this.each(function(){var wrapper=$(this).addClass("tracking_report_result");if(jQuery.isArray(settings.records)||(typeof(settings.records)=="object"&&settings.records)){if(settings.sum_by_user){for(var group_id in settings.records){if(typeof(settings.records[group_id]["records"])=="object"&&!jQuery.isEmptyObject(settings.records[group_id]["records"])){var group_label=typeof(settings.records[group_id]["label"])=="string"?settings.records[group_id]["label"]:"--";var group_wrapper=$('<div class="tracking_report_result_group_wrapper"><p>'+group_label.clean()+'</p><div class="tracking_report_result_group_inner_wrapper"></div></div>').appendTo(wrapper);var group_table=$('<table class="common auto summarized" cellspacing="0"><thead><tr><th class="user">'+App.lang("User")+'</th></tr></thead><tbody></tbody><tfoot><tr><td class="total">'+App.lang("Total")+":</td></tr></tfoot></table>").appendTo(group_wrapper.find("div.tracking_report_result_group_inner_wrapper"));if(settings.show_time||settings.show_expenses){var header=group_table.find("thead tr");var footer=group_table.find("tfoot tr");if(settings.show_time){header.append('<th class="time right">'+App.lang("Time")+"</th>");footer.append('<td class="time right"></td>')}if(settings.show_expenses){for(var currency_id in settings.currencies){header.append('<th class="expenses center" currency_id="'+currency_id+'">'+App.lang("Expenses (:currency_code)",{currency_code:settings.currencies[currency_id]["code"]})+"</th>");footer.append('<td class="expenses center" currency_id="'+currency_id+'"></td>')}}}var group_table_body=group_table.find("tbody");var total_time=0;var total_expenses={};if(settings.show_expenses){for(var currency_id in settings.currencies){total_expenses[currency_id]=0}}for(var user_email in settings.records[group_id]["records"]){if(settings.show_time){total_time+=settings.records[group_id]["records"][user_email]["time"]}var row='<tr class="record summarized" user_id="'+settings.records[group_id]["records"][user_email]["user_id"]+'" user_email="'+user_email.clean()+'">';row+='<td class="user">'+settings.records[group_id]["records"][user_email]["user_name"].clean()+"</td>";if(settings.show_time){row+='<td class="time right">'+App.hoursFormat(settings.records[group_id]["records"][user_email]["time"])+"</td>"}if(settings.show_expenses){for(var currency_id in settings.currencies){var expenses_for_currency=settings.records[group_id]["records"][user_email]["expenses_for_"+currency_id];row+='<td class="expenses center" currency_id="'+currency_id+'">'+App.moneyFormat(expenses_for_currency)+"</td>";total_expenses[currency_id]+=expenses_for_currency}}group_table_body.append(row+"</tr>")}if(group_table_body.find("tr.record").length>0){if(settings.show_time){footer.find("td.time").text(App.hoursFormat(total_time))}if(settings.show_expenses){for(var currency_id in settings.currencies){footer.find("td.expenses[currency_id="+currency_id+"]").text(App.moneyFormat(total_expenses[currency_id]))}}}else{group_table.find("tfoot").remove()}}}}else{var render_date=function(record){return typeof(record.record_date)=="object"&&record.record_date?record.record_date["formatted_date_gmt"].clean():"--"};var render_user=function(record){return typeof(record.user_name)=="string"&&record.user_name?record.user_name:record.user_email};var render_value=function(record){if(record.type=="TimeRecord"){if(typeof(record.group_name)!="undefined"&&record.group_name){return App.lang(":hours of :job_type",{hours:App.hoursFormat(record.value),job_type:record.group_name})}else{return App.hoursFormat(record.value)}}else{var currency_id=typeof(record.currency_id)!="undefined"?record.currency_id:0;if(currency_id&&typeof(settings.currencies[currency_id])=="object"){var currency_code=settings.currencies[currency_id]["code"]}else{var currency_code=""}if(typeof(record.group_name)!="undefined"&&record.group_name){return App.lang(":amount in :category",{amount:currency_code.clean()+" "+App.moneyFormat(record.value),category:record.group_name})}else{return currency_code.clean()+App.moneyFormat(record.value)}}};var render_summary=function(record){if(record.parent_type=="Task"&&record.parent_name&&record.parent_url){var parent_text='<a href="'+record.parent_url.clean()+'" class="quick_view_item">'+record.parent_name.clean()+"</a>"}else{var parent_text=""}if(typeof(record.summary)=="string"&&record.summary){var summary_text=record.summary.clean()}else{var summary_text=""}if(parent_text&&summary_text){return parent_text+" ("+summary_text+")"}else{if(parent_text){return parent_text}else{if(summary_text){return summary_text}else{return""}}}};var render_status=function(record){switch(record.billable_status){case 0:return App.lang("Not Billable");case 1:return App.lang("Billable");case 2:return App.lang("Pending Payment");case 3:return App.lang("Paid");default:return App.lang("Unknown Status")}};var render_project=function(record){return typeof(record.project_name)=="string"&&record.project_name&&typeof(record.project_url)=="string"&&record.project_url?'<a href="'+record.project_url.clean()+'" class="quick_view_item">'+record.project_name.clean()+"</a>":App.lang("Unknown Project")};for(var group_id in settings.records){if(jQuery.isArray(settings.records[group_id]["records"])&&settings.records[group_id]["records"].length){var group_label=typeof(settings.records[group_id]["label"])=="string"?settings.records[group_id]["label"]:"--";var group_wrapper=$('<div class="tracking_report_result_group_wrapper"><p>'+group_label.clean()+'</p><div class="tracking_report_result_group_inner_wrapper"></div></div>').appendTo(wrapper);var group_table=$('<table class="common records_list" cellspacing="0"><thead></thead><tbody></tbody></table>').appendTo(group_wrapper.find("div.tracking_report_result_group_inner_wrapper"));var group_table_head=group_table.find("thead");var group_table_body=group_table.find("tbody");switch(settings.group_by){case"date":group_table_head.append('<tr><th class="value">'+App.lang("Value")+"</th>"+(settings.show_user_column?'<th class="user">'+App.lang("User")+"</th>":"")+'<th class="summary">'+App.lang("Summary")+'</th><th class="status center">'+App.lang("Status")+'</th><th class="project right">'+App.lang("Project")+"</th></tr>");var columns_count=settings.show_user_column?5:4;break;case"project":group_table_head.append('<tr><th class="date left">'+App.lang("Date")+'</th><th class="value">'+App.lang("Value")+"</th>"+(settings.show_user_column?'<th class="user">'+App.lang("User")+"</th>":"")+'<th class="summary">'+App.lang("Summary")+'</th><th class="status center">'+App.lang("Status")+"</th></tr>");var columns_count=settings.show_user_column?5:4;break;default:group_table_head.append('<tr><th class="date left">'+App.lang("Date")+'</th><th class="value">'+App.lang("Value")+"</th>"+(settings.show_user_column?'<th class="user">'+App.lang("User")+"</th>":"")+'<th class="summary">'+App.lang("Summary")+'</th><th class="status center">'+App.lang("Status")+'</th><th class="project right">'+App.lang("Project")+"</th></tr>");var columns_count=settings.show_user_column?6:5;break}var total_time=0;var total_expenses={};App.each(settings.records[group_id]["records"],function(record_id,record){if(record.type=="TimeRecord"){var record_type="time_record";total_time+=record.value}else{var record_type="expense";var currency_id=record.currency_id;if(typeof(total_expenses[currency_id])=="undefined"){total_expenses[currency_id]=0}total_expenses[currency_id]+=record.value}var row='<tr class="record '+record_type+'" record_id="'+record_id+'" user_id="'+record.user_id+'" currency_id="'+record.currency_id+'">';switch(settings.group_by){case"date":row+='<td class="value">'+render_value(record)+"</td>";if(settings.show_user_column){row+='<td class="user">'+render_user(record)+"</td>"}row+='<td class="summary">'+render_summary(record)+"</td>";row+='<td class="status center">'+render_status(record)+"</td>";row+='<td class="project right">'+render_project(record)+"</td>";break;case"project":row+='<td class="date left">'+render_date(record)+"</td>";row+='<td class="value">'+render_value(record)+"</td>";if(settings.show_user_column){row+='<td class="user">'+render_user(record)+"</td>"}row+='<td class="summary">'+render_summary(record)+"</td>";row+='<td class="status center">'+render_status(record)+"</td>";break;default:row+='<td class="date left">'+render_date(record)+"</td>";row+='<td class="value">'+render_value(record)+"</td>";if(settings.show_user_column){row+='<td class="user">'+render_user(record)+"</td>"}row+='<td class="summary">'+render_summary(record)+"</td>";row+='<td class="status center">'+render_status(record)+"</td>";row+='<td class="project right">'+render_project(record)+"</td>";break}group_table_body.append(row+"</tr>")});var total_time_string=App.lang("Total Time: :time",{time:App.hoursFormat(total_time)});var total_expenses_by_currency=[];for(var currency_id in total_expenses){if(currency_id&&typeof(settings.currencies[currency_id])=="object"){var currency_code=settings.currencies[currency_id]["code"]}else{var currency_code=""}total_expenses_by_currency.push(currency_code.clean()+" "+total_expenses[currency_id])}if(total_expenses_by_currency.length<1){var total_expenses_string=App.lang("Total Expenses: :expenses",{expenses:0})}else{var total_expenses_string=App.lang("Total Expenses: :expenses",{expenses:total_expenses_by_currency.join(", ")})}if(settings.show_time&&settings.show_expenses){var totals=total_time_string.clean()+". "+total_expenses_string.clean()}else{if(settings.show_time){var totals=total_time_string.clean()}else{if(settings.show_expenses){var totals=total_expenses_string.clean()}else{var totals=""}}}group_table_body.after('<tfoot><tr><td colspan="'+columns_count+'" class="center">'+totals+"</td></tr></tfoot>")}}}}else{if(settings.show_no_records_message&&typeof(settings.no_records_message)=="string"){wrapper.append('<p class="empty_page">'+settings.no_records_message.clean()+"</p>")}}})};
App.widgets.TrackingReports=function(){var wrapper;var result_wrapper;var edit_report_button;var delete_report_button;var saved_reports={};var companies;var users;var project_categories;var set_user_filter=function(user_filter,params){var row=$("#tracking_report_user_filter");row.find("td.report_select_select select").val(user_filter);if(user_filter=="company"){prepare_select_company("report[company_id]",(typeof(params)=="object"&&params.company_id?params.company_id:0)).appendTo(row.find("td.report_select_data"))}else{if(user_filter=="selected"){prepare_select_users("report[user_ids]",(typeof(params)=="object"&&params.user_ids?params.user_ids:[])).appendTo(row.find("td.report_select_data"))}}};var set_date_filter=function(date_filter,params){var row=$("#tracking_report_date_filter");row.find("td.report_select_select select").val(date_filter);if(date_filter=="selected_date"){prepare_select_date("report[date_on]",(typeof(params)=="object"&&params.date_on?params.date_on:new Date())).appendTo(row.find("td.report_select_data"))}else{if(date_filter=="selected_range"){if(typeof(params)=="object"){var date_from=params.date_from?params.date_from:new Date();var date_to=params.date_to?params.date_to:new Date()}else{var date_from=date_to=new Date()}prepare_select_date_range("report[date_from]","report[date_to]",date_from,date_to).appendTo(row.find("td.report_select_data"))}}};var set_project_filter=function(project_filter,params){var row=$("#tracking_report_project_filter");row.find("td.report_select_select select").val(project_filter);if(project_filter=="category"){prepare_select_project_category("report[project_category_id]",(typeof(params)=="object"&&params.project_category_id?params.project_category_id:0)).appendTo(row.find("td.report_select_data"))}else{if(project_filter=="client"){prepare_select_company("report[project_client_id]",(typeof(params)=="object"&&params.project_client_id?params.project_client_id:0)).appendTo(row.find("td.report_select_data"))}else{if(project_filter=="selected"){prepare_select_projects("report[project_ids]",(typeof(params)=="object"&&params.project_ids?params.project_ids:{})).appendTo(row.find("td.report_select_data"))}}}};var prepare_select_company=function(name,selected_company_id){var select=$('<select name="'+name+'"></select>');for(var company_id in companies){$("<option></option>").attr({value:company_id,selected:company_id==selected_company_id?"selected":""}).text(companies[company_id].clean()).appendTo(select)}return select};var prepare_select_users=function(name,selected_user_ids){var select=$('<div class="tracking_report_select_users"></div>');for(var company_name in users){var company_wrapper=$('<div class="tracking_report_select_users_company"><div class="company_name">'+company_name.clean()+'</div><div class="company_users"></div></div>').appendTo(select);var company_users_wrapper=company_wrapper.find("div.company_users");for(var user_id in users[company_name]){var id="tracking_report_user_filter_data_select_user_"+user_id;var company_user=$('<div class="company_user"><input type="checkbox" name="'+name+'[]" value="'+user_id+'" id="'+id+'" /> <label for="'+id+'">'+users[company_name][user_id].clean()+"</label></div>").appendTo(company_users_wrapper);if(jQuery.isArray(selected_user_ids)&&selected_user_ids.indexOf(parseInt(user_id))>=0){company_user.find("input[type=checkbox]")[0].checked=true}}}return select};var prepare_select_project_category=function(name,selected_category_id){var select=$('<select name="'+name+'"></select>');for(var project_category_id in project_categories){$("<option></option>").attr({value:project_category_id,selected:project_category_id==selected_category_id?"selected":""}).text(project_categories[project_category_id].clean()).appendTo(select)}return select};var prepare_select_projects=function(name,selected_project_ids){var select=$('<div class="tracking_report_select_projects"></div>');for(var project_id in projects){var id="tracking_report_project_filter_data_select_project_"+project_id;var project=$('<div class="project"><input type="checkbox" name="'+name+'[]" value="'+project_id+'" id="'+id+'" /> <label for="'+id+'">'+projects[project_id].clean()+"</label></div>").appendTo(select);if(jQuery.isArray(selected_project_ids)&&selected_project_ids.indexOf(parseInt(project_id))>=0){projecet.find("input[type=checkbox]")[0].checked=true}}return select};var prepare_select_date=function(name,value){var select=$('<div class="select_date"><input name="'+name+'" value="'+value.toString("yyyy/mm/dd")+'" /></div>');select.find("input").datepicker({dateFormat:"yy/mm/dd",minDate:new Date("2000/01/01"),maxDate:new Date("2050/01/01"),showAnim:"blind",duration:0,changeYear:true,showOn:"both",buttonImage:App.Wireframe.Utils.imageUrl("icons/16x16/calendar.png","tracking"),buttonImageOnly:true,buttonText:App.lang("Select Date"),firstDay:App.Config.get("first_week_day"),hideIfNoPrevNext:true,defaultDate:value?new Date(value):new Date()});return select};var prepare_select_date_range=function(name_from,name_to,range_from,range_to){var select=$('<date class="select_date_range"><div>');prepare_select_date(name_from,range_from).appendTo(select);select.append(" - ");prepare_select_date(name_to,range_to).appendTo(select);return select};var selected_report_id=0;var select_report=function(report_id){if(selected_report_id==report_id){return}if(report_id>0){var report=saved_reports[report_id];if(typeof(report)!="object"){App.Wireframe.Flash.error("Unknown tracking report")}selected_report_id=report_id;edit_report_button.show().text(App.lang("Update"));delete_report_button.show();switch(report.user_filter){case"company":set_user_filter(report.user_filter,{company_id:report.company_id});break;case"selected":set_user_filter(report.user_filter,{user_ids:report.user_ids});break;default:set_user_filter(report.user_filter)}switch(report.date_filter){case"selected_date":set_date_filter(report.date_filter,{date_on:report.date_on});break;case"selected_range":set_date_filter(report.date_filter,{date_from:report.date_from,date_to:report.date_to});break;default:set_date_filter(report.date_filter)}switch(report.project_filter){case"category":set_project_filter(report.project_filter,{project_category_id:report.project_category_id});break;case"client":set_project_filter(report.project_filter,{project_client_id:report.project_client_id});break;case"selected":set_project_filter(report.project_filter,{project_ids:report.project_ids});break;default:set_project_filter(report.project_filter)}wrapper.find("#tracking_report_billable_status_filter td.report_select_select select").val(report.billable_status_filter);wrapper.find("#tracking_report_type_filter td.report_select_select select").val(report.type_filter);wrapper.find("#tracking_report_sum_by_user td.report_select_select input[type=checkbox]")[0].checked=report.sum_by_user;wrapper.find("#tracking_report_group_by td.report_select_select select").val(report.group_by)}else{selected_report_id=report_id;edit_report_button.show().text(App.lang("Save"));delete_report_button.hide()}};return{init:function(wrapper_id,all_companies,all_users,all_projects,all_project_categories){wrapper=$("#"+wrapper_id);result_wrapper=wrapper.find("#tracking_report_result");edit_report_button=wrapper.find("#tracking_report_save");delete_report_button=wrapper.find("#tracking_report_delete");companies=all_companies;users=all_users;projects=all_projects;project_categories=all_project_categories;var report_form=wrapper.find("form");var saved_report_select=wrapper.find("tr#saved_tracking_reports select");saved_report_select.change(function(){select_report(saved_report_select.val()==""?0:parseInt(saved_report_select.val()))});wrapper.find("tr.report_select td.report_select_select select").change(function(){var select=$(this);var row=select.parent().parent();var data=row.find("td.report_select_data");var new_value=select.val();if(data.attr("currently_loaded")==new_value){return}else{data.empty().attr("currently_loaded",new_value)}switch(row.attr("id")){case"tracking_report_user_filter":set_user_filter(new_value);break;case"tracking_report_date_filter":set_date_filter(new_value);break;case"tracking_report_project_filter":set_project_filter(new_value);break}});report_form.submit(function(){$.ajax({type:"get",url:App.extendUrl(report_form.attr("action"),"async=1&"+report_form.serialize()),success:function(response){result_wrapper.empty().append(response)},error:function(reponse){App.Wireframe.Flash.error("Failed to run the report. Please try again later")}});return false});edit_report_button.click(function(){if(selected_report_id){var report=saved_reports[selected_report_id];var report_name=prompt(App.lang("How would you like this report to be called? Leave unchanged to keep the existing name"),report.name);if(report_name!==false){report_name=jQuery.trim(report_name)}if(report_name){$.ajax({url:App.extendUrl(report.urls["edit"],{async:1}),type:"post",data:report_form.serialize()+"&submitted=submitted&report[name]="+report_name,success:function(response){if(typeof(response)=="object"){if(response.name!==report.name){saved_report_select.find("option:selected").text(response.name)}saved_reports[selected_report_id]=response;App.Wireframe.Flash.success("Selected report has been successfully updated")}else{App.Wireframe.Flash.error("Failed to save tracking report. Please try again later")}},error:function(response){App.Wireframe.Flash.error("Failed to save tracking report. Please try again later")}})}else{if(report_name!==false){App.Wireframe.Flash.error("Report name is required")}}}else{var report_name=prompt(App.lang("How would you like this report to be called?",""));if(report_name!==false){report_name=jQuery.trim(report_name)}if(report_name){var option_group=saved_report_select.find("optgroup");if(option_group.length<1){saved_report_select.append('<option value=""></option>');option_group=$('<optgroup label="'+App.lang("Saved Reports")+'"></optgroup>').appendTo(saved_report_select)}var report_exists=false;option_group.find("option").each(function(){if($(this).text()==report_name){report_exists=true;return false}});if(report_exists){App.Wireframe.Flash.error('":name" report already exists. Please use a different name',{name:report_name})}else{$.ajax({url:App.extendUrl(saved_report_select.attr("new_report_url"),{async:1}),type:"post",data:report_form.serialize()+"&submitted=submitted&report[name]="+report_name,success:function(response){if(typeof(response)=="object"){var options=option_group.find("option");var option=$('<option value="'+response.id+'"></option>').text(response.name);var option_added=false;if(options.length>0){options.each(function(){var current_option=$(this);if(response.name<current_option.text()){current_option.before(option);option_added=true;return false}})}if(!option_added){option_group.append(option)}saved_report_select.val(response.id)}else{App.Wireframe.Flash.error("Failed to save tracking report. Please try again later")}},error:function(response){App.Wireframe.Flash.error("Failed to save tracking report. Please try again later")}})}}}});delete_report_button.click(function(){if(selected_report_id&&confirm(App.lang("Are you sure that you want to remove selected tracking report?"))){var report=saved_reports[selected_report_id];$.ajax({url:App.extendUrl(report.urls["delete"],{async:1}),type:"post",data:{submitted:"submitted"},success:function(response){saved_report_select.find("option[value="+selected_report_id+"]").remove();saved_report_select.find("option:first")[0].selected=true;selected_report_id=0;App.Wireframe.Flash.success("Selected report has been successfully removed")},error:function(response){App.Wireframe.Flash.error("Failed to remove selected report. Please try again later")}})}})},setSavedReport:function(report_id,report_attributes){saved_reports[report_id]=report_attributes}}}();
