<?php

  /**
   * TaxRates class
   * 
   * @package activeCollab.modules.invoicing
   * @subpackage models
   */
  class TaxRates extends BaseTaxRates {

    /**
  	 * Return slice of invoice item template definitions based on given criteria
  	 * 
  	 * @param integer $num
  	 * @param array $exclude
  	 * @param integer $timestamp
  	 * @return DBResult
  	 */
  	public static function getSlice($num = 10, $exclude = null, $timestamp = null) {
  		if($exclude) {
  			return self::find(array(
  			  'conditions' => array('id NOT IN (?)', $exclude), 
  			  'order' => 'name', 
  			  'limit' => $num,  
  			));
  		} else {
  			return self::find(array(
  			  'order' => 'name', 
  			  'limit' => $num,  
  			));
  		} // if
  	} // getSlice

    /**
     * Get Default tax rate
     *
     * @return TaxRate
     */
    public static function getDefault() {
      return self::find(array(
        'conditions' => array('is_default = ?', true),
        'one'        => true
      ));
    } // getDefault
  }