<?php

  /**
   * Search framework initialization file
   * 
   * @package angie.frameworks.search
   */
  
  define('SEARCH_FRAMEWORK', 'search');
  define('SEARCH_FRAMEWORK_PATH', ANGIE_PATH . '/frameworks/search');
  
  // Name of the module that provides interface to this framework
  @define('SEARCH_FRAMEWORK_INJECT_INTO', 'system');
  @define('SEARCH_FRAMEWORK_ADMIN_ROUTE_BASE', 'admin');
  @define('SEARCH_FRAMEWORK_BACKEND_SEARCH_BASE', 'backend');
  
  AngieApplication::setForAutoload(array(
    'Search' => SEARCH_FRAMEWORK_PATH . '/models/Search.class.php',
  
    'SearchItemsCriteria' => SEARCH_FRAMEWORK_PATH . '/models/criteria/SearchItemsCriteria.class.php',
    'IncludeSearchItemsCriteria' => SEARCH_FRAMEWORK_PATH . '/models/criteria/IncludeSearchItemsCriteria.class.php',
    'ExcludeSearchItemsCriteria' => SEARCH_FRAMEWORK_PATH . '/models/criteria/ExcludeSearchItemsCriteria.class.php',
    'SearchCriterion' => SEARCH_FRAMEWORK_PATH . '/models/criteria/SearchCriterion.class.php',
  
    'ISearchItem' => SEARCH_FRAMEWORK_PATH . '/models/ISearchItem.class.php',
    'ISearchItemImplementation' => SEARCH_FRAMEWORK_PATH . '/models/ISearchItemImplementation.class.php',
  
    'SearchIndex' => SEARCH_FRAMEWORK_PATH . '/models/indexes/SearchIndex.class.php',
  
    'SearchFilter' => SEARCH_FRAMEWORK_PATH . '/models/filters/SearchFilter.class.php',
    'NumberSearchFilter' => SEARCH_FRAMEWORK_PATH . '/models/filters/NumberSearchFilter.class.php',
    'DateSearchFilter' => SEARCH_FRAMEWORK_PATH . '/models/filters/DateSearchFilter.class.php',
    'EnumerableSearchFilter' => SEARCH_FRAMEWORK_PATH . '/models/filters/EnumerableSearchFilter.class.php',
  
    'SearchProvider' => SEARCH_FRAMEWORK_PATH . '/models/providers/SearchProvider.class.php',
    'MySqlSearchProvider' => SEARCH_FRAMEWORK_PATH . '/models/providers/MySqlSearchProvider.class.php', 
  ));