<?php

  /**
   * Comments framework definition
   *
   * @package angie.frameworks.comments
   */
  
  define('COMMENTS_FRAMEWORK', 'comments');
  define('COMMENTS_FRAMEWORK_PATH', ANGIE_PATH . '/frameworks/comments');
  
  // Inject comments framework in system module by default
  @define('COMMENTS_FRAMEWORK_INJECT_INTO', 'system');
  
  // Number of comments that are loaded by default or per async load
  @define('COMMENTS_PER_LOAD', 2);
  
  AngieApplication::setForAutoload(array(
    'FwComment' => COMMENTS_FRAMEWORK_PATH . '/models/comments/FwComment.class.php', 
    'FwComments' => COMMENTS_FRAMEWORK_PATH . '/models/comments/FwComments.class.php', 
    'IComments' => COMMENTS_FRAMEWORK_PATH . '/models/IComments.class.php', 
    'ICommentsImplementation' => COMMENTS_FRAMEWORK_PATH . '/models/ICommentsImplementation.class.php', 
    
    'ICommentActivityLogsImplementation' => COMMENTS_FRAMEWORK_PATH . '/models/ICommentActivityLogsImplementation.class.php',
  
    'CommentCreatedActivityLogCallback' => COMMENTS_FRAMEWORK_PATH . '/models/javascript_callbacks/CommentCreatedActivityLogCallback.class.php',
  ));