<?php

  /**
   * Default configuration values
   */
  
  define('APPLICATION_NAME', 'ActiveCollab');
  define('APPLICATION_BUILD', '4043');

  @define('APPLICATION_VERSION_STABLE', 0);
  @define('USE_UNPACKED_FILES', false); // By default, use Phar distribution

  if(USE_UNPACKED_FILES) {
    define('APPLICATION_PATH', ROOT . '/' . APPLICATION_VERSION); // If we are using unpacked file, make sure that value is well set
  } else {
    define('APPLICATION_PATH', 'phar://' . APPLICATION_NAME . '-' . APPLICATION_VERSION . '.phar'); // Not using packed files? Properly set angie path
  } // if

  if(!defined('ANGIE_PATH')) {
    define('ANGIE_PATH', APPLICATION_PATH . '/angie');
  } // if

  if(!defined('APPLICATION_MODE')) {
    define('APPLICATION_MODE', 'in_production');
  } // if
  
  define('APPLICATION_FRAMEWORKS', 'environment,modules,globalization,authentication,activity_logs,reports,history,email,download,preview,homescreens,complete,attachments,subscriptions,comments,categories,labels,assignees,subtasks,favorites,visual_editor,file_uploader,payments,avatar,text_compare,reminders,search,custom_fields');
  
  if(LICENSE_PACKAGE == 'corporate') {
    define('APPLICATION_MODULES', 'system,discussions,milestones,files,todo,calendar,notebooks,tasks,tracking,project_exporter,status,documents,source,invoicing,flow,sitemaps,work_analyzer');
  } elseif(LICENSE_PACKAGE == 'smallbiz') {
    define('APPLICATION_MODULES', 'system,discussions,milestones,files,todo');
  } else {
    define('APPLICATION_MODULES', 'system');
  } // if

  @define('GLOBALIZATION_ADAPTER', 'ActiveCollabGlobalizationAdapter');
  
  // Use activeCollab specific favorites routes
  define('FAVORITES_FRAMEWORK_DEFINE_ROUTES', false);

  define('TEST_SMTP_BY_SENDING_EMAIL_TO', 'noreply@activecollab.com');
  
  @define('APPLICATION_UNIQUE_KEY', LICENSE_KEY);
  
  // ---------------------------------------------------
  //  Defaults MVC mapping
  // ---------------------------------------------------

  define('DEFAULT_CONTROLLER', 'backend');

  define('UPDATE_INSTRUCTIONS_URL', 'http://www.activecollab.com/docs/manuals/admin-version-3/upgrade/latest-stable');
  define('UPGRADE_TO_CORPORATE_URL', 'http://www.activecollab.com/user/' . LICENSE_UID . '/upgrade-to-corporate?license_key=' . LICENSE_KEY);
  define('REMOVE_BRANDING_URL', 'http://www.activecollab.com/user/' . LICENSE_UID . '/purchase-branding-removal?license_key=' . LICENSE_KEY);
  define('RENEW_SUPPORT_URL', 'http://www.activecollab.com/user/' . LICENSE_UID . '/extend-support?license_key=' . LICENSE_KEY);

  // ---------------------------------------------------
  //  Load framewok default configuration
  // ---------------------------------------------------

  require_once ANGIE_PATH . '/defaults.php';
