<?php

  /**
   * Application level status bar implementation
   * 
   * @package activeCollab.modules.system
   * @subpackage models
   */
  class StatusBar extends FwStatusBar {
  
    /**
     * Load status bar
     * 
     * @param IUser $user
     */
    function load(IUser $user) {
      if($this->isLoaded()) {
        return;
      } // if
      
      $this->add('quick-jump', lang('Jump To'), Router::assemble('quick_jump'), AngieApplication::getImageUrl('status-bar/quick-jump.png', SYSTEM_MODULE), array(
				'onclick' => new QuickJumpCallback(),
        'hotkey' => 'j',
      ));
      
      $this->add('quick-add', lang('Quick Add'), Router::assemble('quick_add'), AngieApplication::getImageUrl('status-bar/quick-add.png', SYSTEM_MODULE), array(
      	'onclick' => new QuickAddCallback(),
        'hotkey' => 'q',
      ));
      
      $this->add('favorites', lang('Favorites'), Router::assemble('people_company_user_favorites', array('company_id' => $user->getCompanyId(), 'user_id' => $user->getId())), AngieApplication::getImageUrl('status-bar/favorites.png', SYSTEM_MODULE), array(
        'group' => StatusBar::GROUP_RIGHT, 
      ));

      parent::load($user);

      if (!AngieApplication::getAdapter()->getBrandingRemoved()) {
      	$this->add('branding', 'powered', 'http://www.activecollab.com/', AngieApplication::getBrandImageUrl('footer-branding.png'), array(
	        'group' => StatusBar::GROUP_RIGHT,
	      	'target' => '_blank'
      	));
      } // if

    } // load
    
  }