<?php

  /**
   * Renders label pill
   * 
   * Params:
   * 
   * - label_id - Id number of label
   *
   * @param array $params
   * @param Smarty $smarty
   * @return string
   */
  function smarty_function_render_label_pill($params, &$smarty) {
    $label_id = array_var($params, 'label_id');
    $label = Labels::findById($label_id);
    
    if($label instanceof AssignmentLabel) {
      $label_style = '';
       
      if($foreground_color = $label->getForegroundColor()) {
        $label_style .= "color: $foreground_color ;";
      } // if
      
      if($background_color = $label->getBackgroundColor()) {
        $label_style .= "background-color: $background_color ;";
      } // if
      
      $label_text = $label->getAlwaysUppercase() ? strtoupper($label->getName()) : $label->getName();
          
      return "<span class='pill label' style='$label_style'>" . clean($label_text) . "</span>";
    } else {
      return '';
    } // if
  } // smarty_function_render_label_pill